# coding: utf-8

"""
    Listmonk

    The API collection for listmonk

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional, Union
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr
from pydantic import Field
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class SMTPTest(BaseModel):
    """
    SMTPTest
    """ # noqa: E501
    uuid: Optional[StrictStr] = None
    enabled: Optional[StrictBool] = None
    host: Optional[StrictStr] = None
    hello_hostname: Optional[StrictStr] = None
    port: Optional[StrictInt] = None
    auth_protocol: Optional[StrictStr] = None
    username: Optional[StrictStr] = None
    email_headers: Optional[List[Union[str, Any]]] = None
    max_conns: Optional[StrictInt] = None
    max_msg_retries: Optional[StrictInt] = None
    idle_timeout: Optional[StrictStr] = None
    wait_timeout: Optional[StrictStr] = None
    tls_type: Optional[StrictStr] = None
    tls_skip_verify: Optional[StrictBool] = None
    str_email_headers: Optional[StrictStr] = Field(default=None, alias="strEmailHeaders")
    password: Optional[StrictStr] = None
    email: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["uuid", "enabled", "host", "hello_hostname", "port", "auth_protocol", "username", "email_headers", "max_conns", "max_msg_retries", "idle_timeout", "wait_timeout", "tls_type", "tls_skip_verify", "strEmailHeaders", "password", "email"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of SMTPTest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of SMTPTest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "uuid": obj.get("uuid"),
            "enabled": obj.get("enabled"),
            "host": obj.get("host"),
            "hello_hostname": obj.get("hello_hostname"),
            "port": obj.get("port"),
            "auth_protocol": obj.get("auth_protocol"),
            "username": obj.get("username"),
            "email_headers": obj.get("email_headers"),
            "max_conns": obj.get("max_conns"),
            "max_msg_retries": obj.get("max_msg_retries"),
            "idle_timeout": obj.get("idle_timeout"),
            "wait_timeout": obj.get("wait_timeout"),
            "tls_type": obj.get("tls_type"),
            "tls_skip_verify": obj.get("tls_skip_verify"),
            "strEmailHeaders": obj.get("strEmailHeaders"),
            "password": obj.get("password"),
            "email": obj.get("email")
        })
        return _obj


