# coding: utf-8

"""
    Listmonk

    The API collection for listmonk

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional, Union
from pydantic import BaseModel, StrictStr
from listmonk.models.subscriber_profile import SubscriberProfile
from listmonk.models.subscriptions import Subscriptions
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class SubscriberData(BaseModel):
    """
    SubscriberData
    """ # noqa: E501
    email: Optional[StrictStr] = None
    profile: Optional[List[SubscriberProfile]] = None
    subscriptions: Optional[List[Subscriptions]] = None
    campaign_views: Optional[List[Union[str, Any]]] = None
    link_clicks: Optional[List[Union[str, Any]]] = None
    __properties: ClassVar[List[str]] = ["email", "profile", "subscriptions", "campaign_views", "link_clicks"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of SubscriberData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in profile (list)
        _items = []
        if self.profile:
            for _item in self.profile:
                if _item:
                    _items.append(_item.to_dict())
            _dict['profile'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in subscriptions (list)
        _items = []
        if self.subscriptions:
            for _item in self.subscriptions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['subscriptions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of SubscriberData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "email": obj.get("email"),
            "profile": [SubscriberProfile.from_dict(_item) for _item in obj.get("profile")] if obj.get("profile") is not None else None,
            "subscriptions": [Subscriptions.from_dict(_item) for _item in obj.get("subscriptions")] if obj.get("subscriptions") is not None else None,
            "campaign_views": obj.get("campaign_views"),
            "link_clicks": obj.get("link_clicks")
        })
        return _obj


