# coding: utf-8

"""
    Listmonk

    The API collection for listmonk

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictInt, StrictStr, field_validator
from pydantic import Field
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class SubscriberQueryRequest(BaseModel):
    """
    SubscriberQueryRequest
    """ # noqa: E501
    query: Optional[StrictStr] = None
    ids: Optional[List[StrictInt]] = Field(default=None, description="The ids of the subscribers to be modified.")
    action: Optional[StrictStr] = Field(default=None, description="Whether to add, remove, or unsubscribe the users.")
    target_list_ids: Optional[List[StrictInt]] = Field(default=None, description="The ids of the lists to be modified.")
    status: Optional[StrictStr] = Field(default=None, description="confirmed, unconfirmed, or unsubscribed status.")
    __properties: ClassVar[List[str]] = ["query", "ids", "action", "target_list_ids", "status"]

    @field_validator('action')
    def action_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('add', 'remove', 'unsubscribe'):
            raise ValueError("must be one of enum values ('add', 'remove', 'unsubscribe')")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('confirmed', 'unconfirmed', 'unsubscribed'):
            raise ValueError("must be one of enum values ('confirmed', 'unconfirmed', 'unsubscribed')")
        return value

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of SubscriberQueryRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of SubscriberQueryRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "query": obj.get("query"),
            "ids": obj.get("ids"),
            "action": obj.get("action"),
            "target_list_ids": obj.get("target_list_ids"),
            "status": obj.get("status")
        })
        return _obj


