# coding: utf-8

"""
    Listmonk

    The API collection for listmonk

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr
from listmonk.models.new_subscriber_attribs import NewSubscriberAttribs
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class UpdateSubscriber(BaseModel):
    """
    UpdateSubscriber
    """ # noqa: E501
    email: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    status: Optional[StrictStr] = None
    lists: Optional[List[StrictInt]] = None
    list_uuids: Optional[List[StrictStr]] = None
    preconfirm_subscriptions: Optional[StrictBool] = None
    attribs: Optional[NewSubscriberAttribs] = None
    __properties: ClassVar[List[str]] = ["email", "name", "status", "lists", "list_uuids", "preconfirm_subscriptions", "attribs"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of UpdateSubscriber from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of attribs
        if self.attribs:
            _dict['attribs'] = self.attribs.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of UpdateSubscriber from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "email": obj.get("email"),
            "name": obj.get("name"),
            "status": obj.get("status"),
            "lists": obj.get("lists"),
            "list_uuids": obj.get("list_uuids"),
            "preconfirm_subscriptions": obj.get("preconfirm_subscriptions"),
            "attribs": NewSubscriberAttribs.from_dict(obj.get("attribs")) if obj.get("attribs") is not None else None
        })
        return _obj


