# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['discord_logging']

package_data = \
{'': ['*']}

install_requires = \
['discord-webhook>=0.15.0,<0.16.0']

extras_require = \
{'docs': ['Sphinx>=4.4.0,<5.0.0',
          'sphinx-rtd-theme>=1.0.0,<2.0.0',
          'sphinx-sitemap>=2.2.0,<3.0.0',
          'sphinx-autodoc-typehints[docs]>=1.16.0,<2.0.0']}

setup_kwargs = {
    'name': 'python-logging-discord-handler',
    'version': '0.1.1',
    'description': 'Direct Python log output to Discord',
    'long_description': '[![PyPI version](https://badge.fury.io/py/python-logging-discord-handler.svg)](https://badge.fury.io/py/python-logging-discord-handler)\n\n[![Automated test suite](https://github.com/tradingstrategy-ai/python-logging-discord-handler/actions/workflows/tests.yml/badge.svg)](https://github.com/tradingstrategy-ai/python-logging-discord-handler/actions/workflows/tests.yml)\n\n[![Documentation Status](https://readthedocs.org/projects/python-logging-discord-handler/badge/?version=latest)](https://python-logging-discord-handler.readthedocs.io/en/latest/?badge=latest)\n\n# Python logging handler for Discord\n\nRedirect your Python log output to Discord using [Python logging subsystem](https://docs.python.org/3/howto/logging.html) and [Discord Webhook library](https://github.com/lovvskillz/python-discord-webhook).\n\n![Example screenshot](https://raw.githubusercontent.com/tradingstrategy-ai/python-logging-discord-handler/master/docs/source/_static/example_screenshot.png)\n\n# Use cases\n\n- Get notified on server-side errors\n- Follow your batch job processes easily\n- Good for businesses and communities that have their messaging set up in Discord \n\n# Features\n\n- Minimum or no changes to a Python application needed\n- Optional color coding of messages using [Discord embeds](https://discordjs.guide/popular-topics/embeds.html#embed-preview)\n- Optional emoticons on messages using Unicode\n- Discord rate limiting friendly for burst of logs\n- Documentation\n- Special handling for long log messages like tracebacks to deal with Discord\'s 2000 character max message length\n\n# Requirements\n\n- Python 3.8+\n\n# Usage\n\nThis example logs both to Discord and standard output. \n\nFirst you need to \n\n```python\nimport logging\n\nfrom discord_logging.handler import DiscordHandler\n\n# See instructions below how to get a Webhook URL\nwebhook_url = # ...\nlogger = logging.getLogger()\n\nstream_format = logging.Formatter("%(asctime)s - %(name)s - %(levelname)s - %(message)s")\ndiscord_format = logging.Formatter("%(message)s")\n\ndiscord_handler = DiscordHandler(\n    "Hello World Bot", \n    webhook_url, \n    avatar_url="https://i0.wp.com/www.theterminatorfans.com/wp-content/uploads/2012/09/the-terminator3.jpg?resize=900%2C450&ssl=1")\n\n#discord_handler = DiscordHandler("Happy Bot", webhook_url, emojis={})\ndiscord_handler.setFormatter(discord_format)\nstream_handler = logging.StreamHandler()\nstream_handler.setFormatter(stream_format)\n\n# Add the handlers to the Logger\nlogger.addHandler(discord_handler)\nlogger.addHandler(stream_handler)\nlogger.setLevel(logging.DEBUG)\n\nlogger.info("This is an info message")\nlogger.debug("A debug message - usually not that interesting")\nlogger.error("Very nasty error messgae!")\n```\n\n[Find more examples in the examples.py source code](https://github.com/tradingstrategy-ai/python-logging-discord-handler/blob/master/discord_logging/examples.py).\n\n# How to get Discord webhook URL\n\n1. Go to *Edit channel* (gear) in Discord\n2. Choose *Integrations*\n3. Choose *View webhooks* -> *New*\n4. Copy URL\n\n## Webhook URL security\n\nIt is recommend that you store the webhook URL outside your source code to avoid damage in hacks or similar security incidents.\n\nIn Linux/macOS shell you can do on the command line:\n\n```shell\nexport DISCORD_TEST_WEBHOOK_URL=<your webhook URL here>\n```\n\nFor long term configuration, you can create a file storing environment variables outside your source code tree, like in your home directory. Store the `export` commands there.\n\n```shell\n# Text editor for a secrets.env file in your home directory on Linux\nnano ~/secrets.env  \n```\n\nIn your Linux shell session, you can then read this file and make environment variables effective using [source](https://superuser.com/a/46149) command in your shell:\n\n```shell\n# Reads secrets.env and executes all commands there and makes them effective\n# in the current shell session\nsource ~/secrets.env\n```\n\nThen you can read the environment variable in your Python code: \n\n```python\nimport os\n\nwebhook_url = os.environ["DISCORD_TEST_WEBHOOK_URL"]\n```\n\n# Discord limitations\n\n- Max 2000 characters per message. See API documentation how to work around this limitation with different options. By default the bottom most lines of the log message, like a traceback, are shown.\n- Discord embeds, those that give you a logging level color bar on the left, have very hard time to deal with long lines. Embeds are disabled for long lines by default.\n\n## Log output formatting logic\n\nThe log message are converted to Discord embeds with the following logic\n\n- Single line log messsages are converted to embed titles\n- For multi line log messages, the first line is the embed title and the following lines are the embed description\n- Long lines or long messages cannot be convert to embeds, instead they use [Discord Markdown code formattiong](https://support.discord.com/hc/en-us/articles/210298617-Markdown-Text-101-Chat-Formatting-Bold-Italic-Underline-) to preserve the readability of the output\n- A special `message_break_char` can be assigned to manually split long messages \n\n# Colours and emoticons\n\nLogging messages can be decorated with colours and emoticons.\n\n![Emoji screenshot](https://raw.githubusercontent.com/tradingstrategy-ai/python-logging-discord-handler/master/docs/source/_static/emoji_example.png)\n\n\nHere are the defaults:\n\n```python\n#: The default log level colors as hexacimal, converted int\nDEFAULT_COLOURS = {\n    None: 2040357,  # Unknown log level\n    logging.CRITICAL: 14362664,  # Red\n    logging.ERROR: 14362664,  # Red\n    logging.WARNING: 16497928,  # Yellow\n    logging.INFO: 2196944,  # Blue\n    logging.DEBUG: 8947848,  # Gray\n}\n\n\n#: The default log emojis as\nDEFAULT_EMOJIS = {\n    None: "",  # Unknown log level\n    logging.CRITICAL: "🆘",\n    logging.ERROR: "❌",\n    logging.WARNING: "⚠️",\n    logging.INFO: "",\n    logging.DEBUG: "",\n}\n```\n\nEmoticons are disabled by default as they often make the output a bit too colourful and harder to read.\n\n# Testing and development\n\n## Manual tests\n\nInspect how logging output looks in Discord.\n\n- Checkout this Git repository\n- Set up a dummy Discord channel\n- Get its webhook URL\n\n```shell\npoetry install -E docs \nexport DISCORD_TEST_WEBHOOK_URL=...\npython discord_logging/examples.py\n```\n\nThis will dump some messages to your Discord.\n\n## Automated tests\n\nRun:\n\n```shell\npytest\n```\n\n# History\n\n[Originally created for Trading Strategy](https://tradingstrategy.ai) to follow trading bot activity.\n\n# License \n\nMIT\n',
    'author': 'Mikko Ohtamaa',
    'author_email': 'mikko@opensourcehacker.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://tradingstrategy.ai',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
