"""
/*
 *
 *    Copyright (c) 2022 Project CHIP Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

// THIS FILE IS GENERATED BY ZAP
"""

# This file contains generated struct, enum, command definition.
# Users are not expected to import this file, instead, users can use import chip.clusters, which will import all symbols from this file and can get a readable, pretty naming like clusters.OnOff.commands.OnCommand

from dataclasses import dataclass, field
import typing
from enum import IntEnum
from .. import ChipUtility

from ..tlv import uint, float32

from .ClusterObjects import (
    ClusterObject,
    ClusterObjectDescriptor,
    ClusterObjectFieldDescriptor,
    ClusterCommand,
    ClusterAttributeDescriptor,
    Cluster,
    ClusterEvent,
)
from .Types import Nullable, NullValue


@dataclass
class Identify(Cluster):
    id: typing.ClassVar[int] = 0x0003

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="identifyTime", Tag=0x00000000, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="identifyType", Tag=0x00000001, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    identifyTime: "uint" = None
    identifyType: "uint" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Enums:
        class IdentifyEffectIdentifier(IntEnum):
            kBlink = 0x00
            kBreathe = 0x01
            kOkay = 0x02
            kChannelChange = 0x0B
            kFinishEffect = 0xFE
            kStopEffect = 0xFF

        class IdentifyEffectVariant(IntEnum):
            kDefault = 0x00

        class IdentifyIdentifyType(IntEnum):
            kNone = 0x00
            kVisibleLight = 0x01
            kVisibleLED = 0x02
            kAudibleBeep = 0x03
            kDisplay = 0x04
            kActuator = 0x05

    class Commands:
        @dataclass
        class Identify(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0003
            command_id: typing.ClassVar[int] = 0x0000
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="identifyTime", Tag=0, Type=uint
                        ),
                    ]
                )

            identifyTime: "uint" = 0

        @dataclass
        class TriggerEffect(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0003
            command_id: typing.ClassVar[int] = 0x0040
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="effectIdentifier",
                            Tag=0,
                            Type=Identify.Enums.IdentifyEffectIdentifier,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="effectVariant",
                            Tag=1,
                            Type=Identify.Enums.IdentifyEffectVariant,
                        ),
                    ]
                )

            effectIdentifier: "Identify.Enums.IdentifyEffectIdentifier" = 0
            effectVariant: "Identify.Enums.IdentifyEffectVariant" = 0

    class Attributes:
        @dataclass
        class IdentifyTime(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0003

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class IdentifyType(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0003

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0003

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0003

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0003

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0003

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0003

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class Groups(Cluster):
    id: typing.ClassVar[int] = 0x0004

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="nameSupport", Tag=0x00000000, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    nameSupport: "uint" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Commands:
        @dataclass
        class AddGroup(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0004
            command_id: typing.ClassVar[int] = 0x0000
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="groupId", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="groupName", Tag=1, Type=str
                        ),
                    ]
                )

            groupId: "uint" = 0
            groupName: "str" = ""

        @dataclass
        class AddGroupResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0004
            command_id: typing.ClassVar[int] = 0x0000
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="status", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(Label="groupId", Tag=1, Type=uint),
                    ]
                )

            status: "uint" = 0
            groupId: "uint" = 0

        @dataclass
        class ViewGroup(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0004
            command_id: typing.ClassVar[int] = 0x0001
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="groupId", Tag=0, Type=uint),
                    ]
                )

            groupId: "uint" = 0

        @dataclass
        class ViewGroupResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0004
            command_id: typing.ClassVar[int] = 0x0001
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="status", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(Label="groupId", Tag=1, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="groupName", Tag=2, Type=str
                        ),
                    ]
                )

            status: "uint" = 0
            groupId: "uint" = 0
            groupName: "str" = ""

        @dataclass
        class GetGroupMembership(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0004
            command_id: typing.ClassVar[int] = 0x0002
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="groupList", Tag=0, Type=typing.List[uint]
                        ),
                    ]
                )

            groupList: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class GetGroupMembershipResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0004
            command_id: typing.ClassVar[int] = 0x0002
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="capacity", Tag=0, Type=typing.Union[Nullable, uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="groupList", Tag=1, Type=typing.List[uint]
                        ),
                    ]
                )

            capacity: "typing.Union[Nullable, uint]" = NullValue
            groupList: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class RemoveGroup(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0004
            command_id: typing.ClassVar[int] = 0x0003
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="groupId", Tag=0, Type=uint),
                    ]
                )

            groupId: "uint" = 0

        @dataclass
        class RemoveGroupResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0004
            command_id: typing.ClassVar[int] = 0x0003
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="status", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(Label="groupId", Tag=1, Type=uint),
                    ]
                )

            status: "uint" = 0
            groupId: "uint" = 0

        @dataclass
        class RemoveAllGroups(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0004
            command_id: typing.ClassVar[int] = 0x0004
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class AddGroupIfIdentifying(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0004
            command_id: typing.ClassVar[int] = 0x0005
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="groupId", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="groupName", Tag=1, Type=str
                        ),
                    ]
                )

            groupId: "uint" = 0
            groupName: "str" = ""

    class Attributes:
        @dataclass
        class NameSupport(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0004

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0004

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0004

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0004

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0004

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0004

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class Scenes(Cluster):
    id: typing.ClassVar[int] = 0x0005

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="sceneCount", Tag=0x00000000, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="currentScene", Tag=0x00000001, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="currentGroup", Tag=0x00000002, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="sceneValid", Tag=0x00000003, Type=bool
                ),
                ClusterObjectFieldDescriptor(
                    Label="nameSupport", Tag=0x00000004, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="lastConfiguredBy",
                    Tag=0x00000005,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    sceneCount: "uint" = None
    currentScene: "uint" = None
    currentGroup: "uint" = None
    sceneValid: "bool" = None
    nameSupport: "uint" = None
    lastConfiguredBy: "typing.Union[None, Nullable, uint]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Structs:
        @dataclass
        class AttributeValuePair(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="attributeId", Tag=0, Type=typing.Optional[uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="attributeValue", Tag=1, Type=typing.List[uint]
                        ),
                    ]
                )

            attributeId: "typing.Optional[uint]" = None
            attributeValue: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class ExtensionFieldSet(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="clusterId", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="attributeValueList",
                            Tag=1,
                            Type=typing.List[Scenes.Structs.AttributeValuePair],
                        ),
                    ]
                )

            clusterId: "uint" = 0
            attributeValueList: "typing.List[Scenes.Structs.AttributeValuePair]" = (
                field(default_factory=lambda: [])
            )

    class Commands:
        @dataclass
        class AddScene(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0005
            command_id: typing.ClassVar[int] = 0x0000
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="groupId", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(Label="sceneId", Tag=1, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="transitionTime", Tag=2, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="sceneName", Tag=3, Type=str
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="extensionFieldSets",
                            Tag=4,
                            Type=typing.List[Scenes.Structs.ExtensionFieldSet],
                        ),
                    ]
                )

            groupId: "uint" = 0
            sceneId: "uint" = 0
            transitionTime: "uint" = 0
            sceneName: "str" = ""
            extensionFieldSets: "typing.List[Scenes.Structs.ExtensionFieldSet]" = field(
                default_factory=lambda: []
            )

        @dataclass
        class AddSceneResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0005
            command_id: typing.ClassVar[int] = 0x0000
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="status", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(Label="groupId", Tag=1, Type=uint),
                        ClusterObjectFieldDescriptor(Label="sceneId", Tag=2, Type=uint),
                    ]
                )

            status: "uint" = 0
            groupId: "uint" = 0
            sceneId: "uint" = 0

        @dataclass
        class ViewScene(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0005
            command_id: typing.ClassVar[int] = 0x0001
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="groupId", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(Label="sceneId", Tag=1, Type=uint),
                    ]
                )

            groupId: "uint" = 0
            sceneId: "uint" = 0

        @dataclass
        class ViewSceneResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0005
            command_id: typing.ClassVar[int] = 0x0001
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="status", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(Label="groupId", Tag=1, Type=uint),
                        ClusterObjectFieldDescriptor(Label="sceneId", Tag=2, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="transitionTime", Tag=3, Type=typing.Optional[uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="sceneName", Tag=4, Type=typing.Optional[str]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="extensionFieldSets",
                            Tag=5,
                            Type=typing.Optional[
                                typing.List[Scenes.Structs.ExtensionFieldSet]
                            ],
                        ),
                    ]
                )

            status: "uint" = 0
            groupId: "uint" = 0
            sceneId: "uint" = 0
            transitionTime: "typing.Optional[uint]" = None
            sceneName: "typing.Optional[str]" = None
            extensionFieldSets: "typing.Optional[typing.List[Scenes.Structs.ExtensionFieldSet]]" = (
                None
            )

        @dataclass
        class RemoveScene(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0005
            command_id: typing.ClassVar[int] = 0x0002
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="groupId", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(Label="sceneId", Tag=1, Type=uint),
                    ]
                )

            groupId: "uint" = 0
            sceneId: "uint" = 0

        @dataclass
        class RemoveSceneResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0005
            command_id: typing.ClassVar[int] = 0x0002
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="status", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(Label="groupId", Tag=1, Type=uint),
                        ClusterObjectFieldDescriptor(Label="sceneId", Tag=2, Type=uint),
                    ]
                )

            status: "uint" = 0
            groupId: "uint" = 0
            sceneId: "uint" = 0

        @dataclass
        class RemoveAllScenes(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0005
            command_id: typing.ClassVar[int] = 0x0003
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="groupId", Tag=0, Type=uint),
                    ]
                )

            groupId: "uint" = 0

        @dataclass
        class RemoveAllScenesResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0005
            command_id: typing.ClassVar[int] = 0x0003
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="status", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(Label="groupId", Tag=1, Type=uint),
                    ]
                )

            status: "uint" = 0
            groupId: "uint" = 0

        @dataclass
        class StoreScene(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0005
            command_id: typing.ClassVar[int] = 0x0004
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="groupId", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(Label="sceneId", Tag=1, Type=uint),
                    ]
                )

            groupId: "uint" = 0
            sceneId: "uint" = 0

        @dataclass
        class StoreSceneResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0005
            command_id: typing.ClassVar[int] = 0x0004
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="status", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(Label="groupId", Tag=1, Type=uint),
                        ClusterObjectFieldDescriptor(Label="sceneId", Tag=2, Type=uint),
                    ]
                )

            status: "uint" = 0
            groupId: "uint" = 0
            sceneId: "uint" = 0

        @dataclass
        class RecallScene(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0005
            command_id: typing.ClassVar[int] = 0x0005
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="groupId", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(Label="sceneId", Tag=1, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="transitionTime",
                            Tag=2,
                            Type=typing.Union[None, Nullable, uint],
                        ),
                    ]
                )

            groupId: "uint" = 0
            sceneId: "uint" = 0
            transitionTime: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class GetSceneMembership(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0005
            command_id: typing.ClassVar[int] = 0x0006
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="groupId", Tag=0, Type=uint),
                    ]
                )

            groupId: "uint" = 0

        @dataclass
        class GetSceneMembershipResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0005
            command_id: typing.ClassVar[int] = 0x0006
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="status", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="capacity", Tag=1, Type=typing.Union[Nullable, uint]
                        ),
                        ClusterObjectFieldDescriptor(Label="groupId", Tag=2, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="sceneList",
                            Tag=3,
                            Type=typing.Optional[typing.List[uint]],
                        ),
                    ]
                )

            status: "uint" = 0
            capacity: "typing.Union[Nullable, uint]" = NullValue
            groupId: "uint" = 0
            sceneList: "typing.Optional[typing.List[uint]]" = None

        @dataclass
        class EnhancedAddScene(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0005
            command_id: typing.ClassVar[int] = 0x0040
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="groupId", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(Label="sceneId", Tag=1, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="transitionTime", Tag=2, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="sceneName", Tag=3, Type=str
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="extensionFieldSets",
                            Tag=4,
                            Type=typing.List[Scenes.Structs.ExtensionFieldSet],
                        ),
                    ]
                )

            groupId: "uint" = 0
            sceneId: "uint" = 0
            transitionTime: "uint" = 0
            sceneName: "str" = ""
            extensionFieldSets: "typing.List[Scenes.Structs.ExtensionFieldSet]" = field(
                default_factory=lambda: []
            )

        @dataclass
        class EnhancedAddSceneResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0005
            command_id: typing.ClassVar[int] = 0x0040
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="status", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(Label="groupId", Tag=1, Type=uint),
                        ClusterObjectFieldDescriptor(Label="sceneId", Tag=2, Type=uint),
                    ]
                )

            status: "uint" = 0
            groupId: "uint" = 0
            sceneId: "uint" = 0

        @dataclass
        class EnhancedViewScene(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0005
            command_id: typing.ClassVar[int] = 0x0041
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="groupId", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(Label="sceneId", Tag=1, Type=uint),
                    ]
                )

            groupId: "uint" = 0
            sceneId: "uint" = 0

        @dataclass
        class EnhancedViewSceneResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0005
            command_id: typing.ClassVar[int] = 0x0041
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="status", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(Label="groupId", Tag=1, Type=uint),
                        ClusterObjectFieldDescriptor(Label="sceneId", Tag=2, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="transitionTime", Tag=3, Type=typing.Optional[uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="sceneName", Tag=4, Type=typing.Optional[str]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="extensionFieldSets",
                            Tag=5,
                            Type=typing.Optional[
                                typing.List[Scenes.Structs.ExtensionFieldSet]
                            ],
                        ),
                    ]
                )

            status: "uint" = 0
            groupId: "uint" = 0
            sceneId: "uint" = 0
            transitionTime: "typing.Optional[uint]" = None
            sceneName: "typing.Optional[str]" = None
            extensionFieldSets: "typing.Optional[typing.List[Scenes.Structs.ExtensionFieldSet]]" = (
                None
            )

        @dataclass
        class CopyScene(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0005
            command_id: typing.ClassVar[int] = 0x0042
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="mode", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="groupIdFrom", Tag=1, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="sceneIdFrom", Tag=2, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="groupIdTo", Tag=3, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="sceneIdTo", Tag=4, Type=uint
                        ),
                    ]
                )

            mode: "uint" = 0
            groupIdFrom: "uint" = 0
            sceneIdFrom: "uint" = 0
            groupIdTo: "uint" = 0
            sceneIdTo: "uint" = 0

        @dataclass
        class CopySceneResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0005
            command_id: typing.ClassVar[int] = 0x0042
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="status", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="groupIdFrom", Tag=1, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="sceneIdFrom", Tag=2, Type=uint
                        ),
                    ]
                )

            status: "uint" = 0
            groupIdFrom: "uint" = 0
            sceneIdFrom: "uint" = 0

    class Attributes:
        @dataclass
        class SceneCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0005

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class CurrentScene(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0005

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class CurrentGroup(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0005

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class SceneValid(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0005

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=bool)

            value: "bool" = False

        @dataclass
        class NameSupport(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0005

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000004

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class LastConfiguredBy(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0005

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000005

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0005

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0005

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0005

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0005

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0005

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class OnOff(Cluster):
    id: typing.ClassVar[int] = 0x0006

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(Label="onOff", Tag=0x00000000, Type=bool),
                ClusterObjectFieldDescriptor(
                    Label="globalSceneControl",
                    Tag=0x00004000,
                    Type=typing.Optional[bool],
                ),
                ClusterObjectFieldDescriptor(
                    Label="onTime", Tag=0x00004001, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="offWaitTime", Tag=0x00004002, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="startUpOnOff",
                    Tag=0x00004003,
                    Type=typing.Union[None, Nullable, OnOff.Enums.OnOffStartUpOnOff],
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    onOff: "bool" = None
    globalSceneControl: "typing.Optional[bool]" = None
    onTime: "typing.Optional[uint]" = None
    offWaitTime: "typing.Optional[uint]" = None
    startUpOnOff: "typing.Union[None, Nullable, OnOff.Enums.OnOffStartUpOnOff]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Enums:
        class OnOffDelayedAllOffEffectVariant(IntEnum):
            kFadeToOffIn0p8Seconds = 0x00
            kNoFade = 0x01
            k50PercentDimDownIn0p8SecondsThenFadeToOffIn12Seconds = 0x02

        class OnOffDyingLightEffectVariant(IntEnum):
            k20PercenterDimUpIn0p5SecondsThenFadeToOffIn1Second = 0x00

        class OnOffEffectIdentifier(IntEnum):
            kDelayedAllOff = 0x00
            kDyingLight = 0x01

        class OnOffStartUpOnOff(IntEnum):
            kOff = 0x00
            kOn = 0x01
            kTogglePreviousOnOff = 0x02

    class Commands:
        @dataclass
        class Off(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0006
            command_id: typing.ClassVar[int] = 0x0000
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class On(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0006
            command_id: typing.ClassVar[int] = 0x0001
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class Toggle(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0006
            command_id: typing.ClassVar[int] = 0x0002
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class OffWithEffect(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0006
            command_id: typing.ClassVar[int] = 0x0040
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="effectId",
                            Tag=0,
                            Type=OnOff.Enums.OnOffEffectIdentifier,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="effectVariant",
                            Tag=1,
                            Type=OnOff.Enums.OnOffDelayedAllOffEffectVariant,
                        ),
                    ]
                )

            effectId: "OnOff.Enums.OnOffEffectIdentifier" = 0
            effectVariant: "OnOff.Enums.OnOffDelayedAllOffEffectVariant" = 0

        @dataclass
        class OnWithRecallGlobalScene(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0006
            command_id: typing.ClassVar[int] = 0x0041
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class OnWithTimedOff(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0006
            command_id: typing.ClassVar[int] = 0x0042
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="onOffControl", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(Label="onTime", Tag=1, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="offWaitTime", Tag=2, Type=uint
                        ),
                    ]
                )

            onOffControl: "uint" = 0
            onTime: "uint" = 0
            offWaitTime: "uint" = 0

    class Attributes:
        @dataclass
        class OnOff(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0006

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=bool)

            value: "bool" = False

        @dataclass
        class GlobalSceneControl(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0006

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00004000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[bool])

            value: "typing.Optional[bool]" = None

        @dataclass
        class OnTime(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0006

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00004001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class OffWaitTime(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0006

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00004002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class StartUpOnOff(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0006

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00004003

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, OnOff.Enums.OnOffStartUpOnOff]
                )

            value: "typing.Union[None, Nullable, OnOff.Enums.OnOffStartUpOnOff]" = None

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0006

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0006

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0006

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0006

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0006

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class OnOffSwitchConfiguration(Cluster):
    id: typing.ClassVar[int] = 0x0007

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="switchType", Tag=0x00000000, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="switchActions", Tag=0x00000010, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    switchType: "uint" = None
    switchActions: "uint" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Attributes:
        @dataclass
        class SwitchType(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0007

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class SwitchActions(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0007

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000010

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0007

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0007

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0007

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0007

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0007

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class LevelControl(Cluster):
    id: typing.ClassVar[int] = 0x0008

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="currentLevel",
                    Tag=0x00000000,
                    Type=typing.Union[Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="remainingTime", Tag=0x00000001, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="minLevel", Tag=0x00000002, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="maxLevel", Tag=0x00000003, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="currentFrequency", Tag=0x00000004, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="minFrequency", Tag=0x00000005, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="maxFrequency", Tag=0x00000006, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="options", Tag=0x0000000F, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="onOffTransitionTime",
                    Tag=0x00000010,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="onLevel", Tag=0x00000011, Type=typing.Union[Nullable, uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="onTransitionTime",
                    Tag=0x00000012,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="offTransitionTime",
                    Tag=0x00000013,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="defaultMoveRate",
                    Tag=0x00000014,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="startUpCurrentLevel",
                    Tag=0x00004000,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    currentLevel: "typing.Union[Nullable, uint]" = None
    remainingTime: "typing.Optional[uint]" = None
    minLevel: "typing.Optional[uint]" = None
    maxLevel: "typing.Optional[uint]" = None
    currentFrequency: "typing.Optional[uint]" = None
    minFrequency: "typing.Optional[uint]" = None
    maxFrequency: "typing.Optional[uint]" = None
    options: "uint" = None
    onOffTransitionTime: "typing.Optional[uint]" = None
    onLevel: "typing.Union[Nullable, uint]" = None
    onTransitionTime: "typing.Union[None, Nullable, uint]" = None
    offTransitionTime: "typing.Union[None, Nullable, uint]" = None
    defaultMoveRate: "typing.Union[None, Nullable, uint]" = None
    startUpCurrentLevel: "typing.Union[None, Nullable, uint]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Enums:
        class MoveMode(IntEnum):
            kUp = 0x00
            kDown = 0x01

        class StepMode(IntEnum):
            kUp = 0x00
            kDown = 0x01

    class Commands:
        @dataclass
        class MoveToLevel(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0008
            command_id: typing.ClassVar[int] = 0x0000
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="level", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="transitionTime",
                            Tag=1,
                            Type=typing.Union[Nullable, uint],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsMask", Tag=2, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsOverride", Tag=3, Type=uint
                        ),
                    ]
                )

            level: "uint" = 0
            transitionTime: "typing.Union[Nullable, uint]" = NullValue
            optionsMask: "uint" = 0
            optionsOverride: "uint" = 0

        @dataclass
        class Move(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0008
            command_id: typing.ClassVar[int] = 0x0001
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="moveMode", Tag=0, Type=LevelControl.Enums.MoveMode
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="rate", Tag=1, Type=typing.Union[Nullable, uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsMask", Tag=2, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsOverride", Tag=3, Type=uint
                        ),
                    ]
                )

            moveMode: "LevelControl.Enums.MoveMode" = 0
            rate: "typing.Union[Nullable, uint]" = NullValue
            optionsMask: "uint" = 0
            optionsOverride: "uint" = 0

        @dataclass
        class Step(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0008
            command_id: typing.ClassVar[int] = 0x0002
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="stepMode", Tag=0, Type=LevelControl.Enums.StepMode
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="stepSize", Tag=1, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="transitionTime",
                            Tag=2,
                            Type=typing.Union[Nullable, uint],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsMask", Tag=3, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsOverride", Tag=4, Type=uint
                        ),
                    ]
                )

            stepMode: "LevelControl.Enums.StepMode" = 0
            stepSize: "uint" = 0
            transitionTime: "typing.Union[Nullable, uint]" = NullValue
            optionsMask: "uint" = 0
            optionsOverride: "uint" = 0

        @dataclass
        class Stop(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0008
            command_id: typing.ClassVar[int] = 0x0003
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="optionsMask", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsOverride", Tag=1, Type=uint
                        ),
                    ]
                )

            optionsMask: "uint" = 0
            optionsOverride: "uint" = 0

        @dataclass
        class MoveToLevelWithOnOff(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0008
            command_id: typing.ClassVar[int] = 0x0004
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="level", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="transitionTime",
                            Tag=1,
                            Type=typing.Union[Nullable, uint],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsMask", Tag=2, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsOverride", Tag=3, Type=uint
                        ),
                    ]
                )

            level: "uint" = 0
            transitionTime: "typing.Union[Nullable, uint]" = NullValue
            optionsMask: "uint" = 0
            optionsOverride: "uint" = 0

        @dataclass
        class MoveWithOnOff(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0008
            command_id: typing.ClassVar[int] = 0x0005
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="moveMode", Tag=0, Type=LevelControl.Enums.MoveMode
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="rate", Tag=1, Type=typing.Union[Nullable, uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsMask", Tag=2, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsOverride", Tag=3, Type=uint
                        ),
                    ]
                )

            moveMode: "LevelControl.Enums.MoveMode" = 0
            rate: "typing.Union[Nullable, uint]" = NullValue
            optionsMask: "uint" = 0
            optionsOverride: "uint" = 0

        @dataclass
        class StepWithOnOff(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0008
            command_id: typing.ClassVar[int] = 0x0006
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="stepMode", Tag=0, Type=LevelControl.Enums.StepMode
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="stepSize", Tag=1, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="transitionTime",
                            Tag=2,
                            Type=typing.Union[Nullable, uint],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsMask", Tag=3, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsOverride", Tag=4, Type=uint
                        ),
                    ]
                )

            stepMode: "LevelControl.Enums.StepMode" = 0
            stepSize: "uint" = 0
            transitionTime: "typing.Union[Nullable, uint]" = NullValue
            optionsMask: "uint" = 0
            optionsOverride: "uint" = 0

        @dataclass
        class StopWithOnOff(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0008
            command_id: typing.ClassVar[int] = 0x0007
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="optionsMask", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsOverride", Tag=1, Type=uint
                        ),
                    ]
                )

            optionsMask: "uint" = 0
            optionsOverride: "uint" = 0

        @dataclass
        class MoveToClosestFrequency(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0008
            command_id: typing.ClassVar[int] = 0x0008
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="frequency", Tag=0, Type=uint
                        ),
                    ]
                )

            frequency: "uint" = 0

    class Attributes:
        @dataclass
        class CurrentLevel(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0008

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, uint])

            value: "typing.Union[Nullable, uint]" = NullValue

        @dataclass
        class RemainingTime(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0008

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class MinLevel(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0008

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class MaxLevel(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0008

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class CurrentFrequency(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0008

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000004

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class MinFrequency(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0008

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000005

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class MaxFrequency(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0008

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000006

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class Options(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0008

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000F

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class OnOffTransitionTime(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0008

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000010

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class OnLevel(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0008

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000011

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, uint])

            value: "typing.Union[Nullable, uint]" = NullValue

        @dataclass
        class OnTransitionTime(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0008

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000012

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class OffTransitionTime(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0008

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000013

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class DefaultMoveRate(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0008

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000014

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class StartUpCurrentLevel(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0008

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00004000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0008

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0008

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0008

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0008

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0008

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class BinaryInputBasic(Cluster):
    id: typing.ClassVar[int] = 0x000F

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="activeText", Tag=0x00000004, Type=typing.Optional[str]
                ),
                ClusterObjectFieldDescriptor(
                    Label="description", Tag=0x0000001C, Type=typing.Optional[str]
                ),
                ClusterObjectFieldDescriptor(
                    Label="inactiveText", Tag=0x0000002E, Type=typing.Optional[str]
                ),
                ClusterObjectFieldDescriptor(
                    Label="outOfService", Tag=0x00000051, Type=bool
                ),
                ClusterObjectFieldDescriptor(
                    Label="polarity", Tag=0x00000054, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="presentValue", Tag=0x00000055, Type=bool
                ),
                ClusterObjectFieldDescriptor(
                    Label="reliability", Tag=0x00000067, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="statusFlags", Tag=0x0000006F, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="applicationType", Tag=0x00000100, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    activeText: "typing.Optional[str]" = None
    description: "typing.Optional[str]" = None
    inactiveText: "typing.Optional[str]" = None
    outOfService: "bool" = None
    polarity: "typing.Optional[uint]" = None
    presentValue: "bool" = None
    reliability: "typing.Optional[uint]" = None
    statusFlags: "uint" = None
    applicationType: "typing.Optional[uint]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Attributes:
        @dataclass
        class ActiveText(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x000F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000004

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[str])

            value: "typing.Optional[str]" = None

        @dataclass
        class Description(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x000F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000001C

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[str])

            value: "typing.Optional[str]" = None

        @dataclass
        class InactiveText(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x000F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000002E

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[str])

            value: "typing.Optional[str]" = None

        @dataclass
        class OutOfService(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x000F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000051

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=bool)

            value: "bool" = False

        @dataclass
        class Polarity(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x000F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000054

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class PresentValue(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x000F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000055

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=bool)

            value: "bool" = False

        @dataclass
        class Reliability(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x000F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000067

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class StatusFlags(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x000F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000006F

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ApplicationType(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x000F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000100

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x000F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x000F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x000F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x000F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x000F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class PulseWidthModulation(Cluster):
    id: typing.ClassVar[int] = 0x001C

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Attributes:
        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x001C

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x001C

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x001C

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x001C

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x001C

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class Descriptor(Cluster):
    id: typing.ClassVar[int] = 0x001D

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="deviceTypeList",
                    Tag=0x00000000,
                    Type=typing.List[Descriptor.Structs.DeviceTypeStruct],
                ),
                ClusterObjectFieldDescriptor(
                    Label="serverList", Tag=0x00000001, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="clientList", Tag=0x00000002, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="partsList", Tag=0x00000003, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    deviceTypeList: "typing.List[Descriptor.Structs.DeviceTypeStruct]" = None
    serverList: "typing.List[uint]" = None
    clientList: "typing.List[uint]" = None
    partsList: "typing.List[uint]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Structs:
        @dataclass
        class DeviceTypeStruct(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="type", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="revision", Tag=1, Type=uint
                        ),
                    ]
                )

            type: "uint" = 0
            revision: "uint" = 0

    class Attributes:
        @dataclass
        class DeviceTypeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x001D

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.List[Descriptor.Structs.DeviceTypeStruct]
                )

            value: "typing.List[Descriptor.Structs.DeviceTypeStruct]" = field(
                default_factory=lambda: []
            )

        @dataclass
        class ServerList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x001D

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class ClientList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x001D

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class PartsList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x001D

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x001D

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x001D

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x001D

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x001D

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x001D

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class Binding(Cluster):
    id: typing.ClassVar[int] = 0x001E

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="binding",
                    Tag=0x00000000,
                    Type=typing.List[Binding.Structs.TargetStruct],
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    binding: "typing.List[Binding.Structs.TargetStruct]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Structs:
        @dataclass
        class TargetStruct(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="node", Tag=1, Type=typing.Optional[uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="group", Tag=2, Type=typing.Optional[uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="endpoint", Tag=3, Type=typing.Optional[uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="cluster", Tag=4, Type=typing.Optional[uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="fabricIndex", Tag=254, Type=uint
                        ),
                    ]
                )

            node: "typing.Optional[uint]" = None
            group: "typing.Optional[uint]" = None
            endpoint: "typing.Optional[uint]" = None
            cluster: "typing.Optional[uint]" = None
            fabricIndex: "uint" = 0

    class Attributes:
        @dataclass
        class Binding(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x001E

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.List[Binding.Structs.TargetStruct]
                )

            value: "typing.List[Binding.Structs.TargetStruct]" = field(
                default_factory=lambda: []
            )

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x001E

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x001E

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x001E

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x001E

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x001E

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class AccessControl(Cluster):
    id: typing.ClassVar[int] = 0x001F

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="acl",
                    Tag=0x00000000,
                    Type=typing.List[AccessControl.Structs.AccessControlEntry],
                ),
                ClusterObjectFieldDescriptor(
                    Label="extension",
                    Tag=0x00000001,
                    Type=typing.Optional[
                        typing.List[AccessControl.Structs.ExtensionEntry]
                    ],
                ),
                ClusterObjectFieldDescriptor(
                    Label="subjectsPerAccessControlEntry", Tag=0x00000002, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="targetsPerAccessControlEntry", Tag=0x00000003, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="accessControlEntriesPerFabric", Tag=0x00000004, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    acl: "typing.List[AccessControl.Structs.AccessControlEntry]" = None
    extension: "typing.Optional[typing.List[AccessControl.Structs.ExtensionEntry]]" = (
        None
    )
    subjectsPerAccessControlEntry: "uint" = None
    targetsPerAccessControlEntry: "uint" = None
    accessControlEntriesPerFabric: "uint" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Enums:
        class AuthMode(IntEnum):
            kPase = 0x01
            kCase = 0x02
            kGroup = 0x03

        class ChangeTypeEnum(IntEnum):
            kChanged = 0x00
            kAdded = 0x01
            kRemoved = 0x02

        class Privilege(IntEnum):
            kView = 0x01
            kProxyView = 0x02
            kOperate = 0x03
            kManage = 0x04
            kAdminister = 0x05

    class Structs:
        @dataclass
        class Target(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="cluster", Tag=0, Type=typing.Union[Nullable, uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="endpoint", Tag=1, Type=typing.Union[Nullable, uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="deviceType", Tag=2, Type=typing.Union[Nullable, uint]
                        ),
                    ]
                )

            cluster: "typing.Union[Nullable, uint]" = NullValue
            endpoint: "typing.Union[Nullable, uint]" = NullValue
            deviceType: "typing.Union[Nullable, uint]" = NullValue

        @dataclass
        class AccessControlEntry(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="privilege", Tag=1, Type=AccessControl.Enums.Privilege
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="authMode", Tag=2, Type=AccessControl.Enums.AuthMode
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="subjects",
                            Tag=3,
                            Type=typing.Union[Nullable, typing.List[uint]],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="targets",
                            Tag=4,
                            Type=typing.Union[
                                Nullable, typing.List[AccessControl.Structs.Target]
                            ],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="fabricIndex", Tag=254, Type=uint
                        ),
                    ]
                )

            privilege: "AccessControl.Enums.Privilege" = 0
            authMode: "AccessControl.Enums.AuthMode" = 0
            subjects: "typing.Union[Nullable, typing.List[uint]]" = NullValue
            targets: "typing.Union[Nullable, typing.List[AccessControl.Structs.Target]]" = (
                NullValue
            )
            fabricIndex: "uint" = 0

        @dataclass
        class ExtensionEntry(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="data", Tag=1, Type=bytes),
                        ClusterObjectFieldDescriptor(
                            Label="fabricIndex", Tag=254, Type=uint
                        ),
                    ]
                )

            data: "bytes" = b""
            fabricIndex: "uint" = 0

    class Attributes:
        @dataclass
        class Acl(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x001F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.List[AccessControl.Structs.AccessControlEntry]
                )

            value: "typing.List[AccessControl.Structs.AccessControlEntry]" = field(
                default_factory=lambda: []
            )

        @dataclass
        class Extension(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x001F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Optional[
                        typing.List[AccessControl.Structs.ExtensionEntry]
                    ]
                )

            value: "typing.Optional[typing.List[AccessControl.Structs.ExtensionEntry]]" = (
                None
            )

        @dataclass
        class SubjectsPerAccessControlEntry(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x001F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class TargetsPerAccessControlEntry(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x001F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class AccessControlEntriesPerFabric(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x001F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000004

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x001F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x001F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x001F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x001F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x001F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

    class Events:
        @dataclass
        class AccessControlEntryChanged(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x001F

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="adminNodeID",
                            Tag=1,
                            Type=typing.Union[Nullable, uint],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="adminPasscodeID",
                            Tag=2,
                            Type=typing.Union[Nullable, uint],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="changeType",
                            Tag=3,
                            Type=AccessControl.Enums.ChangeTypeEnum,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="latestValue",
                            Tag=4,
                            Type=typing.Union[
                                Nullable, AccessControl.Structs.AccessControlEntry
                            ],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="fabricIndex", Tag=254, Type=uint
                        ),
                    ]
                )

            adminNodeID: "typing.Union[Nullable, uint]" = NullValue
            adminPasscodeID: "typing.Union[Nullable, uint]" = NullValue
            changeType: "AccessControl.Enums.ChangeTypeEnum" = 0
            latestValue: "typing.Union[Nullable, AccessControl.Structs.AccessControlEntry]" = (
                NullValue
            )
            fabricIndex: "uint" = 0

        @dataclass
        class AccessControlExtensionChanged(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x001F

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="adminNodeID",
                            Tag=1,
                            Type=typing.Union[Nullable, uint],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="adminPasscodeID",
                            Tag=2,
                            Type=typing.Union[Nullable, uint],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="changeType",
                            Tag=3,
                            Type=AccessControl.Enums.ChangeTypeEnum,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="latestValue",
                            Tag=4,
                            Type=typing.Union[
                                Nullable, AccessControl.Structs.ExtensionEntry
                            ],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="fabricIndex", Tag=254, Type=uint
                        ),
                    ]
                )

            adminNodeID: "typing.Union[Nullable, uint]" = NullValue
            adminPasscodeID: "typing.Union[Nullable, uint]" = NullValue
            changeType: "AccessControl.Enums.ChangeTypeEnum" = 0
            latestValue: "typing.Union[Nullable, AccessControl.Structs.ExtensionEntry]" = (
                NullValue
            )
            fabricIndex: "uint" = 0


@dataclass
class Actions(Cluster):
    id: typing.ClassVar[int] = 0x0025

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="actionList",
                    Tag=0x00000000,
                    Type=typing.List[Actions.Structs.ActionStruct],
                ),
                ClusterObjectFieldDescriptor(
                    Label="endpointLists",
                    Tag=0x00000001,
                    Type=typing.List[Actions.Structs.EndpointListStruct],
                ),
                ClusterObjectFieldDescriptor(
                    Label="setupURL", Tag=0x00000002, Type=typing.Optional[str]
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    actionList: "typing.List[Actions.Structs.ActionStruct]" = None
    endpointLists: "typing.List[Actions.Structs.EndpointListStruct]" = None
    setupURL: "typing.Optional[str]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Enums:
        class ActionErrorEnum(IntEnum):
            kUnknown = 0x00
            kInterrupted = 0x01

        class ActionStateEnum(IntEnum):
            kInactive = 0x00
            kActive = 0x01
            kPaused = 0x02
            kDisabled = 0x03

        class ActionTypeEnum(IntEnum):
            kOther = 0x00
            kScene = 0x01
            kSequence = 0x02
            kAutomation = 0x03
            kException = 0x04
            kNotification = 0x05
            kAlarm = 0x06

        class EndpointListTypeEnum(IntEnum):
            kOther = 0x00
            kRoom = 0x01
            kZone = 0x02

    class Structs:
        @dataclass
        class ActionStruct(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="actionID", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(Label="name", Tag=1, Type=str),
                        ClusterObjectFieldDescriptor(
                            Label="type", Tag=2, Type=Actions.Enums.ActionTypeEnum
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="endpointListID", Tag=3, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="supportedCommands", Tag=4, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="state", Tag=5, Type=Actions.Enums.ActionStateEnum
                        ),
                    ]
                )

            actionID: "uint" = 0
            name: "str" = ""
            type: "Actions.Enums.ActionTypeEnum" = 0
            endpointListID: "uint" = 0
            supportedCommands: "uint" = 0
            state: "Actions.Enums.ActionStateEnum" = 0

        @dataclass
        class EndpointListStruct(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="endpointListID", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(Label="name", Tag=1, Type=str),
                        ClusterObjectFieldDescriptor(
                            Label="type", Tag=2, Type=Actions.Enums.EndpointListTypeEnum
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="endpoints", Tag=3, Type=typing.List[uint]
                        ),
                    ]
                )

            endpointListID: "uint" = 0
            name: "str" = ""
            type: "Actions.Enums.EndpointListTypeEnum" = 0
            endpoints: "typing.List[uint]" = field(default_factory=lambda: [])

    class Commands:
        @dataclass
        class InstantAction(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0025
            command_id: typing.ClassVar[int] = 0x0000
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="actionID", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="invokeID", Tag=1, Type=typing.Optional[uint]
                        ),
                    ]
                )

            actionID: "uint" = 0
            invokeID: "typing.Optional[uint]" = None

        @dataclass
        class InstantActionWithTransition(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0025
            command_id: typing.ClassVar[int] = 0x0001
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="actionID", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="invokeID", Tag=1, Type=typing.Optional[uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="transitionTime", Tag=2, Type=uint
                        ),
                    ]
                )

            actionID: "uint" = 0
            invokeID: "typing.Optional[uint]" = None
            transitionTime: "uint" = 0

        @dataclass
        class StartAction(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0025
            command_id: typing.ClassVar[int] = 0x0002
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="actionID", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="invokeID", Tag=1, Type=typing.Optional[uint]
                        ),
                    ]
                )

            actionID: "uint" = 0
            invokeID: "typing.Optional[uint]" = None

        @dataclass
        class StartActionWithDuration(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0025
            command_id: typing.ClassVar[int] = 0x0003
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="actionID", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="invokeID", Tag=1, Type=typing.Optional[uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="duration", Tag=2, Type=uint
                        ),
                    ]
                )

            actionID: "uint" = 0
            invokeID: "typing.Optional[uint]" = None
            duration: "uint" = 0

        @dataclass
        class StopAction(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0025
            command_id: typing.ClassVar[int] = 0x0004
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="actionID", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="invokeID", Tag=1, Type=typing.Optional[uint]
                        ),
                    ]
                )

            actionID: "uint" = 0
            invokeID: "typing.Optional[uint]" = None

        @dataclass
        class PauseAction(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0025
            command_id: typing.ClassVar[int] = 0x0005
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="actionID", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="invokeID", Tag=1, Type=typing.Optional[uint]
                        ),
                    ]
                )

            actionID: "uint" = 0
            invokeID: "typing.Optional[uint]" = None

        @dataclass
        class PauseActionWithDuration(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0025
            command_id: typing.ClassVar[int] = 0x0006
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="actionID", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="invokeID", Tag=1, Type=typing.Optional[uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="duration", Tag=2, Type=uint
                        ),
                    ]
                )

            actionID: "uint" = 0
            invokeID: "typing.Optional[uint]" = None
            duration: "uint" = 0

        @dataclass
        class ResumeAction(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0025
            command_id: typing.ClassVar[int] = 0x0007
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="actionID", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="invokeID", Tag=1, Type=typing.Optional[uint]
                        ),
                    ]
                )

            actionID: "uint" = 0
            invokeID: "typing.Optional[uint]" = None

        @dataclass
        class EnableAction(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0025
            command_id: typing.ClassVar[int] = 0x0008
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="actionID", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="invokeID", Tag=1, Type=typing.Optional[uint]
                        ),
                    ]
                )

            actionID: "uint" = 0
            invokeID: "typing.Optional[uint]" = None

        @dataclass
        class EnableActionWithDuration(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0025
            command_id: typing.ClassVar[int] = 0x0009
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="actionID", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="invokeID", Tag=1, Type=typing.Optional[uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="duration", Tag=2, Type=uint
                        ),
                    ]
                )

            actionID: "uint" = 0
            invokeID: "typing.Optional[uint]" = None
            duration: "uint" = 0

        @dataclass
        class DisableAction(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0025
            command_id: typing.ClassVar[int] = 0x000A
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="actionID", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="invokeID", Tag=1, Type=typing.Optional[uint]
                        ),
                    ]
                )

            actionID: "uint" = 0
            invokeID: "typing.Optional[uint]" = None

        @dataclass
        class DisableActionWithDuration(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0025
            command_id: typing.ClassVar[int] = 0x000B
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="actionID", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="invokeID", Tag=1, Type=typing.Optional[uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="duration", Tag=2, Type=uint
                        ),
                    ]
                )

            actionID: "uint" = 0
            invokeID: "typing.Optional[uint]" = None
            duration: "uint" = 0

    class Attributes:
        @dataclass
        class ActionList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0025

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.List[Actions.Structs.ActionStruct]
                )

            value: "typing.List[Actions.Structs.ActionStruct]" = field(
                default_factory=lambda: []
            )

        @dataclass
        class EndpointLists(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0025

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.List[Actions.Structs.EndpointListStruct]
                )

            value: "typing.List[Actions.Structs.EndpointListStruct]" = field(
                default_factory=lambda: []
            )

        @dataclass
        class SetupURL(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0025

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[str])

            value: "typing.Optional[str]" = None

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0025

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0025

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0025

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0025

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0025

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

    class Events:
        @dataclass
        class StateChanged(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0025

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="actionID", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="invokeID", Tag=1, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="newState", Tag=2, Type=Actions.Enums.ActionStateEnum
                        ),
                    ]
                )

            actionID: "uint" = 0
            invokeID: "uint" = 0
            newState: "Actions.Enums.ActionStateEnum" = 0

        @dataclass
        class ActionFailed(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0025

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="actionID", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="invokeID", Tag=1, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="newState", Tag=2, Type=Actions.Enums.ActionStateEnum
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="error", Tag=3, Type=Actions.Enums.ActionErrorEnum
                        ),
                    ]
                )

            actionID: "uint" = 0
            invokeID: "uint" = 0
            newState: "Actions.Enums.ActionStateEnum" = 0
            error: "Actions.Enums.ActionErrorEnum" = 0


@dataclass
class Basic(Cluster):
    id: typing.ClassVar[int] = 0x0028

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="dataModelRevision", Tag=0x00000000, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="vendorName", Tag=0x00000001, Type=str
                ),
                ClusterObjectFieldDescriptor(
                    Label="vendorID", Tag=0x00000002, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="productName", Tag=0x00000003, Type=str
                ),
                ClusterObjectFieldDescriptor(
                    Label="productID", Tag=0x00000004, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="nodeLabel", Tag=0x00000005, Type=str
                ),
                ClusterObjectFieldDescriptor(
                    Label="location", Tag=0x00000006, Type=str
                ),
                ClusterObjectFieldDescriptor(
                    Label="hardwareVersion", Tag=0x00000007, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="hardwareVersionString", Tag=0x00000008, Type=str
                ),
                ClusterObjectFieldDescriptor(
                    Label="softwareVersion", Tag=0x00000009, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="softwareVersionString", Tag=0x0000000A, Type=str
                ),
                ClusterObjectFieldDescriptor(
                    Label="manufacturingDate", Tag=0x0000000B, Type=typing.Optional[str]
                ),
                ClusterObjectFieldDescriptor(
                    Label="partNumber", Tag=0x0000000C, Type=typing.Optional[str]
                ),
                ClusterObjectFieldDescriptor(
                    Label="productURL", Tag=0x0000000D, Type=typing.Optional[str]
                ),
                ClusterObjectFieldDescriptor(
                    Label="productLabel", Tag=0x0000000E, Type=typing.Optional[str]
                ),
                ClusterObjectFieldDescriptor(
                    Label="serialNumber", Tag=0x0000000F, Type=typing.Optional[str]
                ),
                ClusterObjectFieldDescriptor(
                    Label="localConfigDisabled",
                    Tag=0x00000010,
                    Type=typing.Optional[bool],
                ),
                ClusterObjectFieldDescriptor(
                    Label="reachable", Tag=0x00000011, Type=typing.Optional[bool]
                ),
                ClusterObjectFieldDescriptor(
                    Label="uniqueID", Tag=0x00000012, Type=typing.Optional[str]
                ),
                ClusterObjectFieldDescriptor(
                    Label="capabilityMinima",
                    Tag=0x00000013,
                    Type=Basic.Structs.CapabilityMinimaStruct,
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    dataModelRevision: "uint" = None
    vendorName: "str" = None
    vendorID: "uint" = None
    productName: "str" = None
    productID: "uint" = None
    nodeLabel: "str" = None
    location: "str" = None
    hardwareVersion: "uint" = None
    hardwareVersionString: "str" = None
    softwareVersion: "uint" = None
    softwareVersionString: "str" = None
    manufacturingDate: "typing.Optional[str]" = None
    partNumber: "typing.Optional[str]" = None
    productURL: "typing.Optional[str]" = None
    productLabel: "typing.Optional[str]" = None
    serialNumber: "typing.Optional[str]" = None
    localConfigDisabled: "typing.Optional[bool]" = None
    reachable: "typing.Optional[bool]" = None
    uniqueID: "typing.Optional[str]" = None
    capabilityMinima: "Basic.Structs.CapabilityMinimaStruct" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Structs:
        @dataclass
        class CapabilityMinimaStruct(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="caseSessionsPerFabric", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="subscriptionsPerFabric", Tag=1, Type=uint
                        ),
                    ]
                )

            caseSessionsPerFabric: "uint" = 0
            subscriptionsPerFabric: "uint" = 0

    class Commands:
        @dataclass
        class MfgSpecificPing(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0028
            command_id: typing.ClassVar[int] = 0x0000
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

    class Attributes:
        @dataclass
        class DataModelRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0028

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class VendorName(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0028

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=str)

            value: "str" = ""

        @dataclass
        class VendorID(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0028

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ProductName(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0028

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=str)

            value: "str" = ""

        @dataclass
        class ProductID(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0028

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000004

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class NodeLabel(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0028

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000005

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=str)

            value: "str" = ""

        @dataclass
        class Location(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0028

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000006

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=str)

            value: "str" = ""

        @dataclass
        class HardwareVersion(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0028

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000007

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class HardwareVersionString(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0028

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000008

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=str)

            value: "str" = ""

        @dataclass
        class SoftwareVersion(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0028

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000009

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class SoftwareVersionString(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0028

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000A

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=str)

            value: "str" = ""

        @dataclass
        class ManufacturingDate(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0028

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000B

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[str])

            value: "typing.Optional[str]" = None

        @dataclass
        class PartNumber(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0028

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000C

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[str])

            value: "typing.Optional[str]" = None

        @dataclass
        class ProductURL(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0028

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000D

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[str])

            value: "typing.Optional[str]" = None

        @dataclass
        class ProductLabel(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0028

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000E

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[str])

            value: "typing.Optional[str]" = None

        @dataclass
        class SerialNumber(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0028

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000F

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[str])

            value: "typing.Optional[str]" = None

        @dataclass
        class LocalConfigDisabled(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0028

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000010

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[bool])

            value: "typing.Optional[bool]" = None

        @dataclass
        class Reachable(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0028

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000011

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[bool])

            value: "typing.Optional[bool]" = None

        @dataclass
        class UniqueID(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0028

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000012

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[str])

            value: "typing.Optional[str]" = None

        @dataclass
        class CapabilityMinima(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0028

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000013

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=Basic.Structs.CapabilityMinimaStruct
                )

            value: "Basic.Structs.CapabilityMinimaStruct" = field(
                default_factory=lambda: Basic.Structs.CapabilityMinimaStruct()
            )

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0028

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0028

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0028

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0028

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0028

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

    class Events:
        @dataclass
        class StartUp(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0028

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="softwareVersion", Tag=0, Type=uint
                        ),
                    ]
                )

            softwareVersion: "uint" = 0

        @dataclass
        class ShutDown(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0028

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class Leave(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0028

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="fabricIndex", Tag=0, Type=uint
                        ),
                    ]
                )

            fabricIndex: "uint" = 0

        @dataclass
        class ReachableChanged(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0028

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="reachableNewValue", Tag=0, Type=bool
                        ),
                    ]
                )

            reachableNewValue: "bool" = False


@dataclass
class OtaSoftwareUpdateProvider(Cluster):
    id: typing.ClassVar[int] = 0x0029

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Enums:
        class OTAApplyUpdateAction(IntEnum):
            kProceed = 0x00
            kAwaitNextAction = 0x01
            kDiscontinue = 0x02

        class OTADownloadProtocol(IntEnum):
            kBDXSynchronous = 0x00
            kBDXAsynchronous = 0x01
            kHttps = 0x02
            kVendorSpecific = 0x03

        class OTAQueryStatus(IntEnum):
            kUpdateAvailable = 0x00
            kBusy = 0x01
            kNotAvailable = 0x02
            kDownloadProtocolNotSupported = 0x03

    class Commands:
        @dataclass
        class QueryImage(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0029
            command_id: typing.ClassVar[int] = 0x0000
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="vendorId", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="productId", Tag=1, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="softwareVersion", Tag=2, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="protocolsSupported",
                            Tag=3,
                            Type=typing.List[
                                OtaSoftwareUpdateProvider.Enums.OTADownloadProtocol
                            ],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="hardwareVersion", Tag=4, Type=typing.Optional[uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="location", Tag=5, Type=typing.Optional[str]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="requestorCanConsent",
                            Tag=6,
                            Type=typing.Optional[bool],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="metadataForProvider",
                            Tag=7,
                            Type=typing.Optional[bytes],
                        ),
                    ]
                )

            vendorId: "uint" = 0
            productId: "uint" = 0
            softwareVersion: "uint" = 0
            protocolsSupported: "typing.List[OtaSoftwareUpdateProvider.Enums.OTADownloadProtocol]" = field(
                default_factory=lambda: []
            )
            hardwareVersion: "typing.Optional[uint]" = None
            location: "typing.Optional[str]" = None
            requestorCanConsent: "typing.Optional[bool]" = None
            metadataForProvider: "typing.Optional[bytes]" = None

        @dataclass
        class QueryImageResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0029
            command_id: typing.ClassVar[int] = 0x0001
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="status",
                            Tag=0,
                            Type=OtaSoftwareUpdateProvider.Enums.OTAQueryStatus,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="delayedActionTime", Tag=1, Type=typing.Optional[uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="imageURI", Tag=2, Type=typing.Optional[str]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="softwareVersion", Tag=3, Type=typing.Optional[uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="softwareVersionString",
                            Tag=4,
                            Type=typing.Optional[str],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="updateToken", Tag=5, Type=typing.Optional[bytes]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="userConsentNeeded", Tag=6, Type=typing.Optional[bool]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="metadataForRequestor",
                            Tag=7,
                            Type=typing.Optional[bytes],
                        ),
                    ]
                )

            status: "OtaSoftwareUpdateProvider.Enums.OTAQueryStatus" = 0
            delayedActionTime: "typing.Optional[uint]" = None
            imageURI: "typing.Optional[str]" = None
            softwareVersion: "typing.Optional[uint]" = None
            softwareVersionString: "typing.Optional[str]" = None
            updateToken: "typing.Optional[bytes]" = None
            userConsentNeeded: "typing.Optional[bool]" = None
            metadataForRequestor: "typing.Optional[bytes]" = None

        @dataclass
        class ApplyUpdateRequest(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0029
            command_id: typing.ClassVar[int] = 0x0002
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="updateToken", Tag=0, Type=bytes
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="newVersion", Tag=1, Type=uint
                        ),
                    ]
                )

            updateToken: "bytes" = b""
            newVersion: "uint" = 0

        @dataclass
        class ApplyUpdateResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0029
            command_id: typing.ClassVar[int] = 0x0003
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="action",
                            Tag=0,
                            Type=OtaSoftwareUpdateProvider.Enums.OTAApplyUpdateAction,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="delayedActionTime", Tag=1, Type=uint
                        ),
                    ]
                )

            action: "OtaSoftwareUpdateProvider.Enums.OTAApplyUpdateAction" = 0
            delayedActionTime: "uint" = 0

        @dataclass
        class NotifyUpdateApplied(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0029
            command_id: typing.ClassVar[int] = 0x0004
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="updateToken", Tag=0, Type=bytes
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="softwareVersion", Tag=1, Type=uint
                        ),
                    ]
                )

            updateToken: "bytes" = b""
            softwareVersion: "uint" = 0

    class Attributes:
        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0029

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0029

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0029

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0029

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0029

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class OtaSoftwareUpdateRequestor(Cluster):
    id: typing.ClassVar[int] = 0x002A

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="defaultOtaProviders",
                    Tag=0x00000000,
                    Type=typing.List[
                        OtaSoftwareUpdateRequestor.Structs.ProviderLocation
                    ],
                ),
                ClusterObjectFieldDescriptor(
                    Label="updatePossible", Tag=0x00000001, Type=bool
                ),
                ClusterObjectFieldDescriptor(
                    Label="updateState",
                    Tag=0x00000002,
                    Type=OtaSoftwareUpdateRequestor.Enums.OTAUpdateStateEnum,
                ),
                ClusterObjectFieldDescriptor(
                    Label="updateStateProgress",
                    Tag=0x00000003,
                    Type=typing.Union[Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    defaultOtaProviders: "typing.List[OtaSoftwareUpdateRequestor.Structs.ProviderLocation]" = (
        None
    )
    updatePossible: "bool" = None
    updateState: "OtaSoftwareUpdateRequestor.Enums.OTAUpdateStateEnum" = None
    updateStateProgress: "typing.Union[Nullable, uint]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Enums:
        class OTAAnnouncementReason(IntEnum):
            kSimpleAnnouncement = 0x00
            kUpdateAvailable = 0x01
            kUrgentUpdateAvailable = 0x02

        class OTAChangeReasonEnum(IntEnum):
            kUnknown = 0x00
            kSuccess = 0x01
            kFailure = 0x02
            kTimeOut = 0x03
            kDelayByProvider = 0x04

        class OTAUpdateStateEnum(IntEnum):
            kUnknown = 0x00
            kIdle = 0x01
            kQuerying = 0x02
            kDelayedOnQuery = 0x03
            kDownloading = 0x04
            kApplying = 0x05
            kDelayedOnApply = 0x06
            kRollingBack = 0x07
            kDelayedOnUserConsent = 0x08

    class Structs:
        @dataclass
        class ProviderLocation(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="providerNodeID", Tag=1, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="endpoint", Tag=2, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="fabricIndex", Tag=254, Type=uint
                        ),
                    ]
                )

            providerNodeID: "uint" = 0
            endpoint: "uint" = 0
            fabricIndex: "uint" = 0

    class Commands:
        @dataclass
        class AnnounceOtaProvider(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x002A
            command_id: typing.ClassVar[int] = 0x0000
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="providerNodeId", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="vendorId", Tag=1, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="announcementReason",
                            Tag=2,
                            Type=OtaSoftwareUpdateRequestor.Enums.OTAAnnouncementReason,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="metadataForNode", Tag=3, Type=typing.Optional[bytes]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="endpoint", Tag=4, Type=uint
                        ),
                    ]
                )

            providerNodeId: "uint" = 0
            vendorId: "uint" = 0
            announcementReason: "OtaSoftwareUpdateRequestor.Enums.OTAAnnouncementReason" = (
                0
            )
            metadataForNode: "typing.Optional[bytes]" = None
            endpoint: "uint" = 0

    class Attributes:
        @dataclass
        class DefaultOtaProviders(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002A

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.List[
                        OtaSoftwareUpdateRequestor.Structs.ProviderLocation
                    ]
                )

            value: "typing.List[OtaSoftwareUpdateRequestor.Structs.ProviderLocation]" = field(
                default_factory=lambda: []
            )

        @dataclass
        class UpdatePossible(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002A

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=bool)

            value: "bool" = False

        @dataclass
        class UpdateState(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002A

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=OtaSoftwareUpdateRequestor.Enums.OTAUpdateStateEnum
                )

            value: "OtaSoftwareUpdateRequestor.Enums.OTAUpdateStateEnum" = 0

        @dataclass
        class UpdateStateProgress(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002A

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, uint])

            value: "typing.Union[Nullable, uint]" = NullValue

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002A

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002A

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002A

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002A

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002A

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

    class Events:
        @dataclass
        class StateTransition(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002A

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="previousState",
                            Tag=0,
                            Type=OtaSoftwareUpdateRequestor.Enums.OTAUpdateStateEnum,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="newState",
                            Tag=1,
                            Type=OtaSoftwareUpdateRequestor.Enums.OTAUpdateStateEnum,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="reason",
                            Tag=2,
                            Type=OtaSoftwareUpdateRequestor.Enums.OTAChangeReasonEnum,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="targetSoftwareVersion",
                            Tag=3,
                            Type=typing.Union[Nullable, uint],
                        ),
                    ]
                )

            previousState: "OtaSoftwareUpdateRequestor.Enums.OTAUpdateStateEnum" = 0
            newState: "OtaSoftwareUpdateRequestor.Enums.OTAUpdateStateEnum" = 0
            reason: "OtaSoftwareUpdateRequestor.Enums.OTAChangeReasonEnum" = 0
            targetSoftwareVersion: "typing.Union[Nullable, uint]" = NullValue

        @dataclass
        class VersionApplied(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002A

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="softwareVersion", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="productID", Tag=1, Type=uint
                        ),
                    ]
                )

            softwareVersion: "uint" = 0
            productID: "uint" = 0

        @dataclass
        class DownloadError(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002A

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="softwareVersion", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="bytesDownloaded", Tag=1, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="progressPercent",
                            Tag=2,
                            Type=typing.Union[Nullable, uint],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="platformCode",
                            Tag=3,
                            Type=typing.Union[Nullable, int],
                        ),
                    ]
                )

            softwareVersion: "uint" = 0
            bytesDownloaded: "uint" = 0
            progressPercent: "typing.Union[Nullable, uint]" = NullValue
            platformCode: "typing.Union[Nullable, int]" = NullValue


@dataclass
class LocalizationConfiguration(Cluster):
    id: typing.ClassVar[int] = 0x002B

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="activeLocale", Tag=0x00000000, Type=str
                ),
                ClusterObjectFieldDescriptor(
                    Label="supportedLocales", Tag=0x00000001, Type=typing.List[str]
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    activeLocale: "str" = None
    supportedLocales: "typing.List[str]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Attributes:
        @dataclass
        class ActiveLocale(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002B

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=str)

            value: "str" = ""

        @dataclass
        class SupportedLocales(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002B

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[str])

            value: "typing.List[str]" = field(default_factory=lambda: [])

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002B

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002B

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002B

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002B

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002B

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class TimeFormatLocalization(Cluster):
    id: typing.ClassVar[int] = 0x002C

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="hourFormat",
                    Tag=0x00000000,
                    Type=TimeFormatLocalization.Enums.HourFormat,
                ),
                ClusterObjectFieldDescriptor(
                    Label="activeCalendarType",
                    Tag=0x00000001,
                    Type=typing.Optional[TimeFormatLocalization.Enums.CalendarType],
                ),
                ClusterObjectFieldDescriptor(
                    Label="supportedCalendarTypes",
                    Tag=0x00000002,
                    Type=typing.Optional[
                        typing.List[TimeFormatLocalization.Enums.CalendarType]
                    ],
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    hourFormat: "TimeFormatLocalization.Enums.HourFormat" = None
    activeCalendarType: "typing.Optional[TimeFormatLocalization.Enums.CalendarType]" = (
        None
    )
    supportedCalendarTypes: "typing.Optional[typing.List[TimeFormatLocalization.Enums.CalendarType]]" = (
        None
    )
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Enums:
        class CalendarType(IntEnum):
            kBuddhist = 0x00
            kChinese = 0x01
            kCoptic = 0x02
            kEthiopian = 0x03
            kGregorian = 0x04
            kHebrew = 0x05
            kIndian = 0x06
            kIslamic = 0x07
            kJapanese = 0x08
            kKorean = 0x09
            kPersian = 0x0A
            kTaiwanese = 0x0B

        class HourFormat(IntEnum):
            k12hr = 0x00
            k24hr = 0x01

    class Attributes:
        @dataclass
        class HourFormat(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002C

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=TimeFormatLocalization.Enums.HourFormat
                )

            value: "TimeFormatLocalization.Enums.HourFormat" = 0

        @dataclass
        class ActiveCalendarType(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002C

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Optional[TimeFormatLocalization.Enums.CalendarType]
                )

            value: "typing.Optional[TimeFormatLocalization.Enums.CalendarType]" = None

        @dataclass
        class SupportedCalendarTypes(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002C

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Optional[
                        typing.List[TimeFormatLocalization.Enums.CalendarType]
                    ]
                )

            value: "typing.Optional[typing.List[TimeFormatLocalization.Enums.CalendarType]]" = (
                None
            )

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002C

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002C

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002C

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002C

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002C

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class UnitLocalization(Cluster):
    id: typing.ClassVar[int] = 0x002D

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="temperatureUnit",
                    Tag=0x00000000,
                    Type=typing.Optional[UnitLocalization.Enums.TempUnit],
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    temperatureUnit: "typing.Optional[UnitLocalization.Enums.TempUnit]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Enums:
        class TempUnit(IntEnum):
            kFahrenheit = 0x00
            kCelsius = 0x01
            kKelvin = 0x02

    class Attributes:
        @dataclass
        class TemperatureUnit(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002D

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Optional[UnitLocalization.Enums.TempUnit]
                )

            value: "typing.Optional[UnitLocalization.Enums.TempUnit]" = None

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002D

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002D

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002D

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002D

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002D

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class PowerSourceConfiguration(Cluster):
    id: typing.ClassVar[int] = 0x002E

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="sources", Tag=0x00000000, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    sources: "typing.List[uint]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Attributes:
        @dataclass
        class Sources(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002E

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002E

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002E

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002E

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002E

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002E

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class PowerSource(Cluster):
    id: typing.ClassVar[int] = 0x002F

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="status",
                    Tag=0x00000000,
                    Type=PowerSource.Enums.PowerSourceStatus,
                ),
                ClusterObjectFieldDescriptor(Label="order", Tag=0x00000001, Type=uint),
                ClusterObjectFieldDescriptor(
                    Label="description", Tag=0x00000002, Type=str
                ),
                ClusterObjectFieldDescriptor(
                    Label="wiredAssessedInputVoltage",
                    Tag=0x00000003,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="wiredAssessedInputFrequency",
                    Tag=0x00000004,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="wiredCurrentType",
                    Tag=0x00000005,
                    Type=typing.Optional[PowerSource.Enums.WiredCurrentType],
                ),
                ClusterObjectFieldDescriptor(
                    Label="wiredAssessedCurrent",
                    Tag=0x00000006,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="wiredNominalVoltage",
                    Tag=0x00000007,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="wiredMaximumCurrent",
                    Tag=0x00000008,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="wiredPresent", Tag=0x00000009, Type=typing.Optional[bool]
                ),
                ClusterObjectFieldDescriptor(
                    Label="activeWiredFaults",
                    Tag=0x0000000A,
                    Type=typing.Optional[typing.List[PowerSource.Enums.WiredFault]],
                ),
                ClusterObjectFieldDescriptor(
                    Label="batVoltage",
                    Tag=0x0000000B,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="batPercentRemaining",
                    Tag=0x0000000C,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="batTimeRemaining",
                    Tag=0x0000000D,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="batChargeLevel",
                    Tag=0x0000000E,
                    Type=typing.Optional[PowerSource.Enums.BatChargeLevel],
                ),
                ClusterObjectFieldDescriptor(
                    Label="batReplacementNeeded",
                    Tag=0x0000000F,
                    Type=typing.Optional[bool],
                ),
                ClusterObjectFieldDescriptor(
                    Label="batReplaceability",
                    Tag=0x00000010,
                    Type=typing.Optional[PowerSource.Enums.BatReplaceability],
                ),
                ClusterObjectFieldDescriptor(
                    Label="batPresent", Tag=0x00000011, Type=typing.Optional[bool]
                ),
                ClusterObjectFieldDescriptor(
                    Label="activeBatFaults",
                    Tag=0x00000012,
                    Type=typing.Optional[typing.List[PowerSource.Enums.BatFault]],
                ),
                ClusterObjectFieldDescriptor(
                    Label="batReplacementDescription",
                    Tag=0x00000013,
                    Type=typing.Optional[str],
                ),
                ClusterObjectFieldDescriptor(
                    Label="batCommonDesignation",
                    Tag=0x00000014,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="batANSIDesignation",
                    Tag=0x00000015,
                    Type=typing.Optional[str],
                ),
                ClusterObjectFieldDescriptor(
                    Label="batIECDesignation", Tag=0x00000016, Type=typing.Optional[str]
                ),
                ClusterObjectFieldDescriptor(
                    Label="batApprovedChemistry",
                    Tag=0x00000017,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="batCapacity", Tag=0x00000018, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="batQuantity", Tag=0x00000019, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="batChargeState",
                    Tag=0x0000001A,
                    Type=typing.Optional[PowerSource.Enums.BatChargeState],
                ),
                ClusterObjectFieldDescriptor(
                    Label="batTimeToFullCharge",
                    Tag=0x0000001B,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="batFunctionalWhileCharging",
                    Tag=0x0000001C,
                    Type=typing.Optional[bool],
                ),
                ClusterObjectFieldDescriptor(
                    Label="batChargingCurrent",
                    Tag=0x0000001D,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="activeBatChargeFaults",
                    Tag=0x0000001E,
                    Type=typing.Optional[typing.List[PowerSource.Enums.BatChargeFault]],
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    status: "PowerSource.Enums.PowerSourceStatus" = None
    order: "uint" = None
    description: "str" = None
    wiredAssessedInputVoltage: "typing.Union[None, Nullable, uint]" = None
    wiredAssessedInputFrequency: "typing.Union[None, Nullable, uint]" = None
    wiredCurrentType: "typing.Optional[PowerSource.Enums.WiredCurrentType]" = None
    wiredAssessedCurrent: "typing.Union[None, Nullable, uint]" = None
    wiredNominalVoltage: "typing.Optional[uint]" = None
    wiredMaximumCurrent: "typing.Optional[uint]" = None
    wiredPresent: "typing.Optional[bool]" = None
    activeWiredFaults: "typing.Optional[typing.List[PowerSource.Enums.WiredFault]]" = (
        None
    )
    batVoltage: "typing.Union[None, Nullable, uint]" = None
    batPercentRemaining: "typing.Union[None, Nullable, uint]" = None
    batTimeRemaining: "typing.Union[None, Nullable, uint]" = None
    batChargeLevel: "typing.Optional[PowerSource.Enums.BatChargeLevel]" = None
    batReplacementNeeded: "typing.Optional[bool]" = None
    batReplaceability: "typing.Optional[PowerSource.Enums.BatReplaceability]" = None
    batPresent: "typing.Optional[bool]" = None
    activeBatFaults: "typing.Optional[typing.List[PowerSource.Enums.BatFault]]" = None
    batReplacementDescription: "typing.Optional[str]" = None
    batCommonDesignation: "typing.Optional[uint]" = None
    batANSIDesignation: "typing.Optional[str]" = None
    batIECDesignation: "typing.Optional[str]" = None
    batApprovedChemistry: "typing.Optional[uint]" = None
    batCapacity: "typing.Optional[uint]" = None
    batQuantity: "typing.Optional[uint]" = None
    batChargeState: "typing.Optional[PowerSource.Enums.BatChargeState]" = None
    batTimeToFullCharge: "typing.Union[None, Nullable, uint]" = None
    batFunctionalWhileCharging: "typing.Optional[bool]" = None
    batChargingCurrent: "typing.Union[None, Nullable, uint]" = None
    activeBatChargeFaults: "typing.Optional[typing.List[PowerSource.Enums.BatChargeFault]]" = (
        None
    )
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Enums:
        class BatChargeFault(IntEnum):
            kUnspecfied = 0x00
            kAmbientTooHot = 0x01
            kAmbientTooCold = 0x02
            kBatteryTooHot = 0x03
            kBatteryTooCold = 0x04
            kBatteryAbsent = 0x05
            kBatteryOverVoltage = 0x06
            kBatteryUnderVoltage = 0x07
            kChargerOverVoltage = 0x08
            kChargerUnderVoltage = 0x09
            kSafetyTimeout = 0x0A

        class BatChargeLevel(IntEnum):
            kOk = 0x00
            kWarning = 0x01
            kCritical = 0x02

        class BatChargeState(IntEnum):
            kUnknown = 0x00
            kIsCharging = 0x01
            kIsAtFullCharge = 0x02
            kIsNotCharging = 0x03

        class BatFault(IntEnum):
            kUnspecfied = 0x00
            kOverTemp = 0x01
            kUnderTemp = 0x02

        class BatReplaceability(IntEnum):
            kUnspecified = 0x00
            kNotReplaceable = 0x01
            kUserReplaceable = 0x02
            kFactoryReplaceable = 0x03

        class PowerSourceStatus(IntEnum):
            kUnspecfied = 0x00
            kActive = 0x01
            kStandby = 0x02
            kUnavailable = 0x03

        class WiredCurrentType(IntEnum):
            kAc = 0x00
            kDc = 0x01

        class WiredFault(IntEnum):
            kUnspecfied = 0x00
            kOverVoltage = 0x01
            kUnderVoltage = 0x02

    class Structs:
        @dataclass
        class BatChargeFaultChangeType(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="current",
                            Tag=0,
                            Type=typing.List[PowerSource.Enums.BatChargeFault],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="previous",
                            Tag=1,
                            Type=typing.List[PowerSource.Enums.BatChargeFault],
                        ),
                    ]
                )

            current: "typing.List[PowerSource.Enums.BatChargeFault]" = field(
                default_factory=lambda: []
            )
            previous: "typing.List[PowerSource.Enums.BatChargeFault]" = field(
                default_factory=lambda: []
            )

        @dataclass
        class BatFaultChangeType(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="current",
                            Tag=0,
                            Type=typing.List[PowerSource.Enums.BatFault],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="previous",
                            Tag=1,
                            Type=typing.List[PowerSource.Enums.BatFault],
                        ),
                    ]
                )

            current: "typing.List[PowerSource.Enums.BatFault]" = field(
                default_factory=lambda: []
            )
            previous: "typing.List[PowerSource.Enums.BatFault]" = field(
                default_factory=lambda: []
            )

        @dataclass
        class WiredFaultChangeType(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="current",
                            Tag=0,
                            Type=typing.List[PowerSource.Enums.WiredFault],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="previous",
                            Tag=1,
                            Type=typing.List[PowerSource.Enums.WiredFault],
                        ),
                    ]
                )

            current: "typing.List[PowerSource.Enums.WiredFault]" = field(
                default_factory=lambda: []
            )
            previous: "typing.List[PowerSource.Enums.WiredFault]" = field(
                default_factory=lambda: []
            )

    class Attributes:
        @dataclass
        class Status(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=PowerSource.Enums.PowerSourceStatus
                )

            value: "PowerSource.Enums.PowerSourceStatus" = 0

        @dataclass
        class Order(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class Description(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=str)

            value: "str" = ""

        @dataclass
        class WiredAssessedInputVoltage(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class WiredAssessedInputFrequency(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000004

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class WiredCurrentType(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000005

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Optional[PowerSource.Enums.WiredCurrentType]
                )

            value: "typing.Optional[PowerSource.Enums.WiredCurrentType]" = None

        @dataclass
        class WiredAssessedCurrent(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000006

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class WiredNominalVoltage(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000007

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class WiredMaximumCurrent(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000008

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class WiredPresent(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000009

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[bool])

            value: "typing.Optional[bool]" = None

        @dataclass
        class ActiveWiredFaults(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000A

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Optional[typing.List[PowerSource.Enums.WiredFault]]
                )

            value: "typing.Optional[typing.List[PowerSource.Enums.WiredFault]]" = None

        @dataclass
        class BatVoltage(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000B

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class BatPercentRemaining(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000C

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class BatTimeRemaining(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000D

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class BatChargeLevel(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000E

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Optional[PowerSource.Enums.BatChargeLevel]
                )

            value: "typing.Optional[PowerSource.Enums.BatChargeLevel]" = None

        @dataclass
        class BatReplacementNeeded(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000F

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[bool])

            value: "typing.Optional[bool]" = None

        @dataclass
        class BatReplaceability(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000010

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Optional[PowerSource.Enums.BatReplaceability]
                )

            value: "typing.Optional[PowerSource.Enums.BatReplaceability]" = None

        @dataclass
        class BatPresent(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000011

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[bool])

            value: "typing.Optional[bool]" = None

        @dataclass
        class ActiveBatFaults(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000012

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Optional[typing.List[PowerSource.Enums.BatFault]]
                )

            value: "typing.Optional[typing.List[PowerSource.Enums.BatFault]]" = None

        @dataclass
        class BatReplacementDescription(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000013

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[str])

            value: "typing.Optional[str]" = None

        @dataclass
        class BatCommonDesignation(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000014

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class BatANSIDesignation(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000015

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[str])

            value: "typing.Optional[str]" = None

        @dataclass
        class BatIECDesignation(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000016

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[str])

            value: "typing.Optional[str]" = None

        @dataclass
        class BatApprovedChemistry(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000017

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class BatCapacity(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000018

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class BatQuantity(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000019

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class BatChargeState(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000001A

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Optional[PowerSource.Enums.BatChargeState]
                )

            value: "typing.Optional[PowerSource.Enums.BatChargeState]" = None

        @dataclass
        class BatTimeToFullCharge(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000001B

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class BatFunctionalWhileCharging(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000001C

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[bool])

            value: "typing.Optional[bool]" = None

        @dataclass
        class BatChargingCurrent(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000001D

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class ActiveBatChargeFaults(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000001E

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Optional[typing.List[PowerSource.Enums.BatChargeFault]]
                )

            value: "typing.Optional[typing.List[PowerSource.Enums.BatChargeFault]]" = (
                None
            )

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x002F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class GeneralCommissioning(Cluster):
    id: typing.ClassVar[int] = 0x0030

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="breadcrumb", Tag=0x00000000, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="basicCommissioningInfo",
                    Tag=0x00000001,
                    Type=GeneralCommissioning.Structs.BasicCommissioningInfo,
                ),
                ClusterObjectFieldDescriptor(
                    Label="regulatoryConfig",
                    Tag=0x00000002,
                    Type=GeneralCommissioning.Enums.RegulatoryLocationType,
                ),
                ClusterObjectFieldDescriptor(
                    Label="locationCapability",
                    Tag=0x00000003,
                    Type=GeneralCommissioning.Enums.RegulatoryLocationType,
                ),
                ClusterObjectFieldDescriptor(
                    Label="supportsConcurrentConnection", Tag=0x00000004, Type=bool
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    breadcrumb: "uint" = None
    basicCommissioningInfo: "GeneralCommissioning.Structs.BasicCommissioningInfo" = None
    regulatoryConfig: "GeneralCommissioning.Enums.RegulatoryLocationType" = None
    locationCapability: "GeneralCommissioning.Enums.RegulatoryLocationType" = None
    supportsConcurrentConnection: "bool" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Enums:
        class CommissioningError(IntEnum):
            kOk = 0x00
            kValueOutsideRange = 0x01
            kInvalidAuthentication = 0x02
            kNoFailSafe = 0x03
            kBusyWithOtherAdmin = 0x04

        class RegulatoryLocationType(IntEnum):
            kIndoor = 0x00
            kOutdoor = 0x01
            kIndoorOutdoor = 0x02

    class Structs:
        @dataclass
        class BasicCommissioningInfo(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="failSafeExpiryLengthSeconds", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="maxCumulativeFailsafeSeconds", Tag=1, Type=uint
                        ),
                    ]
                )

            failSafeExpiryLengthSeconds: "uint" = 0
            maxCumulativeFailsafeSeconds: "uint" = 0

    class Commands:
        @dataclass
        class ArmFailSafe(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0030
            command_id: typing.ClassVar[int] = 0x0000
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="expiryLengthSeconds", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="breadcrumb", Tag=1, Type=uint
                        ),
                    ]
                )

            expiryLengthSeconds: "uint" = 0
            breadcrumb: "uint" = 0

        @dataclass
        class ArmFailSafeResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0030
            command_id: typing.ClassVar[int] = 0x0001
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="errorCode",
                            Tag=0,
                            Type=GeneralCommissioning.Enums.CommissioningError,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="debugText", Tag=1, Type=str
                        ),
                    ]
                )

            errorCode: "GeneralCommissioning.Enums.CommissioningError" = 0
            debugText: "str" = ""

        @dataclass
        class SetRegulatoryConfig(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0030
            command_id: typing.ClassVar[int] = 0x0002
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="newRegulatoryConfig",
                            Tag=0,
                            Type=GeneralCommissioning.Enums.RegulatoryLocationType,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="countryCode", Tag=1, Type=str
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="breadcrumb", Tag=2, Type=uint
                        ),
                    ]
                )

            newRegulatoryConfig: "GeneralCommissioning.Enums.RegulatoryLocationType" = 0
            countryCode: "str" = ""
            breadcrumb: "uint" = 0

        @dataclass
        class SetRegulatoryConfigResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0030
            command_id: typing.ClassVar[int] = 0x0003
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="errorCode",
                            Tag=0,
                            Type=GeneralCommissioning.Enums.CommissioningError,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="debugText", Tag=1, Type=str
                        ),
                    ]
                )

            errorCode: "GeneralCommissioning.Enums.CommissioningError" = 0
            debugText: "str" = ""

        @dataclass
        class CommissioningComplete(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0030
            command_id: typing.ClassVar[int] = 0x0004
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class CommissioningCompleteResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0030
            command_id: typing.ClassVar[int] = 0x0005
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="errorCode",
                            Tag=0,
                            Type=GeneralCommissioning.Enums.CommissioningError,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="debugText", Tag=1, Type=str
                        ),
                    ]
                )

            errorCode: "GeneralCommissioning.Enums.CommissioningError" = 0
            debugText: "str" = ""

    class Attributes:
        @dataclass
        class Breadcrumb(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0030

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class BasicCommissioningInfo(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0030

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=GeneralCommissioning.Structs.BasicCommissioningInfo
                )

            value: "GeneralCommissioning.Structs.BasicCommissioningInfo" = field(
                default_factory=lambda: GeneralCommissioning.Structs.BasicCommissioningInfo()
            )

        @dataclass
        class RegulatoryConfig(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0030

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=GeneralCommissioning.Enums.RegulatoryLocationType
                )

            value: "GeneralCommissioning.Enums.RegulatoryLocationType" = 0

        @dataclass
        class LocationCapability(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0030

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=GeneralCommissioning.Enums.RegulatoryLocationType
                )

            value: "GeneralCommissioning.Enums.RegulatoryLocationType" = 0

        @dataclass
        class SupportsConcurrentConnection(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0030

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000004

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=bool)

            value: "bool" = False

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0030

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0030

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0030

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0030

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0030

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class NetworkCommissioning(Cluster):
    id: typing.ClassVar[int] = 0x0031

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="maxNetworks", Tag=0x00000000, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="networks",
                    Tag=0x00000001,
                    Type=typing.List[NetworkCommissioning.Structs.NetworkInfo],
                ),
                ClusterObjectFieldDescriptor(
                    Label="scanMaxTimeSeconds",
                    Tag=0x00000002,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="connectMaxTimeSeconds",
                    Tag=0x00000003,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="interfaceEnabled", Tag=0x00000004, Type=bool
                ),
                ClusterObjectFieldDescriptor(
                    Label="lastNetworkingStatus",
                    Tag=0x00000005,
                    Type=typing.Union[
                        Nullable, NetworkCommissioning.Enums.NetworkCommissioningStatus
                    ],
                ),
                ClusterObjectFieldDescriptor(
                    Label="lastNetworkID",
                    Tag=0x00000006,
                    Type=typing.Union[Nullable, bytes],
                ),
                ClusterObjectFieldDescriptor(
                    Label="lastConnectErrorValue",
                    Tag=0x00000007,
                    Type=typing.Union[Nullable, int],
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    maxNetworks: "uint" = None
    networks: "typing.List[NetworkCommissioning.Structs.NetworkInfo]" = None
    scanMaxTimeSeconds: "typing.Optional[uint]" = None
    connectMaxTimeSeconds: "typing.Optional[uint]" = None
    interfaceEnabled: "bool" = None
    lastNetworkingStatus: "typing.Union[Nullable, NetworkCommissioning.Enums.NetworkCommissioningStatus]" = (
        None
    )
    lastNetworkID: "typing.Union[Nullable, bytes]" = None
    lastConnectErrorValue: "typing.Union[Nullable, int]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Enums:
        class NetworkCommissioningStatus(IntEnum):
            kSuccess = 0x00
            kOutOfRange = 0x01
            kBoundsExceeded = 0x02
            kNetworkIDNotFound = 0x03
            kDuplicateNetworkID = 0x04
            kNetworkNotFound = 0x05
            kRegulatoryError = 0x06
            kAuthFailure = 0x07
            kUnsupportedSecurity = 0x08
            kOtherConnectionFailure = 0x09
            kIPV6Failed = 0x0A
            kIPBindFailed = 0x0B
            kUnknownError = 0x0C

        class WiFiBand(IntEnum):
            k2g4 = 0x00
            k3g65 = 0x01
            k5g = 0x02
            k6g = 0x03
            k60g = 0x04

    class Structs:
        @dataclass
        class NetworkInfo(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="networkID", Tag=0, Type=bytes
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="connected", Tag=1, Type=bool
                        ),
                    ]
                )

            networkID: "bytes" = b""
            connected: "bool" = False

        @dataclass
        class ThreadInterfaceScanResult(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="panId", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="extendedPanId", Tag=1, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="networkName", Tag=2, Type=str
                        ),
                        ClusterObjectFieldDescriptor(Label="channel", Tag=3, Type=uint),
                        ClusterObjectFieldDescriptor(Label="version", Tag=4, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="extendedAddress", Tag=5, Type=bytes
                        ),
                        ClusterObjectFieldDescriptor(Label="rssi", Tag=6, Type=int),
                        ClusterObjectFieldDescriptor(Label="lqi", Tag=7, Type=uint),
                    ]
                )

            panId: "uint" = 0
            extendedPanId: "uint" = 0
            networkName: "str" = ""
            channel: "uint" = 0
            version: "uint" = 0
            extendedAddress: "bytes" = b""
            rssi: "int" = 0
            lqi: "uint" = 0

        @dataclass
        class WiFiInterfaceScanResult(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="security", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(Label="ssid", Tag=1, Type=bytes),
                        ClusterObjectFieldDescriptor(Label="bssid", Tag=2, Type=bytes),
                        ClusterObjectFieldDescriptor(Label="channel", Tag=3, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="wiFiBand",
                            Tag=4,
                            Type=NetworkCommissioning.Enums.WiFiBand,
                        ),
                        ClusterObjectFieldDescriptor(Label="rssi", Tag=5, Type=int),
                    ]
                )

            security: "uint" = 0
            ssid: "bytes" = b""
            bssid: "bytes" = b""
            channel: "uint" = 0
            wiFiBand: "NetworkCommissioning.Enums.WiFiBand" = 0
            rssi: "int" = 0

    class Commands:
        @dataclass
        class ScanNetworks(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0031
            command_id: typing.ClassVar[int] = 0x0000
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="ssid",
                            Tag=0,
                            Type=typing.Union[None, Nullable, bytes],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="breadcrumb", Tag=1, Type=typing.Optional[uint]
                        ),
                    ]
                )

            ssid: "typing.Union[None, Nullable, bytes]" = None
            breadcrumb: "typing.Optional[uint]" = None

        @dataclass
        class ScanNetworksResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0031
            command_id: typing.ClassVar[int] = 0x0001
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="networkingStatus",
                            Tag=0,
                            Type=NetworkCommissioning.Enums.NetworkCommissioningStatus,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="debugText", Tag=1, Type=typing.Optional[str]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="wiFiScanResults",
                            Tag=2,
                            Type=typing.Optional[
                                typing.List[
                                    NetworkCommissioning.Structs.WiFiInterfaceScanResult
                                ]
                            ],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="threadScanResults",
                            Tag=3,
                            Type=typing.Optional[
                                typing.List[
                                    NetworkCommissioning.Structs.ThreadInterfaceScanResult
                                ]
                            ],
                        ),
                    ]
                )

            networkingStatus: "NetworkCommissioning.Enums.NetworkCommissioningStatus" = (
                0
            )
            debugText: "typing.Optional[str]" = None
            wiFiScanResults: "typing.Optional[typing.List[NetworkCommissioning.Structs.WiFiInterfaceScanResult]]" = (
                None
            )
            threadScanResults: "typing.Optional[typing.List[NetworkCommissioning.Structs.ThreadInterfaceScanResult]]" = (
                None
            )

        @dataclass
        class AddOrUpdateWiFiNetwork(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0031
            command_id: typing.ClassVar[int] = 0x0002
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="ssid", Tag=0, Type=bytes),
                        ClusterObjectFieldDescriptor(
                            Label="credentials", Tag=1, Type=bytes
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="breadcrumb", Tag=2, Type=typing.Optional[uint]
                        ),
                    ]
                )

            ssid: "bytes" = b""
            credentials: "bytes" = b""
            breadcrumb: "typing.Optional[uint]" = None

        @dataclass
        class AddOrUpdateThreadNetwork(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0031
            command_id: typing.ClassVar[int] = 0x0003
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="operationalDataset", Tag=0, Type=bytes
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="breadcrumb", Tag=1, Type=typing.Optional[uint]
                        ),
                    ]
                )

            operationalDataset: "bytes" = b""
            breadcrumb: "typing.Optional[uint]" = None

        @dataclass
        class RemoveNetwork(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0031
            command_id: typing.ClassVar[int] = 0x0004
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="networkID", Tag=0, Type=bytes
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="breadcrumb", Tag=1, Type=typing.Optional[uint]
                        ),
                    ]
                )

            networkID: "bytes" = b""
            breadcrumb: "typing.Optional[uint]" = None

        @dataclass
        class NetworkConfigResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0031
            command_id: typing.ClassVar[int] = 0x0005
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="networkingStatus",
                            Tag=0,
                            Type=NetworkCommissioning.Enums.NetworkCommissioningStatus,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="debugText", Tag=1, Type=typing.Optional[str]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="networkIndex", Tag=2, Type=typing.Optional[uint]
                        ),
                    ]
                )

            networkingStatus: "NetworkCommissioning.Enums.NetworkCommissioningStatus" = (
                0
            )
            debugText: "typing.Optional[str]" = None
            networkIndex: "typing.Optional[uint]" = None

        @dataclass
        class ConnectNetwork(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0031
            command_id: typing.ClassVar[int] = 0x0006
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="networkID", Tag=0, Type=bytes
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="breadcrumb", Tag=1, Type=typing.Optional[uint]
                        ),
                    ]
                )

            networkID: "bytes" = b""
            breadcrumb: "typing.Optional[uint]" = None

        @dataclass
        class ConnectNetworkResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0031
            command_id: typing.ClassVar[int] = 0x0007
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="networkingStatus",
                            Tag=0,
                            Type=NetworkCommissioning.Enums.NetworkCommissioningStatus,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="debugText", Tag=1, Type=typing.Optional[str]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="errorValue", Tag=2, Type=typing.Union[Nullable, int]
                        ),
                    ]
                )

            networkingStatus: "NetworkCommissioning.Enums.NetworkCommissioningStatus" = (
                0
            )
            debugText: "typing.Optional[str]" = None
            errorValue: "typing.Union[Nullable, int]" = NullValue

        @dataclass
        class ReorderNetwork(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0031
            command_id: typing.ClassVar[int] = 0x0008
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="networkID", Tag=0, Type=bytes
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="networkIndex", Tag=1, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="breadcrumb", Tag=2, Type=typing.Optional[uint]
                        ),
                    ]
                )

            networkID: "bytes" = b""
            networkIndex: "uint" = 0
            breadcrumb: "typing.Optional[uint]" = None

    class Attributes:
        @dataclass
        class MaxNetworks(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0031

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class Networks(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0031

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.List[NetworkCommissioning.Structs.NetworkInfo]
                )

            value: "typing.List[NetworkCommissioning.Structs.NetworkInfo]" = field(
                default_factory=lambda: []
            )

        @dataclass
        class ScanMaxTimeSeconds(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0031

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class ConnectMaxTimeSeconds(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0031

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class InterfaceEnabled(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0031

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000004

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=bool)

            value: "bool" = False

        @dataclass
        class LastNetworkingStatus(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0031

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000005

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[
                        Nullable, NetworkCommissioning.Enums.NetworkCommissioningStatus
                    ]
                )

            value: "typing.Union[Nullable, NetworkCommissioning.Enums.NetworkCommissioningStatus]" = (
                NullValue
            )

        @dataclass
        class LastNetworkID(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0031

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000006

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, bytes])

            value: "typing.Union[Nullable, bytes]" = NullValue

        @dataclass
        class LastConnectErrorValue(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0031

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000007

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, int])

            value: "typing.Union[Nullable, int]" = NullValue

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0031

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0031

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0031

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0031

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0031

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class DiagnosticLogs(Cluster):
    id: typing.ClassVar[int] = 0x0032

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Enums:
        class LogsIntent(IntEnum):
            kEndUserSupport = 0x00
            kNetworkDiag = 0x01
            kCrashLogs = 0x02

        class LogsStatus(IntEnum):
            kSuccess = 0x00
            kExhausted = 0x01
            kNoLogs = 0x02
            kBusy = 0x03
            kDenied = 0x04

        class LogsTransferProtocol(IntEnum):
            kResponsePayload = 0x00
            kBdx = 0x01

    class Commands:
        @dataclass
        class RetrieveLogsRequest(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0032
            command_id: typing.ClassVar[int] = 0x0000
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="intent", Tag=0, Type=DiagnosticLogs.Enums.LogsIntent
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="requestedProtocol",
                            Tag=1,
                            Type=DiagnosticLogs.Enums.LogsTransferProtocol,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="transferFileDesignator", Tag=2, Type=bytes
                        ),
                    ]
                )

            intent: "DiagnosticLogs.Enums.LogsIntent" = 0
            requestedProtocol: "DiagnosticLogs.Enums.LogsTransferProtocol" = 0
            transferFileDesignator: "bytes" = b""

        @dataclass
        class RetrieveLogsResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0032
            command_id: typing.ClassVar[int] = 0x0001
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="status", Tag=0, Type=DiagnosticLogs.Enums.LogsStatus
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="content", Tag=1, Type=bytes
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="timeStamp", Tag=2, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="timeSinceBoot", Tag=3, Type=uint
                        ),
                    ]
                )

            status: "DiagnosticLogs.Enums.LogsStatus" = 0
            content: "bytes" = b""
            timeStamp: "uint" = 0
            timeSinceBoot: "uint" = 0

    class Attributes:
        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0032

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0032

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0032

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0032

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0032

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class GeneralDiagnostics(Cluster):
    id: typing.ClassVar[int] = 0x0033

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="networkInterfaces",
                    Tag=0x00000000,
                    Type=typing.List[GeneralDiagnostics.Structs.NetworkInterfaceType],
                ),
                ClusterObjectFieldDescriptor(
                    Label="rebootCount", Tag=0x00000001, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="upTime", Tag=0x00000002, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="totalOperationalHours",
                    Tag=0x00000003,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="bootReasons", Tag=0x00000004, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="activeHardwareFaults",
                    Tag=0x00000005,
                    Type=typing.Optional[typing.List[uint]],
                ),
                ClusterObjectFieldDescriptor(
                    Label="activeRadioFaults",
                    Tag=0x00000006,
                    Type=typing.Optional[typing.List[uint]],
                ),
                ClusterObjectFieldDescriptor(
                    Label="activeNetworkFaults",
                    Tag=0x00000007,
                    Type=typing.Optional[typing.List[uint]],
                ),
                ClusterObjectFieldDescriptor(
                    Label="testEventTriggersEnabled", Tag=0x00000008, Type=bool
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    networkInterfaces: "typing.List[GeneralDiagnostics.Structs.NetworkInterfaceType]" = (
        None
    )
    rebootCount: "uint" = None
    upTime: "typing.Optional[uint]" = None
    totalOperationalHours: "typing.Optional[uint]" = None
    bootReasons: "typing.Optional[uint]" = None
    activeHardwareFaults: "typing.Optional[typing.List[uint]]" = None
    activeRadioFaults: "typing.Optional[typing.List[uint]]" = None
    activeNetworkFaults: "typing.Optional[typing.List[uint]]" = None
    testEventTriggersEnabled: "bool" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Enums:
        class BootReasonType(IntEnum):
            kUnspecified = 0x00
            kPowerOnReboot = 0x01
            kBrownOutReset = 0x02
            kSoftwareWatchdogReset = 0x03
            kHardwareWatchdogReset = 0x04
            kSoftwareUpdateCompleted = 0x05
            kSoftwareReset = 0x06

        class HardwareFaultType(IntEnum):
            kUnspecified = 0x00
            kRadio = 0x01
            kSensor = 0x02
            kResettableOverTemp = 0x03
            kNonResettableOverTemp = 0x04
            kPowerSource = 0x05
            kVisualDisplayFault = 0x06
            kAudioOutputFault = 0x07
            kUserInterfaceFault = 0x08
            kNonVolatileMemoryError = 0x09
            kTamperDetected = 0x0A

        class InterfaceType(IntEnum):
            kUnspecified = 0x00
            kWiFi = 0x01
            kEthernet = 0x02
            kCellular = 0x03
            kThread = 0x04

        class NetworkFaultType(IntEnum):
            kUnspecified = 0x00
            kHardwareFailure = 0x01
            kNetworkJammed = 0x02
            kConnectionFailed = 0x03

        class RadioFaultType(IntEnum):
            kUnspecified = 0x00
            kWiFiFault = 0x01
            kCellularFault = 0x02
            kThreadFault = 0x03
            kNFCFault = 0x04
            kBLEFault = 0x05
            kEthernetFault = 0x06

    class Structs:
        @dataclass
        class NetworkInterfaceType(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="name", Tag=0, Type=str),
                        ClusterObjectFieldDescriptor(
                            Label="isOperational", Tag=1, Type=bool
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="offPremiseServicesReachableIPv4",
                            Tag=2,
                            Type=typing.Union[Nullable, bool],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="offPremiseServicesReachableIPv6",
                            Tag=3,
                            Type=typing.Union[Nullable, bool],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="hardwareAddress", Tag=4, Type=bytes
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="IPv4Addresses", Tag=5, Type=typing.List[bytes]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="IPv6Addresses", Tag=6, Type=typing.List[bytes]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="type",
                            Tag=7,
                            Type=GeneralDiagnostics.Enums.InterfaceType,
                        ),
                    ]
                )

            name: "str" = ""
            isOperational: "bool" = False
            offPremiseServicesReachableIPv4: "typing.Union[Nullable, bool]" = NullValue
            offPremiseServicesReachableIPv6: "typing.Union[Nullable, bool]" = NullValue
            hardwareAddress: "bytes" = b""
            IPv4Addresses: "typing.List[bytes]" = field(default_factory=lambda: [])
            IPv6Addresses: "typing.List[bytes]" = field(default_factory=lambda: [])
            type: "GeneralDiagnostics.Enums.InterfaceType" = 0

    class Commands:
        @dataclass
        class TestEventTrigger(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0033
            command_id: typing.ClassVar[int] = 0x0000
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="enableKey", Tag=0, Type=bytes
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="eventTrigger", Tag=1, Type=uint
                        ),
                    ]
                )

            enableKey: "bytes" = b""
            eventTrigger: "uint" = 0

    class Attributes:
        @dataclass
        class NetworkInterfaces(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0033

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.List[GeneralDiagnostics.Structs.NetworkInterfaceType]
                )

            value: "typing.List[GeneralDiagnostics.Structs.NetworkInterfaceType]" = (
                field(default_factory=lambda: [])
            )

        @dataclass
        class RebootCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0033

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class UpTime(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0033

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class TotalOperationalHours(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0033

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class BootReasons(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0033

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000004

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class ActiveHardwareFaults(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0033

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000005

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Optional[typing.List[uint]]
                )

            value: "typing.Optional[typing.List[uint]]" = None

        @dataclass
        class ActiveRadioFaults(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0033

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000006

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Optional[typing.List[uint]]
                )

            value: "typing.Optional[typing.List[uint]]" = None

        @dataclass
        class ActiveNetworkFaults(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0033

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000007

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Optional[typing.List[uint]]
                )

            value: "typing.Optional[typing.List[uint]]" = None

        @dataclass
        class TestEventTriggersEnabled(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0033

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000008

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=bool)

            value: "bool" = False

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0033

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0033

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0033

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0033

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0033

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

    class Events:
        @dataclass
        class HardwareFaultChange(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0033

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="current",
                            Tag=0,
                            Type=typing.List[
                                GeneralDiagnostics.Enums.HardwareFaultType
                            ],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="previous",
                            Tag=1,
                            Type=typing.List[
                                GeneralDiagnostics.Enums.HardwareFaultType
                            ],
                        ),
                    ]
                )

            current: "typing.List[GeneralDiagnostics.Enums.HardwareFaultType]" = field(
                default_factory=lambda: []
            )
            previous: "typing.List[GeneralDiagnostics.Enums.HardwareFaultType]" = field(
                default_factory=lambda: []
            )

        @dataclass
        class RadioFaultChange(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0033

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="current",
                            Tag=0,
                            Type=typing.List[GeneralDiagnostics.Enums.RadioFaultType],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="previous",
                            Tag=1,
                            Type=typing.List[GeneralDiagnostics.Enums.RadioFaultType],
                        ),
                    ]
                )

            current: "typing.List[GeneralDiagnostics.Enums.RadioFaultType]" = field(
                default_factory=lambda: []
            )
            previous: "typing.List[GeneralDiagnostics.Enums.RadioFaultType]" = field(
                default_factory=lambda: []
            )

        @dataclass
        class NetworkFaultChange(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0033

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="current",
                            Tag=0,
                            Type=typing.List[GeneralDiagnostics.Enums.NetworkFaultType],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="previous",
                            Tag=1,
                            Type=typing.List[GeneralDiagnostics.Enums.NetworkFaultType],
                        ),
                    ]
                )

            current: "typing.List[GeneralDiagnostics.Enums.NetworkFaultType]" = field(
                default_factory=lambda: []
            )
            previous: "typing.List[GeneralDiagnostics.Enums.NetworkFaultType]" = field(
                default_factory=lambda: []
            )

        @dataclass
        class BootReason(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0033

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="bootReason",
                            Tag=0,
                            Type=GeneralDiagnostics.Enums.BootReasonType,
                        ),
                    ]
                )

            bootReason: "GeneralDiagnostics.Enums.BootReasonType" = 0


@dataclass
class SoftwareDiagnostics(Cluster):
    id: typing.ClassVar[int] = 0x0034

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="threadMetrics",
                    Tag=0x00000000,
                    Type=typing.Optional[
                        typing.List[SoftwareDiagnostics.Structs.ThreadMetrics]
                    ],
                ),
                ClusterObjectFieldDescriptor(
                    Label="currentHeapFree", Tag=0x00000001, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="currentHeapUsed", Tag=0x00000002, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="currentHeapHighWatermark",
                    Tag=0x00000003,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    threadMetrics: "typing.Optional[typing.List[SoftwareDiagnostics.Structs.ThreadMetrics]]" = (
        None
    )
    currentHeapFree: "typing.Optional[uint]" = None
    currentHeapUsed: "typing.Optional[uint]" = None
    currentHeapHighWatermark: "typing.Optional[uint]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Structs:
        @dataclass
        class ThreadMetrics(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="id", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="name", Tag=1, Type=typing.Optional[str]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="stackFreeCurrent", Tag=2, Type=typing.Optional[uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="stackFreeMinimum", Tag=3, Type=typing.Optional[uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="stackSize", Tag=4, Type=typing.Optional[uint]
                        ),
                    ]
                )

            id: "uint" = 0
            name: "typing.Optional[str]" = None
            stackFreeCurrent: "typing.Optional[uint]" = None
            stackFreeMinimum: "typing.Optional[uint]" = None
            stackSize: "typing.Optional[uint]" = None

    class Commands:
        @dataclass
        class ResetWatermarks(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0034
            command_id: typing.ClassVar[int] = 0x0000
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

    class Attributes:
        @dataclass
        class ThreadMetrics(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0034

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Optional[
                        typing.List[SoftwareDiagnostics.Structs.ThreadMetrics]
                    ]
                )

            value: "typing.Optional[typing.List[SoftwareDiagnostics.Structs.ThreadMetrics]]" = (
                None
            )

        @dataclass
        class CurrentHeapFree(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0034

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class CurrentHeapUsed(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0034

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class CurrentHeapHighWatermark(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0034

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0034

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0034

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0034

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0034

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0034

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

    class Events:
        @dataclass
        class SoftwareFault(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0034

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="id", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="name", Tag=1, Type=typing.Optional[str]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="faultRecording", Tag=2, Type=typing.Optional[bytes]
                        ),
                    ]
                )

            id: "uint" = 0
            name: "typing.Optional[str]" = None
            faultRecording: "typing.Optional[bytes]" = None


@dataclass
class ThreadNetworkDiagnostics(Cluster):
    id: typing.ClassVar[int] = 0x0035

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="channel", Tag=0x00000000, Type=typing.Union[Nullable, uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="routingRole",
                    Tag=0x00000001,
                    Type=typing.Union[
                        Nullable, ThreadNetworkDiagnostics.Enums.RoutingRole
                    ],
                ),
                ClusterObjectFieldDescriptor(
                    Label="networkName",
                    Tag=0x00000002,
                    Type=typing.Union[Nullable, str],
                ),
                ClusterObjectFieldDescriptor(
                    Label="panId", Tag=0x00000003, Type=typing.Union[Nullable, uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="extendedPanId",
                    Tag=0x00000004,
                    Type=typing.Union[Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="meshLocalPrefix",
                    Tag=0x00000005,
                    Type=typing.Union[Nullable, bytes],
                ),
                ClusterObjectFieldDescriptor(
                    Label="overrunCount", Tag=0x00000006, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="neighborTableList",
                    Tag=0x00000007,
                    Type=typing.List[ThreadNetworkDiagnostics.Structs.NeighborTable],
                ),
                ClusterObjectFieldDescriptor(
                    Label="routeTableList",
                    Tag=0x00000008,
                    Type=typing.List[ThreadNetworkDiagnostics.Structs.RouteTable],
                ),
                ClusterObjectFieldDescriptor(
                    Label="partitionId",
                    Tag=0x00000009,
                    Type=typing.Union[Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="weighting", Tag=0x0000000A, Type=typing.Union[Nullable, uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="dataVersion",
                    Tag=0x0000000B,
                    Type=typing.Union[Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="stableDataVersion",
                    Tag=0x0000000C,
                    Type=typing.Union[Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="leaderRouterId",
                    Tag=0x0000000D,
                    Type=typing.Union[Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="detachedRoleCount",
                    Tag=0x0000000E,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="childRoleCount", Tag=0x0000000F, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="routerRoleCount", Tag=0x00000010, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="leaderRoleCount", Tag=0x00000011, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attachAttemptCount",
                    Tag=0x00000012,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="partitionIdChangeCount",
                    Tag=0x00000013,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="betterPartitionAttachAttemptCount",
                    Tag=0x00000014,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="parentChangeCount",
                    Tag=0x00000015,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="txTotalCount", Tag=0x00000016, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="txUnicastCount", Tag=0x00000017, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="txBroadcastCount", Tag=0x00000018, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="txAckRequestedCount",
                    Tag=0x00000019,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="txAckedCount", Tag=0x0000001A, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="txNoAckRequestedCount",
                    Tag=0x0000001B,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="txDataCount", Tag=0x0000001C, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="txDataPollCount", Tag=0x0000001D, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="txBeaconCount", Tag=0x0000001E, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="txBeaconRequestCount",
                    Tag=0x0000001F,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="txOtherCount", Tag=0x00000020, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="txRetryCount", Tag=0x00000021, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="txDirectMaxRetryExpiryCount",
                    Tag=0x00000022,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="txIndirectMaxRetryExpiryCount",
                    Tag=0x00000023,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="txErrCcaCount", Tag=0x00000024, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="txErrAbortCount", Tag=0x00000025, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="txErrBusyChannelCount",
                    Tag=0x00000026,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="rxTotalCount", Tag=0x00000027, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="rxUnicastCount", Tag=0x00000028, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="rxBroadcastCount", Tag=0x00000029, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="rxDataCount", Tag=0x0000002A, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="rxDataPollCount", Tag=0x0000002B, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="rxBeaconCount", Tag=0x0000002C, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="rxBeaconRequestCount",
                    Tag=0x0000002D,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="rxOtherCount", Tag=0x0000002E, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="rxAddressFilteredCount",
                    Tag=0x0000002F,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="rxDestAddrFilteredCount",
                    Tag=0x00000030,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="rxDuplicatedCount",
                    Tag=0x00000031,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="rxErrNoFrameCount",
                    Tag=0x00000032,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="rxErrUnknownNeighborCount",
                    Tag=0x00000033,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="rxErrInvalidSrcAddrCount",
                    Tag=0x00000034,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="rxErrSecCount", Tag=0x00000035, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="rxErrFcsCount", Tag=0x00000036, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="rxErrOtherCount", Tag=0x00000037, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="activeTimestamp",
                    Tag=0x00000038,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="pendingTimestamp",
                    Tag=0x00000039,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="delay",
                    Tag=0x0000003A,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="securityPolicy",
                    Tag=0x0000003B,
                    Type=typing.Union[
                        Nullable, ThreadNetworkDiagnostics.Structs.SecurityPolicy
                    ],
                ),
                ClusterObjectFieldDescriptor(
                    Label="channelPage0Mask",
                    Tag=0x0000003C,
                    Type=typing.Union[Nullable, bytes],
                ),
                ClusterObjectFieldDescriptor(
                    Label="operationalDatasetComponents",
                    Tag=0x0000003D,
                    Type=typing.Union[
                        Nullable,
                        ThreadNetworkDiagnostics.Structs.OperationalDatasetComponents,
                    ],
                ),
                ClusterObjectFieldDescriptor(
                    Label="activeNetworkFaultsList",
                    Tag=0x0000003E,
                    Type=typing.List[ThreadNetworkDiagnostics.Enums.NetworkFault],
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    channel: "typing.Union[Nullable, uint]" = None
    routingRole: "typing.Union[Nullable, ThreadNetworkDiagnostics.Enums.RoutingRole]" = (
        None
    )
    networkName: "typing.Union[Nullable, str]" = None
    panId: "typing.Union[Nullable, uint]" = None
    extendedPanId: "typing.Union[Nullable, uint]" = None
    meshLocalPrefix: "typing.Union[Nullable, bytes]" = None
    overrunCount: "typing.Optional[uint]" = None
    neighborTableList: "typing.List[ThreadNetworkDiagnostics.Structs.NeighborTable]" = (
        None
    )
    routeTableList: "typing.List[ThreadNetworkDiagnostics.Structs.RouteTable]" = None
    partitionId: "typing.Union[Nullable, uint]" = None
    weighting: "typing.Union[Nullable, uint]" = None
    dataVersion: "typing.Union[Nullable, uint]" = None
    stableDataVersion: "typing.Union[Nullable, uint]" = None
    leaderRouterId: "typing.Union[Nullable, uint]" = None
    detachedRoleCount: "typing.Optional[uint]" = None
    childRoleCount: "typing.Optional[uint]" = None
    routerRoleCount: "typing.Optional[uint]" = None
    leaderRoleCount: "typing.Optional[uint]" = None
    attachAttemptCount: "typing.Optional[uint]" = None
    partitionIdChangeCount: "typing.Optional[uint]" = None
    betterPartitionAttachAttemptCount: "typing.Optional[uint]" = None
    parentChangeCount: "typing.Optional[uint]" = None
    txTotalCount: "typing.Optional[uint]" = None
    txUnicastCount: "typing.Optional[uint]" = None
    txBroadcastCount: "typing.Optional[uint]" = None
    txAckRequestedCount: "typing.Optional[uint]" = None
    txAckedCount: "typing.Optional[uint]" = None
    txNoAckRequestedCount: "typing.Optional[uint]" = None
    txDataCount: "typing.Optional[uint]" = None
    txDataPollCount: "typing.Optional[uint]" = None
    txBeaconCount: "typing.Optional[uint]" = None
    txBeaconRequestCount: "typing.Optional[uint]" = None
    txOtherCount: "typing.Optional[uint]" = None
    txRetryCount: "typing.Optional[uint]" = None
    txDirectMaxRetryExpiryCount: "typing.Optional[uint]" = None
    txIndirectMaxRetryExpiryCount: "typing.Optional[uint]" = None
    txErrCcaCount: "typing.Optional[uint]" = None
    txErrAbortCount: "typing.Optional[uint]" = None
    txErrBusyChannelCount: "typing.Optional[uint]" = None
    rxTotalCount: "typing.Optional[uint]" = None
    rxUnicastCount: "typing.Optional[uint]" = None
    rxBroadcastCount: "typing.Optional[uint]" = None
    rxDataCount: "typing.Optional[uint]" = None
    rxDataPollCount: "typing.Optional[uint]" = None
    rxBeaconCount: "typing.Optional[uint]" = None
    rxBeaconRequestCount: "typing.Optional[uint]" = None
    rxOtherCount: "typing.Optional[uint]" = None
    rxAddressFilteredCount: "typing.Optional[uint]" = None
    rxDestAddrFilteredCount: "typing.Optional[uint]" = None
    rxDuplicatedCount: "typing.Optional[uint]" = None
    rxErrNoFrameCount: "typing.Optional[uint]" = None
    rxErrUnknownNeighborCount: "typing.Optional[uint]" = None
    rxErrInvalidSrcAddrCount: "typing.Optional[uint]" = None
    rxErrSecCount: "typing.Optional[uint]" = None
    rxErrFcsCount: "typing.Optional[uint]" = None
    rxErrOtherCount: "typing.Optional[uint]" = None
    activeTimestamp: "typing.Union[None, Nullable, uint]" = None
    pendingTimestamp: "typing.Union[None, Nullable, uint]" = None
    delay: "typing.Union[None, Nullable, uint]" = None
    securityPolicy: "typing.Union[Nullable, ThreadNetworkDiagnostics.Structs.SecurityPolicy]" = (
        None
    )
    channelPage0Mask: "typing.Union[Nullable, bytes]" = None
    operationalDatasetComponents: "typing.Union[Nullable, ThreadNetworkDiagnostics.Structs.OperationalDatasetComponents]" = (
        None
    )
    activeNetworkFaultsList: "typing.List[ThreadNetworkDiagnostics.Enums.NetworkFault]" = (
        None
    )
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Enums:
        class NetworkFault(IntEnum):
            kUnspecified = 0x00
            kLinkDown = 0x01
            kHardwareFailure = 0x02
            kNetworkJammed = 0x03

        class RoutingRole(IntEnum):
            kUnspecified = 0x00
            kUnassigned = 0x01
            kSleepyEndDevice = 0x02
            kEndDevice = 0x03
            kReed = 0x04
            kRouter = 0x05
            kLeader = 0x06

        class ThreadConnectionStatus(IntEnum):
            kConnected = 0x00
            kNotConnected = 0x01

    class Structs:
        @dataclass
        class NeighborTable(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="extAddress", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(Label="age", Tag=1, Type=uint),
                        ClusterObjectFieldDescriptor(Label="rloc16", Tag=2, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="linkFrameCounter", Tag=3, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="mleFrameCounter", Tag=4, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(Label="lqi", Tag=5, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="averageRssi", Tag=6, Type=typing.Union[Nullable, int]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="lastRssi", Tag=7, Type=typing.Union[Nullable, int]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="frameErrorRate", Tag=8, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="messageErrorRate", Tag=9, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="rxOnWhenIdle", Tag=10, Type=bool
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="fullThreadDevice", Tag=11, Type=bool
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="fullNetworkData", Tag=12, Type=bool
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="isChild", Tag=13, Type=bool
                        ),
                    ]
                )

            extAddress: "uint" = 0
            age: "uint" = 0
            rloc16: "uint" = 0
            linkFrameCounter: "uint" = 0
            mleFrameCounter: "uint" = 0
            lqi: "uint" = 0
            averageRssi: "typing.Union[Nullable, int]" = NullValue
            lastRssi: "typing.Union[Nullable, int]" = NullValue
            frameErrorRate: "uint" = 0
            messageErrorRate: "uint" = 0
            rxOnWhenIdle: "bool" = False
            fullThreadDevice: "bool" = False
            fullNetworkData: "bool" = False
            isChild: "bool" = False

        @dataclass
        class OperationalDatasetComponents(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="activeTimestampPresent", Tag=0, Type=bool
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="pendingTimestampPresent", Tag=1, Type=bool
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="masterKeyPresent", Tag=2, Type=bool
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="networkNamePresent", Tag=3, Type=bool
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="extendedPanIdPresent", Tag=4, Type=bool
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="meshLocalPrefixPresent", Tag=5, Type=bool
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="delayPresent", Tag=6, Type=bool
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="panIdPresent", Tag=7, Type=bool
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="channelPresent", Tag=8, Type=bool
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="pskcPresent", Tag=9, Type=bool
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="securityPolicyPresent", Tag=10, Type=bool
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="channelMaskPresent", Tag=11, Type=bool
                        ),
                    ]
                )

            activeTimestampPresent: "bool" = False
            pendingTimestampPresent: "bool" = False
            masterKeyPresent: "bool" = False
            networkNamePresent: "bool" = False
            extendedPanIdPresent: "bool" = False
            meshLocalPrefixPresent: "bool" = False
            delayPresent: "bool" = False
            panIdPresent: "bool" = False
            channelPresent: "bool" = False
            pskcPresent: "bool" = False
            securityPolicyPresent: "bool" = False
            channelMaskPresent: "bool" = False

        @dataclass
        class RouteTable(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="extAddress", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(Label="rloc16", Tag=1, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="routerId", Tag=2, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(Label="nextHop", Tag=3, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="pathCost", Tag=4, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(Label="LQIIn", Tag=5, Type=uint),
                        ClusterObjectFieldDescriptor(Label="LQIOut", Tag=6, Type=uint),
                        ClusterObjectFieldDescriptor(Label="age", Tag=7, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="allocated", Tag=8, Type=bool
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="linkEstablished", Tag=9, Type=bool
                        ),
                    ]
                )

            extAddress: "uint" = 0
            rloc16: "uint" = 0
            routerId: "uint" = 0
            nextHop: "uint" = 0
            pathCost: "uint" = 0
            LQIIn: "uint" = 0
            LQIOut: "uint" = 0
            age: "uint" = 0
            allocated: "bool" = False
            linkEstablished: "bool" = False

        @dataclass
        class SecurityPolicy(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="rotationTime", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(Label="flags", Tag=1, Type=uint),
                    ]
                )

            rotationTime: "uint" = 0
            flags: "uint" = 0

    class Commands:
        @dataclass
        class ResetCounts(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0035
            command_id: typing.ClassVar[int] = 0x0000
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

    class Attributes:
        @dataclass
        class Channel(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, uint])

            value: "typing.Union[Nullable, uint]" = NullValue

        @dataclass
        class RoutingRole(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[
                        Nullable, ThreadNetworkDiagnostics.Enums.RoutingRole
                    ]
                )

            value: "typing.Union[Nullable, ThreadNetworkDiagnostics.Enums.RoutingRole]" = (
                NullValue
            )

        @dataclass
        class NetworkName(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, str])

            value: "typing.Union[Nullable, str]" = NullValue

        @dataclass
        class PanId(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, uint])

            value: "typing.Union[Nullable, uint]" = NullValue

        @dataclass
        class ExtendedPanId(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000004

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, uint])

            value: "typing.Union[Nullable, uint]" = NullValue

        @dataclass
        class MeshLocalPrefix(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000005

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, bytes])

            value: "typing.Union[Nullable, bytes]" = NullValue

        @dataclass
        class OverrunCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000006

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class NeighborTableList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000007

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.List[ThreadNetworkDiagnostics.Structs.NeighborTable]
                )

            value: "typing.List[ThreadNetworkDiagnostics.Structs.NeighborTable]" = (
                field(default_factory=lambda: [])
            )

        @dataclass
        class RouteTableList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000008

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.List[ThreadNetworkDiagnostics.Structs.RouteTable]
                )

            value: "typing.List[ThreadNetworkDiagnostics.Structs.RouteTable]" = field(
                default_factory=lambda: []
            )

        @dataclass
        class PartitionId(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000009

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, uint])

            value: "typing.Union[Nullable, uint]" = NullValue

        @dataclass
        class Weighting(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000A

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, uint])

            value: "typing.Union[Nullable, uint]" = NullValue

        @dataclass
        class DataVersion(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000B

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, uint])

            value: "typing.Union[Nullable, uint]" = NullValue

        @dataclass
        class StableDataVersion(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000C

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, uint])

            value: "typing.Union[Nullable, uint]" = NullValue

        @dataclass
        class LeaderRouterId(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000D

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, uint])

            value: "typing.Union[Nullable, uint]" = NullValue

        @dataclass
        class DetachedRoleCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000E

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class ChildRoleCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000F

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class RouterRoleCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000010

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class LeaderRoleCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000011

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class AttachAttemptCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000012

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class PartitionIdChangeCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000013

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class BetterPartitionAttachAttemptCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000014

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class ParentChangeCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000015

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class TxTotalCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000016

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class TxUnicastCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000017

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class TxBroadcastCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000018

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class TxAckRequestedCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000019

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class TxAckedCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000001A

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class TxNoAckRequestedCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000001B

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class TxDataCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000001C

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class TxDataPollCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000001D

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class TxBeaconCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000001E

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class TxBeaconRequestCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000001F

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class TxOtherCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000020

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class TxRetryCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000021

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class TxDirectMaxRetryExpiryCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000022

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class TxIndirectMaxRetryExpiryCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000023

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class TxErrCcaCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000024

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class TxErrAbortCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000025

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class TxErrBusyChannelCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000026

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class RxTotalCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000027

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class RxUnicastCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000028

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class RxBroadcastCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000029

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class RxDataCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000002A

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class RxDataPollCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000002B

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class RxBeaconCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000002C

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class RxBeaconRequestCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000002D

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class RxOtherCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000002E

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class RxAddressFilteredCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000002F

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class RxDestAddrFilteredCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000030

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class RxDuplicatedCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000031

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class RxErrNoFrameCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000032

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class RxErrUnknownNeighborCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000033

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class RxErrInvalidSrcAddrCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000034

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class RxErrSecCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000035

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class RxErrFcsCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000036

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class RxErrOtherCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000037

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class ActiveTimestamp(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000038

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class PendingTimestamp(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000039

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class Delay(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000003A

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class SecurityPolicy(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000003B

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[
                        Nullable, ThreadNetworkDiagnostics.Structs.SecurityPolicy
                    ]
                )

            value: "typing.Union[Nullable, ThreadNetworkDiagnostics.Structs.SecurityPolicy]" = (
                NullValue
            )

        @dataclass
        class ChannelPage0Mask(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000003C

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, bytes])

            value: "typing.Union[Nullable, bytes]" = NullValue

        @dataclass
        class OperationalDatasetComponents(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000003D

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[
                        Nullable,
                        ThreadNetworkDiagnostics.Structs.OperationalDatasetComponents,
                    ]
                )

            value: "typing.Union[Nullable, ThreadNetworkDiagnostics.Structs.OperationalDatasetComponents]" = (
                NullValue
            )

        @dataclass
        class ActiveNetworkFaultsList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000003E

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.List[ThreadNetworkDiagnostics.Enums.NetworkFault]
                )

            value: "typing.List[ThreadNetworkDiagnostics.Enums.NetworkFault]" = field(
                default_factory=lambda: []
            )

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

    class Events:
        @dataclass
        class ConnectionStatus(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="connectionStatus",
                            Tag=0,
                            Type=ThreadNetworkDiagnostics.Enums.ThreadConnectionStatus,
                        ),
                    ]
                )

            connectionStatus: "ThreadNetworkDiagnostics.Enums.ThreadConnectionStatus" = (
                0
            )

        @dataclass
        class NetworkFaultChange(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0035

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="current",
                            Tag=0,
                            Type=typing.List[
                                ThreadNetworkDiagnostics.Enums.NetworkFault
                            ],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="previous",
                            Tag=1,
                            Type=typing.List[
                                ThreadNetworkDiagnostics.Enums.NetworkFault
                            ],
                        ),
                    ]
                )

            current: "typing.List[ThreadNetworkDiagnostics.Enums.NetworkFault]" = field(
                default_factory=lambda: []
            )
            previous: "typing.List[ThreadNetworkDiagnostics.Enums.NetworkFault]" = (
                field(default_factory=lambda: [])
            )


@dataclass
class WiFiNetworkDiagnostics(Cluster):
    id: typing.ClassVar[int] = 0x0036

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="bssid", Tag=0x00000000, Type=typing.Union[Nullable, bytes]
                ),
                ClusterObjectFieldDescriptor(
                    Label="securityType",
                    Tag=0x00000001,
                    Type=typing.Union[
                        Nullable, WiFiNetworkDiagnostics.Enums.SecurityType
                    ],
                ),
                ClusterObjectFieldDescriptor(
                    Label="wiFiVersion",
                    Tag=0x00000002,
                    Type=typing.Union[
                        Nullable, WiFiNetworkDiagnostics.Enums.WiFiVersionType
                    ],
                ),
                ClusterObjectFieldDescriptor(
                    Label="channelNumber",
                    Tag=0x00000003,
                    Type=typing.Union[Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="rssi", Tag=0x00000004, Type=typing.Union[Nullable, int]
                ),
                ClusterObjectFieldDescriptor(
                    Label="beaconLostCount",
                    Tag=0x00000005,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="beaconRxCount",
                    Tag=0x00000006,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="packetMulticastRxCount",
                    Tag=0x00000007,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="packetMulticastTxCount",
                    Tag=0x00000008,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="packetUnicastRxCount",
                    Tag=0x00000009,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="packetUnicastTxCount",
                    Tag=0x0000000A,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="currentMaxRate",
                    Tag=0x0000000B,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="overrunCount",
                    Tag=0x0000000C,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    bssid: "typing.Union[Nullable, bytes]" = None
    securityType: "typing.Union[Nullable, WiFiNetworkDiagnostics.Enums.SecurityType]" = (
        None
    )
    wiFiVersion: "typing.Union[Nullable, WiFiNetworkDiagnostics.Enums.WiFiVersionType]" = (
        None
    )
    channelNumber: "typing.Union[Nullable, uint]" = None
    rssi: "typing.Union[Nullable, int]" = None
    beaconLostCount: "typing.Union[None, Nullable, uint]" = None
    beaconRxCount: "typing.Union[None, Nullable, uint]" = None
    packetMulticastRxCount: "typing.Union[None, Nullable, uint]" = None
    packetMulticastTxCount: "typing.Union[None, Nullable, uint]" = None
    packetUnicastRxCount: "typing.Union[None, Nullable, uint]" = None
    packetUnicastTxCount: "typing.Union[None, Nullable, uint]" = None
    currentMaxRate: "typing.Union[None, Nullable, uint]" = None
    overrunCount: "typing.Union[None, Nullable, uint]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Enums:
        class AssociationFailureCause(IntEnum):
            kUnknown = 0x00
            kAssociationFailed = 0x01
            kAuthenticationFailed = 0x02
            kSsidNotFound = 0x03

        class SecurityType(IntEnum):
            kUnspecified = 0x00
            kNone = 0x01
            kWep = 0x02
            kWpa = 0x03
            kWpa2 = 0x04
            kWpa3 = 0x05

        class WiFiConnectionStatus(IntEnum):
            kConnected = 0x00
            kNotConnected = 0x01

        class WiFiVersionType(IntEnum):
            k80211a = 0x00
            k80211b = 0x01
            k80211g = 0x02
            k80211n = 0x03
            k80211ac = 0x04
            k80211ax = 0x05

    class Commands:
        @dataclass
        class ResetCounts(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0036
            command_id: typing.ClassVar[int] = 0x0000
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

    class Attributes:
        @dataclass
        class Bssid(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0036

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, bytes])

            value: "typing.Union[Nullable, bytes]" = NullValue

        @dataclass
        class SecurityType(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0036

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[
                        Nullable, WiFiNetworkDiagnostics.Enums.SecurityType
                    ]
                )

            value: "typing.Union[Nullable, WiFiNetworkDiagnostics.Enums.SecurityType]" = (
                NullValue
            )

        @dataclass
        class WiFiVersion(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0036

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[
                        Nullable, WiFiNetworkDiagnostics.Enums.WiFiVersionType
                    ]
                )

            value: "typing.Union[Nullable, WiFiNetworkDiagnostics.Enums.WiFiVersionType]" = (
                NullValue
            )

        @dataclass
        class ChannelNumber(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0036

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, uint])

            value: "typing.Union[Nullable, uint]" = NullValue

        @dataclass
        class Rssi(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0036

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000004

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, int])

            value: "typing.Union[Nullable, int]" = NullValue

        @dataclass
        class BeaconLostCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0036

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000005

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class BeaconRxCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0036

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000006

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class PacketMulticastRxCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0036

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000007

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class PacketMulticastTxCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0036

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000008

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class PacketUnicastRxCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0036

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000009

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class PacketUnicastTxCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0036

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000A

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class CurrentMaxRate(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0036

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000B

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class OverrunCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0036

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000C

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0036

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0036

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0036

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0036

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0036

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

    class Events:
        @dataclass
        class Disconnection(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0036

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="reasonCode", Tag=0, Type=uint
                        ),
                    ]
                )

            reasonCode: "uint" = 0

        @dataclass
        class AssociationFailure(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0036

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="associationFailure",
                            Tag=0,
                            Type=WiFiNetworkDiagnostics.Enums.AssociationFailureCause,
                        ),
                        ClusterObjectFieldDescriptor(Label="status", Tag=1, Type=uint),
                    ]
                )

            associationFailure: "WiFiNetworkDiagnostics.Enums.AssociationFailureCause" = (
                0
            )
            status: "uint" = 0

        @dataclass
        class ConnectionStatus(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0036

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="connectionStatus",
                            Tag=0,
                            Type=WiFiNetworkDiagnostics.Enums.WiFiConnectionStatus,
                        ),
                    ]
                )

            connectionStatus: "WiFiNetworkDiagnostics.Enums.WiFiConnectionStatus" = 0


@dataclass
class EthernetNetworkDiagnostics(Cluster):
    id: typing.ClassVar[int] = 0x0037

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="PHYRate",
                    Tag=0x00000000,
                    Type=typing.Union[
                        None, Nullable, EthernetNetworkDiagnostics.Enums.PHYRateType
                    ],
                ),
                ClusterObjectFieldDescriptor(
                    Label="fullDuplex",
                    Tag=0x00000001,
                    Type=typing.Union[None, Nullable, bool],
                ),
                ClusterObjectFieldDescriptor(
                    Label="packetRxCount", Tag=0x00000002, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="packetTxCount", Tag=0x00000003, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="txErrCount", Tag=0x00000004, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="collisionCount", Tag=0x00000005, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="overrunCount", Tag=0x00000006, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="carrierDetect",
                    Tag=0x00000007,
                    Type=typing.Union[None, Nullable, bool],
                ),
                ClusterObjectFieldDescriptor(
                    Label="timeSinceReset", Tag=0x00000008, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    PHYRate: "typing.Union[None, Nullable, EthernetNetworkDiagnostics.Enums.PHYRateType]" = (
        None
    )
    fullDuplex: "typing.Union[None, Nullable, bool]" = None
    packetRxCount: "typing.Optional[uint]" = None
    packetTxCount: "typing.Optional[uint]" = None
    txErrCount: "typing.Optional[uint]" = None
    collisionCount: "typing.Optional[uint]" = None
    overrunCount: "typing.Optional[uint]" = None
    carrierDetect: "typing.Union[None, Nullable, bool]" = None
    timeSinceReset: "typing.Optional[uint]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Enums:
        class PHYRateType(IntEnum):
            k10m = 0x00
            k100m = 0x01
            k1000m = 0x02
            k25g = 0x03
            k5g = 0x04
            k10g = 0x05
            k40g = 0x06
            k100g = 0x07
            k200g = 0x08
            k400g = 0x09

    class Commands:
        @dataclass
        class ResetCounts(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0037
            command_id: typing.ClassVar[int] = 0x0000
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

    class Attributes:
        @dataclass
        class PHYRate(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0037

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[
                        None, Nullable, EthernetNetworkDiagnostics.Enums.PHYRateType
                    ]
                )

            value: "typing.Union[None, Nullable, EthernetNetworkDiagnostics.Enums.PHYRateType]" = (
                None
            )

        @dataclass
        class FullDuplex(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0037

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, bool]
                )

            value: "typing.Union[None, Nullable, bool]" = None

        @dataclass
        class PacketRxCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0037

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class PacketTxCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0037

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class TxErrCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0037

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000004

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class CollisionCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0037

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000005

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class OverrunCount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0037

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000006

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class CarrierDetect(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0037

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000007

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, bool]
                )

            value: "typing.Union[None, Nullable, bool]" = None

        @dataclass
        class TimeSinceReset(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0037

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000008

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0037

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0037

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0037

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0037

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0037

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class TimeSynchronization(Cluster):
    id: typing.ClassVar[int] = 0x0038

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="UTCTime", Tag=0x00000000, Type=typing.Union[Nullable, uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="granularity",
                    Tag=0x00000001,
                    Type=TimeSynchronization.Enums.GranularityEnum,
                ),
                ClusterObjectFieldDescriptor(
                    Label="timeSource",
                    Tag=0x00000002,
                    Type=typing.Optional[TimeSynchronization.Enums.TimeSourceEnum],
                ),
                ClusterObjectFieldDescriptor(
                    Label="trustedTimeNodeId",
                    Tag=0x00000003,
                    Type=typing.Union[Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="defaultNtp",
                    Tag=0x00000004,
                    Type=typing.Union[None, Nullable, str],
                ),
                ClusterObjectFieldDescriptor(
                    Label="timeZone",
                    Tag=0x00000005,
                    Type=typing.Optional[
                        typing.List[TimeSynchronization.Structs.TimeZoneType]
                    ],
                ),
                ClusterObjectFieldDescriptor(
                    Label="dstOffset",
                    Tag=0x00000006,
                    Type=typing.Optional[
                        typing.List[TimeSynchronization.Structs.DstOffsetType]
                    ],
                ),
                ClusterObjectFieldDescriptor(
                    Label="localTime",
                    Tag=0x00000007,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="timeZoneDatabase", Tag=0x00000008, Type=typing.Optional[bool]
                ),
                ClusterObjectFieldDescriptor(
                    Label="ntpServerPort",
                    Tag=0x00000009,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    UTCTime: "typing.Union[Nullable, uint]" = None
    granularity: "TimeSynchronization.Enums.GranularityEnum" = None
    timeSource: "typing.Optional[TimeSynchronization.Enums.TimeSourceEnum]" = None
    trustedTimeNodeId: "typing.Union[Nullable, uint]" = None
    defaultNtp: "typing.Union[None, Nullable, str]" = None
    timeZone: "typing.Optional[typing.List[TimeSynchronization.Structs.TimeZoneType]]" = (
        None
    )
    dstOffset: "typing.Optional[typing.List[TimeSynchronization.Structs.DstOffsetType]]" = (
        None
    )
    localTime: "typing.Union[None, Nullable, uint]" = None
    timeZoneDatabase: "typing.Optional[bool]" = None
    ntpServerPort: "typing.Union[None, Nullable, uint]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Enums:
        class GranularityEnum(IntEnum):
            kNoTimeGranularity = 0x00
            kMinutesGranularity = 0x01
            kSecondsGranularity = 0x02
            kMillisecondsGranularity = 0x03
            kMicrosecondsGranularity = 0x04

        class TimeSourceEnum(IntEnum):
            kNone = 0x00
            kUnknown = 0x01
            kAdmin = 0x02
            kNodeTimeCluster = 0x03
            kNonFabricSntp = 0x04
            kNonFabricNtp = 0x05
            kFabricSntp = 0x06
            kFabricNtp = 0x07
            kMixedNtp = 0x08
            kNonFabricSntpNts = 0x09
            kNonFabricNtpNts = 0x0A
            kFabricSntpNts = 0x0B
            kFabricNtpNts = 0x0C
            kMixedNtpNts = 0x0D
            kCloudSource = 0x0E
            kPtp = 0x0F
            kGnss = 0x10

    class Structs:
        @dataclass
        class DstOffsetType(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="offset", Tag=0, Type=int),
                        ClusterObjectFieldDescriptor(
                            Label="validStarting", Tag=1, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="validUntil", Tag=2, Type=uint
                        ),
                    ]
                )

            offset: "int" = 0
            validStarting: "uint" = 0
            validUntil: "uint" = 0

        @dataclass
        class TimeZoneType(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="offset", Tag=0, Type=int),
                        ClusterObjectFieldDescriptor(Label="validAt", Tag=1, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="name", Tag=2, Type=typing.Optional[str]
                        ),
                    ]
                )

            offset: "int" = 0
            validAt: "uint" = 0
            name: "typing.Optional[str]" = None

    class Commands:
        @dataclass
        class SetUtcTime(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0038
            command_id: typing.ClassVar[int] = 0x0000
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="utcTime", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="granularity",
                            Tag=1,
                            Type=TimeSynchronization.Enums.GranularityEnum,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="timeSource",
                            Tag=2,
                            Type=typing.Optional[
                                TimeSynchronization.Enums.TimeSourceEnum
                            ],
                        ),
                    ]
                )

            utcTime: "uint" = 0
            granularity: "TimeSynchronization.Enums.GranularityEnum" = 0
            timeSource: "typing.Optional[TimeSynchronization.Enums.TimeSourceEnum]" = (
                None
            )

    class Attributes:
        @dataclass
        class UTCTime(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0038

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, uint])

            value: "typing.Union[Nullable, uint]" = NullValue

        @dataclass
        class Granularity(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0038

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=TimeSynchronization.Enums.GranularityEnum
                )

            value: "TimeSynchronization.Enums.GranularityEnum" = 0

        @dataclass
        class TimeSource(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0038

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Optional[TimeSynchronization.Enums.TimeSourceEnum]
                )

            value: "typing.Optional[TimeSynchronization.Enums.TimeSourceEnum]" = None

        @dataclass
        class TrustedTimeNodeId(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0038

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, uint])

            value: "typing.Union[Nullable, uint]" = NullValue

        @dataclass
        class DefaultNtp(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0038

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000004

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, str]
                )

            value: "typing.Union[None, Nullable, str]" = None

        @dataclass
        class TimeZone(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0038

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000005

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Optional[
                        typing.List[TimeSynchronization.Structs.TimeZoneType]
                    ]
                )

            value: "typing.Optional[typing.List[TimeSynchronization.Structs.TimeZoneType]]" = (
                None
            )

        @dataclass
        class DstOffset(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0038

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000006

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Optional[
                        typing.List[TimeSynchronization.Structs.DstOffsetType]
                    ]
                )

            value: "typing.Optional[typing.List[TimeSynchronization.Structs.DstOffsetType]]" = (
                None
            )

        @dataclass
        class LocalTime(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0038

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000007

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class TimeZoneDatabase(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0038

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000008

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[bool])

            value: "typing.Optional[bool]" = None

        @dataclass
        class NtpServerPort(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0038

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000009

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0038

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0038

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0038

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0038

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0038

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class BridgedDeviceBasic(Cluster):
    id: typing.ClassVar[int] = 0x0039

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="vendorName", Tag=0x00000001, Type=typing.Optional[str]
                ),
                ClusterObjectFieldDescriptor(
                    Label="vendorID", Tag=0x00000002, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="productName", Tag=0x00000003, Type=typing.Optional[str]
                ),
                ClusterObjectFieldDescriptor(
                    Label="nodeLabel", Tag=0x00000005, Type=typing.Optional[str]
                ),
                ClusterObjectFieldDescriptor(
                    Label="hardwareVersion", Tag=0x00000007, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="hardwareVersionString",
                    Tag=0x00000008,
                    Type=typing.Optional[str],
                ),
                ClusterObjectFieldDescriptor(
                    Label="softwareVersion", Tag=0x00000009, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="softwareVersionString",
                    Tag=0x0000000A,
                    Type=typing.Optional[str],
                ),
                ClusterObjectFieldDescriptor(
                    Label="manufacturingDate", Tag=0x0000000B, Type=typing.Optional[str]
                ),
                ClusterObjectFieldDescriptor(
                    Label="partNumber", Tag=0x0000000C, Type=typing.Optional[str]
                ),
                ClusterObjectFieldDescriptor(
                    Label="productURL", Tag=0x0000000D, Type=typing.Optional[str]
                ),
                ClusterObjectFieldDescriptor(
                    Label="productLabel", Tag=0x0000000E, Type=typing.Optional[str]
                ),
                ClusterObjectFieldDescriptor(
                    Label="serialNumber", Tag=0x0000000F, Type=typing.Optional[str]
                ),
                ClusterObjectFieldDescriptor(
                    Label="reachable", Tag=0x00000011, Type=bool
                ),
                ClusterObjectFieldDescriptor(
                    Label="uniqueID", Tag=0x00000012, Type=typing.Optional[str]
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    vendorName: "typing.Optional[str]" = None
    vendorID: "typing.Optional[uint]" = None
    productName: "typing.Optional[str]" = None
    nodeLabel: "typing.Optional[str]" = None
    hardwareVersion: "typing.Optional[uint]" = None
    hardwareVersionString: "typing.Optional[str]" = None
    softwareVersion: "typing.Optional[uint]" = None
    softwareVersionString: "typing.Optional[str]" = None
    manufacturingDate: "typing.Optional[str]" = None
    partNumber: "typing.Optional[str]" = None
    productURL: "typing.Optional[str]" = None
    productLabel: "typing.Optional[str]" = None
    serialNumber: "typing.Optional[str]" = None
    reachable: "bool" = None
    uniqueID: "typing.Optional[str]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Attributes:
        @dataclass
        class VendorName(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0039

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[str])

            value: "typing.Optional[str]" = None

        @dataclass
        class VendorID(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0039

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class ProductName(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0039

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[str])

            value: "typing.Optional[str]" = None

        @dataclass
        class NodeLabel(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0039

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000005

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[str])

            value: "typing.Optional[str]" = None

        @dataclass
        class HardwareVersion(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0039

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000007

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class HardwareVersionString(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0039

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000008

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[str])

            value: "typing.Optional[str]" = None

        @dataclass
        class SoftwareVersion(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0039

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000009

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class SoftwareVersionString(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0039

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000A

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[str])

            value: "typing.Optional[str]" = None

        @dataclass
        class ManufacturingDate(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0039

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000B

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[str])

            value: "typing.Optional[str]" = None

        @dataclass
        class PartNumber(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0039

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000C

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[str])

            value: "typing.Optional[str]" = None

        @dataclass
        class ProductURL(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0039

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000D

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[str])

            value: "typing.Optional[str]" = None

        @dataclass
        class ProductLabel(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0039

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000E

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[str])

            value: "typing.Optional[str]" = None

        @dataclass
        class SerialNumber(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0039

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000F

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[str])

            value: "typing.Optional[str]" = None

        @dataclass
        class Reachable(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0039

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000011

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=bool)

            value: "bool" = False

        @dataclass
        class UniqueID(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0039

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000012

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[str])

            value: "typing.Optional[str]" = None

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0039

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0039

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0039

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0039

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0039

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

    class Events:
        @dataclass
        class StartUp(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0039

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="softwareVersion", Tag=0, Type=uint
                        ),
                    ]
                )

            softwareVersion: "uint" = 0

        @dataclass
        class ShutDown(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0039

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class Leave(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0039

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class ReachableChanged(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0039

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="reachableNewValue", Tag=0, Type=bool
                        ),
                    ]
                )

            reachableNewValue: "bool" = False


@dataclass
class Switch(Cluster):
    id: typing.ClassVar[int] = 0x003B

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="numberOfPositions", Tag=0x00000000, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="currentPosition", Tag=0x00000001, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="multiPressMax", Tag=0x00000002, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    numberOfPositions: "uint" = None
    currentPosition: "uint" = None
    multiPressMax: "typing.Optional[uint]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Attributes:
        @dataclass
        class NumberOfPositions(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003B

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class CurrentPosition(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003B

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class MultiPressMax(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003B

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003B

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003B

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003B

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003B

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003B

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

    class Events:
        @dataclass
        class SwitchLatched(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003B

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="newPosition", Tag=0, Type=uint
                        ),
                    ]
                )

            newPosition: "uint" = 0

        @dataclass
        class InitialPress(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003B

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="newPosition", Tag=0, Type=uint
                        ),
                    ]
                )

            newPosition: "uint" = 0

        @dataclass
        class LongPress(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003B

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="newPosition", Tag=0, Type=uint
                        ),
                    ]
                )

            newPosition: "uint" = 0

        @dataclass
        class ShortRelease(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003B

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="previousPosition", Tag=0, Type=uint
                        ),
                    ]
                )

            previousPosition: "uint" = 0

        @dataclass
        class LongRelease(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003B

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000004

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="previousPosition", Tag=0, Type=uint
                        ),
                    ]
                )

            previousPosition: "uint" = 0

        @dataclass
        class MultiPressOngoing(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003B

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000005

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="newPosition", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="currentNumberOfPressesCounted", Tag=1, Type=uint
                        ),
                    ]
                )

            newPosition: "uint" = 0
            currentNumberOfPressesCounted: "uint" = 0

        @dataclass
        class MultiPressComplete(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003B

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000006

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="newPosition", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="totalNumberOfPressesCounted", Tag=1, Type=uint
                        ),
                    ]
                )

            newPosition: "uint" = 0
            totalNumberOfPressesCounted: "uint" = 0


@dataclass
class AdministratorCommissioning(Cluster):
    id: typing.ClassVar[int] = 0x003C

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="windowStatus",
                    Tag=0x00000000,
                    Type=AdministratorCommissioning.Enums.CommissioningWindowStatus,
                ),
                ClusterObjectFieldDescriptor(
                    Label="adminFabricIndex",
                    Tag=0x00000001,
                    Type=typing.Union[Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="adminVendorId",
                    Tag=0x00000002,
                    Type=typing.Union[Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    windowStatus: "AdministratorCommissioning.Enums.CommissioningWindowStatus" = None
    adminFabricIndex: "typing.Union[Nullable, uint]" = None
    adminVendorId: "typing.Union[Nullable, uint]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Enums:
        class CommissioningWindowStatus(IntEnum):
            kWindowNotOpen = 0x00
            kEnhancedWindowOpen = 0x01
            kBasicWindowOpen = 0x02

        class StatusCode(IntEnum):
            kBusy = 0x02
            kPAKEParameterError = 0x03
            kWindowNotOpen = 0x04

    class Commands:
        @dataclass
        class OpenCommissioningWindow(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x003C
            command_id: typing.ClassVar[int] = 0x0000
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="commissioningTimeout", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="PAKEVerifier", Tag=1, Type=bytes
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="discriminator", Tag=2, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="iterations", Tag=3, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(Label="salt", Tag=4, Type=bytes),
                    ]
                )

            @ChipUtility.classproperty
            def must_use_timed_invoke(cls) -> bool:
                return True

            commissioningTimeout: "uint" = 0
            PAKEVerifier: "bytes" = b""
            discriminator: "uint" = 0
            iterations: "uint" = 0
            salt: "bytes" = b""

        @dataclass
        class OpenBasicCommissioningWindow(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x003C
            command_id: typing.ClassVar[int] = 0x0001
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="commissioningTimeout", Tag=0, Type=uint
                        ),
                    ]
                )

            @ChipUtility.classproperty
            def must_use_timed_invoke(cls) -> bool:
                return True

            commissioningTimeout: "uint" = 0

        @dataclass
        class RevokeCommissioning(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x003C
            command_id: typing.ClassVar[int] = 0x0002
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

            @ChipUtility.classproperty
            def must_use_timed_invoke(cls) -> bool:
                return True

    class Attributes:
        @dataclass
        class WindowStatus(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003C

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=AdministratorCommissioning.Enums.CommissioningWindowStatus
                )

            value: "AdministratorCommissioning.Enums.CommissioningWindowStatus" = 0

        @dataclass
        class AdminFabricIndex(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003C

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, uint])

            value: "typing.Union[Nullable, uint]" = NullValue

        @dataclass
        class AdminVendorId(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003C

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, uint])

            value: "typing.Union[Nullable, uint]" = NullValue

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003C

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003C

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003C

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003C

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003C

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class OperationalCredentials(Cluster):
    id: typing.ClassVar[int] = 0x003E

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="NOCs",
                    Tag=0x00000000,
                    Type=typing.List[OperationalCredentials.Structs.NOCStruct],
                ),
                ClusterObjectFieldDescriptor(
                    Label="fabrics",
                    Tag=0x00000001,
                    Type=typing.List[OperationalCredentials.Structs.FabricDescriptor],
                ),
                ClusterObjectFieldDescriptor(
                    Label="supportedFabrics", Tag=0x00000002, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="commissionedFabrics", Tag=0x00000003, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="trustedRootCertificates",
                    Tag=0x00000004,
                    Type=typing.List[bytes],
                ),
                ClusterObjectFieldDescriptor(
                    Label="currentFabricIndex", Tag=0x00000005, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    NOCs: "typing.List[OperationalCredentials.Structs.NOCStruct]" = None
    fabrics: "typing.List[OperationalCredentials.Structs.FabricDescriptor]" = None
    supportedFabrics: "uint" = None
    commissionedFabrics: "uint" = None
    trustedRootCertificates: "typing.List[bytes]" = None
    currentFabricIndex: "uint" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Enums:
        class OperationalCertStatus(IntEnum):
            kSuccess = 0x00
            kInvalidPublicKey = 0x01
            kInvalidNodeOpId = 0x02
            kInvalidNOC = 0x03
            kMissingCsr = 0x04
            kTableFull = 0x05
            kInvalidAdminSubject = 0x06
            kFabricConflict = 0x09
            kLabelConflict = 0x0A
            kInvalidFabricIndex = 0x0B

    class Structs:
        @dataclass
        class FabricDescriptor(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="rootPublicKey", Tag=1, Type=bytes
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="vendorId", Tag=2, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="fabricId", Tag=3, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(Label="nodeId", Tag=4, Type=uint),
                        ClusterObjectFieldDescriptor(Label="label", Tag=5, Type=str),
                        ClusterObjectFieldDescriptor(
                            Label="fabricIndex", Tag=254, Type=uint
                        ),
                    ]
                )

            rootPublicKey: "bytes" = b""
            vendorId: "uint" = 0
            fabricId: "uint" = 0
            nodeId: "uint" = 0
            label: "str" = ""
            fabricIndex: "uint" = 0

        @dataclass
        class NOCStruct(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="noc", Tag=1, Type=bytes),
                        ClusterObjectFieldDescriptor(
                            Label="icac", Tag=2, Type=typing.Union[Nullable, bytes]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="fabricIndex", Tag=254, Type=uint
                        ),
                    ]
                )

            noc: "bytes" = b""
            icac: "typing.Union[Nullable, bytes]" = NullValue
            fabricIndex: "uint" = 0

    class Commands:
        @dataclass
        class AttestationRequest(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x003E
            command_id: typing.ClassVar[int] = 0x0000
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="attestationNonce", Tag=0, Type=bytes
                        ),
                    ]
                )

            attestationNonce: "bytes" = b""

        @dataclass
        class AttestationResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x003E
            command_id: typing.ClassVar[int] = 0x0001
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="attestationElements", Tag=0, Type=bytes
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="signature", Tag=1, Type=bytes
                        ),
                    ]
                )

            attestationElements: "bytes" = b""
            signature: "bytes" = b""

        @dataclass
        class CertificateChainRequest(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x003E
            command_id: typing.ClassVar[int] = 0x0002
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="certificateType", Tag=0, Type=uint
                        ),
                    ]
                )

            certificateType: "uint" = 0

        @dataclass
        class CertificateChainResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x003E
            command_id: typing.ClassVar[int] = 0x0003
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="certificate", Tag=0, Type=bytes
                        ),
                    ]
                )

            certificate: "bytes" = b""

        @dataclass
        class CSRRequest(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x003E
            command_id: typing.ClassVar[int] = 0x0004
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="CSRNonce", Tag=0, Type=bytes
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="isForUpdateNOC", Tag=1, Type=typing.Optional[bool]
                        ),
                    ]
                )

            CSRNonce: "bytes" = b""
            isForUpdateNOC: "typing.Optional[bool]" = None

        @dataclass
        class CSRResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x003E
            command_id: typing.ClassVar[int] = 0x0005
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="NOCSRElements", Tag=0, Type=bytes
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="attestationSignature", Tag=1, Type=bytes
                        ),
                    ]
                )

            NOCSRElements: "bytes" = b""
            attestationSignature: "bytes" = b""

        @dataclass
        class AddNOC(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x003E
            command_id: typing.ClassVar[int] = 0x0006
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="NOCValue", Tag=0, Type=bytes
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="ICACValue", Tag=1, Type=typing.Optional[bytes]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="IPKValue", Tag=2, Type=bytes
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="caseAdminSubject", Tag=3, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="adminVendorId", Tag=4, Type=uint
                        ),
                    ]
                )

            NOCValue: "bytes" = b""
            ICACValue: "typing.Optional[bytes]" = None
            IPKValue: "bytes" = b""
            caseAdminSubject: "uint" = 0
            adminVendorId: "uint" = 0

        @dataclass
        class UpdateNOC(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x003E
            command_id: typing.ClassVar[int] = 0x0007
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="NOCValue", Tag=0, Type=bytes
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="ICACValue", Tag=1, Type=typing.Optional[bytes]
                        ),
                    ]
                )

            NOCValue: "bytes" = b""
            ICACValue: "typing.Optional[bytes]" = None

        @dataclass
        class NOCResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x003E
            command_id: typing.ClassVar[int] = 0x0008
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="statusCode",
                            Tag=0,
                            Type=OperationalCredentials.Enums.OperationalCertStatus,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="fabricIndex", Tag=1, Type=typing.Optional[uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="debugText", Tag=2, Type=typing.Optional[str]
                        ),
                    ]
                )

            statusCode: "OperationalCredentials.Enums.OperationalCertStatus" = 0
            fabricIndex: "typing.Optional[uint]" = None
            debugText: "typing.Optional[str]" = None

        @dataclass
        class UpdateFabricLabel(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x003E
            command_id: typing.ClassVar[int] = 0x0009
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="label", Tag=0, Type=str),
                    ]
                )

            label: "str" = ""

        @dataclass
        class RemoveFabric(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x003E
            command_id: typing.ClassVar[int] = 0x000A
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="fabricIndex", Tag=0, Type=uint
                        ),
                    ]
                )

            fabricIndex: "uint" = 0

        @dataclass
        class AddTrustedRootCertificate(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x003E
            command_id: typing.ClassVar[int] = 0x000B
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="rootCertificate", Tag=0, Type=bytes
                        ),
                    ]
                )

            rootCertificate: "bytes" = b""

    class Attributes:
        @dataclass
        class NOCs(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003E

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.List[OperationalCredentials.Structs.NOCStruct]
                )

            value: "typing.List[OperationalCredentials.Structs.NOCStruct]" = field(
                default_factory=lambda: []
            )

        @dataclass
        class Fabrics(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003E

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.List[OperationalCredentials.Structs.FabricDescriptor]
                )

            value: "typing.List[OperationalCredentials.Structs.FabricDescriptor]" = (
                field(default_factory=lambda: [])
            )

        @dataclass
        class SupportedFabrics(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003E

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class CommissionedFabrics(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003E

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class TrustedRootCertificates(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003E

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000004

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[bytes])

            value: "typing.List[bytes]" = field(default_factory=lambda: [])

        @dataclass
        class CurrentFabricIndex(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003E

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000005

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003E

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003E

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003E

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003E

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003E

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class GroupKeyManagement(Cluster):
    id: typing.ClassVar[int] = 0x003F

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="groupKeyMap",
                    Tag=0x00000000,
                    Type=typing.List[GroupKeyManagement.Structs.GroupKeyMapStruct],
                ),
                ClusterObjectFieldDescriptor(
                    Label="groupTable",
                    Tag=0x00000001,
                    Type=typing.List[GroupKeyManagement.Structs.GroupInfoMapStruct],
                ),
                ClusterObjectFieldDescriptor(
                    Label="maxGroupsPerFabric", Tag=0x00000002, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="maxGroupKeysPerFabric", Tag=0x00000003, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    groupKeyMap: "typing.List[GroupKeyManagement.Structs.GroupKeyMapStruct]" = None
    groupTable: "typing.List[GroupKeyManagement.Structs.GroupInfoMapStruct]" = None
    maxGroupsPerFabric: "uint" = None
    maxGroupKeysPerFabric: "uint" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Enums:
        class GroupKeySecurityPolicy(IntEnum):
            kTrustFirst = 0x00
            kCacheAndSync = 0x01

    class Structs:
        @dataclass
        class GroupInfoMapStruct(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="groupId", Tag=1, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="endpoints", Tag=2, Type=typing.List[uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="groupName", Tag=3, Type=typing.Optional[str]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="fabricIndex", Tag=254, Type=uint
                        ),
                    ]
                )

            groupId: "uint" = 0
            endpoints: "typing.List[uint]" = field(default_factory=lambda: [])
            groupName: "typing.Optional[str]" = None
            fabricIndex: "uint" = 0

        @dataclass
        class GroupKeyMapStruct(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="groupId", Tag=1, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="groupKeySetID", Tag=2, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="fabricIndex", Tag=254, Type=uint
                        ),
                    ]
                )

            groupId: "uint" = 0
            groupKeySetID: "uint" = 0
            fabricIndex: "uint" = 0

        @dataclass
        class GroupKeySetStruct(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="groupKeySetID", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="groupKeySecurityPolicy",
                            Tag=1,
                            Type=GroupKeyManagement.Enums.GroupKeySecurityPolicy,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="epochKey0", Tag=2, Type=typing.Union[Nullable, bytes]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="epochStartTime0",
                            Tag=3,
                            Type=typing.Union[Nullable, uint],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="epochKey1", Tag=4, Type=typing.Union[Nullable, bytes]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="epochStartTime1",
                            Tag=5,
                            Type=typing.Union[Nullable, uint],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="epochKey2", Tag=6, Type=typing.Union[Nullable, bytes]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="epochStartTime2",
                            Tag=7,
                            Type=typing.Union[Nullable, uint],
                        ),
                    ]
                )

            groupKeySetID: "uint" = 0
            groupKeySecurityPolicy: "GroupKeyManagement.Enums.GroupKeySecurityPolicy" = (
                0
            )
            epochKey0: "typing.Union[Nullable, bytes]" = NullValue
            epochStartTime0: "typing.Union[Nullable, uint]" = NullValue
            epochKey1: "typing.Union[Nullable, bytes]" = NullValue
            epochStartTime1: "typing.Union[Nullable, uint]" = NullValue
            epochKey2: "typing.Union[Nullable, bytes]" = NullValue
            epochStartTime2: "typing.Union[Nullable, uint]" = NullValue

    class Commands:
        @dataclass
        class KeySetWrite(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x003F
            command_id: typing.ClassVar[int] = 0x0000
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="groupKeySet",
                            Tag=0,
                            Type=GroupKeyManagement.Structs.GroupKeySetStruct,
                        ),
                    ]
                )

            groupKeySet: "GroupKeyManagement.Structs.GroupKeySetStruct" = field(
                default_factory=lambda: GroupKeyManagement.Structs.GroupKeySetStruct()
            )

        @dataclass
        class KeySetRead(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x003F
            command_id: typing.ClassVar[int] = 0x0001
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="groupKeySetID", Tag=0, Type=uint
                        ),
                    ]
                )

            groupKeySetID: "uint" = 0

        @dataclass
        class KeySetReadResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x003F
            command_id: typing.ClassVar[int] = 0x0002
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="groupKeySet",
                            Tag=0,
                            Type=GroupKeyManagement.Structs.GroupKeySetStruct,
                        ),
                    ]
                )

            groupKeySet: "GroupKeyManagement.Structs.GroupKeySetStruct" = field(
                default_factory=lambda: GroupKeyManagement.Structs.GroupKeySetStruct()
            )

        @dataclass
        class KeySetRemove(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x003F
            command_id: typing.ClassVar[int] = 0x0003
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="groupKeySetID", Tag=0, Type=uint
                        ),
                    ]
                )

            groupKeySetID: "uint" = 0

        @dataclass
        class KeySetReadAllIndices(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x003F
            command_id: typing.ClassVar[int] = 0x0004
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="groupKeySetIDs", Tag=0, Type=typing.List[uint]
                        ),
                    ]
                )

            groupKeySetIDs: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class KeySetReadAllIndicesResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x003F
            command_id: typing.ClassVar[int] = 0x0005
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="groupKeySetIDs", Tag=0, Type=typing.List[uint]
                        ),
                    ]
                )

            groupKeySetIDs: "typing.List[uint]" = field(default_factory=lambda: [])

    class Attributes:
        @dataclass
        class GroupKeyMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.List[GroupKeyManagement.Structs.GroupKeyMapStruct]
                )

            value: "typing.List[GroupKeyManagement.Structs.GroupKeyMapStruct]" = field(
                default_factory=lambda: []
            )

        @dataclass
        class GroupTable(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.List[GroupKeyManagement.Structs.GroupInfoMapStruct]
                )

            value: "typing.List[GroupKeyManagement.Structs.GroupInfoMapStruct]" = field(
                default_factory=lambda: []
            )

        @dataclass
        class MaxGroupsPerFabric(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class MaxGroupKeysPerFabric(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x003F

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class FixedLabel(Cluster):
    id: typing.ClassVar[int] = 0x0040

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="labelList",
                    Tag=0x00000000,
                    Type=typing.List[FixedLabel.Structs.LabelStruct],
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    labelList: "typing.List[FixedLabel.Structs.LabelStruct]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Structs:
        @dataclass
        class LabelStruct(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="label", Tag=0, Type=str),
                        ClusterObjectFieldDescriptor(Label="value", Tag=1, Type=str),
                    ]
                )

            label: "str" = ""
            value: "str" = ""

    class Attributes:
        @dataclass
        class LabelList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0040

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.List[FixedLabel.Structs.LabelStruct]
                )

            value: "typing.List[FixedLabel.Structs.LabelStruct]" = field(
                default_factory=lambda: []
            )

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0040

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0040

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0040

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0040

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0040

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class UserLabel(Cluster):
    id: typing.ClassVar[int] = 0x0041

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="labelList",
                    Tag=0x00000000,
                    Type=typing.List[UserLabel.Structs.LabelStruct],
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    labelList: "typing.List[UserLabel.Structs.LabelStruct]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Structs:
        @dataclass
        class LabelStruct(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="label", Tag=0, Type=str),
                        ClusterObjectFieldDescriptor(Label="value", Tag=1, Type=str),
                    ]
                )

            label: "str" = ""
            value: "str" = ""

    class Attributes:
        @dataclass
        class LabelList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0041

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.List[UserLabel.Structs.LabelStruct]
                )

            value: "typing.List[UserLabel.Structs.LabelStruct]" = field(
                default_factory=lambda: []
            )

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0041

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0041

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0041

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0041

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0041

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class ProxyConfiguration(Cluster):
    id: typing.ClassVar[int] = 0x0042

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Attributes:
        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0042

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0042

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0042

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0042

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0042

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class ProxyDiscovery(Cluster):
    id: typing.ClassVar[int] = 0x0043

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Attributes:
        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0043

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0043

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0043

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0043

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0043

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class ProxyValid(Cluster):
    id: typing.ClassVar[int] = 0x0044

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Attributes:
        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0044

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0044

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0044

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0044

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0044

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class BooleanState(Cluster):
    id: typing.ClassVar[int] = 0x0045

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="stateValue", Tag=0x00000000, Type=bool
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    stateValue: "bool" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Attributes:
        @dataclass
        class StateValue(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0045

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=bool)

            value: "bool" = False

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0045

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0045

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0045

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0045

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0045

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

    class Events:
        @dataclass
        class StateChange(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0045

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="stateValue", Tag=0, Type=bool
                        ),
                    ]
                )

            stateValue: "bool" = False


@dataclass
class ModeSelect(Cluster):
    id: typing.ClassVar[int] = 0x0050

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="description", Tag=0x00000000, Type=str
                ),
                ClusterObjectFieldDescriptor(
                    Label="standardNamespace",
                    Tag=0x00000001,
                    Type=typing.Union[Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="supportedModes",
                    Tag=0x00000002,
                    Type=typing.List[ModeSelect.Structs.ModeOptionStruct],
                ),
                ClusterObjectFieldDescriptor(
                    Label="currentMode", Tag=0x00000003, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="startUpMode",
                    Tag=0x00000004,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="onMode",
                    Tag=0x00000005,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    description: "str" = None
    standardNamespace: "typing.Union[Nullable, uint]" = None
    supportedModes: "typing.List[ModeSelect.Structs.ModeOptionStruct]" = None
    currentMode: "uint" = None
    startUpMode: "typing.Union[None, Nullable, uint]" = None
    onMode: "typing.Union[None, Nullable, uint]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Structs:
        @dataclass
        class SemanticTag(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="mfgCode", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(Label="value", Tag=1, Type=uint),
                    ]
                )

            mfgCode: "uint" = 0
            value: "uint" = 0

        @dataclass
        class ModeOptionStruct(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="label", Tag=0, Type=str),
                        ClusterObjectFieldDescriptor(Label="mode", Tag=1, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="semanticTags",
                            Tag=2,
                            Type=typing.List[ModeSelect.Structs.SemanticTag],
                        ),
                    ]
                )

            label: "str" = ""
            mode: "uint" = 0
            semanticTags: "typing.List[ModeSelect.Structs.SemanticTag]" = field(
                default_factory=lambda: []
            )

    class Commands:
        @dataclass
        class ChangeToMode(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0050
            command_id: typing.ClassVar[int] = 0x0000
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="newMode", Tag=0, Type=uint),
                    ]
                )

            newMode: "uint" = 0

    class Attributes:
        @dataclass
        class Description(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0050

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=str)

            value: "str" = ""

        @dataclass
        class StandardNamespace(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0050

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, uint])

            value: "typing.Union[Nullable, uint]" = NullValue

        @dataclass
        class SupportedModes(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0050

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.List[ModeSelect.Structs.ModeOptionStruct]
                )

            value: "typing.List[ModeSelect.Structs.ModeOptionStruct]" = field(
                default_factory=lambda: []
            )

        @dataclass
        class CurrentMode(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0050

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class StartUpMode(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0050

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000004

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class OnMode(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0050

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000005

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0050

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0050

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0050

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0050

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0050

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class DoorLock(Cluster):
    id: typing.ClassVar[int] = 0x0101

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="lockState",
                    Tag=0x00000000,
                    Type=typing.Union[Nullable, DoorLock.Enums.DlLockState],
                ),
                ClusterObjectFieldDescriptor(
                    Label="lockType", Tag=0x00000001, Type=DoorLock.Enums.DlLockType
                ),
                ClusterObjectFieldDescriptor(
                    Label="actuatorEnabled", Tag=0x00000002, Type=bool
                ),
                ClusterObjectFieldDescriptor(
                    Label="doorState",
                    Tag=0x00000003,
                    Type=typing.Union[None, Nullable, DoorLock.Enums.DlDoorState],
                ),
                ClusterObjectFieldDescriptor(
                    Label="doorOpenEvents", Tag=0x00000004, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="doorClosedEvents", Tag=0x00000005, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="openPeriod", Tag=0x00000006, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="numberOfTotalUsersSupported",
                    Tag=0x00000011,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="numberOfPINUsersSupported",
                    Tag=0x00000012,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="numberOfRFIDUsersSupported",
                    Tag=0x00000013,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="numberOfWeekDaySchedulesSupportedPerUser",
                    Tag=0x00000014,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="numberOfYearDaySchedulesSupportedPerUser",
                    Tag=0x00000015,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="numberOfHolidaySchedulesSupported",
                    Tag=0x00000016,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="maxPINCodeLength", Tag=0x00000017, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="minPINCodeLength", Tag=0x00000018, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="maxRFIDCodeLength",
                    Tag=0x00000019,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="minRFIDCodeLength",
                    Tag=0x0000001A,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="credentialRulesSupport",
                    Tag=0x0000001B,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="numberOfCredentialsSupportedPerUser",
                    Tag=0x0000001C,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="language", Tag=0x00000021, Type=typing.Optional[str]
                ),
                ClusterObjectFieldDescriptor(
                    Label="LEDSettings", Tag=0x00000022, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="autoRelockTime", Tag=0x00000023, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="soundVolume", Tag=0x00000024, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="operatingMode",
                    Tag=0x00000025,
                    Type=DoorLock.Enums.DlOperatingMode,
                ),
                ClusterObjectFieldDescriptor(
                    Label="supportedOperatingModes", Tag=0x00000026, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="defaultConfigurationRegister",
                    Tag=0x00000027,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="enableLocalProgramming",
                    Tag=0x00000028,
                    Type=typing.Optional[bool],
                ),
                ClusterObjectFieldDescriptor(
                    Label="enableOneTouchLocking",
                    Tag=0x00000029,
                    Type=typing.Optional[bool],
                ),
                ClusterObjectFieldDescriptor(
                    Label="enableInsideStatusLED",
                    Tag=0x0000002A,
                    Type=typing.Optional[bool],
                ),
                ClusterObjectFieldDescriptor(
                    Label="enablePrivacyModeButton",
                    Tag=0x0000002B,
                    Type=typing.Optional[bool],
                ),
                ClusterObjectFieldDescriptor(
                    Label="localProgrammingFeatures",
                    Tag=0x0000002C,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="wrongCodeEntryLimit",
                    Tag=0x00000030,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="userCodeTemporaryDisableTime",
                    Tag=0x00000031,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="sendPINOverTheAir",
                    Tag=0x00000032,
                    Type=typing.Optional[bool],
                ),
                ClusterObjectFieldDescriptor(
                    Label="requirePINforRemoteOperation",
                    Tag=0x00000033,
                    Type=typing.Optional[bool],
                ),
                ClusterObjectFieldDescriptor(
                    Label="expiringUserTimeout",
                    Tag=0x00000035,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    lockState: "typing.Union[Nullable, DoorLock.Enums.DlLockState]" = None
    lockType: "DoorLock.Enums.DlLockType" = None
    actuatorEnabled: "bool" = None
    doorState: "typing.Union[None, Nullable, DoorLock.Enums.DlDoorState]" = None
    doorOpenEvents: "typing.Optional[uint]" = None
    doorClosedEvents: "typing.Optional[uint]" = None
    openPeriod: "typing.Optional[uint]" = None
    numberOfTotalUsersSupported: "typing.Optional[uint]" = None
    numberOfPINUsersSupported: "typing.Optional[uint]" = None
    numberOfRFIDUsersSupported: "typing.Optional[uint]" = None
    numberOfWeekDaySchedulesSupportedPerUser: "typing.Optional[uint]" = None
    numberOfYearDaySchedulesSupportedPerUser: "typing.Optional[uint]" = None
    numberOfHolidaySchedulesSupported: "typing.Optional[uint]" = None
    maxPINCodeLength: "typing.Optional[uint]" = None
    minPINCodeLength: "typing.Optional[uint]" = None
    maxRFIDCodeLength: "typing.Optional[uint]" = None
    minRFIDCodeLength: "typing.Optional[uint]" = None
    credentialRulesSupport: "typing.Optional[uint]" = None
    numberOfCredentialsSupportedPerUser: "typing.Optional[uint]" = None
    language: "typing.Optional[str]" = None
    LEDSettings: "typing.Optional[uint]" = None
    autoRelockTime: "uint" = None
    soundVolume: "typing.Optional[uint]" = None
    operatingMode: "DoorLock.Enums.DlOperatingMode" = None
    supportedOperatingModes: "uint" = None
    defaultConfigurationRegister: "typing.Optional[uint]" = None
    enableLocalProgramming: "typing.Optional[bool]" = None
    enableOneTouchLocking: "typing.Optional[bool]" = None
    enableInsideStatusLED: "typing.Optional[bool]" = None
    enablePrivacyModeButton: "typing.Optional[bool]" = None
    localProgrammingFeatures: "typing.Optional[uint]" = None
    wrongCodeEntryLimit: "typing.Optional[uint]" = None
    userCodeTemporaryDisableTime: "typing.Optional[uint]" = None
    sendPINOverTheAir: "typing.Optional[bool]" = None
    requirePINforRemoteOperation: "typing.Optional[bool]" = None
    expiringUserTimeout: "typing.Optional[uint]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Enums:
        class DlAlarmCode(IntEnum):
            kLockJammed = 0x00
            kLockFactoryReset = 0x01
            kLockRadioPowerCycled = 0x03
            kWrongCodeEntryLimit = 0x04
            kFrontEsceutcheonRemoved = 0x05
            kDoorForcedOpen = 0x06
            kDoorAjar = 0x07
            kForcedUser = 0x08

        class DlCredentialRule(IntEnum):
            kSingle = 0x00
            kDouble = 0x01
            kTri = 0x02

        class DlCredentialType(IntEnum):
            kProgrammingPIN = 0x00
            kPin = 0x01
            kRfid = 0x02
            kFingerprint = 0x03
            kFingerVein = 0x04
            kFace = 0x05

        class DlDataOperationType(IntEnum):
            kAdd = 0x00
            kClear = 0x01
            kModify = 0x02

        class DlDoorState(IntEnum):
            kDoorOpen = 0x00
            kDoorClosed = 0x01
            kDoorJammed = 0x02
            kDoorForcedOpen = 0x03
            kDoorUnspecifiedError = 0x04
            kDoorAjar = 0x05

        class DlLockDataType(IntEnum):
            kUnspecified = 0x00
            kProgrammingCode = 0x01
            kUserIndex = 0x02
            kWeekDaySchedule = 0x03
            kYearDaySchedule = 0x04
            kHolidaySchedule = 0x05
            kPin = 0x06
            kRfid = 0x07
            kFingerprint = 0x08

        class DlLockOperationType(IntEnum):
            kLock = 0x00
            kUnlock = 0x01
            kNonAccessUserEvent = 0x02
            kForcedUserEvent = 0x03

        class DlLockState(IntEnum):
            kNotFullyLocked = 0x00
            kLocked = 0x01
            kUnlocked = 0x02

        class DlLockType(IntEnum):
            kDeadBolt = 0x00
            kMagnetic = 0x01
            kOther = 0x02
            kMortise = 0x03
            kRim = 0x04
            kLatchBolt = 0x05
            kCylindricalLock = 0x06
            kTubularLock = 0x07
            kInterconnectedLock = 0x08
            kDeadLatch = 0x09
            kDoorFurniture = 0x0A

        class DlOperatingMode(IntEnum):
            kNormal = 0x00
            kVacation = 0x01
            kPrivacy = 0x02
            kNoRemoteLockUnlock = 0x03
            kPassage = 0x04

        class DlOperationError(IntEnum):
            kUnspecified = 0x00
            kInvalidCredential = 0x01
            kDisabledUserDenied = 0x02
            kRestricted = 0x03
            kInsufficientBattery = 0x04

        class DlOperationSource(IntEnum):
            kUnspecified = 0x00
            kManual = 0x01
            kProprietaryRemote = 0x02
            kKeypad = 0x03
            kAuto = 0x04
            kButton = 0x05
            kSchedule = 0x06
            kRemote = 0x07
            kRfid = 0x08
            kBiometric = 0x09

        class DlStatus(IntEnum):
            kSuccess = 0x00
            kFailure = 0x01
            kDuplicate = 0x02
            kOccupied = 0x03
            kInvalidField = 0x85
            kResourceExhausted = 0x89
            kNotFound = 0x8B

        class DlUserStatus(IntEnum):
            kAvailable = 0x00
            kOccupiedEnabled = 0x01
            kOccupiedDisabled = 0x03

        class DlUserType(IntEnum):
            kUnrestrictedUser = 0x00
            kYearDayScheduleUser = 0x01
            kWeekDayScheduleUser = 0x02
            kProgrammingUser = 0x03
            kNonAccessUser = 0x04
            kForcedUser = 0x05
            kDisposableUser = 0x06
            kExpiringUser = 0x07
            kScheduleRestrictedUser = 0x08
            kRemoteOnlyUser = 0x09

        class DoorLockOperationEventCode(IntEnum):
            kUnknownOrMfgSpecific = 0x00
            kLock = 0x01
            kUnlock = 0x02
            kLockInvalidPinOrId = 0x03
            kLockInvalidSchedule = 0x04
            kUnlockInvalidPinOrId = 0x05
            kUnlockInvalidSchedule = 0x06
            kOneTouchLock = 0x07
            kKeyLock = 0x08
            kKeyUnlock = 0x09
            kAutoLock = 0x0A
            kScheduleLock = 0x0B
            kScheduleUnlock = 0x0C
            kManualLock = 0x0D
            kManualUnlock = 0x0E

        class DoorLockProgrammingEventCode(IntEnum):
            kUnknownOrMfgSpecific = 0x00
            kMasterCodeChanged = 0x01
            kPinAdded = 0x02
            kPinDeleted = 0x03
            kPinChanged = 0x04
            kIdAdded = 0x05
            kIdDeleted = 0x06

        class DoorLockSetPinOrIdStatus(IntEnum):
            kSuccess = 0x00
            kGeneralFailure = 0x01
            kMemoryFull = 0x02
            kDuplicateCodeError = 0x03

        class DoorLockUserStatus(IntEnum):
            kAvailable = 0x00
            kOccupiedEnabled = 0x01
            kOccupiedDisabled = 0x03
            kNotSupported = 0xFF

        class DoorLockUserType(IntEnum):
            kUnrestricted = 0x00
            kYearDayScheduleUser = 0x01
            kWeekDayScheduleUser = 0x02
            kMasterUser = 0x03
            kNonAccessUser = 0x04
            kNotSupported = 0xFF

    class Structs:
        @dataclass
        class DlCredential(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="credentialType",
                            Tag=0,
                            Type=DoorLock.Enums.DlCredentialType,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="credentialIndex", Tag=1, Type=uint
                        ),
                    ]
                )

            credentialType: "DoorLock.Enums.DlCredentialType" = 0
            credentialIndex: "uint" = 0

    class Commands:
        @dataclass
        class LockDoor(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0101
            command_id: typing.ClassVar[int] = 0x0000
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="pinCode", Tag=0, Type=typing.Optional[bytes]
                        ),
                    ]
                )

            @ChipUtility.classproperty
            def must_use_timed_invoke(cls) -> bool:
                return True

            pinCode: "typing.Optional[bytes]" = None

        @dataclass
        class UnlockDoor(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0101
            command_id: typing.ClassVar[int] = 0x0001
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="pinCode", Tag=0, Type=typing.Optional[bytes]
                        ),
                    ]
                )

            @ChipUtility.classproperty
            def must_use_timed_invoke(cls) -> bool:
                return True

            pinCode: "typing.Optional[bytes]" = None

        @dataclass
        class UnlockWithTimeout(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0101
            command_id: typing.ClassVar[int] = 0x0003
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="timeout", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="pinCode", Tag=1, Type=typing.Optional[bytes]
                        ),
                    ]
                )

            @ChipUtility.classproperty
            def must_use_timed_invoke(cls) -> bool:
                return True

            timeout: "uint" = 0
            pinCode: "typing.Optional[bytes]" = None

        @dataclass
        class SetWeekDaySchedule(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0101
            command_id: typing.ClassVar[int] = 0x000B
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="weekDayIndex", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="userIndex", Tag=1, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="daysMask", Tag=2, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="startHour", Tag=3, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="startMinute", Tag=4, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(Label="endHour", Tag=5, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="endMinute", Tag=6, Type=uint
                        ),
                    ]
                )

            weekDayIndex: "uint" = 0
            userIndex: "uint" = 0
            daysMask: "uint" = 0
            startHour: "uint" = 0
            startMinute: "uint" = 0
            endHour: "uint" = 0
            endMinute: "uint" = 0

        @dataclass
        class GetWeekDaySchedule(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0101
            command_id: typing.ClassVar[int] = 0x000C
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="weekDayIndex", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="userIndex", Tag=1, Type=uint
                        ),
                    ]
                )

            weekDayIndex: "uint" = 0
            userIndex: "uint" = 0

        @dataclass
        class GetWeekDayScheduleResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0101
            command_id: typing.ClassVar[int] = 0x000C
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="weekDayIndex", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="userIndex", Tag=1, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="status", Tag=2, Type=DoorLock.Enums.DlStatus
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="daysMask", Tag=3, Type=typing.Optional[uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="startHour", Tag=4, Type=typing.Optional[uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="startMinute", Tag=5, Type=typing.Optional[uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="endHour", Tag=6, Type=typing.Optional[uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="endMinute", Tag=7, Type=typing.Optional[uint]
                        ),
                    ]
                )

            weekDayIndex: "uint" = 0
            userIndex: "uint" = 0
            status: "DoorLock.Enums.DlStatus" = 0
            daysMask: "typing.Optional[uint]" = None
            startHour: "typing.Optional[uint]" = None
            startMinute: "typing.Optional[uint]" = None
            endHour: "typing.Optional[uint]" = None
            endMinute: "typing.Optional[uint]" = None

        @dataclass
        class ClearWeekDaySchedule(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0101
            command_id: typing.ClassVar[int] = 0x000D
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="weekDayIndex", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="userIndex", Tag=1, Type=uint
                        ),
                    ]
                )

            weekDayIndex: "uint" = 0
            userIndex: "uint" = 0

        @dataclass
        class SetYearDaySchedule(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0101
            command_id: typing.ClassVar[int] = 0x000E
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="yearDayIndex", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="userIndex", Tag=1, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="localStartTime", Tag=2, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="localEndTime", Tag=3, Type=uint
                        ),
                    ]
                )

            yearDayIndex: "uint" = 0
            userIndex: "uint" = 0
            localStartTime: "uint" = 0
            localEndTime: "uint" = 0

        @dataclass
        class GetYearDaySchedule(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0101
            command_id: typing.ClassVar[int] = 0x000F
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="yearDayIndex", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="userIndex", Tag=1, Type=uint
                        ),
                    ]
                )

            yearDayIndex: "uint" = 0
            userIndex: "uint" = 0

        @dataclass
        class GetYearDayScheduleResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0101
            command_id: typing.ClassVar[int] = 0x000F
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="yearDayIndex", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="userIndex", Tag=1, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="status", Tag=2, Type=DoorLock.Enums.DlStatus
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="localStartTime", Tag=3, Type=typing.Optional[uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="localEndTime", Tag=4, Type=typing.Optional[uint]
                        ),
                    ]
                )

            yearDayIndex: "uint" = 0
            userIndex: "uint" = 0
            status: "DoorLock.Enums.DlStatus" = 0
            localStartTime: "typing.Optional[uint]" = None
            localEndTime: "typing.Optional[uint]" = None

        @dataclass
        class ClearYearDaySchedule(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0101
            command_id: typing.ClassVar[int] = 0x0010
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="yearDayIndex", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="userIndex", Tag=1, Type=uint
                        ),
                    ]
                )

            yearDayIndex: "uint" = 0
            userIndex: "uint" = 0

        @dataclass
        class SetHolidaySchedule(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0101
            command_id: typing.ClassVar[int] = 0x0011
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="holidayIndex", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="localStartTime", Tag=1, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="localEndTime", Tag=2, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="operatingMode",
                            Tag=3,
                            Type=DoorLock.Enums.DlOperatingMode,
                        ),
                    ]
                )

            holidayIndex: "uint" = 0
            localStartTime: "uint" = 0
            localEndTime: "uint" = 0
            operatingMode: "DoorLock.Enums.DlOperatingMode" = 0

        @dataclass
        class GetHolidaySchedule(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0101
            command_id: typing.ClassVar[int] = 0x0012
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="holidayIndex", Tag=0, Type=uint
                        ),
                    ]
                )

            holidayIndex: "uint" = 0

        @dataclass
        class GetHolidayScheduleResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0101
            command_id: typing.ClassVar[int] = 0x0012
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="holidayIndex", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="status", Tag=1, Type=DoorLock.Enums.DlStatus
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="localStartTime", Tag=2, Type=typing.Optional[uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="localEndTime", Tag=3, Type=typing.Optional[uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="operatingMode",
                            Tag=4,
                            Type=typing.Optional[DoorLock.Enums.DlOperatingMode],
                        ),
                    ]
                )

            holidayIndex: "uint" = 0
            status: "DoorLock.Enums.DlStatus" = 0
            localStartTime: "typing.Optional[uint]" = None
            localEndTime: "typing.Optional[uint]" = None
            operatingMode: "typing.Optional[DoorLock.Enums.DlOperatingMode]" = None

        @dataclass
        class ClearHolidaySchedule(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0101
            command_id: typing.ClassVar[int] = 0x0013
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="holidayIndex", Tag=0, Type=uint
                        ),
                    ]
                )

            holidayIndex: "uint" = 0

        @dataclass
        class SetUser(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0101
            command_id: typing.ClassVar[int] = 0x001A
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="operationType",
                            Tag=0,
                            Type=DoorLock.Enums.DlDataOperationType,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="userIndex", Tag=1, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="userName", Tag=2, Type=typing.Union[Nullable, str]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="userUniqueId",
                            Tag=3,
                            Type=typing.Union[Nullable, uint],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="userStatus",
                            Tag=4,
                            Type=typing.Union[Nullable, DoorLock.Enums.DlUserStatus],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="userType",
                            Tag=5,
                            Type=typing.Union[Nullable, DoorLock.Enums.DlUserType],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="credentialRule",
                            Tag=6,
                            Type=typing.Union[
                                Nullable, DoorLock.Enums.DlCredentialRule
                            ],
                        ),
                    ]
                )

            @ChipUtility.classproperty
            def must_use_timed_invoke(cls) -> bool:
                return True

            operationType: "DoorLock.Enums.DlDataOperationType" = 0
            userIndex: "uint" = 0
            userName: "typing.Union[Nullable, str]" = NullValue
            userUniqueId: "typing.Union[Nullable, uint]" = NullValue
            userStatus: "typing.Union[Nullable, DoorLock.Enums.DlUserStatus]" = (
                NullValue
            )
            userType: "typing.Union[Nullable, DoorLock.Enums.DlUserType]" = NullValue
            credentialRule: "typing.Union[Nullable, DoorLock.Enums.DlCredentialRule]" = (
                NullValue
            )

        @dataclass
        class GetUser(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0101
            command_id: typing.ClassVar[int] = 0x001B
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="userIndex", Tag=0, Type=uint
                        ),
                    ]
                )

            userIndex: "uint" = 0

        @dataclass
        class GetUserResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0101
            command_id: typing.ClassVar[int] = 0x001C
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="userIndex", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="userName", Tag=1, Type=typing.Union[Nullable, str]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="userUniqueId",
                            Tag=2,
                            Type=typing.Union[Nullable, uint],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="userStatus",
                            Tag=3,
                            Type=typing.Union[Nullable, DoorLock.Enums.DlUserStatus],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="userType",
                            Tag=4,
                            Type=typing.Union[Nullable, DoorLock.Enums.DlUserType],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="credentialRule",
                            Tag=5,
                            Type=typing.Union[
                                Nullable, DoorLock.Enums.DlCredentialRule
                            ],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="credentials",
                            Tag=6,
                            Type=typing.Union[
                                Nullable, typing.List[DoorLock.Structs.DlCredential]
                            ],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="creatorFabricIndex",
                            Tag=7,
                            Type=typing.Union[Nullable, uint],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="lastModifiedFabricIndex",
                            Tag=8,
                            Type=typing.Union[Nullable, uint],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="nextUserIndex",
                            Tag=9,
                            Type=typing.Union[Nullable, uint],
                        ),
                    ]
                )

            userIndex: "uint" = 0
            userName: "typing.Union[Nullable, str]" = NullValue
            userUniqueId: "typing.Union[Nullable, uint]" = NullValue
            userStatus: "typing.Union[Nullable, DoorLock.Enums.DlUserStatus]" = (
                NullValue
            )
            userType: "typing.Union[Nullable, DoorLock.Enums.DlUserType]" = NullValue
            credentialRule: "typing.Union[Nullable, DoorLock.Enums.DlCredentialRule]" = (
                NullValue
            )
            credentials: "typing.Union[Nullable, typing.List[DoorLock.Structs.DlCredential]]" = (
                NullValue
            )
            creatorFabricIndex: "typing.Union[Nullable, uint]" = NullValue
            lastModifiedFabricIndex: "typing.Union[Nullable, uint]" = NullValue
            nextUserIndex: "typing.Union[Nullable, uint]" = NullValue

        @dataclass
        class ClearUser(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0101
            command_id: typing.ClassVar[int] = 0x001D
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="userIndex", Tag=0, Type=uint
                        ),
                    ]
                )

            @ChipUtility.classproperty
            def must_use_timed_invoke(cls) -> bool:
                return True

            userIndex: "uint" = 0

        @dataclass
        class SetCredential(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0101
            command_id: typing.ClassVar[int] = 0x0022
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="operationType",
                            Tag=0,
                            Type=DoorLock.Enums.DlDataOperationType,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="credential",
                            Tag=1,
                            Type=DoorLock.Structs.DlCredential,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="credentialData", Tag=2, Type=bytes
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="userIndex", Tag=3, Type=typing.Union[Nullable, uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="userStatus",
                            Tag=4,
                            Type=typing.Union[Nullable, DoorLock.Enums.DlUserStatus],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="userType",
                            Tag=5,
                            Type=typing.Union[Nullable, DoorLock.Enums.DlUserType],
                        ),
                    ]
                )

            @ChipUtility.classproperty
            def must_use_timed_invoke(cls) -> bool:
                return True

            operationType: "DoorLock.Enums.DlDataOperationType" = 0
            credential: "DoorLock.Structs.DlCredential" = field(
                default_factory=lambda: DoorLock.Structs.DlCredential()
            )
            credentialData: "bytes" = b""
            userIndex: "typing.Union[Nullable, uint]" = NullValue
            userStatus: "typing.Union[Nullable, DoorLock.Enums.DlUserStatus]" = (
                NullValue
            )
            userType: "typing.Union[Nullable, DoorLock.Enums.DlUserType]" = NullValue

        @dataclass
        class SetCredentialResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0101
            command_id: typing.ClassVar[int] = 0x0023
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="status", Tag=0, Type=DoorLock.Enums.DlStatus
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="userIndex", Tag=1, Type=typing.Union[Nullable, uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="nextCredentialIndex",
                            Tag=2,
                            Type=typing.Union[Nullable, uint],
                        ),
                    ]
                )

            status: "DoorLock.Enums.DlStatus" = 0
            userIndex: "typing.Union[Nullable, uint]" = NullValue
            nextCredentialIndex: "typing.Union[Nullable, uint]" = NullValue

        @dataclass
        class GetCredentialStatus(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0101
            command_id: typing.ClassVar[int] = 0x0024
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="credential",
                            Tag=0,
                            Type=DoorLock.Structs.DlCredential,
                        ),
                    ]
                )

            credential: "DoorLock.Structs.DlCredential" = field(
                default_factory=lambda: DoorLock.Structs.DlCredential()
            )

        @dataclass
        class GetCredentialStatusResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0101
            command_id: typing.ClassVar[int] = 0x0025
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="credentialExists", Tag=0, Type=bool
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="userIndex", Tag=1, Type=typing.Union[Nullable, uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="creatorFabricIndex",
                            Tag=2,
                            Type=typing.Union[Nullable, uint],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="lastModifiedFabricIndex",
                            Tag=3,
                            Type=typing.Union[Nullable, uint],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="nextCredentialIndex",
                            Tag=4,
                            Type=typing.Union[Nullable, uint],
                        ),
                    ]
                )

            credentialExists: "bool" = False
            userIndex: "typing.Union[Nullable, uint]" = NullValue
            creatorFabricIndex: "typing.Union[Nullable, uint]" = NullValue
            lastModifiedFabricIndex: "typing.Union[Nullable, uint]" = NullValue
            nextCredentialIndex: "typing.Union[Nullable, uint]" = NullValue

        @dataclass
        class ClearCredential(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0101
            command_id: typing.ClassVar[int] = 0x0026
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="credential",
                            Tag=0,
                            Type=typing.Union[Nullable, DoorLock.Structs.DlCredential],
                        ),
                    ]
                )

            @ChipUtility.classproperty
            def must_use_timed_invoke(cls) -> bool:
                return True

            credential: "typing.Union[Nullable, DoorLock.Structs.DlCredential]" = (
                NullValue
            )

    class Attributes:
        @dataclass
        class LockState(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[Nullable, DoorLock.Enums.DlLockState]
                )

            value: "typing.Union[Nullable, DoorLock.Enums.DlLockState]" = NullValue

        @dataclass
        class LockType(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=DoorLock.Enums.DlLockType)

            value: "DoorLock.Enums.DlLockType" = 0

        @dataclass
        class ActuatorEnabled(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=bool)

            value: "bool" = False

        @dataclass
        class DoorState(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, DoorLock.Enums.DlDoorState]
                )

            value: "typing.Union[None, Nullable, DoorLock.Enums.DlDoorState]" = None

        @dataclass
        class DoorOpenEvents(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000004

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class DoorClosedEvents(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000005

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class OpenPeriod(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000006

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class NumberOfTotalUsersSupported(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000011

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class NumberOfPINUsersSupported(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000012

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class NumberOfRFIDUsersSupported(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000013

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class NumberOfWeekDaySchedulesSupportedPerUser(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000014

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class NumberOfYearDaySchedulesSupportedPerUser(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000015

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class NumberOfHolidaySchedulesSupported(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000016

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class MaxPINCodeLength(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000017

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class MinPINCodeLength(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000018

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class MaxRFIDCodeLength(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000019

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class MinRFIDCodeLength(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000001A

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class CredentialRulesSupport(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000001B

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class NumberOfCredentialsSupportedPerUser(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000001C

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class Language(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000021

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[str])

            value: "typing.Optional[str]" = None

        @dataclass
        class LEDSettings(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000022

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class AutoRelockTime(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000023

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class SoundVolume(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000024

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class OperatingMode(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000025

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=DoorLock.Enums.DlOperatingMode)

            value: "DoorLock.Enums.DlOperatingMode" = 0

        @dataclass
        class SupportedOperatingModes(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000026

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class DefaultConfigurationRegister(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000027

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class EnableLocalProgramming(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000028

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[bool])

            value: "typing.Optional[bool]" = None

        @dataclass
        class EnableOneTouchLocking(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000029

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[bool])

            value: "typing.Optional[bool]" = None

        @dataclass
        class EnableInsideStatusLED(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000002A

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[bool])

            value: "typing.Optional[bool]" = None

        @dataclass
        class EnablePrivacyModeButton(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000002B

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[bool])

            value: "typing.Optional[bool]" = None

        @dataclass
        class LocalProgrammingFeatures(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000002C

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class WrongCodeEntryLimit(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000030

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class UserCodeTemporaryDisableTime(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000031

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class SendPINOverTheAir(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000032

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[bool])

            value: "typing.Optional[bool]" = None

        @dataclass
        class RequirePINforRemoteOperation(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000033

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[bool])

            value: "typing.Optional[bool]" = None

        @dataclass
        class ExpiringUserTimeout(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000035

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

    class Events:
        @dataclass
        class DoorLockAlarm(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="alarmCode", Tag=0, Type=DoorLock.Enums.DlAlarmCode
                        ),
                    ]
                )

            alarmCode: "DoorLock.Enums.DlAlarmCode" = 0

        @dataclass
        class DoorStateChange(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="doorState", Tag=0, Type=DoorLock.Enums.DlDoorState
                        ),
                    ]
                )

            doorState: "DoorLock.Enums.DlDoorState" = 0

        @dataclass
        class LockOperation(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="lockOperationType",
                            Tag=0,
                            Type=DoorLock.Enums.DlLockOperationType,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="operationSource",
                            Tag=1,
                            Type=DoorLock.Enums.DlOperationSource,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="userIndex", Tag=2, Type=typing.Union[Nullable, uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="fabricIndex",
                            Tag=3,
                            Type=typing.Union[Nullable, uint],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="sourceNode", Tag=4, Type=typing.Union[Nullable, uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="credentials",
                            Tag=5,
                            Type=typing.Union[
                                None,
                                Nullable,
                                typing.List[DoorLock.Structs.DlCredential],
                            ],
                        ),
                    ]
                )

            lockOperationType: "DoorLock.Enums.DlLockOperationType" = 0
            operationSource: "DoorLock.Enums.DlOperationSource" = 0
            userIndex: "typing.Union[Nullable, uint]" = NullValue
            fabricIndex: "typing.Union[Nullable, uint]" = NullValue
            sourceNode: "typing.Union[Nullable, uint]" = NullValue
            credentials: "typing.Union[None, Nullable, typing.List[DoorLock.Structs.DlCredential]]" = (
                None
            )

        @dataclass
        class LockOperationError(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="lockOperationType",
                            Tag=0,
                            Type=DoorLock.Enums.DlLockOperationType,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="operationSource",
                            Tag=1,
                            Type=DoorLock.Enums.DlOperationSource,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="operationError",
                            Tag=2,
                            Type=DoorLock.Enums.DlOperationError,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="userIndex", Tag=3, Type=typing.Union[Nullable, uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="fabricIndex",
                            Tag=4,
                            Type=typing.Union[Nullable, uint],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="sourceNode", Tag=5, Type=typing.Union[Nullable, uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="credentials",
                            Tag=6,
                            Type=typing.Union[
                                None,
                                Nullable,
                                typing.List[DoorLock.Structs.DlCredential],
                            ],
                        ),
                    ]
                )

            lockOperationType: "DoorLock.Enums.DlLockOperationType" = 0
            operationSource: "DoorLock.Enums.DlOperationSource" = 0
            operationError: "DoorLock.Enums.DlOperationError" = 0
            userIndex: "typing.Union[Nullable, uint]" = NullValue
            fabricIndex: "typing.Union[Nullable, uint]" = NullValue
            sourceNode: "typing.Union[Nullable, uint]" = NullValue
            credentials: "typing.Union[None, Nullable, typing.List[DoorLock.Structs.DlCredential]]" = (
                None
            )

        @dataclass
        class LockUserChange(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0101

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000004

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="lockDataType",
                            Tag=0,
                            Type=DoorLock.Enums.DlLockDataType,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="dataOperationType",
                            Tag=1,
                            Type=DoorLock.Enums.DlDataOperationType,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="operationSource",
                            Tag=2,
                            Type=DoorLock.Enums.DlOperationSource,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="userIndex", Tag=3, Type=typing.Union[Nullable, uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="fabricIndex",
                            Tag=4,
                            Type=typing.Union[Nullable, uint],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="sourceNode", Tag=5, Type=typing.Union[Nullable, uint]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="dataIndex", Tag=6, Type=typing.Union[Nullable, uint]
                        ),
                    ]
                )

            lockDataType: "DoorLock.Enums.DlLockDataType" = 0
            dataOperationType: "DoorLock.Enums.DlDataOperationType" = 0
            operationSource: "DoorLock.Enums.DlOperationSource" = 0
            userIndex: "typing.Union[Nullable, uint]" = NullValue
            fabricIndex: "typing.Union[Nullable, uint]" = NullValue
            sourceNode: "typing.Union[Nullable, uint]" = NullValue
            dataIndex: "typing.Union[Nullable, uint]" = NullValue


@dataclass
class WindowCovering(Cluster):
    id: typing.ClassVar[int] = 0x0102

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="type", Tag=0x00000000, Type=WindowCovering.Enums.Type
                ),
                ClusterObjectFieldDescriptor(
                    Label="physicalClosedLimitLift",
                    Tag=0x00000001,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="physicalClosedLimitTilt",
                    Tag=0x00000002,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="currentPositionLift",
                    Tag=0x00000003,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="currentPositionTilt",
                    Tag=0x00000004,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="numberOfActuationsLift",
                    Tag=0x00000005,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="numberOfActuationsTilt",
                    Tag=0x00000006,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="configStatus", Tag=0x00000007, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="currentPositionLiftPercentage",
                    Tag=0x00000008,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="currentPositionTiltPercentage",
                    Tag=0x00000009,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="operationalStatus", Tag=0x0000000A, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="targetPositionLiftPercent100ths",
                    Tag=0x0000000B,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="targetPositionTiltPercent100ths",
                    Tag=0x0000000C,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="endProductType",
                    Tag=0x0000000D,
                    Type=WindowCovering.Enums.EndProductType,
                ),
                ClusterObjectFieldDescriptor(
                    Label="currentPositionLiftPercent100ths",
                    Tag=0x0000000E,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="currentPositionTiltPercent100ths",
                    Tag=0x0000000F,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="installedOpenLimitLift",
                    Tag=0x00000010,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="installedClosedLimitLift",
                    Tag=0x00000011,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="installedOpenLimitTilt",
                    Tag=0x00000012,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="installedClosedLimitTilt",
                    Tag=0x00000013,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(Label="mode", Tag=0x00000017, Type=uint),
                ClusterObjectFieldDescriptor(
                    Label="safetyStatus", Tag=0x0000001A, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    type: "WindowCovering.Enums.Type" = None
    physicalClosedLimitLift: "typing.Optional[uint]" = None
    physicalClosedLimitTilt: "typing.Optional[uint]" = None
    currentPositionLift: "typing.Union[None, Nullable, uint]" = None
    currentPositionTilt: "typing.Union[None, Nullable, uint]" = None
    numberOfActuationsLift: "typing.Optional[uint]" = None
    numberOfActuationsTilt: "typing.Optional[uint]" = None
    configStatus: "uint" = None
    currentPositionLiftPercentage: "typing.Union[None, Nullable, uint]" = None
    currentPositionTiltPercentage: "typing.Union[None, Nullable, uint]" = None
    operationalStatus: "uint" = None
    targetPositionLiftPercent100ths: "typing.Union[None, Nullable, uint]" = None
    targetPositionTiltPercent100ths: "typing.Union[None, Nullable, uint]" = None
    endProductType: "WindowCovering.Enums.EndProductType" = None
    currentPositionLiftPercent100ths: "typing.Union[None, Nullable, uint]" = None
    currentPositionTiltPercent100ths: "typing.Union[None, Nullable, uint]" = None
    installedOpenLimitLift: "typing.Optional[uint]" = None
    installedClosedLimitLift: "typing.Optional[uint]" = None
    installedOpenLimitTilt: "typing.Optional[uint]" = None
    installedClosedLimitTilt: "typing.Optional[uint]" = None
    mode: "uint" = None
    safetyStatus: "typing.Optional[uint]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Enums:
        class EndProductType(IntEnum):
            kRollerShade = 0x00
            kRomanShade = 0x01
            kBalloonShade = 0x02
            kWovenWood = 0x03
            kPleatedShade = 0x04
            kCellularShade = 0x05
            kLayeredShade = 0x06
            kLayeredShade2D = 0x07
            kSheerShade = 0x08
            kTiltOnlyInteriorBlind = 0x09
            kInteriorBlind = 0x0A
            kVerticalBlindStripCurtain = 0x0B
            kInteriorVenetianBlind = 0x0C
            kExteriorVenetianBlind = 0x0D
            kLateralLeftCurtain = 0x0E
            kLateralRightCurtain = 0x0F
            kCentralCurtain = 0x10
            kRollerShutter = 0x11
            kExteriorVerticalScreen = 0x12
            kAwningTerracePatio = 0x13
            kAwningVerticalScreen = 0x14
            kTiltOnlyPergola = 0x15
            kSwingingShutter = 0x16
            kSlidingShutter = 0x17
            kUnknown = 0xFF

        class Type(IntEnum):
            kRollerShade = 0x00
            kRollerShade2Motor = 0x01
            kRollerShadeExterior = 0x02
            kRollerShadeExterior2Motor = 0x03
            kDrapery = 0x04
            kAwning = 0x05
            kShutter = 0x06
            kTiltBlindTiltOnly = 0x07
            kTiltBlindLiftAndTilt = 0x08
            kProjectorScreen = 0x09
            kUnknown = 0xFF

    class Commands:
        @dataclass
        class UpOrOpen(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0102
            command_id: typing.ClassVar[int] = 0x0000
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class DownOrClose(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0102
            command_id: typing.ClassVar[int] = 0x0001
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class StopMotion(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0102
            command_id: typing.ClassVar[int] = 0x0002
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class GoToLiftValue(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0102
            command_id: typing.ClassVar[int] = 0x0004
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="liftValue", Tag=0, Type=uint
                        ),
                    ]
                )

            liftValue: "uint" = 0

        @dataclass
        class GoToLiftPercentage(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0102
            command_id: typing.ClassVar[int] = 0x0005
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="liftPercent100thsValue", Tag=0, Type=uint
                        ),
                    ]
                )

            liftPercent100thsValue: "uint" = 0

        @dataclass
        class GoToTiltValue(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0102
            command_id: typing.ClassVar[int] = 0x0007
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="tiltValue", Tag=0, Type=uint
                        ),
                    ]
                )

            tiltValue: "uint" = 0

        @dataclass
        class GoToTiltPercentage(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0102
            command_id: typing.ClassVar[int] = 0x0008
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="tiltPercent100thsValue", Tag=0, Type=uint
                        ),
                    ]
                )

            tiltPercent100thsValue: "uint" = 0

    class Attributes:
        @dataclass
        class Type(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0102

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=WindowCovering.Enums.Type)

            value: "WindowCovering.Enums.Type" = 0

        @dataclass
        class PhysicalClosedLimitLift(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0102

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class PhysicalClosedLimitTilt(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0102

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class CurrentPositionLift(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0102

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class CurrentPositionTilt(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0102

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000004

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class NumberOfActuationsLift(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0102

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000005

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class NumberOfActuationsTilt(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0102

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000006

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class ConfigStatus(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0102

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000007

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class CurrentPositionLiftPercentage(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0102

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000008

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class CurrentPositionTiltPercentage(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0102

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000009

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class OperationalStatus(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0102

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000A

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class TargetPositionLiftPercent100ths(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0102

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000B

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class TargetPositionTiltPercent100ths(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0102

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000C

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class EndProductType(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0102

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000D

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=WindowCovering.Enums.EndProductType
                )

            value: "WindowCovering.Enums.EndProductType" = 0

        @dataclass
        class CurrentPositionLiftPercent100ths(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0102

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000E

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class CurrentPositionTiltPercent100ths(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0102

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000F

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class InstalledOpenLimitLift(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0102

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000010

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class InstalledClosedLimitLift(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0102

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000011

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class InstalledOpenLimitTilt(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0102

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000012

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class InstalledClosedLimitTilt(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0102

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000013

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class Mode(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0102

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000017

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class SafetyStatus(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0102

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000001A

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0102

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0102

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0102

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0102

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0102

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class BarrierControl(Cluster):
    id: typing.ClassVar[int] = 0x0103

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="barrierMovingState", Tag=0x00000001, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="barrierSafetyStatus", Tag=0x00000002, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="barrierCapabilities", Tag=0x00000003, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="barrierOpenEvents",
                    Tag=0x00000004,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="barrierCloseEvents",
                    Tag=0x00000005,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="barrierCommandOpenEvents",
                    Tag=0x00000006,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="barrierCommandCloseEvents",
                    Tag=0x00000007,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="barrierOpenPeriod",
                    Tag=0x00000008,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="barrierClosePeriod",
                    Tag=0x00000009,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="barrierPosition", Tag=0x0000000A, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    barrierMovingState: "uint" = None
    barrierSafetyStatus: "uint" = None
    barrierCapabilities: "uint" = None
    barrierOpenEvents: "typing.Optional[uint]" = None
    barrierCloseEvents: "typing.Optional[uint]" = None
    barrierCommandOpenEvents: "typing.Optional[uint]" = None
    barrierCommandCloseEvents: "typing.Optional[uint]" = None
    barrierOpenPeriod: "typing.Optional[uint]" = None
    barrierClosePeriod: "typing.Optional[uint]" = None
    barrierPosition: "uint" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Commands:
        @dataclass
        class BarrierControlGoToPercent(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0103
            command_id: typing.ClassVar[int] = 0x0000
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="percentOpen", Tag=0, Type=uint
                        ),
                    ]
                )

            percentOpen: "uint" = 0

        @dataclass
        class BarrierControlStop(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0103
            command_id: typing.ClassVar[int] = 0x0001
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

    class Attributes:
        @dataclass
        class BarrierMovingState(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0103

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class BarrierSafetyStatus(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0103

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class BarrierCapabilities(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0103

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class BarrierOpenEvents(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0103

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000004

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class BarrierCloseEvents(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0103

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000005

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class BarrierCommandOpenEvents(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0103

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000006

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class BarrierCommandCloseEvents(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0103

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000007

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class BarrierOpenPeriod(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0103

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000008

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class BarrierClosePeriod(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0103

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000009

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class BarrierPosition(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0103

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000A

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0103

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0103

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0103

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0103

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0103

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class PumpConfigurationAndControl(Cluster):
    id: typing.ClassVar[int] = 0x0200

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="maxPressure",
                    Tag=0x00000000,
                    Type=typing.Union[Nullable, int],
                ),
                ClusterObjectFieldDescriptor(
                    Label="maxSpeed", Tag=0x00000001, Type=typing.Union[Nullable, uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="maxFlow", Tag=0x00000002, Type=typing.Union[Nullable, uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="minConstPressure",
                    Tag=0x00000003,
                    Type=typing.Union[None, Nullable, int],
                ),
                ClusterObjectFieldDescriptor(
                    Label="maxConstPressure",
                    Tag=0x00000004,
                    Type=typing.Union[None, Nullable, int],
                ),
                ClusterObjectFieldDescriptor(
                    Label="minCompPressure",
                    Tag=0x00000005,
                    Type=typing.Union[None, Nullable, int],
                ),
                ClusterObjectFieldDescriptor(
                    Label="maxCompPressure",
                    Tag=0x00000006,
                    Type=typing.Union[None, Nullable, int],
                ),
                ClusterObjectFieldDescriptor(
                    Label="minConstSpeed",
                    Tag=0x00000007,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="maxConstSpeed",
                    Tag=0x00000008,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="minConstFlow",
                    Tag=0x00000009,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="maxConstFlow",
                    Tag=0x0000000A,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="minConstTemp",
                    Tag=0x0000000B,
                    Type=typing.Union[None, Nullable, int],
                ),
                ClusterObjectFieldDescriptor(
                    Label="maxConstTemp",
                    Tag=0x0000000C,
                    Type=typing.Union[None, Nullable, int],
                ),
                ClusterObjectFieldDescriptor(
                    Label="pumpStatus", Tag=0x00000010, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="effectiveOperationMode",
                    Tag=0x00000011,
                    Type=PumpConfigurationAndControl.Enums.PumpOperationMode,
                ),
                ClusterObjectFieldDescriptor(
                    Label="effectiveControlMode",
                    Tag=0x00000012,
                    Type=PumpConfigurationAndControl.Enums.PumpControlMode,
                ),
                ClusterObjectFieldDescriptor(
                    Label="capacity", Tag=0x00000013, Type=typing.Union[Nullable, int]
                ),
                ClusterObjectFieldDescriptor(
                    Label="speed",
                    Tag=0x00000014,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="lifetimeRunningHours",
                    Tag=0x00000015,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="power",
                    Tag=0x00000016,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="lifetimeEnergyConsumed",
                    Tag=0x00000017,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="operationMode",
                    Tag=0x00000020,
                    Type=PumpConfigurationAndControl.Enums.PumpOperationMode,
                ),
                ClusterObjectFieldDescriptor(
                    Label="controlMode",
                    Tag=0x00000021,
                    Type=typing.Optional[
                        PumpConfigurationAndControl.Enums.PumpControlMode
                    ],
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    maxPressure: "typing.Union[Nullable, int]" = None
    maxSpeed: "typing.Union[Nullable, uint]" = None
    maxFlow: "typing.Union[Nullable, uint]" = None
    minConstPressure: "typing.Union[None, Nullable, int]" = None
    maxConstPressure: "typing.Union[None, Nullable, int]" = None
    minCompPressure: "typing.Union[None, Nullable, int]" = None
    maxCompPressure: "typing.Union[None, Nullable, int]" = None
    minConstSpeed: "typing.Union[None, Nullable, uint]" = None
    maxConstSpeed: "typing.Union[None, Nullable, uint]" = None
    minConstFlow: "typing.Union[None, Nullable, uint]" = None
    maxConstFlow: "typing.Union[None, Nullable, uint]" = None
    minConstTemp: "typing.Union[None, Nullable, int]" = None
    maxConstTemp: "typing.Union[None, Nullable, int]" = None
    pumpStatus: "typing.Optional[uint]" = None
    effectiveOperationMode: "PumpConfigurationAndControl.Enums.PumpOperationMode" = None
    effectiveControlMode: "PumpConfigurationAndControl.Enums.PumpControlMode" = None
    capacity: "typing.Union[Nullable, int]" = None
    speed: "typing.Union[None, Nullable, uint]" = None
    lifetimeRunningHours: "typing.Union[None, Nullable, uint]" = None
    power: "typing.Union[None, Nullable, uint]" = None
    lifetimeEnergyConsumed: "typing.Union[None, Nullable, uint]" = None
    operationMode: "PumpConfigurationAndControl.Enums.PumpOperationMode" = None
    controlMode: "typing.Optional[PumpConfigurationAndControl.Enums.PumpControlMode]" = (
        None
    )
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Enums:
        class PumpControlMode(IntEnum):
            kConstantSpeed = 0x00
            kConstantPressure = 0x01
            kProportionalPressure = 0x02
            kConstantFlow = 0x03
            kConstantTemperature = 0x05
            kAutomatic = 0x07

        class PumpOperationMode(IntEnum):
            kNormal = 0x00
            kMinimum = 0x01
            kMaximum = 0x02
            kLocal = 0x03

    class Attributes:
        @dataclass
        class MaxPressure(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, int])

            value: "typing.Union[Nullable, int]" = NullValue

        @dataclass
        class MaxSpeed(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, uint])

            value: "typing.Union[Nullable, uint]" = NullValue

        @dataclass
        class MaxFlow(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, uint])

            value: "typing.Union[Nullable, uint]" = NullValue

        @dataclass
        class MinConstPressure(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, int]
                )

            value: "typing.Union[None, Nullable, int]" = None

        @dataclass
        class MaxConstPressure(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000004

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, int]
                )

            value: "typing.Union[None, Nullable, int]" = None

        @dataclass
        class MinCompPressure(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000005

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, int]
                )

            value: "typing.Union[None, Nullable, int]" = None

        @dataclass
        class MaxCompPressure(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000006

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, int]
                )

            value: "typing.Union[None, Nullable, int]" = None

        @dataclass
        class MinConstSpeed(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000007

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class MaxConstSpeed(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000008

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class MinConstFlow(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000009

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class MaxConstFlow(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000A

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class MinConstTemp(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000B

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, int]
                )

            value: "typing.Union[None, Nullable, int]" = None

        @dataclass
        class MaxConstTemp(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000C

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, int]
                )

            value: "typing.Union[None, Nullable, int]" = None

        @dataclass
        class PumpStatus(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000010

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class EffectiveOperationMode(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000011

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=PumpConfigurationAndControl.Enums.PumpOperationMode
                )

            value: "PumpConfigurationAndControl.Enums.PumpOperationMode" = 0

        @dataclass
        class EffectiveControlMode(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000012

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=PumpConfigurationAndControl.Enums.PumpControlMode
                )

            value: "PumpConfigurationAndControl.Enums.PumpControlMode" = 0

        @dataclass
        class Capacity(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000013

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, int])

            value: "typing.Union[Nullable, int]" = NullValue

        @dataclass
        class Speed(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000014

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class LifetimeRunningHours(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000015

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class Power(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000016

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class LifetimeEnergyConsumed(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000017

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class OperationMode(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000020

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=PumpConfigurationAndControl.Enums.PumpOperationMode
                )

            value: "PumpConfigurationAndControl.Enums.PumpOperationMode" = 0

        @dataclass
        class ControlMode(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000021

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Optional[
                        PumpConfigurationAndControl.Enums.PumpControlMode
                    ]
                )

            value: "typing.Optional[PumpConfigurationAndControl.Enums.PumpControlMode]" = (
                None
            )

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

    class Events:
        @dataclass
        class SupplyVoltageLow(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class SupplyVoltageHigh(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class PowerMissingPhase(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class SystemPressureLow(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class SystemPressureHigh(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000004

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class DryRunning(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000005

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class MotorTemperatureHigh(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000006

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class PumpMotorFatalFailure(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000007

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class ElectronicTemperatureHigh(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000008

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class PumpBlocked(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000009

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class SensorFailure(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x0000000A

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class ElectronicNonFatalFailure(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x0000000B

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class ElectronicFatalFailure(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x0000000C

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class GeneralFault(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x0000000D

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class Leakage(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x0000000E

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class AirDetection(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x0000000F

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class TurbineOperation(ClusterEvent):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0200

            @ChipUtility.classproperty
            def event_id(cls) -> int:
                return 0x00000010

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])


@dataclass
class Thermostat(Cluster):
    id: typing.ClassVar[int] = 0x0201

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="localTemperature",
                    Tag=0x00000000,
                    Type=typing.Union[Nullable, int],
                ),
                ClusterObjectFieldDescriptor(
                    Label="outdoorTemperature",
                    Tag=0x00000001,
                    Type=typing.Union[None, Nullable, int],
                ),
                ClusterObjectFieldDescriptor(
                    Label="occupancy", Tag=0x00000002, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="absMinHeatSetpointLimit",
                    Tag=0x00000003,
                    Type=typing.Optional[int],
                ),
                ClusterObjectFieldDescriptor(
                    Label="absMaxHeatSetpointLimit",
                    Tag=0x00000004,
                    Type=typing.Optional[int],
                ),
                ClusterObjectFieldDescriptor(
                    Label="absMinCoolSetpointLimit",
                    Tag=0x00000005,
                    Type=typing.Optional[int],
                ),
                ClusterObjectFieldDescriptor(
                    Label="absMaxCoolSetpointLimit",
                    Tag=0x00000006,
                    Type=typing.Optional[int],
                ),
                ClusterObjectFieldDescriptor(
                    Label="PICoolingDemand", Tag=0x00000007, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="PIHeatingDemand", Tag=0x00000008, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="HVACSystemTypeConfiguration",
                    Tag=0x00000009,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="localTemperatureCalibration",
                    Tag=0x00000010,
                    Type=typing.Optional[int],
                ),
                ClusterObjectFieldDescriptor(
                    Label="occupiedCoolingSetpoint",
                    Tag=0x00000011,
                    Type=typing.Optional[int],
                ),
                ClusterObjectFieldDescriptor(
                    Label="occupiedHeatingSetpoint",
                    Tag=0x00000012,
                    Type=typing.Optional[int],
                ),
                ClusterObjectFieldDescriptor(
                    Label="unoccupiedCoolingSetpoint",
                    Tag=0x00000013,
                    Type=typing.Optional[int],
                ),
                ClusterObjectFieldDescriptor(
                    Label="unoccupiedHeatingSetpoint",
                    Tag=0x00000014,
                    Type=typing.Optional[int],
                ),
                ClusterObjectFieldDescriptor(
                    Label="minHeatSetpointLimit",
                    Tag=0x00000015,
                    Type=typing.Optional[int],
                ),
                ClusterObjectFieldDescriptor(
                    Label="maxHeatSetpointLimit",
                    Tag=0x00000016,
                    Type=typing.Optional[int],
                ),
                ClusterObjectFieldDescriptor(
                    Label="minCoolSetpointLimit",
                    Tag=0x00000017,
                    Type=typing.Optional[int],
                ),
                ClusterObjectFieldDescriptor(
                    Label="maxCoolSetpointLimit",
                    Tag=0x00000018,
                    Type=typing.Optional[int],
                ),
                ClusterObjectFieldDescriptor(
                    Label="minSetpointDeadBand",
                    Tag=0x00000019,
                    Type=typing.Optional[int],
                ),
                ClusterObjectFieldDescriptor(
                    Label="remoteSensing", Tag=0x0000001A, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="controlSequenceOfOperation",
                    Tag=0x0000001B,
                    Type=Thermostat.Enums.ThermostatControlSequence,
                ),
                ClusterObjectFieldDescriptor(
                    Label="systemMode", Tag=0x0000001C, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="thermostatRunningMode",
                    Tag=0x0000001E,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="startOfWeek", Tag=0x00000020, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="numberOfWeeklyTransitions",
                    Tag=0x00000021,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="numberOfDailyTransitions",
                    Tag=0x00000022,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="temperatureSetpointHold",
                    Tag=0x00000023,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="temperatureSetpointHoldDuration",
                    Tag=0x00000024,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="thermostatProgrammingOperationMode",
                    Tag=0x00000025,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="thermostatRunningState",
                    Tag=0x00000029,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="setpointChangeSource",
                    Tag=0x00000030,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="setpointChangeAmount",
                    Tag=0x00000031,
                    Type=typing.Union[None, Nullable, int],
                ),
                ClusterObjectFieldDescriptor(
                    Label="setpointChangeSourceTimestamp",
                    Tag=0x00000032,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="occupiedSetback",
                    Tag=0x00000034,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="occupiedSetbackMin",
                    Tag=0x00000035,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="occupiedSetbackMax",
                    Tag=0x00000036,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="unoccupiedSetback",
                    Tag=0x00000037,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="unoccupiedSetbackMin",
                    Tag=0x00000038,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="unoccupiedSetbackMax",
                    Tag=0x00000039,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="emergencyHeatDelta",
                    Tag=0x0000003A,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="ACType", Tag=0x00000040, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="ACCapacity", Tag=0x00000041, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="ACRefrigerantType",
                    Tag=0x00000042,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="ACCompressorType", Tag=0x00000043, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="ACErrorCode", Tag=0x00000044, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="ACLouverPosition", Tag=0x00000045, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="ACCoilTemperature",
                    Tag=0x00000046,
                    Type=typing.Union[None, Nullable, int],
                ),
                ClusterObjectFieldDescriptor(
                    Label="ACCapacityformat", Tag=0x00000047, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    localTemperature: "typing.Union[Nullable, int]" = None
    outdoorTemperature: "typing.Union[None, Nullable, int]" = None
    occupancy: "typing.Optional[uint]" = None
    absMinHeatSetpointLimit: "typing.Optional[int]" = None
    absMaxHeatSetpointLimit: "typing.Optional[int]" = None
    absMinCoolSetpointLimit: "typing.Optional[int]" = None
    absMaxCoolSetpointLimit: "typing.Optional[int]" = None
    PICoolingDemand: "typing.Optional[uint]" = None
    PIHeatingDemand: "typing.Optional[uint]" = None
    HVACSystemTypeConfiguration: "typing.Optional[uint]" = None
    localTemperatureCalibration: "typing.Optional[int]" = None
    occupiedCoolingSetpoint: "typing.Optional[int]" = None
    occupiedHeatingSetpoint: "typing.Optional[int]" = None
    unoccupiedCoolingSetpoint: "typing.Optional[int]" = None
    unoccupiedHeatingSetpoint: "typing.Optional[int]" = None
    minHeatSetpointLimit: "typing.Optional[int]" = None
    maxHeatSetpointLimit: "typing.Optional[int]" = None
    minCoolSetpointLimit: "typing.Optional[int]" = None
    maxCoolSetpointLimit: "typing.Optional[int]" = None
    minSetpointDeadBand: "typing.Optional[int]" = None
    remoteSensing: "typing.Optional[uint]" = None
    controlSequenceOfOperation: "Thermostat.Enums.ThermostatControlSequence" = None
    systemMode: "uint" = None
    thermostatRunningMode: "typing.Optional[uint]" = None
    startOfWeek: "typing.Optional[uint]" = None
    numberOfWeeklyTransitions: "typing.Optional[uint]" = None
    numberOfDailyTransitions: "typing.Optional[uint]" = None
    temperatureSetpointHold: "typing.Optional[uint]" = None
    temperatureSetpointHoldDuration: "typing.Union[None, Nullable, uint]" = None
    thermostatProgrammingOperationMode: "typing.Optional[uint]" = None
    thermostatRunningState: "typing.Optional[uint]" = None
    setpointChangeSource: "typing.Optional[uint]" = None
    setpointChangeAmount: "typing.Union[None, Nullable, int]" = None
    setpointChangeSourceTimestamp: "typing.Optional[uint]" = None
    occupiedSetback: "typing.Union[None, Nullable, uint]" = None
    occupiedSetbackMin: "typing.Union[None, Nullable, uint]" = None
    occupiedSetbackMax: "typing.Union[None, Nullable, uint]" = None
    unoccupiedSetback: "typing.Union[None, Nullable, uint]" = None
    unoccupiedSetbackMin: "typing.Union[None, Nullable, uint]" = None
    unoccupiedSetbackMax: "typing.Union[None, Nullable, uint]" = None
    emergencyHeatDelta: "typing.Optional[uint]" = None
    ACType: "typing.Optional[uint]" = None
    ACCapacity: "typing.Optional[uint]" = None
    ACRefrigerantType: "typing.Optional[uint]" = None
    ACCompressorType: "typing.Optional[uint]" = None
    ACErrorCode: "typing.Optional[uint]" = None
    ACLouverPosition: "typing.Optional[uint]" = None
    ACCoilTemperature: "typing.Union[None, Nullable, int]" = None
    ACCapacityformat: "typing.Optional[uint]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Enums:
        class SetpointAdjustMode(IntEnum):
            kHeatSetpoint = 0x00
            kCoolSetpoint = 0x01
            kHeatAndCoolSetpoints = 0x02

        class ThermostatControlSequence(IntEnum):
            kCoolingOnly = 0x00
            kCoolingWithReheat = 0x01
            kHeatingOnly = 0x02
            kHeatingWithReheat = 0x03
            kCoolingAndHeating = 0x04
            kCoolingAndHeatingWithReheat = 0x05

        class ThermostatRunningMode(IntEnum):
            kOff = 0x00
            kCool = 0x03
            kHeat = 0x04

        class ThermostatSystemMode(IntEnum):
            kOff = 0x00
            kAuto = 0x01
            kCool = 0x03
            kHeat = 0x04
            kEmergencyHeating = 0x05
            kPrecooling = 0x06
            kFanOnly = 0x07

    class Structs:
        @dataclass
        class ThermostatScheduleTransition(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="transitionTime", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="heatSetpoint",
                            Tag=1,
                            Type=typing.Union[Nullable, int],
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="coolSetpoint",
                            Tag=2,
                            Type=typing.Union[Nullable, int],
                        ),
                    ]
                )

            transitionTime: "uint" = 0
            heatSetpoint: "typing.Union[Nullable, int]" = NullValue
            coolSetpoint: "typing.Union[Nullable, int]" = NullValue

    class Commands:
        @dataclass
        class SetpointRaiseLower(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0201
            command_id: typing.ClassVar[int] = 0x0000
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="mode",
                            Tag=0,
                            Type=Thermostat.Enums.SetpointAdjustMode,
                        ),
                        ClusterObjectFieldDescriptor(Label="amount", Tag=1, Type=int),
                    ]
                )

            mode: "Thermostat.Enums.SetpointAdjustMode" = 0
            amount: "int" = 0

        @dataclass
        class GetWeeklyScheduleResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0201
            command_id: typing.ClassVar[int] = 0x0000
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="numberOfTransitionsForSequence", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="dayOfWeekForSequence", Tag=1, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="modeForSequence", Tag=2, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="transitions",
                            Tag=3,
                            Type=typing.List[
                                Thermostat.Structs.ThermostatScheduleTransition
                            ],
                        ),
                    ]
                )

            numberOfTransitionsForSequence: "uint" = 0
            dayOfWeekForSequence: "uint" = 0
            modeForSequence: "uint" = 0
            transitions: "typing.List[Thermostat.Structs.ThermostatScheduleTransition]" = field(
                default_factory=lambda: []
            )

        @dataclass
        class SetWeeklySchedule(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0201
            command_id: typing.ClassVar[int] = 0x0001
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="numberOfTransitionsForSequence", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="dayOfWeekForSequence", Tag=1, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="modeForSequence", Tag=2, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="transitions",
                            Tag=3,
                            Type=typing.List[
                                Thermostat.Structs.ThermostatScheduleTransition
                            ],
                        ),
                    ]
                )

            numberOfTransitionsForSequence: "uint" = 0
            dayOfWeekForSequence: "uint" = 0
            modeForSequence: "uint" = 0
            transitions: "typing.List[Thermostat.Structs.ThermostatScheduleTransition]" = field(
                default_factory=lambda: []
            )

        @dataclass
        class GetWeeklySchedule(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0201
            command_id: typing.ClassVar[int] = 0x0002
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="daysToReturn", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="modeToReturn", Tag=1, Type=uint
                        ),
                    ]
                )

            daysToReturn: "uint" = 0
            modeToReturn: "uint" = 0

        @dataclass
        class ClearWeeklySchedule(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0201
            command_id: typing.ClassVar[int] = 0x0003
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

    class Attributes:
        @dataclass
        class LocalTemperature(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, int])

            value: "typing.Union[Nullable, int]" = NullValue

        @dataclass
        class OutdoorTemperature(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, int]
                )

            value: "typing.Union[None, Nullable, int]" = None

        @dataclass
        class Occupancy(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class AbsMinHeatSetpointLimit(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[int])

            value: "typing.Optional[int]" = None

        @dataclass
        class AbsMaxHeatSetpointLimit(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000004

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[int])

            value: "typing.Optional[int]" = None

        @dataclass
        class AbsMinCoolSetpointLimit(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000005

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[int])

            value: "typing.Optional[int]" = None

        @dataclass
        class AbsMaxCoolSetpointLimit(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000006

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[int])

            value: "typing.Optional[int]" = None

        @dataclass
        class PICoolingDemand(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000007

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class PIHeatingDemand(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000008

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class HVACSystemTypeConfiguration(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000009

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class LocalTemperatureCalibration(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000010

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[int])

            value: "typing.Optional[int]" = None

        @dataclass
        class OccupiedCoolingSetpoint(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000011

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[int])

            value: "typing.Optional[int]" = None

        @dataclass
        class OccupiedHeatingSetpoint(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000012

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[int])

            value: "typing.Optional[int]" = None

        @dataclass
        class UnoccupiedCoolingSetpoint(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000013

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[int])

            value: "typing.Optional[int]" = None

        @dataclass
        class UnoccupiedHeatingSetpoint(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000014

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[int])

            value: "typing.Optional[int]" = None

        @dataclass
        class MinHeatSetpointLimit(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000015

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[int])

            value: "typing.Optional[int]" = None

        @dataclass
        class MaxHeatSetpointLimit(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000016

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[int])

            value: "typing.Optional[int]" = None

        @dataclass
        class MinCoolSetpointLimit(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000017

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[int])

            value: "typing.Optional[int]" = None

        @dataclass
        class MaxCoolSetpointLimit(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000018

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[int])

            value: "typing.Optional[int]" = None

        @dataclass
        class MinSetpointDeadBand(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000019

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[int])

            value: "typing.Optional[int]" = None

        @dataclass
        class RemoteSensing(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000001A

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class ControlSequenceOfOperation(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000001B

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=Thermostat.Enums.ThermostatControlSequence
                )

            value: "Thermostat.Enums.ThermostatControlSequence" = 0

        @dataclass
        class SystemMode(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000001C

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ThermostatRunningMode(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000001E

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class StartOfWeek(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000020

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class NumberOfWeeklyTransitions(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000021

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class NumberOfDailyTransitions(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000022

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class TemperatureSetpointHold(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000023

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class TemperatureSetpointHoldDuration(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000024

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class ThermostatProgrammingOperationMode(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000025

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class ThermostatRunningState(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000029

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class SetpointChangeSource(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000030

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class SetpointChangeAmount(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000031

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, int]
                )

            value: "typing.Union[None, Nullable, int]" = None

        @dataclass
        class SetpointChangeSourceTimestamp(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000032

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class OccupiedSetback(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000034

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class OccupiedSetbackMin(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000035

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class OccupiedSetbackMax(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000036

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class UnoccupiedSetback(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000037

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class UnoccupiedSetbackMin(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000038

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class UnoccupiedSetbackMax(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000039

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class EmergencyHeatDelta(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000003A

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class ACType(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000040

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class ACCapacity(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000041

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class ACRefrigerantType(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000042

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class ACCompressorType(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000043

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class ACErrorCode(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000044

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class ACLouverPosition(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000045

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class ACCoilTemperature(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000046

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, int]
                )

            value: "typing.Union[None, Nullable, int]" = None

        @dataclass
        class ACCapacityformat(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000047

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0201

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class FanControl(Cluster):
    id: typing.ClassVar[int] = 0x0202

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="fanMode", Tag=0x00000000, Type=FanControl.Enums.FanModeType
                ),
                ClusterObjectFieldDescriptor(
                    Label="fanModeSequence",
                    Tag=0x00000001,
                    Type=FanControl.Enums.FanModeSequenceType,
                ),
                ClusterObjectFieldDescriptor(
                    Label="percentSetting",
                    Tag=0x00000002,
                    Type=typing.Union[Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="percentCurrent", Tag=0x00000003, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="speedMax", Tag=0x00000004, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="speedSetting",
                    Tag=0x00000005,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="speedCurrent", Tag=0x00000006, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="rockSupport", Tag=0x00000007, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="rockSetting", Tag=0x00000008, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="windSupport", Tag=0x00000009, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="windSetting", Tag=0x0000000A, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    fanMode: "FanControl.Enums.FanModeType" = None
    fanModeSequence: "FanControl.Enums.FanModeSequenceType" = None
    percentSetting: "typing.Union[Nullable, uint]" = None
    percentCurrent: "uint" = None
    speedMax: "typing.Optional[uint]" = None
    speedSetting: "typing.Union[None, Nullable, uint]" = None
    speedCurrent: "typing.Optional[uint]" = None
    rockSupport: "typing.Optional[uint]" = None
    rockSetting: "typing.Optional[uint]" = None
    windSupport: "typing.Optional[uint]" = None
    windSetting: "typing.Optional[uint]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Enums:
        class FanModeSequenceType(IntEnum):
            kOffLowMedHigh = 0x00
            kOffLowHigh = 0x01
            kOffLowMedHighAuto = 0x02
            kOffLowHighAuto = 0x03
            kOffOnAuto = 0x04
            kOffOn = 0x05

        class FanModeType(IntEnum):
            kOff = 0x00
            kLow = 0x01
            kMedium = 0x02
            kHigh = 0x03
            kOn = 0x04
            kAuto = 0x05
            kSmart = 0x06

    class Attributes:
        @dataclass
        class FanMode(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0202

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=FanControl.Enums.FanModeType)

            value: "FanControl.Enums.FanModeType" = 0

        @dataclass
        class FanModeSequence(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0202

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=FanControl.Enums.FanModeSequenceType
                )

            value: "FanControl.Enums.FanModeSequenceType" = 0

        @dataclass
        class PercentSetting(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0202

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, uint])

            value: "typing.Union[Nullable, uint]" = NullValue

        @dataclass
        class PercentCurrent(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0202

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class SpeedMax(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0202

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000004

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class SpeedSetting(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0202

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000005

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class SpeedCurrent(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0202

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000006

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class RockSupport(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0202

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000007

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class RockSetting(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0202

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000008

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class WindSupport(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0202

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000009

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class WindSetting(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0202

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000A

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0202

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0202

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0202

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0202

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0202

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class ThermostatUserInterfaceConfiguration(Cluster):
    id: typing.ClassVar[int] = 0x0204

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="temperatureDisplayMode", Tag=0x00000000, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="keypadLockout", Tag=0x00000001, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="scheduleProgrammingVisibility",
                    Tag=0x00000002,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    temperatureDisplayMode: "uint" = None
    keypadLockout: "uint" = None
    scheduleProgrammingVisibility: "typing.Optional[uint]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Attributes:
        @dataclass
        class TemperatureDisplayMode(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0204

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class KeypadLockout(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0204

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ScheduleProgrammingVisibility(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0204

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0204

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0204

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0204

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0204

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0204

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class ColorControl(Cluster):
    id: typing.ClassVar[int] = 0x0300

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="currentHue", Tag=0x00000000, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="currentSaturation",
                    Tag=0x00000001,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="remainingTime", Tag=0x00000002, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="currentX", Tag=0x00000003, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="currentY", Tag=0x00000004, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="driftCompensation",
                    Tag=0x00000005,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="compensationText", Tag=0x00000006, Type=typing.Optional[str]
                ),
                ClusterObjectFieldDescriptor(
                    Label="colorTemperatureMireds",
                    Tag=0x00000007,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="colorMode", Tag=0x00000008, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="options", Tag=0x0000000F, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="numberOfPrimaries",
                    Tag=0x00000010,
                    Type=typing.Union[Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="primary1X", Tag=0x00000011, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="primary1Y", Tag=0x00000012, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="primary1Intensity",
                    Tag=0x00000013,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="primary2X", Tag=0x00000015, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="primary2Y", Tag=0x00000016, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="primary2Intensity",
                    Tag=0x00000017,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="primary3X", Tag=0x00000019, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="primary3Y", Tag=0x0000001A, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="primary3Intensity",
                    Tag=0x0000001B,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="primary4X", Tag=0x00000020, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="primary4Y", Tag=0x00000021, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="primary4Intensity",
                    Tag=0x00000022,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="primary5X", Tag=0x00000024, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="primary5Y", Tag=0x00000025, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="primary5Intensity",
                    Tag=0x00000026,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="primary6X", Tag=0x00000028, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="primary6Y", Tag=0x00000029, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="primary6Intensity",
                    Tag=0x0000002A,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="whitePointX", Tag=0x00000030, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="whitePointY", Tag=0x00000031, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="colorPointRX", Tag=0x00000032, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="colorPointRY", Tag=0x00000033, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="colorPointRIntensity",
                    Tag=0x00000034,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="colorPointGX", Tag=0x00000036, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="colorPointGY", Tag=0x00000037, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="colorPointGIntensity",
                    Tag=0x00000038,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="colorPointBX", Tag=0x0000003A, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="colorPointBY", Tag=0x0000003B, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="colorPointBIntensity",
                    Tag=0x0000003C,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="enhancedCurrentHue",
                    Tag=0x00004000,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="enhancedColorMode", Tag=0x00004001, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="colorLoopActive", Tag=0x00004002, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="colorLoopDirection",
                    Tag=0x00004003,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="colorLoopTime", Tag=0x00004004, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="colorLoopStartEnhancedHue",
                    Tag=0x00004005,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="colorLoopStoredEnhancedHue",
                    Tag=0x00004006,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="colorCapabilities", Tag=0x0000400A, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="colorTempPhysicalMinMireds",
                    Tag=0x0000400B,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="colorTempPhysicalMaxMireds",
                    Tag=0x0000400C,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="coupleColorTempToLevelMinMireds",
                    Tag=0x0000400D,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="startUpColorTemperatureMireds",
                    Tag=0x00004010,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    currentHue: "typing.Optional[uint]" = None
    currentSaturation: "typing.Optional[uint]" = None
    remainingTime: "typing.Optional[uint]" = None
    currentX: "typing.Optional[uint]" = None
    currentY: "typing.Optional[uint]" = None
    driftCompensation: "typing.Optional[uint]" = None
    compensationText: "typing.Optional[str]" = None
    colorTemperatureMireds: "typing.Optional[uint]" = None
    colorMode: "uint" = None
    options: "uint" = None
    numberOfPrimaries: "typing.Union[Nullable, uint]" = None
    primary1X: "typing.Optional[uint]" = None
    primary1Y: "typing.Optional[uint]" = None
    primary1Intensity: "typing.Union[None, Nullable, uint]" = None
    primary2X: "typing.Optional[uint]" = None
    primary2Y: "typing.Optional[uint]" = None
    primary2Intensity: "typing.Union[None, Nullable, uint]" = None
    primary3X: "typing.Optional[uint]" = None
    primary3Y: "typing.Optional[uint]" = None
    primary3Intensity: "typing.Union[None, Nullable, uint]" = None
    primary4X: "typing.Optional[uint]" = None
    primary4Y: "typing.Optional[uint]" = None
    primary4Intensity: "typing.Union[None, Nullable, uint]" = None
    primary5X: "typing.Optional[uint]" = None
    primary5Y: "typing.Optional[uint]" = None
    primary5Intensity: "typing.Union[None, Nullable, uint]" = None
    primary6X: "typing.Optional[uint]" = None
    primary6Y: "typing.Optional[uint]" = None
    primary6Intensity: "typing.Union[None, Nullable, uint]" = None
    whitePointX: "typing.Optional[uint]" = None
    whitePointY: "typing.Optional[uint]" = None
    colorPointRX: "typing.Optional[uint]" = None
    colorPointRY: "typing.Optional[uint]" = None
    colorPointRIntensity: "typing.Union[None, Nullable, uint]" = None
    colorPointGX: "typing.Optional[uint]" = None
    colorPointGY: "typing.Optional[uint]" = None
    colorPointGIntensity: "typing.Union[None, Nullable, uint]" = None
    colorPointBX: "typing.Optional[uint]" = None
    colorPointBY: "typing.Optional[uint]" = None
    colorPointBIntensity: "typing.Union[None, Nullable, uint]" = None
    enhancedCurrentHue: "typing.Optional[uint]" = None
    enhancedColorMode: "uint" = None
    colorLoopActive: "typing.Optional[uint]" = None
    colorLoopDirection: "typing.Optional[uint]" = None
    colorLoopTime: "typing.Optional[uint]" = None
    colorLoopStartEnhancedHue: "typing.Optional[uint]" = None
    colorLoopStoredEnhancedHue: "typing.Optional[uint]" = None
    colorCapabilities: "uint" = None
    colorTempPhysicalMinMireds: "typing.Optional[uint]" = None
    colorTempPhysicalMaxMireds: "typing.Optional[uint]" = None
    coupleColorTempToLevelMinMireds: "typing.Optional[uint]" = None
    startUpColorTemperatureMireds: "typing.Union[None, Nullable, uint]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Enums:
        class ColorLoopAction(IntEnum):
            kDeactivate = 0x00
            kActivateFromColorLoopStartEnhancedHue = 0x01
            kActivateFromEnhancedCurrentHue = 0x02

        class ColorLoopDirection(IntEnum):
            kDecrementHue = 0x00
            kIncrementHue = 0x01

        class ColorMode(IntEnum):
            kCurrentHueAndCurrentSaturation = 0x00
            kCurrentXAndCurrentY = 0x01
            kColorTemperature = 0x02

        class HueDirection(IntEnum):
            kShortestDistance = 0x00
            kLongestDistance = 0x01
            kUp = 0x02
            kDown = 0x03

        class HueMoveMode(IntEnum):
            kStop = 0x00
            kUp = 0x01
            kDown = 0x03

        class HueStepMode(IntEnum):
            kUp = 0x01
            kDown = 0x03

        class SaturationMoveMode(IntEnum):
            kStop = 0x00
            kUp = 0x01
            kDown = 0x03

        class SaturationStepMode(IntEnum):
            kUp = 0x01
            kDown = 0x03

    class Commands:
        @dataclass
        class MoveToHue(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0300
            command_id: typing.ClassVar[int] = 0x0000
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="hue", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="direction",
                            Tag=1,
                            Type=ColorControl.Enums.HueDirection,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="transitionTime", Tag=2, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsMask", Tag=3, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsOverride", Tag=4, Type=uint
                        ),
                    ]
                )

            hue: "uint" = 0
            direction: "ColorControl.Enums.HueDirection" = 0
            transitionTime: "uint" = 0
            optionsMask: "uint" = 0
            optionsOverride: "uint" = 0

        @dataclass
        class MoveHue(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0300
            command_id: typing.ClassVar[int] = 0x0001
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="moveMode", Tag=0, Type=ColorControl.Enums.HueMoveMode
                        ),
                        ClusterObjectFieldDescriptor(Label="rate", Tag=1, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="optionsMask", Tag=2, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsOverride", Tag=3, Type=uint
                        ),
                    ]
                )

            moveMode: "ColorControl.Enums.HueMoveMode" = 0
            rate: "uint" = 0
            optionsMask: "uint" = 0
            optionsOverride: "uint" = 0

        @dataclass
        class StepHue(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0300
            command_id: typing.ClassVar[int] = 0x0002
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="stepMode", Tag=0, Type=ColorControl.Enums.HueStepMode
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="stepSize", Tag=1, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="transitionTime", Tag=2, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsMask", Tag=3, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsOverride", Tag=4, Type=uint
                        ),
                    ]
                )

            stepMode: "ColorControl.Enums.HueStepMode" = 0
            stepSize: "uint" = 0
            transitionTime: "uint" = 0
            optionsMask: "uint" = 0
            optionsOverride: "uint" = 0

        @dataclass
        class MoveToSaturation(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0300
            command_id: typing.ClassVar[int] = 0x0003
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="saturation", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="transitionTime", Tag=1, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsMask", Tag=2, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsOverride", Tag=3, Type=uint
                        ),
                    ]
                )

            saturation: "uint" = 0
            transitionTime: "uint" = 0
            optionsMask: "uint" = 0
            optionsOverride: "uint" = 0

        @dataclass
        class MoveSaturation(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0300
            command_id: typing.ClassVar[int] = 0x0004
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="moveMode",
                            Tag=0,
                            Type=ColorControl.Enums.SaturationMoveMode,
                        ),
                        ClusterObjectFieldDescriptor(Label="rate", Tag=1, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="optionsMask", Tag=2, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsOverride", Tag=3, Type=uint
                        ),
                    ]
                )

            moveMode: "ColorControl.Enums.SaturationMoveMode" = 0
            rate: "uint" = 0
            optionsMask: "uint" = 0
            optionsOverride: "uint" = 0

        @dataclass
        class StepSaturation(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0300
            command_id: typing.ClassVar[int] = 0x0005
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="stepMode",
                            Tag=0,
                            Type=ColorControl.Enums.SaturationStepMode,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="stepSize", Tag=1, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="transitionTime", Tag=2, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsMask", Tag=3, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsOverride", Tag=4, Type=uint
                        ),
                    ]
                )

            stepMode: "ColorControl.Enums.SaturationStepMode" = 0
            stepSize: "uint" = 0
            transitionTime: "uint" = 0
            optionsMask: "uint" = 0
            optionsOverride: "uint" = 0

        @dataclass
        class MoveToHueAndSaturation(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0300
            command_id: typing.ClassVar[int] = 0x0006
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="hue", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="saturation", Tag=1, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="transitionTime", Tag=2, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsMask", Tag=3, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsOverride", Tag=4, Type=uint
                        ),
                    ]
                )

            hue: "uint" = 0
            saturation: "uint" = 0
            transitionTime: "uint" = 0
            optionsMask: "uint" = 0
            optionsOverride: "uint" = 0

        @dataclass
        class MoveToColor(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0300
            command_id: typing.ClassVar[int] = 0x0007
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="colorX", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(Label="colorY", Tag=1, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="transitionTime", Tag=2, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsMask", Tag=3, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsOverride", Tag=4, Type=uint
                        ),
                    ]
                )

            colorX: "uint" = 0
            colorY: "uint" = 0
            transitionTime: "uint" = 0
            optionsMask: "uint" = 0
            optionsOverride: "uint" = 0

        @dataclass
        class MoveColor(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0300
            command_id: typing.ClassVar[int] = 0x0008
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="rateX", Tag=0, Type=int),
                        ClusterObjectFieldDescriptor(Label="rateY", Tag=1, Type=int),
                        ClusterObjectFieldDescriptor(
                            Label="optionsMask", Tag=2, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsOverride", Tag=3, Type=uint
                        ),
                    ]
                )

            rateX: "int" = 0
            rateY: "int" = 0
            optionsMask: "uint" = 0
            optionsOverride: "uint" = 0

        @dataclass
        class StepColor(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0300
            command_id: typing.ClassVar[int] = 0x0009
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="stepX", Tag=0, Type=int),
                        ClusterObjectFieldDescriptor(Label="stepY", Tag=1, Type=int),
                        ClusterObjectFieldDescriptor(
                            Label="transitionTime", Tag=2, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsMask", Tag=3, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsOverride", Tag=4, Type=uint
                        ),
                    ]
                )

            stepX: "int" = 0
            stepY: "int" = 0
            transitionTime: "uint" = 0
            optionsMask: "uint" = 0
            optionsOverride: "uint" = 0

        @dataclass
        class MoveToColorTemperature(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0300
            command_id: typing.ClassVar[int] = 0x000A
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="colorTemperatureMireds", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="transitionTime", Tag=1, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsMask", Tag=2, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsOverride", Tag=3, Type=uint
                        ),
                    ]
                )

            colorTemperature: "uint" = 0
            transitionTime: "uint" = 0
            optionsMask: "uint" = 0
            optionsOverride: "uint" = 0

        @dataclass
        class EnhancedMoveToHue(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0300
            command_id: typing.ClassVar[int] = 0x0040
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="enhancedHue", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="direction",
                            Tag=1,
                            Type=ColorControl.Enums.HueDirection,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="transitionTime", Tag=2, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsMask", Tag=3, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsOverride", Tag=4, Type=uint
                        ),
                    ]
                )

            enhancedHue: "uint" = 0
            direction: "ColorControl.Enums.HueDirection" = 0
            transitionTime: "uint" = 0
            optionsMask: "uint" = 0
            optionsOverride: "uint" = 0

        @dataclass
        class EnhancedMoveHue(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0300
            command_id: typing.ClassVar[int] = 0x0041
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="moveMode", Tag=0, Type=ColorControl.Enums.HueMoveMode
                        ),
                        ClusterObjectFieldDescriptor(Label="rate", Tag=1, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="optionsMask", Tag=2, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsOverride", Tag=3, Type=uint
                        ),
                    ]
                )

            moveMode: "ColorControl.Enums.HueMoveMode" = 0
            rate: "uint" = 0
            optionsMask: "uint" = 0
            optionsOverride: "uint" = 0

        @dataclass
        class EnhancedStepHue(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0300
            command_id: typing.ClassVar[int] = 0x0042
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="stepMode", Tag=0, Type=ColorControl.Enums.HueStepMode
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="stepSize", Tag=1, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="transitionTime", Tag=2, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsMask", Tag=3, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsOverride", Tag=4, Type=uint
                        ),
                    ]
                )

            stepMode: "ColorControl.Enums.HueStepMode" = 0
            stepSize: "uint" = 0
            transitionTime: "uint" = 0
            optionsMask: "uint" = 0
            optionsOverride: "uint" = 0

        @dataclass
        class EnhancedMoveToHueAndSaturation(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0300
            command_id: typing.ClassVar[int] = 0x0043
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="enhancedHue", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="saturation", Tag=1, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="transitionTime", Tag=2, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsMask", Tag=3, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsOverride", Tag=4, Type=uint
                        ),
                    ]
                )

            enhancedHue: "uint" = 0
            saturation: "uint" = 0
            transitionTime: "uint" = 0
            optionsMask: "uint" = 0
            optionsOverride: "uint" = 0

        @dataclass
        class ColorLoopSet(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0300
            command_id: typing.ClassVar[int] = 0x0044
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="updateFlags", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="action",
                            Tag=1,
                            Type=ColorControl.Enums.ColorLoopAction,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="direction",
                            Tag=2,
                            Type=ColorControl.Enums.ColorLoopDirection,
                        ),
                        ClusterObjectFieldDescriptor(Label="time", Tag=3, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="startHue", Tag=4, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsMask", Tag=5, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsOverride", Tag=6, Type=uint
                        ),
                    ]
                )

            updateFlags: "uint" = 0
            action: "ColorControl.Enums.ColorLoopAction" = 0
            direction: "ColorControl.Enums.ColorLoopDirection" = 0
            time: "uint" = 0
            startHue: "uint" = 0
            optionsMask: "uint" = 0
            optionsOverride: "uint" = 0

        @dataclass
        class StopMoveStep(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0300
            command_id: typing.ClassVar[int] = 0x0047
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="optionsMask", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsOverride", Tag=1, Type=uint
                        ),
                    ]
                )

            optionsMask: "uint" = 0
            optionsOverride: "uint" = 0

        @dataclass
        class MoveColorTemperature(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0300
            command_id: typing.ClassVar[int] = 0x004B
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="moveMode", Tag=0, Type=ColorControl.Enums.HueMoveMode
                        ),
                        ClusterObjectFieldDescriptor(Label="rate", Tag=1, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="colorTemperatureMinimumMireds", Tag=2, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="colorTemperatureMaximumMireds", Tag=3, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsMask", Tag=4, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsOverride", Tag=5, Type=uint
                        ),
                    ]
                )

            moveMode: "ColorControl.Enums.HueMoveMode" = 0
            rate: "uint" = 0
            colorTemperatureMinimumMireds: "uint" = 0
            colorTemperatureMaximumMireds: "uint" = 0
            optionsMask: "uint" = 0
            optionsOverride: "uint" = 0

        @dataclass
        class StepColorTemperature(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0300
            command_id: typing.ClassVar[int] = 0x004C
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="stepMode", Tag=0, Type=ColorControl.Enums.HueStepMode
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="stepSize", Tag=1, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="transitionTime", Tag=2, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="colorTemperatureMinimumMireds", Tag=3, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="colorTemperatureMaximumMireds", Tag=4, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsMask", Tag=5, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="optionsOverride", Tag=6, Type=uint
                        ),
                    ]
                )

            stepMode: "ColorControl.Enums.HueStepMode" = 0
            stepSize: "uint" = 0
            transitionTime: "uint" = 0
            colorTemperatureMinimumMireds: "uint" = 0
            colorTemperatureMaximumMireds: "uint" = 0
            optionsMask: "uint" = 0
            optionsOverride: "uint" = 0

    class Attributes:
        @dataclass
        class CurrentHue(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class CurrentSaturation(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class RemainingTime(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class CurrentX(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class CurrentY(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000004

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class DriftCompensation(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000005

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class CompensationText(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000006

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[str])

            value: "typing.Optional[str]" = None

        @dataclass
        class ColorTemperatureMireds(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000007

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class ColorMode(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000008

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class Options(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000000F

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class NumberOfPrimaries(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000010

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, uint])

            value: "typing.Union[Nullable, uint]" = NullValue

        @dataclass
        class Primary1X(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000011

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class Primary1Y(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000012

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class Primary1Intensity(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000013

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class Primary2X(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000015

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class Primary2Y(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000016

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class Primary2Intensity(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000017

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class Primary3X(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000019

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class Primary3Y(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000001A

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class Primary3Intensity(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000001B

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class Primary4X(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000020

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class Primary4Y(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000021

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class Primary4Intensity(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000022

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class Primary5X(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000024

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class Primary5Y(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000025

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class Primary5Intensity(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000026

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class Primary6X(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000028

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class Primary6Y(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000029

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class Primary6Intensity(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000002A

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class WhitePointX(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000030

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class WhitePointY(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000031

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class ColorPointRX(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000032

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class ColorPointRY(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000033

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class ColorPointRIntensity(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000034

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class ColorPointGX(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000036

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class ColorPointGY(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000037

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class ColorPointGIntensity(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000038

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class ColorPointBX(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000003A

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class ColorPointBY(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000003B

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class ColorPointBIntensity(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000003C

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class EnhancedCurrentHue(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00004000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class EnhancedColorMode(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00004001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ColorLoopActive(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00004002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class ColorLoopDirection(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00004003

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class ColorLoopTime(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00004004

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class ColorLoopStartEnhancedHue(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00004005

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class ColorLoopStoredEnhancedHue(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00004006

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class ColorCapabilities(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000400A

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ColorTempPhysicalMinMireds(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000400B

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class ColorTempPhysicalMaxMireds(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000400C

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class CoupleColorTempToLevelMinMireds(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000400D

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class StartUpColorTemperatureMireds(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00004010

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0300

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class BallastConfiguration(Cluster):
    id: typing.ClassVar[int] = 0x0301

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="physicalMinLevel", Tag=0x00000000, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="physicalMaxLevel", Tag=0x00000001, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="ballastStatus", Tag=0x00000002, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="minLevel", Tag=0x00000010, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="maxLevel", Tag=0x00000011, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="intrinsicBalanceFactor",
                    Tag=0x00000014,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="ballastFactorAdjustment",
                    Tag=0x00000015,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="lampQuantity", Tag=0x00000020, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="lampType", Tag=0x00000030, Type=typing.Optional[str]
                ),
                ClusterObjectFieldDescriptor(
                    Label="lampManufacturer", Tag=0x00000031, Type=typing.Optional[str]
                ),
                ClusterObjectFieldDescriptor(
                    Label="lampRatedHours",
                    Tag=0x00000032,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="lampBurnHours",
                    Tag=0x00000033,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="lampAlarmMode", Tag=0x00000034, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="lampBurnHoursTripPoint",
                    Tag=0x00000035,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    physicalMinLevel: "uint" = None
    physicalMaxLevel: "uint" = None
    ballastStatus: "typing.Optional[uint]" = None
    minLevel: "uint" = None
    maxLevel: "uint" = None
    intrinsicBalanceFactor: "typing.Union[None, Nullable, uint]" = None
    ballastFactorAdjustment: "typing.Union[None, Nullable, uint]" = None
    lampQuantity: "uint" = None
    lampType: "typing.Optional[str]" = None
    lampManufacturer: "typing.Optional[str]" = None
    lampRatedHours: "typing.Union[None, Nullable, uint]" = None
    lampBurnHours: "typing.Union[None, Nullable, uint]" = None
    lampAlarmMode: "typing.Optional[uint]" = None
    lampBurnHoursTripPoint: "typing.Union[None, Nullable, uint]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Attributes:
        @dataclass
        class PhysicalMinLevel(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0301

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class PhysicalMaxLevel(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0301

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class BallastStatus(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0301

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class MinLevel(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0301

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000010

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class MaxLevel(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0301

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000011

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class IntrinsicBalanceFactor(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0301

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000014

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class BallastFactorAdjustment(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0301

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000015

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class LampQuantity(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0301

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000020

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class LampType(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0301

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000030

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[str])

            value: "typing.Optional[str]" = None

        @dataclass
        class LampManufacturer(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0301

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000031

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[str])

            value: "typing.Optional[str]" = None

        @dataclass
        class LampRatedHours(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0301

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000032

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class LampBurnHours(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0301

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000033

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class LampAlarmMode(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0301

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000034

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class LampBurnHoursTripPoint(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0301

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000035

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0301

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0301

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0301

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0301

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0301

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class IlluminanceMeasurement(Cluster):
    id: typing.ClassVar[int] = 0x0400

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="measuredValue",
                    Tag=0x00000000,
                    Type=typing.Union[Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="minMeasuredValue",
                    Tag=0x00000001,
                    Type=typing.Union[Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="maxMeasuredValue",
                    Tag=0x00000002,
                    Type=typing.Union[Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="tolerance", Tag=0x00000003, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="lightSensorType",
                    Tag=0x00000004,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    measuredValue: "typing.Union[Nullable, uint]" = None
    minMeasuredValue: "typing.Union[Nullable, uint]" = None
    maxMeasuredValue: "typing.Union[Nullable, uint]" = None
    tolerance: "typing.Optional[uint]" = None
    lightSensorType: "typing.Union[None, Nullable, uint]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Enums:
        class LightSensorType(IntEnum):
            kPhotodiode = 0x00
            kCmos = 0x01

    class Attributes:
        @dataclass
        class MeasuredValue(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0400

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, uint])

            value: "typing.Union[Nullable, uint]" = NullValue

        @dataclass
        class MinMeasuredValue(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0400

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, uint])

            value: "typing.Union[Nullable, uint]" = NullValue

        @dataclass
        class MaxMeasuredValue(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0400

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, uint])

            value: "typing.Union[Nullable, uint]" = NullValue

        @dataclass
        class Tolerance(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0400

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class LightSensorType(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0400

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000004

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0400

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0400

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0400

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0400

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0400

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class TemperatureMeasurement(Cluster):
    id: typing.ClassVar[int] = 0x0402

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="measuredValue",
                    Tag=0x00000000,
                    Type=typing.Union[Nullable, int],
                ),
                ClusterObjectFieldDescriptor(
                    Label="minMeasuredValue",
                    Tag=0x00000001,
                    Type=typing.Union[Nullable, int],
                ),
                ClusterObjectFieldDescriptor(
                    Label="maxMeasuredValue",
                    Tag=0x00000002,
                    Type=typing.Union[Nullable, int],
                ),
                ClusterObjectFieldDescriptor(
                    Label="tolerance", Tag=0x00000003, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    measuredValue: "typing.Union[Nullable, int]" = None
    minMeasuredValue: "typing.Union[Nullable, int]" = None
    maxMeasuredValue: "typing.Union[Nullable, int]" = None
    tolerance: "typing.Optional[uint]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Attributes:
        @dataclass
        class MeasuredValue(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0402

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, int])

            value: "typing.Union[Nullable, int]" = NullValue

        @dataclass
        class MinMeasuredValue(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0402

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, int])

            value: "typing.Union[Nullable, int]" = NullValue

        @dataclass
        class MaxMeasuredValue(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0402

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, int])

            value: "typing.Union[Nullable, int]" = NullValue

        @dataclass
        class Tolerance(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0402

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0402

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0402

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0402

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0402

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0402

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class PressureMeasurement(Cluster):
    id: typing.ClassVar[int] = 0x0403

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="measuredValue",
                    Tag=0x00000000,
                    Type=typing.Union[Nullable, int],
                ),
                ClusterObjectFieldDescriptor(
                    Label="minMeasuredValue",
                    Tag=0x00000001,
                    Type=typing.Union[Nullable, int],
                ),
                ClusterObjectFieldDescriptor(
                    Label="maxMeasuredValue",
                    Tag=0x00000002,
                    Type=typing.Union[Nullable, int],
                ),
                ClusterObjectFieldDescriptor(
                    Label="tolerance", Tag=0x00000003, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="scaledValue",
                    Tag=0x00000010,
                    Type=typing.Union[None, Nullable, int],
                ),
                ClusterObjectFieldDescriptor(
                    Label="minScaledValue",
                    Tag=0x00000011,
                    Type=typing.Union[None, Nullable, int],
                ),
                ClusterObjectFieldDescriptor(
                    Label="maxScaledValue",
                    Tag=0x00000012,
                    Type=typing.Union[None, Nullable, int],
                ),
                ClusterObjectFieldDescriptor(
                    Label="scaledTolerance", Tag=0x00000013, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="scale", Tag=0x00000014, Type=typing.Optional[int]
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    measuredValue: "typing.Union[Nullable, int]" = None
    minMeasuredValue: "typing.Union[Nullable, int]" = None
    maxMeasuredValue: "typing.Union[Nullable, int]" = None
    tolerance: "typing.Optional[uint]" = None
    scaledValue: "typing.Union[None, Nullable, int]" = None
    minScaledValue: "typing.Union[None, Nullable, int]" = None
    maxScaledValue: "typing.Union[None, Nullable, int]" = None
    scaledTolerance: "typing.Optional[uint]" = None
    scale: "typing.Optional[int]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Attributes:
        @dataclass
        class MeasuredValue(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0403

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, int])

            value: "typing.Union[Nullable, int]" = NullValue

        @dataclass
        class MinMeasuredValue(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0403

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, int])

            value: "typing.Union[Nullable, int]" = NullValue

        @dataclass
        class MaxMeasuredValue(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0403

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, int])

            value: "typing.Union[Nullable, int]" = NullValue

        @dataclass
        class Tolerance(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0403

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class ScaledValue(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0403

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000010

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, int]
                )

            value: "typing.Union[None, Nullable, int]" = None

        @dataclass
        class MinScaledValue(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0403

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000011

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, int]
                )

            value: "typing.Union[None, Nullable, int]" = None

        @dataclass
        class MaxScaledValue(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0403

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000012

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, int]
                )

            value: "typing.Union[None, Nullable, int]" = None

        @dataclass
        class ScaledTolerance(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0403

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000013

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class Scale(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0403

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000014

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[int])

            value: "typing.Optional[int]" = None

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0403

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0403

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0403

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0403

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0403

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class FlowMeasurement(Cluster):
    id: typing.ClassVar[int] = 0x0404

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="measuredValue",
                    Tag=0x00000000,
                    Type=typing.Union[Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="minMeasuredValue",
                    Tag=0x00000001,
                    Type=typing.Union[Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="maxMeasuredValue",
                    Tag=0x00000002,
                    Type=typing.Union[Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="tolerance", Tag=0x00000003, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    measuredValue: "typing.Union[Nullable, uint]" = None
    minMeasuredValue: "typing.Union[Nullable, uint]" = None
    maxMeasuredValue: "typing.Union[Nullable, uint]" = None
    tolerance: "typing.Optional[uint]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Attributes:
        @dataclass
        class MeasuredValue(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0404

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, uint])

            value: "typing.Union[Nullable, uint]" = NullValue

        @dataclass
        class MinMeasuredValue(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0404

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, uint])

            value: "typing.Union[Nullable, uint]" = NullValue

        @dataclass
        class MaxMeasuredValue(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0404

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, uint])

            value: "typing.Union[Nullable, uint]" = NullValue

        @dataclass
        class Tolerance(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0404

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0404

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0404

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0404

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0404

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0404

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class RelativeHumidityMeasurement(Cluster):
    id: typing.ClassVar[int] = 0x0405

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="measuredValue",
                    Tag=0x00000000,
                    Type=typing.Union[Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="minMeasuredValue",
                    Tag=0x00000001,
                    Type=typing.Union[Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="maxMeasuredValue",
                    Tag=0x00000002,
                    Type=typing.Union[Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="tolerance", Tag=0x00000003, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    measuredValue: "typing.Union[Nullable, uint]" = None
    minMeasuredValue: "typing.Union[Nullable, uint]" = None
    maxMeasuredValue: "typing.Union[Nullable, uint]" = None
    tolerance: "typing.Optional[uint]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Attributes:
        @dataclass
        class MeasuredValue(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0405

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, uint])

            value: "typing.Union[Nullable, uint]" = NullValue

        @dataclass
        class MinMeasuredValue(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0405

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, uint])

            value: "typing.Union[Nullable, uint]" = NullValue

        @dataclass
        class MaxMeasuredValue(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0405

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Union[Nullable, uint])

            value: "typing.Union[Nullable, uint]" = NullValue

        @dataclass
        class Tolerance(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0405

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0405

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0405

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0405

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0405

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0405

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class OccupancySensing(Cluster):
    id: typing.ClassVar[int] = 0x0406

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="occupancy", Tag=0x00000000, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="occupancySensorType", Tag=0x00000001, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="occupancySensorTypeBitmap", Tag=0x00000002, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="pirOccupiedToUnoccupiedDelay",
                    Tag=0x00000010,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="pirUnoccupiedToOccupiedDelay",
                    Tag=0x00000011,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="pirUnoccupiedToOccupiedThreshold",
                    Tag=0x00000012,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="ultrasonicOccupiedToUnoccupiedDelay",
                    Tag=0x00000020,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="ultrasonicUnoccupiedToOccupiedDelay",
                    Tag=0x00000021,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="ultrasonicUnoccupiedToOccupiedThreshold",
                    Tag=0x00000022,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="physicalContactOccupiedToUnoccupiedDelay",
                    Tag=0x00000030,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="physicalContactUnoccupiedToOccupiedDelay",
                    Tag=0x00000031,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="physicalContactUnoccupiedToOccupiedThreshold",
                    Tag=0x00000032,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    occupancy: "uint" = None
    occupancySensorType: "uint" = None
    occupancySensorTypeBitmap: "uint" = None
    pirOccupiedToUnoccupiedDelay: "typing.Optional[uint]" = None
    pirUnoccupiedToOccupiedDelay: "typing.Optional[uint]" = None
    pirUnoccupiedToOccupiedThreshold: "typing.Optional[uint]" = None
    ultrasonicOccupiedToUnoccupiedDelay: "typing.Optional[uint]" = None
    ultrasonicUnoccupiedToOccupiedDelay: "typing.Optional[uint]" = None
    ultrasonicUnoccupiedToOccupiedThreshold: "typing.Optional[uint]" = None
    physicalContactOccupiedToUnoccupiedDelay: "typing.Optional[uint]" = None
    physicalContactUnoccupiedToOccupiedDelay: "typing.Optional[uint]" = None
    physicalContactUnoccupiedToOccupiedThreshold: "typing.Optional[uint]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Attributes:
        @dataclass
        class Occupancy(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0406

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class OccupancySensorType(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0406

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class OccupancySensorTypeBitmap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0406

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class PirOccupiedToUnoccupiedDelay(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0406

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000010

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class PirUnoccupiedToOccupiedDelay(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0406

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000011

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class PirUnoccupiedToOccupiedThreshold(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0406

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000012

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class UltrasonicOccupiedToUnoccupiedDelay(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0406

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000020

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class UltrasonicUnoccupiedToOccupiedDelay(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0406

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000021

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class UltrasonicUnoccupiedToOccupiedThreshold(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0406

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000022

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class PhysicalContactOccupiedToUnoccupiedDelay(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0406

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000030

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class PhysicalContactUnoccupiedToOccupiedDelay(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0406

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000031

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class PhysicalContactUnoccupiedToOccupiedThreshold(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0406

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000032

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0406

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0406

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0406

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0406

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0406

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class WakeOnLan(Cluster):
    id: typing.ClassVar[int] = 0x0503

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="MACAddress", Tag=0x00000000, Type=typing.Optional[str]
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    MACAddress: "typing.Optional[str]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Attributes:
        @dataclass
        class MACAddress(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0503

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[str])

            value: "typing.Optional[str]" = None

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0503

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0503

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0503

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0503

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0503

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class Channel(Cluster):
    id: typing.ClassVar[int] = 0x0504

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="channelList",
                    Tag=0x00000000,
                    Type=typing.Optional[typing.List[Channel.Structs.ChannelInfo]],
                ),
                ClusterObjectFieldDescriptor(
                    Label="lineup",
                    Tag=0x00000001,
                    Type=typing.Union[None, Nullable, Channel.Structs.LineupInfo],
                ),
                ClusterObjectFieldDescriptor(
                    Label="currentChannel",
                    Tag=0x00000002,
                    Type=typing.Union[None, Nullable, Channel.Structs.ChannelInfo],
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    channelList: "typing.Optional[typing.List[Channel.Structs.ChannelInfo]]" = None
    lineup: "typing.Union[None, Nullable, Channel.Structs.LineupInfo]" = None
    currentChannel: "typing.Union[None, Nullable, Channel.Structs.ChannelInfo]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Enums:
        class ChannelStatusEnum(IntEnum):
            kSuccess = 0x00
            kMultipleMatches = 0x01
            kNoMatches = 0x02

        class LineupInfoTypeEnum(IntEnum):
            kMso = 0x00

    class Structs:
        @dataclass
        class ChannelInfo(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="majorNumber", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="minorNumber", Tag=1, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="name", Tag=2, Type=typing.Optional[str]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="callSign", Tag=3, Type=typing.Optional[str]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="affiliateCallSign", Tag=4, Type=typing.Optional[str]
                        ),
                    ]
                )

            majorNumber: "uint" = 0
            minorNumber: "uint" = 0
            name: "typing.Optional[str]" = None
            callSign: "typing.Optional[str]" = None
            affiliateCallSign: "typing.Optional[str]" = None

        @dataclass
        class LineupInfo(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="operatorName", Tag=0, Type=str
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="lineupName", Tag=1, Type=typing.Optional[str]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="postalCode", Tag=2, Type=typing.Optional[str]
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="lineupInfoType",
                            Tag=3,
                            Type=Channel.Enums.LineupInfoTypeEnum,
                        ),
                    ]
                )

            operatorName: "str" = ""
            lineupName: "typing.Optional[str]" = None
            postalCode: "typing.Optional[str]" = None
            lineupInfoType: "Channel.Enums.LineupInfoTypeEnum" = 0

    class Commands:
        @dataclass
        class ChangeChannel(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0504
            command_id: typing.ClassVar[int] = 0x0000
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="match", Tag=0, Type=str),
                    ]
                )

            match: "str" = ""

        @dataclass
        class ChangeChannelResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0504
            command_id: typing.ClassVar[int] = 0x0001
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="status", Tag=0, Type=Channel.Enums.ChannelStatusEnum
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="data", Tag=1, Type=typing.Optional[str]
                        ),
                    ]
                )

            status: "Channel.Enums.ChannelStatusEnum" = 0
            data: "typing.Optional[str]" = None

        @dataclass
        class ChangeChannelByNumber(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0504
            command_id: typing.ClassVar[int] = 0x0002
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="majorNumber", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="minorNumber", Tag=1, Type=uint
                        ),
                    ]
                )

            majorNumber: "uint" = 0
            minorNumber: "uint" = 0

        @dataclass
        class SkipChannel(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0504
            command_id: typing.ClassVar[int] = 0x0003
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="count", Tag=0, Type=uint),
                    ]
                )

            count: "uint" = 0

    class Attributes:
        @dataclass
        class ChannelList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0504

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Optional[typing.List[Channel.Structs.ChannelInfo]]
                )

            value: "typing.Optional[typing.List[Channel.Structs.ChannelInfo]]" = None

        @dataclass
        class Lineup(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0504

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, Channel.Structs.LineupInfo]
                )

            value: "typing.Union[None, Nullable, Channel.Structs.LineupInfo]" = None

        @dataclass
        class CurrentChannel(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0504

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, Channel.Structs.ChannelInfo]
                )

            value: "typing.Union[None, Nullable, Channel.Structs.ChannelInfo]" = None

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0504

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0504

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0504

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0504

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0504

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class TargetNavigator(Cluster):
    id: typing.ClassVar[int] = 0x0505

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="targetList",
                    Tag=0x00000000,
                    Type=typing.List[TargetNavigator.Structs.TargetInfo],
                ),
                ClusterObjectFieldDescriptor(
                    Label="currentTarget", Tag=0x00000001, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    targetList: "typing.List[TargetNavigator.Structs.TargetInfo]" = None
    currentTarget: "typing.Optional[uint]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Enums:
        class TargetNavigatorStatusEnum(IntEnum):
            kSuccess = 0x00
            kTargetNotFound = 0x01
            kNotAllowed = 0x02

    class Structs:
        @dataclass
        class TargetInfo(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="identifier", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(Label="name", Tag=1, Type=str),
                    ]
                )

            identifier: "uint" = 0
            name: "str" = ""

    class Commands:
        @dataclass
        class NavigateTarget(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0505
            command_id: typing.ClassVar[int] = 0x0000
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="target", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="data", Tag=1, Type=typing.Optional[str]
                        ),
                    ]
                )

            target: "uint" = 0
            data: "typing.Optional[str]" = None

        @dataclass
        class NavigateTargetResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0505
            command_id: typing.ClassVar[int] = 0x0001
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="status",
                            Tag=0,
                            Type=TargetNavigator.Enums.TargetNavigatorStatusEnum,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="data", Tag=1, Type=typing.Optional[str]
                        ),
                    ]
                )

            status: "TargetNavigator.Enums.TargetNavigatorStatusEnum" = 0
            data: "typing.Optional[str]" = None

    class Attributes:
        @dataclass
        class TargetList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0505

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.List[TargetNavigator.Structs.TargetInfo]
                )

            value: "typing.List[TargetNavigator.Structs.TargetInfo]" = field(
                default_factory=lambda: []
            )

        @dataclass
        class CurrentTarget(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0505

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0505

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0505

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0505

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0505

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0505

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class MediaPlayback(Cluster):
    id: typing.ClassVar[int] = 0x0506

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="currentState",
                    Tag=0x00000000,
                    Type=MediaPlayback.Enums.PlaybackStateEnum,
                ),
                ClusterObjectFieldDescriptor(
                    Label="startTime",
                    Tag=0x00000001,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="duration",
                    Tag=0x00000002,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="sampledPosition",
                    Tag=0x00000003,
                    Type=typing.Union[
                        None, Nullable, MediaPlayback.Structs.PlaybackPosition
                    ],
                ),
                ClusterObjectFieldDescriptor(
                    Label="playbackSpeed", Tag=0x00000004, Type=typing.Optional[float32]
                ),
                ClusterObjectFieldDescriptor(
                    Label="seekRangeEnd",
                    Tag=0x00000005,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="seekRangeStart",
                    Tag=0x00000006,
                    Type=typing.Union[None, Nullable, uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    currentState: "MediaPlayback.Enums.PlaybackStateEnum" = None
    startTime: "typing.Union[None, Nullable, uint]" = None
    duration: "typing.Union[None, Nullable, uint]" = None
    sampledPosition: "typing.Union[None, Nullable, MediaPlayback.Structs.PlaybackPosition]" = (
        None
    )
    playbackSpeed: "typing.Optional[float32]" = None
    seekRangeEnd: "typing.Union[None, Nullable, uint]" = None
    seekRangeStart: "typing.Union[None, Nullable, uint]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Enums:
        class MediaPlaybackStatusEnum(IntEnum):
            kSuccess = 0x00
            kInvalidStateForCommand = 0x01
            kNotAllowed = 0x02
            kNotActive = 0x03
            kSpeedOutOfRange = 0x04
            kSeekOutOfRange = 0x05

        class PlaybackStateEnum(IntEnum):
            kPlaying = 0x00
            kPaused = 0x01
            kNotPlaying = 0x02
            kBuffering = 0x03

    class Structs:
        @dataclass
        class PlaybackPosition(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="updatedAt", Tag=0, Type=uint
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="position", Tag=1, Type=typing.Union[Nullable, uint]
                        ),
                    ]
                )

            updatedAt: "uint" = 0
            position: "typing.Union[Nullable, uint]" = NullValue

    class Commands:
        @dataclass
        class Play(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0506
            command_id: typing.ClassVar[int] = 0x0000
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class Pause(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0506
            command_id: typing.ClassVar[int] = 0x0001
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class StopPlayback(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0506
            command_id: typing.ClassVar[int] = 0x0002
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class StartOver(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0506
            command_id: typing.ClassVar[int] = 0x0003
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class Previous(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0506
            command_id: typing.ClassVar[int] = 0x0004
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class Next(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0506
            command_id: typing.ClassVar[int] = 0x0005
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class Rewind(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0506
            command_id: typing.ClassVar[int] = 0x0006
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class FastForward(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0506
            command_id: typing.ClassVar[int] = 0x0007
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class SkipForward(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0506
            command_id: typing.ClassVar[int] = 0x0008
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="deltaPositionMilliseconds", Tag=0, Type=uint
                        ),
                    ]
                )

            deltaPositionMilliseconds: "uint" = 0

        @dataclass
        class SkipBackward(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0506
            command_id: typing.ClassVar[int] = 0x0009
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="deltaPositionMilliseconds", Tag=0, Type=uint
                        ),
                    ]
                )

            deltaPositionMilliseconds: "uint" = 0

        @dataclass
        class PlaybackResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0506
            command_id: typing.ClassVar[int] = 0x000A
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="status",
                            Tag=0,
                            Type=MediaPlayback.Enums.MediaPlaybackStatusEnum,
                        ),
                        ClusterObjectFieldDescriptor(
                            Label="data", Tag=1, Type=typing.Optional[str]
                        ),
                    ]
                )

            status: "MediaPlayback.Enums.MediaPlaybackStatusEnum" = 0
            data: "typing.Optional[str]" = None

        @dataclass
        class Seek(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0506
            command_id: typing.ClassVar[int] = 0x000B
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="position", Tag=0, Type=uint
                        ),
                    ]
                )

            position: "uint" = 0

    class Attributes:
        @dataclass
        class CurrentState(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0506

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=MediaPlayback.Enums.PlaybackStateEnum
                )

            value: "MediaPlayback.Enums.PlaybackStateEnum" = 0

        @dataclass
        class StartTime(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0506

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class Duration(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0506

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000002

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class SampledPosition(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0506

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000003

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[
                        None, Nullable, MediaPlayback.Structs.PlaybackPosition
                    ]
                )

            value: "typing.Union[None, Nullable, MediaPlayback.Structs.PlaybackPosition]" = (
                None
            )

        @dataclass
        class PlaybackSpeed(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0506

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000004

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[float32])

            value: "typing.Optional[float32]" = None

        @dataclass
        class SeekRangeEnd(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0506

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000005

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class SeekRangeStart(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0506

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000006

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.Union[None, Nullable, uint]
                )

            value: "typing.Union[None, Nullable, uint]" = None

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0506

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0506

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0506

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0506

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0506

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class MediaInput(Cluster):
    id: typing.ClassVar[int] = 0x0507

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="inputList",
                    Tag=0x00000000,
                    Type=typing.List[MediaInput.Structs.InputInfo],
                ),
                ClusterObjectFieldDescriptor(
                    Label="currentInput", Tag=0x00000001, Type=typing.Optional[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    inputList: "typing.List[MediaInput.Structs.InputInfo]" = None
    currentInput: "typing.Optional[uint]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Enums:
        class InputTypeEnum(IntEnum):
            kInternal = 0x00
            kAux = 0x01
            kCoax = 0x02
            kComposite = 0x03
            kHdmi = 0x04
            kInput = 0x05
            kLine = 0x06
            kOptical = 0x07
            kVideo = 0x08
            kScart = 0x09
            kUsb = 0x0A
            kOther = 0x0B

    class Structs:
        @dataclass
        class InputInfo(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="index", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(
                            Label="inputType",
                            Tag=1,
                            Type=MediaInput.Enums.InputTypeEnum,
                        ),
                        ClusterObjectFieldDescriptor(Label="name", Tag=2, Type=str),
                        ClusterObjectFieldDescriptor(
                            Label="description", Tag=3, Type=str
                        ),
                    ]
                )

            index: "uint" = 0
            inputType: "MediaInput.Enums.InputTypeEnum" = 0
            name: "str" = ""
            description: "str" = ""

    class Commands:
        @dataclass
        class SelectInput(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0507
            command_id: typing.ClassVar[int] = 0x0000
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="index", Tag=0, Type=uint),
                    ]
                )

            index: "uint" = 0

        @dataclass
        class ShowInputStatus(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0507
            command_id: typing.ClassVar[int] = 0x0001
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class HideInputStatus(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0507
            command_id: typing.ClassVar[int] = 0x0002
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

        @dataclass
        class RenameInput(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0507
            command_id: typing.ClassVar[int] = 0x0003
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="index", Tag=0, Type=uint),
                        ClusterObjectFieldDescriptor(Label="name", Tag=1, Type=str),
                    ]
                )

            index: "uint" = 0
            name: "str" = ""

    class Attributes:
        @dataclass
        class InputList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0507

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000000

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(
                    Type=typing.List[MediaInput.Structs.InputInfo]
                )

            value: "typing.List[MediaInput.Structs.InputInfo]" = field(
                default_factory=lambda: []
            )

        @dataclass
        class CurrentInput(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0507

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x00000001

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.Optional[uint])

            value: "typing.Optional[uint]" = None

        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0507

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0507

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0507

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0507

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0507

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class LowPower(Cluster):
    id: typing.ClassVar[int] = 0x0508

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Commands:
        @dataclass
        class Sleep(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0508
            command_id: typing.ClassVar[int] = 0x0000
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(Fields=[])

    class Attributes:
        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0508

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0508

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0508

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0508

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0508

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class KeypadInput(Cluster):
    id: typing.ClassVar[int] = 0x0509

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Enums:
        class CecKeyCode(IntEnum):
            kSelect = 0x00
            kUp = 0x01
            kDown = 0x02
            kLeft = 0x03
            kRight = 0x04
            kRightUp = 0x05
            kRightDown = 0x06
            kLeftUp = 0x07
            kLeftDown = 0x08
            kRootMenu = 0x09
            kSetupMenu = 0x0A
            kContentsMenu = 0x0B
            kFavoriteMenu = 0x0C
            kExit = 0x0D
            kMediaTopMenu = 0x10
            kMediaContextSensitiveMenu = 0x11
            kNumberEntryMode = 0x1D
            kNumber11 = 0x1E
            kNumber12 = 0x1F
            kNumber0OrNumber10 = 0x20
            kNumbers1 = 0x21
            kNumbers2 = 0x22
            kNumbers3 = 0x23
            kNumbers4 = 0x24
            kNumbers5 = 0x25
            kNumbers6 = 0x26
            kNumbers7 = 0x27
            kNumbers8 = 0x28
            kNumbers9 = 0x29
            kDot = 0x2A
            kEnter = 0x2B
            kClear = 0x2C
            kNextFavorite = 0x2F
            kChannelUp = 0x30
            kChannelDown = 0x31
            kPreviousChannel = 0x32
            kSoundSelect = 0x33
            kInputSelect = 0x34
            kDisplayInformation = 0x35
            kHelp = 0x36
            kPageUp = 0x37
            kPageDown = 0x38
            kPower = 0x40
            kVolumeUp = 0x41
            kVolumeDown = 0x42
            kMute = 0x43
            kPlay = 0x44
            kStop = 0x45
            kPause = 0x46
            kRecord = 0x47
            kRewind = 0x48
            kFastForward = 0x49
            kEject = 0x4A
            kForward = 0x4B
            kBackward = 0x4C
            kStopRecord = 0x4D
            kPauseRecord = 0x4E
            kReserved = 0x4F
            kAngle = 0x50
            kSubPicture = 0x51
            kVideoOnDemand = 0x52
            kElectronicProgramGuide = 0x53
            kTimerProgramming = 0x54
            kInitialConfiguration = 0x55
            kSelectBroadcastType = 0x56
            kSelectSoundPresentation = 0x57
            kPlayFunction = 0x60
            kPausePlayFunction = 0x61
            kRecordFunction = 0x62
            kPauseRecordFunction = 0x63
            kStopFunction = 0x64
            kMuteFunction = 0x65
            kRestoreVolumeFunction = 0x66
            kTuneFunction = 0x67
            kSelectMediaFunction = 0x68
            kSelectAvInputFunction = 0x69
            kSelectAudioInputFunction = 0x6A
            kPowerToggleFunction = 0x6B
            kPowerOffFunction = 0x6C
            kPowerOnFunction = 0x6D
            kF1Blue = 0x71
            kF2Red = 0x72
            kF3Green = 0x73
            kF4Yellow = 0x74
            kF5 = 0x75
            kData = 0x76

        class KeypadInputStatusEnum(IntEnum):
            kSuccess = 0x00
            kUnsupportedKey = 0x01
            kInvalidKeyInCurrentState = 0x02

    class Commands:
        @dataclass
        class SendKey(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0509
            command_id: typing.ClassVar[int] = 0x0000
            is_client: typing.ClassVar[bool] = True

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="keyCode", Tag=0, Type=KeypadInput.Enums.CecKeyCode
                        ),
                    ]
                )

            keyCode: "KeypadInput.Enums.CecKeyCode" = 0

        @dataclass
        class SendKeyResponse(ClusterCommand):
            cluster_id: typing.ClassVar[int] = 0x0509
            command_id: typing.ClassVar[int] = 0x0001
            is_client: typing.ClassVar[bool] = False

            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="status",
                            Tag=0,
                            Type=KeypadInput.Enums.KeypadInputStatusEnum,
                        ),
                    ]
                )

            status: "KeypadInput.Enums.KeypadInputStatusEnum" = 0

    class Attributes:
        @dataclass
        class GeneratedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0509

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF8

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AcceptedCommandList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0509

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFF9

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class AttributeList(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0509

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFB

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=typing.List[uint])

            value: "typing.List[uint]" = field(default_factory=lambda: [])

        @dataclass
        class FeatureMap(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0509

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFC

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0

        @dataclass
        class ClusterRevision(ClusterAttributeDescriptor):
            @ChipUtility.classproperty
            def cluster_id(cls) -> int:
                return 0x0509

            @ChipUtility.classproperty
            def attribute_id(cls) -> int:
                return 0x0000FFFD

            @ChipUtility.classproperty
            def attribute_type(cls) -> ClusterObjectFieldDescriptor:
                return ClusterObjectFieldDescriptor(Type=uint)

            value: "uint" = 0


@dataclass
class ContentLauncher(Cluster):
    id: typing.ClassVar[int] = 0x050A

    @ChipUtility.classproperty
    def descriptor(cls) -> ClusterObjectDescriptor:
        return ClusterObjectDescriptor(
            Fields=[
                ClusterObjectFieldDescriptor(
                    Label="acceptHeader",
                    Tag=0x00000000,
                    Type=typing.Optional[typing.List[str]],
                ),
                ClusterObjectFieldDescriptor(
                    Label="supportedStreamingProtocols",
                    Tag=0x00000001,
                    Type=typing.Optional[uint],
                ),
                ClusterObjectFieldDescriptor(
                    Label="generatedCommandList", Tag=0x0000FFF8, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="acceptedCommandList", Tag=0x0000FFF9, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="attributeList", Tag=0x0000FFFB, Type=typing.List[uint]
                ),
                ClusterObjectFieldDescriptor(
                    Label="featureMap", Tag=0x0000FFFC, Type=uint
                ),
                ClusterObjectFieldDescriptor(
                    Label="clusterRevision", Tag=0x0000FFFD, Type=uint
                ),
            ]
        )

    acceptHeader: "typing.Optional[typing.List[str]]" = None
    supportedStreamingProtocols: "typing.Optional[uint]" = None
    generatedCommandList: "typing.List[uint]" = None
    acceptedCommandList: "typing.List[uint]" = None
    attributeList: "typing.List[uint]" = None
    featureMap: "uint" = None
    clusterRevision: "uint" = None

    class Enums:
        class ContentLaunchStatusEnum(IntEnum):
            kSuccess = 0x00
            kUrlNotAvailable = 0x01
            kAuthFailed = 0x02

        class MetricTypeEnum(IntEnum):
            kPixels = 0x00
            kPercentage = 0x01

        class ParameterEnum(IntEnum):
            kActor = 0x00
            kChannel = 0x01
            kCharacter = 0x02
            kDirector = 0x03
            kEvent = 0x04
            kFranchise = 0x05
            kGenre = 0x06
            kLeague = 0x07
            kPopularity = 0x08
            kProvider = 0x09
            kSport = 0x0A
            kSportsTeam = 0x0B
            kType = 0x0C

    class Structs:
        @dataclass
        class Dimension(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="width", Tag=0, Type=float),
                        ClusterObjectFieldDescriptor(Label="height", Tag=1, Type=float),
                        ClusterObjectFieldDescriptor(
                            Label="metric",
                            Tag=2,
                            Type=ContentLauncher.Enums.MetricTypeEnum,
                        ),
                    ]
                )

            width: "float" = 0.0
            height: "float" = 0.0
            metric: "ContentLauncher.Enums.MetricTypeEnum" = 0

        @dataclass
        class AdditionalInfo(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(Label="name", Tag=0, Type=str),
                        ClusterObjectFieldDescriptor(Label="value", Tag=1, Type=str),
                    ]
                )

            name: "str" = ""
            value: "str" = ""

        @dataclass
        class Parameter(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="type",
                            Tag=0,
                            Type=ContentLauncher.Enums.ParameterEnum,
                        ),
                        ClusterObjectFieldDescriptor(Label="value", Tag=1, Type=str),
                        ClusterObjectFieldDescriptor(
                            Label="externalIDList",
                            Tag=2,
                            Type=typing.Optional[
                                typing.List[ContentLauncher.Structs.AdditionalInfo]
                            ],
                        ),
                    ]
                )

            type: "ContentLauncher.Enums.ParameterEnum" = 0
            value: "str" = ""
            externalIDList: "typing.Optional[typing.List[ContentLauncher.Structs.AdditionalInfo]]" = (
                None
            )

        @dataclass
        class ContentSearch(ClusterObject):
            @ChipUtility.classproperty
            def descriptor(cls) -> ClusterObjectDescriptor:
                return ClusterObjectDescriptor(
                    Fields=[
                        ClusterObjectFieldDescriptor(
                            Label="parameterList",
                            Tag=0,
                            Type=typing.List[ContentLauncher.Structs.Parameter],
                        ),
                    ]
                )

            parameterList: "typing.List[ContentLauncher.Structs.Parameter]" = field(
                default_factory=lambd