# Python MCP提示词服务

基于Model Context Protocol的Python SDK实现的提示词管理服务。

## 功能

- 连接Cloudflare Worker API获取提示词数据
- 提供MCP接口供Claude等AI助手调用
- 包含可靠的重试、超时和缓存机制

## 安装

1. 创建虚拟环境

```bash
python -m venv venv
source venv/bin/activate  # Linux/Mac
# 或者 venv\Scripts\activate  # Windows
```

2. 安装依赖

```bash
pip install -r requirements.txt
```

## 使用方法

### 直接测试API连接

运行direct_test.py测试直接连接到Cloudflare Worker API:

```bash
python direct_test.py
```

### 启动MCP服务器

```bash
python mcp_server.py
```

或使用MCP CLI工具:

```bash
mcp dev mcp_server.py
```

### 在Claude Desktop中安装

```bash
mcp install mcp_server.py --name "提示词管理服务"
```

### 测试MCP客户端

```bash
python test_client.py
```

## 配置选项

可以在mcp_server.py文件中修改以下配置项:

- WORKER_URL - Cloudflare Worker API的URL
- API_TIMEOUT - API请求超时时间（秒）
- RETRIES - 重试次数

## 代理配置

如需使用代理，可设置以下环境变量:

```bash
# Linux/Mac
export HTTP_PROXY=http://127.0.0.1:7890
export HTTPS_PROXY=http://127.0.0.1:7890

# Windows
set HTTP_PROXY=http://127.0.0.1:7890
set HTTPS_PROXY=http://127.0.0.1:7890
``` 