# -*- coding: utf-8 -*-
"""
Created on Fri Mar  6 17:43:10 2015

@author: david
"""

import wx

import os

#from pylab import *


import numpy
# import pylab
import matplotlib.cm

#import PYME.ui.autoFoldPanel as afp

from PYME.DSView import fitInfo
from PYME.DSView import overlays
import wx.lib.agw.aui as aui

#from PYME.misc import extraCMaps


from PYME.LMVis import pipeline



import numpy as np

debug = True

def debugPrint(msg):
    if debug:
        print(msg)
        

from PYME.LMVis import visCore
from ._base import Plugin

class LMDisplay(visCore.VisGUICore, Plugin):
    def __init__(self, dsviewer, use_shaders=True):
        Plugin.__init__(self, dsviewer)

        if 'fitResults' in dir(self.image):
            self.fitResults = self.image.fitResults
        else:
            self.fitResults = []
        
        if 'resultsMdh' in dir(self.image):
            self.resultsMdh = self.image.resultsMdh


        dsviewer.paneHooks.append(self.GenPanels)
        dsviewer.updateHooks.append(self.update)


        
        if (len(self.fitResults) > 0) and not 'PYME_BUGGYOPENGL' in os.environ.keys():
            self.GenResultsView()   
            
        if not 'pipeline' in dir(dsviewer):
            dsviewer.pipeline = pipeline.Pipeline(visFr=self)
        
        self.pipeline = dsviewer.pipeline
        self.pipeline.visFr = self

        self._ovl = overlays.PointDisplayOverlay(filter = self.pipeline, display_name='Localisations')
        self.view.add_overlay(self._ovl)

        # initialize the common parts
        visCore.VisGUICore.__init__(self, use_shaders=use_shaders)

        self.CreateMenuBar(subMenu=True, use_shaders=use_shaders)

        #self.Bind(wx.EVT_IDLE, self.OnIdle)

        self._sf = False

        #statusLog.SetStatusDispFcn(self.SetStatus)


        
            
    def CreateFoldPanel(self):
        self.dsviewer.CreateFoldPanel()
    
        
    def Bind(self, *args, **kwargs):
        self.dsviewer.Bind(*args, **kwargs)

    def AddExtrasMenuItem(self,label, callback):
        """Add an item to the VisGUI extras menu.
        
        Parameters
        ==========

        label : str 
            textual label to use for the menu item.
        callback  : function 
            function to call when user selects the menu item. This function should accept one argument, which will be the
            wxPython event generated by the menu selection.
            
        """
        
        ID_NEWITEM = wx.NewIdRef()
        self.extras_menu.Append(ID_NEWITEM, label)
        self.dsviewer.Bind(wx.EVT_MENU, callback, id=ID_NEWITEM)
   

    def GenResultsView(self):
        voxx, voxy = self.image.voxelsize_nm
        
        self.SetFitInfo()

        from PYME.LMVis import gl_render
        self.glCanvas = gl_render.LMGLCanvas(self.dsviewer, False, vp = self.do, vpVoxSize = voxx)
        self.glCanvas.cmap = matplotlib.cm.gist_rainbow
        self.glCanvas.pointSelectionCallbacks.append(self.OnPointSelect)

        self.dsviewer.AddPage(page=self.glCanvas, select=True, caption='VisLite')

        xsc = self.image.data.shape[0]*voxx/self.glCanvas.Size[0]
        ysc = self.image.data.shape[1]*voxy/ self.glCanvas.Size[1]

        if xsc > ysc:
            self.glCanvas.setView(0, xsc*self.glCanvas.Size[0], 0, xsc*self.glCanvas.Size[1])
        else:
            self.glCanvas.setView(0, ysc*self.glCanvas.Size[0], 0, ysc*self.glCanvas.Size[1])

        #we have to wait for the gui to be there before we start changing stuff in the GL view
        #self.timer.WantNotification.append(self.AddPointsToVis)

        self.glCanvas.Bind(wx.EVT_IDLE, self.OnIdle)
        self.pointsAdded = False
        
    def SetFitInfo(self):
        # TODO - dedup with LMAnalysis TODO - does this actually work here ??? - need to get hold of original (base) data source for the fitInfoPanel
        if not 'fitInf' in dir(self):
            self.fitInf = fitInfo.FitInfoPanel(self.dsviewer, self.fitResults, self.resultsMdh, self.do.ds)
            self.dsviewer.AddPage(page=self.fitInf, select=False, caption='Fit Info')
        else:
            self.fitInf.SetResults(self.fitResults, self.resultsMdh)
            
        
    def OnPointSelect(self, xp, yp):
        """ sync image view with point selected in openGL view"""
        dist = np.sqrt((xp - self.fitResults['fitResults']['x0'])**2 + (yp - self.fitResults['fitResults']['y0'])**2)
        
        cand = dist.argmin()
        
        vx, vy, _ = self.image.voxelsize_nm
        self.dsviewer.do.xp = xp/vx
        self.dsviewer.do.yp = yp/vy
        self.dsviewer.do.zp = self.fitResults['tIndex'][cand]
        

#    def OnIdle(self,event):
#        if not self.pointsAdded:
#            self.pointsAdded = True
#
#            self.glCanvas.setPoints(self.fitResults['fitResults']['x0'],self.fitResults['fitResults']['y0'],self.fitResults['tIndex'].astype('f'))
#            self.glCanvas.setCLim((0, self.fitResults['tIndex'].max()))


    # def AddPointsToVis(self):
    #     self.glCanvas.setPoints(self.fitResults['fitResults']['x0'],self.fitResults['fitResults']['y0'],self.fitResults['tIndex'].astype('f'))
    #     self.glCanvas.setCLim((0, self.fitResults['tIndex'].max()))

    #     self.timer.WantNotification.remove(self.AddPointsToVis)

    def GetStatusText(self):
        return 'Frames Analysed: %d    Events detected: %d' % (self.numAnalysed, self.numEvents)
        

    def update(self, dsviewer):
        #self.RefreshView()
        if 'fitInf' in dir(self) and not self.dsviewer.playbackpanel.IsRunning():
            try:
                self.fitInf.UpdateDisp(self._ovl.points_hit_test(self.do.xp, self.do.yp, self.do.zp))
            except:
                import traceback
                print((traceback.format_exc()))


    

def Plug(dsviewer):
    dsviewer.create_overlay_panel()
    
    return LMDisplay(dsviewer)
