"""
CellProfiler is distributed under the GNU General Public License,
but this file is licensed under the more permissive BSD license.
See the accompanying file LICENSE for details.

Copyright (c) 2003-2009 Massachusetts Institute of Technology
Copyright (c) 2009-2012 Broad Institute
All rights reserved.

Please see the AUTHORS file for credits.

Website: http://www.cellprofiler.org
"""
import numpy as np
from scipy.fftpack import fft2
from scipy.ndimage.measurements import sum as nd_sum

def rps(img):
    assert img.ndim == 2
    radii2 = (np.arange(img.shape[0]).reshape((img.shape[0], 1)) ** 2) + (np.arange(img.shape[1])** 2)
    radii2 = np.minimum(radii2, np.flipud(radii2))
    radii2 = np.minimum(radii2, np.fliplr(radii2))
    maxwidth = min(img.shape[0], img.shape[1]) / 8.0 # truncate early to avoid edge effects
    if img.ptp() > 0:
        img = img / np.median(abs(img - img.mean())) # intensity invariant
    mag = abs(fft2(img - np.mean(img)))
    power = mag**2
    radii = np.floor(np.sqrt(radii2)).astype(int) + 1
    labels = np.arange(2, np.floor(maxwidth)).astype(int).tolist() # skip DC component
    if len(labels) > 0:
        magsum = nd_sum(mag, radii, labels)
        powersum = nd_sum(power, radii, labels)
        return np.array(labels), np.array(magsum), np.array(powersum)
    return [2], [0], [0]
