# CBC Build Scripts

This directory contains scripts for downloading and building the COIN-OR CBC solver binaries used by Python-MIP.

## Pre-built Binaries

The pre-built binaries are located in `mip/libraries/`:

| Binary | Platform | Last Updated | Notes |
|--------|----------|--------------|-------|
| `cbc-c-darwin-arm64.dylib` | macOS ARM64 (Apple Silicon) | Feb 2024 | Built from CBC master branch |
| `cbc-c-darwin-x86-64.dylib` | macOS x86-64 (Intel) | Oct 2021 | |
| `cbc-c-linux-x86-64.so` | Linux x86-64 | Dec 2021 | |
| `win64/cbc-c-windows-x86-64.dll` | Windows x86-64 | Jun 2022 | |

**Important**: Python-MIP uses a custom C interface with additional functions not present in CBC release versions. Binaries must be built from the CBC **master branch** (not release tags like 2.10.12) to include all required symbols.

## Build Process

### 1. Download Dependencies

First, download the CBC source code and dependencies:

```bash
./downloadCBC.sh
```

This clones the following repositories:
- CoinUtils
- Osi
- Clp
- Cgl
- Cbc
- ThirdParty-Glpk
- ThirdParty-Lapack
- ThirdParty-Blas

### 2. Build for Target Platform

Use the appropriate build script for your platform:

| Script | Platform |
|--------|----------|
| `buildCBCMacARM.sh` | macOS ARM64 (Apple Silicon) |
| `buildCBCMac.sh` | macOS x86-64 (Intel) |
| `buildCBCLinux.sh` | Linux x86-64 |
| `buildCBCLinuxAs.sh` | Linux (address sanitizer) |
| `buildCBCLinuxDbg.sh` | Linux (debug build) |
| `buildCBCWin.sh` | Windows (via MinGW/MSYS2) |
| `buildMSV.bat` | Windows (via Visual Studio) |

### 3. Copy Binary

After building, copy the resulting binary to `mip/libraries/`.

## Custom C Interface

Python-MIP requires CBC's C interface with custom extensions including:

- `Osi_newSolver`, `Osi_deleteSolver` - OSI solver management
- `Osi_isProvenOptimal`, `Osi_getIntegerTolerance` - Solution status
- `Cbc_generateCuts` - Cut generation
- `Cbc_setIntParam`, `Cbc_setDblParam` - Generic parameter setters
- `OsiCuts_*` - Cut pool management
- And many more (~70+ custom functions)

These functions are available in the CBC **master branch** but not in release versions (e.g., 2.10.12).

## Troubleshooting

### Missing Symbols Error

If you see errors like:
```
AttributeError: function/symbol 'Cbc_generateCuts' not found in library
```

This means the binary was built from a release version instead of master. Rebuild using the master branch.

### Dependency Mismatch

If building from master fails with errors about missing functions in OsiClp or other dependencies, you may need to rebuild all dependencies from their master branches as well.

## Other Scripts

| Script | Purpose |
|--------|---------|
| `downloadCBConly.sh` | Download only CBC (not dependencies) |
| `downloadCBCsvn.sh` | Download from SVN (legacy) |
| `patchLibrariesLinux.sh` | Patch Linux binaries for portability |
| `updateDist.sh` | Update distribution files |
| `uploadPip.sh` | Upload to PyPI |
