<div align="center">

<div id="user-content-toc">
  <ul>
    <img src="pyrinth.png" width="64" height="64"/>
    <summary><h1>Pyrinth</h1></summary>
  </ul>
</div>

  <p>
    Interacts with the Modrinth API
    <br />
    <a href="https://github.com/RevolvingMadness/Pyrinth"><strong>Explore the docs »</strong></a>
    <br />
    <br />
    <a href="https://github.com/RevolvingMadness/Pyrinth/issues">Report Bug</a>
    ·
    <a href="https://github.com/RevolvingMadness/Pyrinth/issues">Request Feature</a>
  </p>

[![Contributors][contributors-shield]][contributors-url]
[![Forks][forks-shield]][forks-url]
[![Stargazers][stars-shield]][stars-url]
[![Issues][issues-shield]][issues-url]
[![Apache License][license-shield]][license-url]
</div>
<br />


## Getting Started

### Prerequisites

To use Pyrinth you need the following:
- [Python](https://www.python.org/downloads)
- pip (Comes with Python)

### Installation

#### Automatic Installation

To automatically install the latest version of Pyrinth, run this command in the terminal:
```sh
pip install python-modrinth
```
---

#### Manual Installation
If you want to get the latest beta or pre-releases, follow the steps below:
1. Go to the [releases page](https://github.com/RevolvingMadness/Pyrinth/releases/) and download one of the `.whl` files.
2. Open a terminal and go to the downloads directory.
3. Type this: `pip install pyrinth`, then press tab and it should autocomplete.

## Issues

If you find a bug, please check if the issue already exists, otherwise open an issue through [this](https://github.com/RevolvingMadness/Pyrinth/issues) link.



## Contributing

### Creating A Fork And Pull Request
Contributions are what make the open source community such an amazing place to learn, inspire, and create. Any contributions you make are **greatly appreciated**.

If you have a suggestion that would make this better, please fork the repo and create a pull request. You can also simply open an issue with the tag "enhancement".  
Don't forget to give the project a star! Thanks again!

1. Fork the Project
2. Create your Feature Branch (`git checkout -b feature/AmazingFeature`)
3. Commit your Changes (`git commit -m 'Add some AmazingFeature'`)
4. Push to the Branch (`git push origin feature/AmazingFeature`)
5. Open a Pull Request

## Using Pyrinth Source Code
When you're using the Pyrinth source code, navigate to the `src` directory and create your main Python file.





## License

This project is distributed under the MIT License. See `LICENSE` for more information.

## Contact

Project Link: https://github.com/RevolvingMadness/Pyrinth 
Discord Server: Coming Soon!

## To-Do
- Projects
  - [x] Search Projects
  - [x] Get a project
  - [x] Modify a project
  - [x] Delete a project
  - [x] Get multiple projects
  - [x] Edit multiple projects
  - [x] Get a list of random projects
  - [x] Create a project
  - [x] Change project's icon
  - [x] Delete projcet's icon
  - [x] Check project slug/ID validity
  - [x] Add a gallery image
  - [x] Modify a gallery image
  - [x] Delete a gallery image
  - [x] Get all of a project's dependencies
  - [x] Follow a project
  - [x] Unfollow a project
  - [ ] Schedule a project
- Versions
  - [x] List project's versions
  - [x] Get a version
  - [x] Modify a version
  - [x] Delete a version
  - [x] Create a version
  - [ ] Schedule a version
  - [x] Get multipe versions
  - [ ] Add files to version
- Version Files
  - [x] Get version from hash
  - [x] Delete a file from its hash
  - [ ] Latest version of a project from a has, loader(s), and game version(s)
  - [ ] Get versions from hashes
  - [ ] Latest versions multiple project from hashes, loader(s), and game version(s)
- Users - Complete
  - [x] Get a user
  - [x] Modify a user
  - [x] Delete a user
  - [x] Get user from authorization header
  - [x] Get multiple users
  - [x] Change user's avatar
  - [x] Get user's projects
  - [x] Get user's notifications
  - [x] Get user's followed projects
  - [x] Get user's payout history
  - [x] Withdraw payout balance to PayPal or Venmo
- Teams
  - [x] Get a project's team members
  - [x] Get a team's members
  - [ ] Add a user to a team
  - [x] Get the members of multiple teams
  - [ ] Join a team
  - [ ] Modify a team member's information
  - [ ] Remove a team member from a team
  - [ ] Transfer team's ownership to another user
- Tags - Complete
  - [x] Get a list of categories
  - [x] Get a list of loaders
  - [x] Get a list of game versions
  - [x] Get a list of licenses
  - [x] Get a list of donation platforms
  - [x] Get a list of report types
- Miscellaneous
  - [ ] Report a project, user, or version
  - [x] Various statistics about this Modrinth instance

## Documentation
You can find the documentation [here](https://revolvingmadness.github.io/Pyrinth)


[contributors-shield]: https://img.shields.io/github/contributors/RevolvingMadness/Pyrinth.svg?style=for-the-badge
[contributors-url]: https://github.com/RevolvingMadness/Pyrinth/graphs/contributors
[forks-shield]: https://img.shields.io/github/forks/RevolvingMadness/Pyrinth.svg?style=for-the-badge
[forks-url]: https://github.com/RevolvingMadness/Pyrinth/network/members
[stars-shield]: https://img.shields.io/github/stars/RevolvingMadness/Pyrinth.svg?style=for-the-badge
[stars-url]: https://github.com/RevolvingMadness/Pyrinth/stargazers
[issues-shield]: https://img.shields.io/github/issues/RevolvingMadness/Pyrinth.svg?style=for-the-badge
[issues-url]: https://github.com/RevolvingMadness/Pyrinth/issues
[license-shield]: https://img.shields.io/github/license/RevolvingMadness/Pyrinth.svg?style=for-the-badge
[license-url]: https://github.com/RevolvingMadness/Pyrinth/LICENSE.txt
