# python-moretools
#
# many more basic tools for python 2/3
# extending itertools, functools and operator
#
# Copyright (C) 2011 Stefan Zimmermann <zimmermann.code@googlemail.com>
#
# python-moretools is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# python-moretools is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with python-moretools.  If not, see <http://www.gnu.org/licenses/>.

"""classes to store args and kwargs and call objects with them
"""

from ._common import *

class _caller(object):
  __slots__ = 'args', 'kwargs',

  def __init__(self, *args, **kwargs):
    self.args = args
    self.kwargs = kwargs

class caller(_caller):
  def __call__(self, obj):
    obj(*self.args, **self.kwargs)

class partialcaller(_caller):
  def __call__(self, obj):
    return partial(obj, *self.args, **self.kwargs)
