# pymsi

[![PyPI](https://img.shields.io/pypi/v/python-msi)](https://pypi.org/project/python-msi/)
[![MIT License](https://img.shields.io/pypi/l/python-msi.svg)](https://github.com/nightlark/pymsi/blob/main/LICENSE)
[![Python Versions](https://img.shields.io/pypi/pyversions/python-msi.svg)](https://pypi.org/project/python-msi/)
[![CI](https://github.com/nightlark/pymsi/actions/workflows/ci.yml/badge.svg)](https://github.com/nightlark/pymsi/actions)
[![Documentation Status](https://readthedocs.org/projects/pymsi/badge/?version=latest)](https://pymsi.readthedocs.io/en/latest/?badge=latest)
[![pre-commit.ci status](https://results.pre-commit.ci/badge/github/nightlark/pymsi/main.svg)](https://results.pre-commit.ci/latest/github/nightlark/pymsi/main)

A pure Python library for reading and manipulating Windows Installer (MSI) files. Based on the rust msi crate and msitools utilities.

To get started `pip install python-msi`. To use it as a library, `import pymsi`. For the CLI utility, run `pymsi help` for a list of supported commands.

Here are some links to pages that may be useful:

[PyPI](https://pypi.org/project/msi/)
[GitHub/Source Code](https://github.com/nightlark/pymsi/)
[Discussions](https://github.com/nightlark/pymsi/discussions/)

## Contents

```{eval-rst}
.. toctree::
   :maxdepth: 2

   self
   msi_viewer
```

## License

pymsi is released under the MIT license. See the [LICENSE](./LICENSE)
and [NOTICE](./NOTICE) files for details. All new contributions must be made
under this license.

SPDX-License-Identifier: MIT

LLNL-CODE-862419
