---
html_meta:
  property=og:title: Overview (pymsi)
  property=og:description: Pure Python library/utility for reading, parsing, and extracting the contents of Windows installer (.msi) files on any platform
---

# pymsi

[![PyPI](https://img.shields.io/pypi/v/python-msi)](https://pypi.org/project/python-msi/)
[![PyPI - Downloads](https://static.pepy.tech/personalized-badge/python-msi?period=monthly&units=INTERNATIONAL_SYSTEM&left_color=GREY&right_color=GREEN&left_text=downloads%2Fmonth)](https://pypi.org/project/python-msi/)
[![MIT License](https://img.shields.io/pypi/l/python-msi.svg)](https://github.com/nightlark/pymsi/blob/main/LICENSE)
[![Python Versions](https://img.shields.io/pypi/pyversions/python-msi.svg)](https://pypi.org/project/python-msi/)

A pure Python library and utilities for reading and manipulating Windows Installer (MSI) files. Based on the rust msi crate and msitools utilities.

To get started `pip install python-msi`. To use it as a library, `import pymsi`. For the CLI utility, run `pymsi help` for a list of supported commands.

Want to give it a try without installing anything? Check out the [MSI file viewer](msi_viewer.md), which uses pymsi to view MSI files entirely client-side in your browser via Pyodide.

Here are some links to pages that may be useful:

[PyPI](https://pypi.org/project/msi/)

[GitHub/Source Code](https://github.com/nightlark/pymsi/)

[Issues](https://github.com/nightlark/pymsi/issues/)

[Discussions](https://github.com/nightlark/pymsi/discussions/)

## Contents

```{toctree}
---
maxdepth: 2
includehidden:
---

Overview <self>
msi_viewer
```

```{toctree}
---
hidden:
caption: Project Links
---

GitHub <https://github.com/nightlark/pymsi>
PyPI <https://pypi.org/project/python-msi>
Issue Tracker <https://github.com/nightlark/pymsi/issues>
Discussions <https://github.com/nightlark/pymsi/discussions>
Contributing <https://github.com/nightlark/pymsi/blob/main/CONTRIBUTING.md>
```

## License

pymsi is released under the MIT license. See the [LICENSE](./LICENSE)
and [NOTICE](./NOTICE) files for details. All new contributions must be made
under this license.

SPDX-License-Identifier: MIT

LLNL-CODE-862419
