# Usage

To use `python-nakb` in a project:

```python
import nakb
```

## Using the High-Level Query

Retrieve the first 10 entries from NAKB, matching all:

```python
client = NAKBClient()
client.query()
```

This returns a `pandas.DataFrame` by default.

### Selecting specific fields

Use the fields parameter:

```python
df = client.query(fields=["pdbid", "resolution"])
```

If you pass `None`, Solr returns its default field set.

### Filtering using keyword operators

The high-level query interface supports convenient Solr filters using
the syntax: `field__operator=value`

The supported operators are:

- Default, exact match or OR query
- `lt` less than
- `gt` greater than
- `range=(a,b)` range filter
- `contains="substr"` substring search

Let's make examples:

```python
df = client.query(pdbid="1A1H")  # exact match
df = client.query(pdbid=["1A1H", "1AAY"])  # OR query
df = client.query(resolution__lt=2.0)  # less than
df = client.query(resolution__gt=1.5)  # greater than
df = client.query(resolution__range=(1.0, 2.0))  # range
df = client.query(description__contains="kinase")  # substring search
```

These can be combined:

```python
df = client.query(
    fields=["pdbid", "resolution", "polyclass"],
    polyclass="Protein/DNA",
    resolution__lt=3.5,
)
```

## Using the Low-Level Query

`query_raw` exposes Solr parameters directly:

```python
docs = client.query_raw(
    q="*:*",
    fl="pdbid,title",
    fq=["polyclass:Protein/DNA"],
    rows=50,
    as_dataframe=False,
)
```

Returns a list of dictionaries unless `as_dataframe=True`.

## Listing All Available Fields

Retrieve the metadata fields stored in NAKB:

```python
client.get_fields()
```
