# Python - NDEV Blizzard API
This package is designed to make it easy to use the [Blizzard API](https://develop.battle.net/documentation) in Python. It handles authentication, the details of making requests, and receives the responses. It also provides a simple interface for accessing each of the API's features.

## Documentation

- [Read the Docs](https://python-ndev-blizzardapi.readthedocs.io/)

## Author

- [@natanrmaia](https://github.com/natanrmaia)

## Instalation
```python
  pip install python-ndev-blizzardapi
```

## Blizzard APIs Supported

| API                     | Items           | Obs                   |
| :---------------------- | :-------------- | :-------------------- |
| **Battle.Net**          | OAuth API       | All Regions supported |
| **World Of Warcraft**   | Game Data API   | _Profile Data API in development_ |

## Report or Request
- [Bug Report](https://github.com/natanrmaia/python-ndev-blizzardapi/issues/new?assignees=&labels=&projects=&template=bug_report.md&title=)
- [Feature request](https://github.com/natanrmaia/python-ndev-blizzardapi/issues/new?assignees=&labels=&projects=&template=feature_request.md&title=)
- [Report a security vulnerability](https://github.com/natanrmaia/python-ndev-blizzardapi/issues/new?assignees=&labels=&projects=&template=feature_request.md&title=)
- [Other questions](https://github.com/natanrmaia/python-ndev-blizzardapi/issues/new/choose)
- [Email - contato@natanael.dev.br](mailto:contato@natanael.dev.br)

## Reference

 - [Battle.Net Developer Portal](https://develop.battle.net/documentation)