# Python - NDEV Blizzard API
This package is designed to make it easy to use the [Blizzard API](https://develop.battle.net/documentation) in Python. It handles authentication, the details of making requests, and receives the responses. It also provides a simple interface for accessing each of the API's features.

## Documentation

- [Read the Docs](https://python-ndev-blizzardapi.readthedocs.io/)

## Author

- [@natanrmaia](https://github.com/natanrmaia)

## Instalation
```python
  pip install python-ndev-blizzardapi
```

## Blizzard APIs Supported

| API                               | Items                             | Obs                                         |
| :-------------------------------- | :-------------------------------- | :------------------------------------------ |
| **Battle.Net**                    | OAuth API                         | All Regions supported                       |
| **World Of Warcraft (Retail)**    | Game Data API, Profile Data API   | All WoW Retail API Supported (Patch 10.1.5) |
| **World Of Warcraft (Classic)**   | Game Data API, Profile Data API   | All WoW Retail API Supported (Patch 10.1.5) |
| **Diablo 4**                      | Nothing                           | Prioritized once an official API emerges    |
| **Hearthstone**                   | Nothing                           | Planned for the near future                 |
| **Overwatch League**              | Nothing                           | Planned for the near future                 |
| **StarCraft 2**                   | Nothing                           | Planned for the near future                 |
| **Diablo 3**                      | Nothing                           | Not planned for addition                    |

## Report or Request
- [Bug Report](https://github.com/natanrmaia/python-ndev-blizzardapi/issues/new?assignees=&labels=&projects=&template=bug_report.md&title=)
- [Feature request](https://github.com/natanrmaia/python-ndev-blizzardapi/issues/new?assignees=&labels=&projects=&template=feature_request.md&title=)
- [Report a security vulnerability](https://github.com/natanrmaia/python-ndev-blizzardapi/issues/new?assignees=&labels=&projects=&template=feature_request.md&title=)
- [Other questions](https://github.com/natanrmaia/python-ndev-blizzardapi/issues/new/choose)
- [Email - contato@natanael.dev.br](mailto:contato@natanael.dev.br)

## Reference

 - [Battle.Net Developer Portal](https://develop.battle.net/documentation)