from distutils.core import setup

setup(
    name='python-ne',
    packages=['python_ne', 'python_ne/core', 'python_ne/extra', 'python_ne/core/backend_adapters', 'python_ne/core/ga',
              'python_ne/core/ga_neural_network', 'python_ne/core/neural_network', 'python_ne/extra/env_adapters'],
    version='0.1',
    license='MIT',
    description='A neuroevolution library for python',
    author='Matheus Zickuhr',
    author_email='matheuszickuhr97@gmail.com',
    url='https://github.com/MatheusZickuhr/python-ne',
    download_url='',
    keywords=['neuroevolution', 'neat', 'ne', 'ann', 'deep-learning'],
    install_requires=[
        'absl-py',
        'astor',
        'box2d-py',
        'cachetools',
        'certifi',
        'chardet',
        'cloudpickle',
        'future',
        'gast',
        'google-auth',
        'google-auth-oauthlib',
        'google-pasta',
        'grpcio',
        'gym',
        'h5py',
        'idna',
        'Keras',
        'Keras-Applications',
        'Keras-Preprocessing',
        'Markdown',
        'numpy',
        'oauthlib',
        'opt-einsum',
        'protobuf',
        'pyasn1',
        'pyasn1-modules',
        'pyglet',
        'PyYAML',
        'requests',
        'requests-oauthlib',
        'rsa',
        'scipy',
        'six',
        'tensorboard',
        'tensorflow',
        'tensorflow-estimator',
        'termcolor',
        'tqdm',
        'urllib3',
        'Werkzeug',
        'wrapt',
    ],
    dependency_links=['https://github.com/ntasfi/PyGame-Learning-Environment/tarball/master/'],
    classifiers=[
        'Development Status :: 3 - Alpha',
        'Intended Audience :: Developers',
        'Intended Audience :: Education',
        'Intended Audience :: Science/Research',
        'Topic :: Scientific/Engineering',
        'Operating System :: OS Independent',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
    ],
)
