
from netlink import generic, attributes
import contextlib

NL80211_CMD_UNSPEC = 0
NL80211_CMD_GET_WIPHY = 1
NL80211_CMD_SET_WIPHY = 2
NL80211_CMD_NEW_WIPHY = 3
NL80211_CMD_DEL_WIPHY = 4
NL80211_CMD_GET_INTERFACE = 5
NL80211_CMD_SET_INTERFACE = 6
NL80211_CMD_NEW_INTERFACE = 7
NL80211_CMD_DEL_INTERFACE = 8
NL80211_CMD_GET_KEY = 9
NL80211_CMD_SET_KEY = 10
NL80211_CMD_NEW_KEY = 11
NL80211_CMD_DEL_KEY = 12
NL80211_CMD_GET_BEACON = 13
NL80211_CMD_SET_BEACON = 14
NL80211_CMD_START_AP = 15
NL80211_CMD_NEW_BEACON = NL80211_CMD_START_AP
NL80211_CMD_STOP_AP = 16
NL80211_CMD_DEL_BEACON = NL80211_CMD_STOP_AP
NL80211_CMD_GET_STATION = 17
NL80211_CMD_SET_STATION = 18
NL80211_CMD_NEW_STATION = 19
NL80211_CMD_DEL_STATION = 20
NL80211_CMD_GET_MPATH = 21
NL80211_CMD_SET_MPATH = 22
NL80211_CMD_NEW_MPATH = 23
NL80211_CMD_DEL_MPATH = 24
NL80211_CMD_SET_BSS = 25
NL80211_CMD_SET_REG = 26
NL80211_CMD_REQ_SET_REG = 27
NL80211_CMD_GET_MESH_CONFIG = 28
NL80211_CMD_SET_MESH_CONFIG = 29
NL80211_CMD_SET_MGMT_EXTRA_IE = 30
NL80211_CMD_GET_REG = 31
NL80211_CMD_GET_SCAN = 32
NL80211_CMD_TRIGGER_SCAN = 33
NL80211_CMD_NEW_SCAN_RESULTS = 34
NL80211_CMD_SCAN_ABORTED = 35
NL80211_CMD_REG_CHANGE = 36
NL80211_CMD_AUTHENTICATE = 37
NL80211_CMD_ASSOCIATE = 38
NL80211_CMD_DEAUTHENTICATE = 39
NL80211_CMD_DISASSOCIATE = 40
NL80211_CMD_MICHAEL_MIC_FAILURE = 41
NL80211_CMD_REG_BEACON_HINT = 42
NL80211_CMD_JOIN_IBSS = 43
NL80211_CMD_LEAVE_IBSS = 44
NL80211_CMD_TESTMODE = 45
NL80211_CMD_CONNECT = 46
NL80211_CMD_ROAM = 47
NL80211_CMD_DISCONNECT = 48
NL80211_CMD_SET_WIPHY_NETNS = 49
NL80211_CMD_GET_SURVEY = 50
NL80211_CMD_NEW_SURVEY_RESULTS = 51
NL80211_CMD_SET_PMKSA = 52
NL80211_CMD_DEL_PMKSA = 53
NL80211_CMD_FLUSH_PMKSA = 54
NL80211_CMD_REMAIN_ON_CHANNEL = 55
NL80211_CMD_CANCEL_REMAIN_ON_CHANNEL = 56
NL80211_CMD_SET_TX_BITRATE_MASK = 57
NL80211_CMD_REGISTER_FRAME = 58
NL80211_CMD_REGISTER_ACTION = NL80211_CMD_REGISTER_FRAME
NL80211_CMD_FRAME = 59
NL80211_CMD_ACTION = NL80211_CMD_FRAME
NL80211_CMD_FRAME_TX_STATUS = 60
NL80211_CMD_ACTION_TX_STATUS = NL80211_CMD_FRAME_TX_STATUS
NL80211_CMD_SET_POWER_SAVE = 61
NL80211_CMD_GET_POWER_SAVE = 62
NL80211_CMD_SET_CQM = 63
NL80211_CMD_NOTIFY_CQM = 64
NL80211_CMD_SET_CHANNEL = 65
NL80211_CMD_SET_WDS_PEER = 66
NL80211_CMD_FRAME_WAIT_CANCEL = 67
NL80211_CMD_JOIN_MESH = 68
NL80211_CMD_LEAVE_MESH = 69
NL80211_CMD_UNPROT_DEAUTHENTICATE = 70
NL80211_CMD_UNPROT_DISASSOCIATE = 71
NL80211_CMD_NEW_PEER_CANDIDATE = 72
NL80211_CMD_GET_WOWLAN = 73
NL80211_CMD_SET_WOWLAN = 74
NL80211_CMD_START_SCHED_SCAN = 75
NL80211_CMD_STOP_SCHED_SCAN = 76
NL80211_CMD_SCHED_SCAN_RESULTS = 77
NL80211_CMD_SCHED_SCAN_STOPPED = 78
NL80211_CMD_SET_REKEY_OFFLOAD = 79
NL80211_CMD_PMKSA_CANDIDATE = 80
NL80211_CMD_TDLS_OPER = 81
NL80211_CMD_TDLS_MGMT = 82
NL80211_CMD_UNEXPECTED_FRAME = 83
NL80211_CMD_PROBE_CLIENT = 84
NL80211_CMD_REGISTER_BEACONS = 85
NL80211_CMD_UNEXPECTED_4ADDR_FRAME = 86
NL80211_CMD_SET_NOACK_MAP = 87
NL80211_CMD_CH_SWITCH_NOTIFY = 88
NL80211_CMD_START_P2P_DEVICE = 89
NL80211_CMD_STOP_P2P_DEVICE = 90
NL80211_CMD_CONN_FAILED = 91
NL80211_CMD_SET_MCAST_RATE = 92
NL80211_CMD_SET_MAC_ACL = 93
NL80211_CMD_RADAR_DETECT = 94
NL80211_CMD_GET_PROTOCOL_FEATURES = 95
NL80211_CMD_UPDATE_FT_IES = 96
NL80211_CMD_FT_EVENT = 97
NL80211_CMD_CRIT_PROTOCOL_START = 98
NL80211_CMD_CRIT_PROTOCOL_STOP = 99
NL80211_CMD_GET_COALESCE = 100
NL80211_CMD_SET_COALESCE = 101
NL80211_CMD_CHANNEL_SWITCH = 102
NL80211_CMD_VENDOR = 103
NL80211_CMD_SET_QOS_MAP = 104
NL80211_CMD_ADD_TX_TS = 105
NL80211_CMD_DEL_TX_TS = 106
NL80211_CMD_GET_MPP = 107
NL80211_CMD_JOIN_OCB = 108
NL80211_CMD_LEAVE_OCB = 109
NL80211_CMD_CH_SWITCH_STARTED_NOTIFY = 110
NL80211_CMD_TDLS_CHANNEL_SWITCH = 111
NL80211_CMD_TDLS_CANCEL_CHANNEL_SWITCH = 112
NL80211_CMD_WIPHY_REG_CHANGE = 113
NL80211_CMD_ABORT_SCAN = 114
NL80211_CMD_START_NAN = 115
NL80211_CMD_STOP_NAN = 116
NL80211_CMD_ADD_NAN_FUNCTION = 117
NL80211_CMD_DEL_NAN_FUNCTION = 118
NL80211_CMD_CHANGE_NAN_CONFIG = 119
NL80211_CMD_NAN_MATCH = 120
NL80211_CMD_SET_MULTICAST_TO_UNICAST = 121
NL80211_CMD_UPDATE_CONNECT_PARAMS = 122
NL80211_CMD_SET_PMK = 123
NL80211_CMD_DEL_PMK = 124
NL80211_CMD_PORT_AUTHORIZED = 125
NL80211_CMD_RELOAD_REGDB = 126
NL80211_CMD_EXTERNAL_AUTH = 127
NL80211_CMD_STA_OPMODE_CHANGED = 128
NL80211_CMD_CONTROL_PORT_FRAME = 129
NL80211_CMD_GET_FTM_RESPONDER_STATS = 130
NL80211_CMD_PEER_MEASUREMENT_START = 131
NL80211_CMD_PEER_MEASUREMENT_RESULT = 132
NL80211_CMD_PEER_MEASUREMENT_COMPLETE = 133
NL80211_CMD_NOTIFY_RADAR = 134
NL80211_CMD_UPDATE_OWE_INFO = 135
NL80211_CMD_PROBE_MESH_LINK = 136
NL80211_CMD_SET_TID_CONFIG = 137
NL80211_CMD_UNPROT_BEACON = 138
NL80211_CMD_CONTROL_PORT_FRAME_TX_STATUS = 139
NL80211_CMD_SET_SAR_SPECS = 140
NL80211_CMD_OBSS_COLOR_COLLISION = 141
NL80211_CMD_COLOR_CHANGE_REQUEST = 142
NL80211_CMD_COLOR_CHANGE_STARTED = 143
NL80211_CMD_COLOR_CHANGE_ABORTED = 144
NL80211_CMD_COLOR_CHANGE_COMPLETED = 145
NL80211_CMD_SET_FILS_AAD = 146

NL80211_ATTR_UNSPEC = 0
NL80211_ATTR_WIPHY = 1
NL80211_ATTR_WIPHY_NAME = 2
NL80211_ATTR_IFINDEX = 3
NL80211_ATTR_IFNAME = 4
NL80211_ATTR_IFTYPE = 5
NL80211_ATTR_MAC = 6
NL80211_ATTR_KEY_DATA = 7
NL80211_ATTR_KEY_IDX = 8
NL80211_ATTR_KEY_CIPHER = 9
NL80211_ATTR_KEY_SEQ = 10
NL80211_ATTR_KEY_DEFAULT = 11
NL80211_ATTR_BEACON_INTERVAL = 12
NL80211_ATTR_DTIM_PERIOD = 13
NL80211_ATTR_BEACON_HEAD = 14
NL80211_ATTR_BEACON_TAIL = 15
NL80211_ATTR_STA_AID = 16
NL80211_ATTR_STA_FLAGS = 17
NL80211_ATTR_STA_LISTEN_INTERVAL = 18
NL80211_ATTR_STA_SUPPORTED_RATES = 19
NL80211_ATTR_STA_VLAN = 20
NL80211_ATTR_STA_INFO = 21
NL80211_ATTR_WIPHY_BANDS = 22
NL80211_ATTR_MNTR_FLAGS = 23
NL80211_ATTR_MESH_ID = 24
NL80211_ATTR_STA_PLINK_ACTION = 25
NL80211_ATTR_MPATH_NEXT_HOP = 26
NL80211_ATTR_MPATH_INFO = 27
NL80211_ATTR_BSS_CTS_PROT = 28
NL80211_ATTR_BSS_SHORT_PREAMBLE = 29
NL80211_ATTR_BSS_SHORT_SLOT_TIME = 30
NL80211_ATTR_HT_CAPABILITY = 31
NL80211_ATTR_SUPPORTED_IFTYPES = 32
NL80211_ATTR_REG_ALPHA2 = 33
NL80211_ATTR_REG_RULES = 34
NL80211_ATTR_MESH_CONFIG = 35
NL80211_ATTR_BSS_BASIC_RATES = 36
NL80211_ATTR_WIPHY_TXQ_PARAMS = 37
NL80211_ATTR_WIPHY_FREQ = 38
NL80211_ATTR_WIPHY_CHANNEL_TYPE = 39
NL80211_ATTR_KEY_DEFAULT_MGMT = 40
NL80211_ATTR_MGMT_SUBTYPE = 41
NL80211_ATTR_IE = 42
NL80211_ATTR_MAX_NUM_SCAN_SSIDS = 43
NL80211_ATTR_SCAN_FREQUENCIES = 44
NL80211_ATTR_SCAN_SSIDS = 45
NL80211_ATTR_GENERATION = 46
NL80211_ATTR_BSS = 47
NL80211_ATTR_REG_INITIATOR = 48
NL80211_ATTR_REG_TYPE = 49
NL80211_ATTR_SUPPORTED_COMMANDS = 50
NL80211_ATTR_FRAME = 51
NL80211_ATTR_SSID = 52
NL80211_ATTR_AUTH_TYPE = 53
NL80211_ATTR_REASON_CODE = 54
NL80211_ATTR_KEY_TYPE = 55
NL80211_ATTR_MAX_SCAN_IE_LEN = 56
NL80211_ATTR_CIPHER_SUITES = 57
NL80211_ATTR_FREQ_BEFORE = 58
NL80211_ATTR_FREQ_AFTER = 59
NL80211_ATTR_FREQ_FIXED = 60
NL80211_ATTR_WIPHY_RETRY_SHORT = 61
NL80211_ATTR_WIPHY_RETRY_LONG = 62
NL80211_ATTR_WIPHY_FRAG_THRESHOLD = 63
NL80211_ATTR_WIPHY_RTS_THRESHOLD = 64
NL80211_ATTR_TIMED_OUT = 65
NL80211_ATTR_USE_MFP = 66
NL80211_ATTR_STA_FLAGS2 = 67
NL80211_ATTR_CONTROL_PORT = 68
NL80211_ATTR_TESTDATA = 69
NL80211_ATTR_PRIVACY = 70
NL80211_ATTR_DISCONNECTED_BY_AP = 71
NL80211_ATTR_STATUS_CODE = 72
NL80211_ATTR_CIPHER_SUITES_PAIRWISE = 73
NL80211_ATTR_CIPHER_SUITE_GROUP = 74
NL80211_ATTR_WPA_VERSIONS = 75
NL80211_ATTR_AKM_SUITES = 76
NL80211_ATTR_REQ_IE = 77
NL80211_ATTR_RESP_IE = 78
NL80211_ATTR_PREV_BSSID = 79
NL80211_ATTR_KEY = 80
NL80211_ATTR_KEYS = 81
NL80211_ATTR_PID = 82
NL80211_ATTR_4ADDR = 83
NL80211_ATTR_SURVEY_INFO = 84
NL80211_ATTR_PMKID = 85
NL80211_ATTR_MAX_NUM_PMKIDS = 86
NL80211_ATTR_DURATION = 87
NL80211_ATTR_COOKIE = 88
NL80211_ATTR_WIPHY_COVERAGE_CLASS = 89
NL80211_ATTR_TX_RATES = 90
NL80211_ATTR_FRAME_MATCH = 91
NL80211_ATTR_ACK = 92
NL80211_ATTR_PS_STATE = 93
NL80211_ATTR_CQM = 94
NL80211_ATTR_LOCAL_STATE_CHANGE = 95
NL80211_ATTR_AP_ISOLATE = 96
NL80211_ATTR_WIPHY_TX_POWER_SETTING = 97
NL80211_ATTR_WIPHY_TX_POWER_LEVEL = 98
NL80211_ATTR_TX_FRAME_TYPES = 99
NL80211_ATTR_RX_FRAME_TYPES = 100
NL80211_ATTR_FRAME_TYPE = 101
NL80211_ATTR_CONTROL_PORT_ETHERTYPE = 102
NL80211_ATTR_CONTROL_PORT_NO_ENCRYPT = 103
NL80211_ATTR_SUPPORT_IBSS_RSN = 104
NL80211_ATTR_WIPHY_ANTENNA_TX = 105
NL80211_ATTR_WIPHY_ANTENNA_RX = 106
NL80211_ATTR_MCAST_RATE = 107
NL80211_ATTR_OFFCHANNEL_TX_OK = 108
NL80211_ATTR_BSS_HT_OPMODE = 109
NL80211_ATTR_KEY_DEFAULT_TYPES = 110
NL80211_ATTR_MAX_REMAIN_ON_CHANNEL_DURATION = 111
NL80211_ATTR_MESH_SETUP = 112
NL80211_ATTR_WIPHY_ANTENNA_AVAIL_TX = 113
NL80211_ATTR_WIPHY_ANTENNA_AVAIL_RX = 114
NL80211_ATTR_SUPPORT_MESH_AUTH = 115
NL80211_ATTR_STA_PLINK_STATE = 116
NL80211_ATTR_WOWLAN_TRIGGERS = 117
NL80211_ATTR_WOWLAN_TRIGGERS_SUPPORTED = 118
NL80211_ATTR_SCHED_SCAN_INTERVAL = 119
NL80211_ATTR_INTERFACE_COMBINATIONS = 120
NL80211_ATTR_SOFTWARE_IFTYPES = 121
NL80211_ATTR_REKEY_DATA = 122
NL80211_ATTR_MAX_NUM_SCHED_SCAN_SSIDS = 123
NL80211_ATTR_MAX_SCHED_SCAN_IE_LEN = 124
NL80211_ATTR_SCAN_SUPP_RATES = 125
NL80211_ATTR_HIDDEN_SSID = 126
NL80211_ATTR_IE_PROBE_RESP = 127
NL80211_ATTR_IE_ASSOC_RESP = 128
NL80211_ATTR_STA_WME = 129
NL80211_ATTR_SUPPORT_AP_UAPSD = 130
NL80211_ATTR_ROAM_SUPPORT = 131
NL80211_ATTR_SCHED_SCAN_MATCH = 132
NL80211_ATTR_MAX_MATCH_SETS = 133
NL80211_ATTR_PMKSA_CANDIDATE = 134
NL80211_ATTR_TX_NO_CCK_RATE = 135
NL80211_ATTR_TDLS_ACTION = 136
NL80211_ATTR_TDLS_DIALOG_TOKEN = 137
NL80211_ATTR_TDLS_OPERATION = 138
NL80211_ATTR_TDLS_SUPPORT = 139
NL80211_ATTR_TDLS_EXTERNAL_SETUP = 140
NL80211_ATTR_DEVICE_AP_SME = 141
NL80211_ATTR_DONT_WAIT_FOR_ACK = 142
NL80211_ATTR_FEATURE_FLAGS = 143
NL80211_ATTR_PROBE_RESP_OFFLOAD = 144
NL80211_ATTR_PROBE_RESP = 145
NL80211_ATTR_DFS_REGION = 146
NL80211_ATTR_DISABLE_HT = 147
NL80211_ATTR_HT_CAPABILITY_MASK = 148
NL80211_ATTR_NOACK_MAP = 149
NL80211_ATTR_INACTIVITY_TIMEOUT = 150
NL80211_ATTR_RX_SIGNAL_DBM = 151
NL80211_ATTR_BG_SCAN_PERIOD = 152
NL80211_ATTR_WDEV = 153
NL80211_ATTR_USER_REG_HINT_TYPE = 154
NL80211_ATTR_CONN_FAILED_REASON = 155
NL80211_ATTR_AUTH_DATA = 156
NL80211_ATTR_VHT_CAPABILITY = 157
NL80211_ATTR_SCAN_FLAGS = 158
NL80211_ATTR_CHANNEL_WIDTH = 159
NL80211_ATTR_CENTER_FREQ1 = 160
NL80211_ATTR_CENTER_FREQ2 = 161
NL80211_ATTR_P2P_CTWINDOW = 162
NL80211_ATTR_P2P_OPPPS = 163
NL80211_ATTR_LOCAL_MESH_POWER_MODE = 164
NL80211_ATTR_ACL_POLICY = 165
NL80211_ATTR_MAC_ADDRS = 166
NL80211_ATTR_MAC_ACL_MAX = 167
NL80211_ATTR_RADAR_EVENT = 168
NL80211_ATTR_EXT_CAPA = 169
NL80211_ATTR_EXT_CAPA_MASK = 170
NL80211_ATTR_STA_CAPABILITY = 171
NL80211_ATTR_STA_EXT_CAPABILITY = 172
NL80211_ATTR_PROTOCOL_FEATURES = 173
NL80211_ATTR_SPLIT_WIPHY_DUMP = 174
NL80211_ATTR_DISABLE_VHT = 175
NL80211_ATTR_VHT_CAPABILITY_MASK = 176
NL80211_ATTR_MDID = 177
NL80211_ATTR_IE_RIC = 178
NL80211_ATTR_CRIT_PROT_ID = 179
NL80211_ATTR_MAX_CRIT_PROT_DURATION = 180
NL80211_ATTR_PEER_AID = 181
NL80211_ATTR_COALESCE_RULE = 182
NL80211_ATTR_CH_SWITCH_COUNT = 183
NL80211_ATTR_CH_SWITCH_BLOCK_TX = 184
NL80211_ATTR_CSA_IES = 185
NL80211_ATTR_CNTDWN_OFFS_BEACON = 186
NL80211_ATTR_CNTDWN_OFFS_PRESP = 187
NL80211_ATTR_RXMGMT_FLAGS = 188
NL80211_ATTR_STA_SUPPORTED_CHANNELS = 189
NL80211_ATTR_STA_SUPPORTED_OPER_CLASSES = 190
NL80211_ATTR_HANDLE_DFS = 191
NL80211_ATTR_SUPPORT_5_MHZ = 192
NL80211_ATTR_SUPPORT_10_MHZ = 193
NL80211_ATTR_OPMODE_NOTIF = 194
NL80211_ATTR_VENDOR_ID = 195
NL80211_ATTR_VENDOR_SUBCMD = 196
NL80211_ATTR_VENDOR_DATA = 197
NL80211_ATTR_VENDOR_EVENTS = 198
NL80211_ATTR_QOS_MAP = 199
NL80211_ATTR_MAC_HINT = 200
NL80211_ATTR_WIPHY_FREQ_HINT = 201
NL80211_ATTR_MAX_AP_ASSOC_STA = 202
NL80211_ATTR_TDLS_PEER_CAPABILITY = 203
NL80211_ATTR_SOCKET_OWNER = 204
NL80211_ATTR_CSA_C_OFFSETS_TX = 205
NL80211_ATTR_MAX_CSA_COUNTERS = 206
NL80211_ATTR_TDLS_INITIATOR = 207
NL80211_ATTR_USE_RRM = 208
NL80211_ATTR_WIPHY_DYN_ACK = 209
NL80211_ATTR_TSID = 210
NL80211_ATTR_USER_PRIO = 211
NL80211_ATTR_ADMITTED_TIME = 212
NL80211_ATTR_SMPS_MODE = 213
NL80211_ATTR_OPER_CLASS = 214
NL80211_ATTR_MAC_MASK = 215
NL80211_ATTR_WIPHY_SELF_MANAGED_REG = 216
NL80211_ATTR_EXT_FEATURES = 217
NL80211_ATTR_SURVEY_RADIO_STATS = 218
NL80211_ATTR_NETNS_FD = 219
NL80211_ATTR_SCHED_SCAN_DELAY = 220
NL80211_ATTR_REG_INDOOR = 221
NL80211_ATTR_MAX_NUM_SCHED_SCAN_PLANS = 222
NL80211_ATTR_MAX_SCAN_PLAN_INTERVAL = 223
NL80211_ATTR_MAX_SCAN_PLAN_ITERATIONS = 224
NL80211_ATTR_SCHED_SCAN_PLANS = 225
NL80211_ATTR_PBSS = 226
NL80211_ATTR_BSS_SELECT = 227
NL80211_ATTR_STA_SUPPORT_P2P_PS = 228
NL80211_ATTR_PAD = 229
NL80211_ATTR_IFTYPE_EXT_CAPA = 230
NL80211_ATTR_MU_MIMO_GROUP_DATA = 231
NL80211_ATTR_MU_MIMO_FOLLOW_MAC_ADDR = 232
NL80211_ATTR_SCAN_START_TIME_TSF = 233
NL80211_ATTR_SCAN_START_TIME_TSF_BSSID = 234
NL80211_ATTR_MEASUREMENT_DURATION = 235
NL80211_ATTR_MEASUREMENT_DURATION_MANDATORY = 236
NL80211_ATTR_MESH_PEER_AID = 237
NL80211_ATTR_NAN_MASTER_PREF = 238
NL80211_ATTR_BANDS = 239
NL80211_ATTR_NAN_FUNC = 240
NL80211_ATTR_NAN_MATCH = 241
NL80211_ATTR_FILS_KEK = 242
NL80211_ATTR_FILS_NONCES = 243
NL80211_ATTR_MULTICAST_TO_UNICAST_ENABLED = 244
NL80211_ATTR_BSSID = 245
NL80211_ATTR_SCHED_SCAN_RELATIVE_RSSI = 246
NL80211_ATTR_SCHED_SCAN_RSSI_ADJUST = 247
NL80211_ATTR_TIMEOUT_REASON = 248
NL80211_ATTR_FILS_ERP_USERNAME = 249
NL80211_ATTR_FILS_ERP_REALM = 250
NL80211_ATTR_FILS_ERP_NEXT_SEQ_NUM = 251
NL80211_ATTR_FILS_ERP_RRK = 252
NL80211_ATTR_FILS_CACHE_ID = 253
NL80211_ATTR_PMK = 254
NL80211_ATTR_SCHED_SCAN_MULTI = 255
NL80211_ATTR_SCHED_SCAN_MAX_REQS = 256
NL80211_ATTR_WANT_1X_4WAY_HS = 257
NL80211_ATTR_PMKR0_NAME = 258
NL80211_ATTR_PORT_AUTHORIZED = 259
NL80211_ATTR_EXTERNAL_AUTH_ACTION = 260
NL80211_ATTR_EXTERNAL_AUTH_SUPPORT = 261
NL80211_ATTR_NSS = 262
NL80211_ATTR_ACK_SIGNAL = 263
NL80211_ATTR_CONTROL_PORT_OVER_NL80211 = 264
NL80211_ATTR_TXQ_STATS = 265
NL80211_ATTR_TXQ_LIMIT = 266
NL80211_ATTR_TXQ_MEMORY_LIMIT = 267
NL80211_ATTR_TXQ_QUANTUM = 268
NL80211_ATTR_HE_CAPABILITY = 269
NL80211_ATTR_FTM_RESPONDER = 270
NL80211_ATTR_FTM_RESPONDER_STATS = 271
NL80211_ATTR_TIMEOUT = 272
NL80211_ATTR_PEER_MEASUREMENTS = 273
NL80211_ATTR_AIRTIME_WEIGHT = 274
NL80211_ATTR_STA_TX_POWER_SETTING = 275
NL80211_ATTR_STA_TX_POWER = 276
NL80211_ATTR_SAE_PASSWORD = 277
NL80211_ATTR_TWT_RESPONDER = 278
NL80211_ATTR_HE_OBSS_PD = 279
NL80211_ATTR_WIPHY_EDMG_CHANNELS = 280
NL80211_ATTR_WIPHY_EDMG_BW_CONFIG = 281
NL80211_ATTR_VLAN_ID = 282
NL80211_ATTR_HE_BSS_COLOR = 283
NL80211_ATTR_IFTYPE_AKM_SUITES = 284
NL80211_ATTR_TID_CONFIG = 285
NL80211_ATTR_CONTROL_PORT_NO_PREAUTH = 286
NL80211_ATTR_PMK_LIFETIME = 287
NL80211_ATTR_PMK_REAUTH_THRESHOLD = 288
NL80211_ATTR_RECEIVE_MULTICAST = 289
NL80211_ATTR_WIPHY_FREQ_OFFSET = 290
NL80211_ATTR_CENTER_FREQ1_OFFSET = 291
NL80211_ATTR_SCAN_FREQ_KHZ = 292
NL80211_ATTR_HE_6GHZ_CAPABILITY = 293
NL80211_ATTR_FILS_DISCOVERY = 294
NL80211_ATTR_UNSOL_BCAST_PROBE_RESP = 295
NL80211_ATTR_S1G_CAPABILITY = 296
NL80211_ATTR_S1G_CAPABILITY_MASK = 297
NL80211_ATTR_SAE_PWE = 298
NL80211_ATTR_RECONNECT_REQUESTED = 299
NL80211_ATTR_SAR_SPEC = 300
NL80211_ATTR_DISABLE_HE = 301
NL80211_ATTR_OBSS_COLOR_BITMAP = 302
NL80211_ATTR_COLOR_CHANGE_COUNT = 303
NL80211_ATTR_COLOR_CHANGE_COLOR = 304
NL80211_ATTR_COLOR_CHANGE_ELEMS = 305
NL80211_ATTR_MBSSID_CONFIG = 306
NL80211_ATTR_MBSSID_ELEMS = 307

NL80211_ATTR_CQM_RSSI_THOLD = 1
NL80211_ATTR_CQM_RSSI_HYST = 2
NL80211_ATTR_CQM_RSSI_THRESHOLD_EVENT = 3
NL80211_ATTR_CQM_PKT_LOSS_EVENT = 4
NL80211_ATTR_CQM_TXE_RATE = 5
NL80211_ATTR_CQM_TXE_PKTS = 6
NL80211_ATTR_CQM_TXE_INTVL = 7
NL80211_ATTR_CQM_BEACON_LOSS_EVENT = 8
NL80211_ATTR_CQM_RSSI_LEVEL = 9

NL80211_ATTR_REG_RULE_FLAGS = 1
NL80211_ATTR_FREQ_RANGE_START = 2
NL80211_ATTR_FREQ_RANGE_END = 3
NL80211_ATTR_FREQ_RANGE_MAX_BW = 4
NL80211_ATTR_POWER_RULE_MAX_ANT_GAIN = 5
NL80211_ATTR_POWER_RULE_MAX_EIRP = 6
NL80211_ATTR_DFS_CAC_TIME = 7

NL80211_BAND_ATTR_FREQS = 1
NL80211_BAND_ATTR_RATES = 2
NL80211_BAND_ATTR_HT_MCS_SET = 3
NL80211_BAND_ATTR_HT_CAPA = 4
NL80211_BAND_ATTR_HT_AMPDU_FACTOR = 5
NL80211_BAND_ATTR_HT_AMPDU_DENSITY = 6
NL80211_BAND_ATTR_VHT_MCS_SET = 7
NL80211_BAND_ATTR_VHT_CAPA = 8
NL80211_BAND_ATTR_IFTYPE_DATA = 9
NL80211_BAND_ATTR_EDMG_CHANNELS = 10
NL80211_BAND_ATTR_EDMG_BW_CONFIG = 11

NL80211_BAND_IFTYPE_ATTR_IFTYPES = 1
NL80211_BAND_IFTYPE_ATTR_HE_CAP_MAC = 2
NL80211_BAND_IFTYPE_ATTR_HE_CAP_PHY = 3
NL80211_BAND_IFTYPE_ATTR_HE_CAP_MCS_SET = 4
NL80211_BAND_IFTYPE_ATTR_HE_CAP_PPE = 5
NL80211_BAND_IFTYPE_ATTR_HE_6GHZ_CAPA = 6
NL80211_BAND_IFTYPE_ATTR_VENDOR_ELEMS = 7

NL80211_BITRATE_ATTR_RATE = 1
NL80211_BITRATE_ATTR_2GHZ_SHORTPREAMBLE = 2

NL80211_BSS_BSSID = 1
NL80211_BSS_FREQUENCY = 2
NL80211_BSS_TSF = 3
NL80211_BSS_BEACON_INTERVAL = 4
NL80211_BSS_CAPABILITY = 5
NL80211_BSS_INFORMATION_ELEMENTS = 6
NL80211_BSS_SIGNAL_MBM = 7
NL80211_BSS_SIGNAL_UNSPEC = 8
NL80211_BSS_STATUS = 9
NL80211_BSS_SEEN_MS_AGO = 10
NL80211_BSS_BEACON_IES = 11
NL80211_BSS_CHAN_WIDTH = 12
NL80211_BSS_BEACON_TSF = 13
NL80211_BSS_PRESP_DATA = 14
NL80211_BSS_LAST_SEEN_BOOTTIME = 15
NL80211_BSS_PAD = 16
NL80211_BSS_PARENT_TSF = 17
NL80211_BSS_PARENT_BSSID = 18
NL80211_BSS_CHAIN_SIGNAL = 19
NL80211_BSS_FREQUENCY_OFFSET = 20

NL80211_FREQUENCY_ATTR_FREQ = 1
NL80211_FREQUENCY_ATTR_DISABLED = 2
NL80211_FREQUENCY_ATTR_NO_IR = 3
NL80211_FREQUENCY_ATTR_NO_IBSS = 4
NL80211_FREQUENCY_ATTR_RADAR = 5
NL80211_FREQUENCY_ATTR_MAX_TX_POWER = 6
NL80211_FREQUENCY_ATTR_DFS_STATE = 7
NL80211_FREQUENCY_ATTR_DFS_TIME = 8
NL80211_FREQUENCY_ATTR_NO_HT40_MINUS = 9
NL80211_FREQUENCY_ATTR_NO_HT40_PLUS = 10
NL80211_FREQUENCY_ATTR_NO_80MHZ = 11
NL80211_FREQUENCY_ATTR_NO_160MHZ = 12
NL80211_FREQUENCY_ATTR_DFS_CAC_TIME = 13
NL80211_FREQUENCY_ATTR_INDOOR_ONLY = 14
NL80211_FREQUENCY_ATTR_IR_CONCURRENT = 15
NL80211_FREQUENCY_ATTR_NO_20MHZ = 16
NL80211_FREQUENCY_ATTR_NO_10MHZ = 17
NL80211_FREQUENCY_ATTR_WMM = 18
NL80211_FREQUENCY_ATTR_NO_HE = 19
NL80211_FREQUENCY_ATTR_OFFSET = 20
NL80211_FREQUENCY_ATTR_1MHZ = 21
NL80211_FREQUENCY_ATTR_2MHZ = 22
NL80211_FREQUENCY_ATTR_4MHZ = 23
NL80211_FREQUENCY_ATTR_8MHZ = 24
NL80211_FREQUENCY_ATTR_16MHZ = 25

NL80211_IFACE_COMB_UNSPEC = 0
NL80211_IFACE_COMB_LIMITS = 1
NL80211_IFACE_COMB_MAXNUM = 2
NL80211_IFACE_COMB_STA_AP_BI_MATCH = 3
NL80211_IFACE_COMB_NUM_CHANNELS = 4
NL80211_IFACE_COMB_RADAR_DETECT_WIDTHS = 5
NL80211_IFACE_COMB_RADAR_DETECT_REGIONS = 6
NL80211_IFACE_COMB_BI_MIN_GCD = 7

NL80211_IFACE_LIMIT_UNSPEC = 0
NL80211_IFACE_LIMIT_MAX = 1
NL80211_IFACE_LIMIT_TYPES = 2

NL80211_KEY_DATA = 1
NL80211_KEY_IDX = 2
NL80211_KEY_CIPHER = 3
NL80211_KEY_SEQ = 4
NL80211_KEY_DEFAULT = 5
NL80211_KEY_DEFAULT_MGMT = 6
NL80211_KEY_TYPE = 7
NL80211_KEY_DEFAULT_TYPES = 8
NL80211_KEY_MODE = 9
NL80211_KEY_DEFAULT_BEACON = 10

NL80211_KEY_DEFAULT_TYPE_UNICAST = 1
NL80211_KEY_DEFAULT_TYPE_MULTICAST = 2

NL80211_MPATH_INFO_FRAME_QLEN = 1
NL80211_MPATH_INFO_SN = 2
NL80211_MPATH_INFO_METRIC = 3
NL80211_MPATH_INFO_EXPTIME = 4
NL80211_MPATH_INFO_FLAGS = 5
NL80211_MPATH_INFO_DISCOVERY_TIMEOUT = 6
NL80211_MPATH_INFO_DISCOVERY_RETRIES = 7
NL80211_MPATH_INFO_HOP_COUNT = 8
NL80211_MPATH_INFO_PATH_CHANGE = 9

NL80211_PKTPAT_MASK = 1
NL80211_PKTPAT_PATTERN = 2
NL80211_PKTPAT_OFFSET = 3

NL80211_RATE_INFO_BITRATE = 1
NL80211_RATE_INFO_MCS = 2
NL80211_RATE_INFO_40_MHZ_WIDTH = 3
NL80211_RATE_INFO_SHORT_GI = 4
NL80211_RATE_INFO_BITRATE32 = 5
NL80211_RATE_INFO_VHT_MCS = 6
NL80211_RATE_INFO_VHT_NSS = 7
NL80211_RATE_INFO_80_MHZ_WIDTH = 8
NL80211_RATE_INFO_80P80_MHZ_WIDTH = 9
NL80211_RATE_INFO_160_MHZ_WIDTH = 10
NL80211_RATE_INFO_10_MHZ_WIDTH = 11
NL80211_RATE_INFO_5_MHZ_WIDTH = 12
NL80211_RATE_INFO_HE_MCS = 13
NL80211_RATE_INFO_HE_NSS = 14
NL80211_RATE_INFO_HE_GI = 15
NL80211_RATE_INFO_HE_DCM = 16
NL80211_RATE_INFO_HE_RU_ALLOC = 17

NL80211_STA_BSS_PARAM_CTS_PROT = 1
NL80211_STA_BSS_PARAM_SHORT_PREAMBLE = 2
NL80211_STA_BSS_PARAM_SHORT_SLOT_TIME = 3
NL80211_STA_BSS_PARAM_DTIM_PERIOD = 4
NL80211_STA_BSS_PARAM_BEACON_INTERVAL = 5

NL80211_STA_FLAG_AUTHORIZED = 1
NL80211_STA_FLAG_SHORT_PREAMBLE = 2
NL80211_STA_FLAG_WME = 3
NL80211_STA_FLAG_MFP = 4
NL80211_STA_FLAG_AUTHENTICATED = 5
NL80211_STA_FLAG_TDLS_PEER = 6
NL80211_STA_FLAG_ASSOCIATED = 7

NL80211_STA_INFO_INACTIVE_TIME = 1
NL80211_STA_INFO_RX_BYTES = 2
NL80211_STA_INFO_TX_BYTES = 3
NL80211_STA_INFO_LLID = 4
NL80211_STA_INFO_PLID = 5
NL80211_STA_INFO_PLINK_STATE = 6
NL80211_STA_INFO_SIGNAL = 7
NL80211_STA_INFO_TX_BITRATE = 8
NL80211_STA_INFO_RX_PACKETS = 9
NL80211_STA_INFO_TX_PACKETS = 10
NL80211_STA_INFO_TX_RETRIES = 11
NL80211_STA_INFO_TX_FAILED = 12
NL80211_STA_INFO_SIGNAL_AVG = 13
NL80211_STA_INFO_RX_BITRATE = 14
NL80211_STA_INFO_BSS_PARAM = 15
NL80211_STA_INFO_CONNECTED_TIME = 16
NL80211_STA_INFO_STA_FLAGS = 17
NL80211_STA_INFO_BEACON_LOSS = 18
NL80211_STA_INFO_T_OFFSET = 19
NL80211_STA_INFO_LOCAL_PM = 20
NL80211_STA_INFO_PEER_PM = 21
NL80211_STA_INFO_NONPEER_PM = 22
NL80211_STA_INFO_RX_BYTES64 = 23
NL80211_STA_INFO_TX_BYTES64 = 24
NL80211_STA_INFO_CHAIN_SIGNAL = 25
NL80211_STA_INFO_CHAIN_SIGNAL_AVG = 26
NL80211_STA_INFO_EXPECTED_THROUGHPUT = 27
NL80211_STA_INFO_RX_DROP_MISC = 28
NL80211_STA_INFO_BEACON_RX = 29
NL80211_STA_INFO_BEACON_SIGNAL_AVG = 30
NL80211_STA_INFO_TID_STATS = 31
NL80211_STA_INFO_RX_DURATION = 32
NL80211_STA_INFO_PAD = 33
NL80211_STA_INFO_ACK_SIGNAL = 34
NL80211_STA_INFO_ACK_SIGNAL_AVG = 35
NL80211_STA_INFO_RX_MPDUS = 36
NL80211_STA_INFO_FCS_ERROR_COUNT = 37
NL80211_STA_INFO_CONNECTED_TO_GATE = 38
NL80211_STA_INFO_TX_DURATION = 39
NL80211_STA_INFO_AIRTIME_WEIGHT = 40
NL80211_STA_INFO_AIRTIME_LINK_METRIC = 41
NL80211_STA_INFO_ASSOC_AT_BOOTTIME = 42
NL80211_STA_INFO_CONNECTED_TO_AS = 43

NL80211_STA_WME_UAPSD_QUEUES = 1
NL80211_STA_WME_MAX_SP = 2

NL80211_TID_STATS_RX_MSDU = 1
NL80211_TID_STATS_TX_MSDU = 2
NL80211_TID_STATS_TX_MSDU_RETRIES = 3
NL80211_TID_STATS_TX_MSDU_FAILED = 4
NL80211_TID_STATS_PAD = 5
NL80211_TID_STATS_TXQ_STATS = 6

NL80211_TXQ_STATS_BACKLOG_BYTES = 1
NL80211_TXQ_STATS_BACKLOG_PACKETS = 2
NL80211_TXQ_STATS_FLOWS = 3
NL80211_TXQ_STATS_DROPS = 4
NL80211_TXQ_STATS_ECN_MARKS = 5
NL80211_TXQ_STATS_OVERLIMIT = 6
NL80211_TXQ_STATS_OVERMEMORY = 7
NL80211_TXQ_STATS_COLLISIONS = 8
NL80211_TXQ_STATS_TX_BYTES = 9
NL80211_TXQ_STATS_TX_PACKETS = 10
NL80211_TXQ_STATS_MAX_FLOWS = 11

NL80211_WMMR_CW_MIN = 1
NL80211_WMMR_CW_MAX = 2
NL80211_WMMR_AIFSN = 3
NL80211_WMMR_TXOP = 4

NL80211_WOWLAN_TCP_SRC_IPV4 = 1
NL80211_WOWLAN_TCP_DST_IPV4 = 2
NL80211_WOWLAN_TCP_DST_MAC = 3
NL80211_WOWLAN_TCP_SRC_PORT = 4
NL80211_WOWLAN_TCP_DST_PORT = 5
NL80211_WOWLAN_TCP_DATA_PAYLOAD = 6
NL80211_WOWLAN_TCP_DATA_PAYLOAD_SEQ = 7
NL80211_WOWLAN_TCP_DATA_PAYLOAD_TOKEN = 8
NL80211_WOWLAN_TCP_DATA_INTERVAL = 9
NL80211_WOWLAN_TCP_WAKE_PAYLOAD = 10
NL80211_WOWLAN_TCP_WAKE_MASK = 11

NL80211_WOWLAN_TRIG_ANY = 1
NL80211_WOWLAN_TRIG_DISCONNECT = 2
NL80211_WOWLAN_TRIG_MAGIC_PKT = 3
NL80211_WOWLAN_TRIG_PKT_PATTERN = 4
NL80211_WOWLAN_TRIG_GTK_REKEY_SUPPORTED = 5
NL80211_WOWLAN_TRIG_GTK_REKEY_FAILURE = 6
NL80211_WOWLAN_TRIG_EAP_IDENT_REQUEST = 7
NL80211_WOWLAN_TRIG_4WAY_HANDSHAKE = 8
NL80211_WOWLAN_TRIG_RFKILL_RELEASE = 9
NL80211_WOWLAN_TRIG_WAKEUP_PKT_80211 = 10
NL80211_WOWLAN_TRIG_WAKEUP_PKT_80211_LEN = 11
NL80211_WOWLAN_TRIG_WAKEUP_PKT_8023 = 12
NL80211_WOWLAN_TRIG_WAKEUP_PKT_8023_LEN = 13
NL80211_WOWLAN_TRIG_TCP_CONNECTION = 14
NL80211_WOWLAN_TRIG_WAKEUP_TCP_MATCH = 15
NL80211_WOWLAN_TRIG_WAKEUP_TCP_CONNLOST = 16
NL80211_WOWLAN_TRIG_WAKEUP_TCP_NOMORETOKENS = 17
NL80211_WOWLAN_TRIG_NET_DETECT = 18
NL80211_WOWLAN_TRIG_NET_DETECT_RESULTS = 19

NL80211_AUTHTYPE_OPEN_SYSTEM = 0
NL80211_AUTHTYPE_SHARED_KEY = 1
NL80211_AUTHTYPE_FT = 2
NL80211_AUTHTYPE_NETWORK_EAP = 3
NL80211_AUTHTYPE_SAE = 4
NL80211_AUTHTYPE_FILS_SK = 5
NL80211_AUTHTYPE_FILS_SK_PFS = 6
NL80211_AUTHTYPE_FILS_PK = 7

NL80211_BAND_2GHZ = 0
NL80211_BAND_5GHZ = 1
NL80211_BAND_60GHZ = 2
NL80211_BAND_6GHZ = 3
NL80211_BAND_S1GHZ = 4
NL80211_BAND_LC = 5

NL80211_HIDDEN_SSID_NOT_IN_USE = 0
NL80211_HIDDEN_SSID_ZERO_LEN = 1
NL80211_HIDDEN_SSID_ZERO_CONTENTS = 2

NL80211_IFTYPE_UNSPECIFIED = 0
NL80211_IFTYPE_ADHOC = 1
NL80211_IFTYPE_STATION = 2
NL80211_IFTYPE_AP = 3
NL80211_IFTYPE_AP_VLAN = 4
NL80211_IFTYPE_WDS = 5
NL80211_IFTYPE_MONITOR = 6
NL80211_IFTYPE_MESH_POINT = 7
NL80211_IFTYPE_P2P_CLIENT = 8
NL80211_IFTYPE_P2P_GO = 9
NL80211_IFTYPE_P2P_DEVICE = 10
NL80211_IFTYPE_OCB = 11
NL80211_IFTYPE_NAN = 12

NL80211_KEY_RX_TX = 0
NL80211_KEY_NO_TX = 1
NL80211_KEY_SET_TX = 2

NL80211_KEYTYPE_GROUP = 0
NL80211_KEYTYPE_PAIRWISE = 1
NL80211_KEYTYPE_PEERKEY = 2

NL80211_MNTR_FLAG_FCSFAIL = 1
NL80211_MNTR_FLAG_PLCPFAIL = 2
NL80211_MNTR_FLAG_CONTROL = 3
NL80211_MNTR_FLAG_OTHER_BSS = 4
NL80211_MNTR_FLAG_COOK_FRAMES = 5
NL80211_MNTR_FLAG_ACTIVE = 6

NL80211_PROBE_RESP_OFFLOAD_SUPPORT_WPS = 1 << 0
NL80211_PROBE_RESP_OFFLOAD_SUPPORT_WPS2 = 1 << 1
NL80211_PROBE_RESP_OFFLOAD_SUPPORT_P2P = 1 << 2
NL80211_PROBE_RESP_OFFLOAD_SUPPORT_80211U = 1 << 3


class NL80211(generic.GenericNetlinkSocket):
	ATTRIBUTES = {} # Forward declaration

	ATTRIBUTES_CQM = {
		NL80211_ATTR_CQM_RSSI_THOLD: attributes.binary(),
		NL80211_ATTR_CQM_RSSI_HYST: attributes.u32(),
		NL80211_ATTR_CQM_RSSI_THRESHOLD_EVENT: attributes.u32(),
		NL80211_ATTR_CQM_PKT_LOSS_EVENT: attributes.u32(),
		NL80211_ATTR_CQM_TXE_RATE: attributes.u32(),
		NL80211_ATTR_CQM_TXE_PKTS: attributes.u32(),
		NL80211_ATTR_CQM_TXE_INTVL: attributes.u32(),
		NL80211_ATTR_CQM_BEACON_LOSS_EVENT: attributes.flag(),
		NL80211_ATTR_CQM_RSSI_LEVEL: attributes.s32()
	}

	ATTRIBUTES_WMMR = {
		NL80211_WMMR_CW_MIN: attributes.u16(),
		NL80211_WMMR_CW_MAX: attributes.u16(),
		NL80211_WMMR_AIFSN: attributes.u8(),
		NL80211_WMMR_TXOP: attributes.u16()
	}

	ATTRIBUTES_FREQUENCY = {
		NL80211_FREQUENCY_ATTR_FREQ: attributes.u32(),
		NL80211_FREQUENCY_ATTR_DISABLED: attributes.flag(),
		NL80211_FREQUENCY_ATTR_NO_IR: attributes.flag(),
		NL80211_FREQUENCY_ATTR_NO_IBSS: attributes.flag(),
		NL80211_FREQUENCY_ATTR_RADAR: attributes.flag(),
		NL80211_FREQUENCY_ATTR_MAX_TX_POWER: attributes.u32(),
		NL80211_FREQUENCY_ATTR_DFS_STATE: attributes.u32(),
		NL80211_FREQUENCY_ATTR_DFS_TIME: attributes.u32(),
		NL80211_FREQUENCY_ATTR_NO_HT40_MINUS: attributes.flag(),
		NL80211_FREQUENCY_ATTR_NO_HT40_PLUS: attributes.flag(),
		NL80211_FREQUENCY_ATTR_NO_80MHZ: attributes.flag(),
		NL80211_FREQUENCY_ATTR_NO_160MHZ: attributes.flag(),
		NL80211_FREQUENCY_ATTR_DFS_CAC_TIME: attributes.u32(),
		NL80211_FREQUENCY_ATTR_INDOOR_ONLY: attributes.flag(),
		NL80211_FREQUENCY_ATTR_IR_CONCURRENT: attributes.flag(),
		NL80211_FREQUENCY_ATTR_NO_20MHZ: attributes.flag(),
		NL80211_FREQUENCY_ATTR_NO_10MHZ: attributes.flag(),
		NL80211_FREQUENCY_ATTR_WMM: attributes.array(attributes.nested(ATTRIBUTES_WMMR)),
		NL80211_FREQUENCY_ATTR_NO_HE: attributes.flag(),
		NL80211_FREQUENCY_ATTR_OFFSET: attributes.u32(),
		NL80211_FREQUENCY_ATTR_1MHZ: attributes.flag(),
		NL80211_FREQUENCY_ATTR_2MHZ: attributes.flag(),
		NL80211_FREQUENCY_ATTR_4MHZ: attributes.flag(),
		NL80211_FREQUENCY_ATTR_8MHZ: attributes.flag(),
		NL80211_FREQUENCY_ATTR_16MHZ: attributes.flag()
	}

	ATTRIBUTES_BITRATE = {
		NL80211_BITRATE_ATTR_RATE: attributes.u32(),
		NL80211_BITRATE_ATTR_2GHZ_SHORTPREAMBLE: attributes.flag()
	}
	
	ATTRIBUTES_BAND_IFTYPE = {
		NL80211_BAND_IFTYPE_ATTR_IFTYPES: attributes.array(attributes.flag()),
		NL80211_BAND_IFTYPE_ATTR_HE_CAP_MAC: attributes.binary(),
		NL80211_BAND_IFTYPE_ATTR_HE_CAP_PHY: attributes.binary(),
		NL80211_BAND_IFTYPE_ATTR_HE_CAP_MCS_SET: attributes.binary(),
		NL80211_BAND_IFTYPE_ATTR_HE_CAP_PPE: attributes.binary(),
		NL80211_BAND_IFTYPE_ATTR_HE_6GHZ_CAPA: attributes.binary(),
		NL80211_BAND_IFTYPE_ATTR_VENDOR_ELEMS: attributes.binary()
	}

	ATTRIBUTES_BAND = {
		NL80211_BAND_ATTR_FREQS: attributes.array(attributes.nested(ATTRIBUTES_FREQUENCY)),
		NL80211_BAND_ATTR_RATES: attributes.array(attributes.nested(ATTRIBUTES_BITRATE)),
		NL80211_BAND_ATTR_HT_MCS_SET: attributes.binary(),
		NL80211_BAND_ATTR_HT_CAPA: attributes.u16(),
		NL80211_BAND_ATTR_HT_AMPDU_FACTOR: attributes.u8(),
		NL80211_BAND_ATTR_HT_AMPDU_DENSITY: attributes.u8(),
		NL80211_BAND_ATTR_VHT_MCS_SET: attributes.binary(),
		NL80211_BAND_ATTR_VHT_CAPA: attributes.u32(),
		NL80211_BAND_ATTR_IFTYPE_DATA: attributes.array(attributes.nested(ATTRIBUTES_BAND_IFTYPE), base=1),
		NL80211_BAND_ATTR_EDMG_CHANNELS: attributes.u8(),
		NL80211_BAND_ATTR_EDMG_BW_CONFIG: attributes.u8()
	}
	
	ATTRIBUTES_PKTPAT = {
		NL80211_PKTPAT_MASK: attributes.binary(),
		NL80211_PKTPAT_PATTERN: attributes.binary(),
		NL80211_PKTPAT_OFFSET: attributes.u32()
	}
	
	ATTRIBUTES_WOWLAN_TCP = {
		NL80211_WOWLAN_TCP_SRC_IPV4: attributes.u32(),
		NL80211_WOWLAN_TCP_DST_IPV4: attributes.u32(),
		NL80211_WOWLAN_TCP_DST_MAC: attributes.binary(),
		NL80211_WOWLAN_TCP_SRC_PORT: attributes.u16(),
		NL80211_WOWLAN_TCP_DST_PORT: attributes.u16(),
		NL80211_WOWLAN_TCP_DATA_PAYLOAD: attributes.binary(),
		NL80211_WOWLAN_TCP_DATA_PAYLOAD_SEQ: attributes.binary(),
		NL80211_WOWLAN_TCP_DATA_PAYLOAD_TOKEN: attributes.binary(),
		NL80211_WOWLAN_TCP_DATA_INTERVAL: attributes.u32(),
		NL80211_WOWLAN_TCP_WAKE_PAYLOAD: attributes.binary(),
		NL80211_WOWLAN_TCP_WAKE_MASK: attributes.binary()
	}

	ATTRIBUTES_WOWLAN_TRIG = {
		NL80211_WOWLAN_TRIG_ANY: attributes.flag(),
		NL80211_WOWLAN_TRIG_DISCONNECT: attributes.flag(),
		NL80211_WOWLAN_TRIG_MAGIC_PKT: attributes.flag(),
		NL80211_WOWLAN_TRIG_PKT_PATTERN: attributes.binary(), # Depends on command
		NL80211_WOWLAN_TRIG_GTK_REKEY_SUPPORTED: attributes.flag(),
		NL80211_WOWLAN_TRIG_GTK_REKEY_FAILURE: attributes.flag(),
		NL80211_WOWLAN_TRIG_EAP_IDENT_REQUEST: attributes.flag(),
		NL80211_WOWLAN_TRIG_4WAY_HANDSHAKE: attributes.flag(),
		NL80211_WOWLAN_TRIG_RFKILL_RELEASE: attributes.flag(),
		NL80211_WOWLAN_TRIG_WAKEUP_PKT_80211: attributes.binary(),
		NL80211_WOWLAN_TRIG_WAKEUP_PKT_80211_LEN: attributes.u32(),
		NL80211_WOWLAN_TRIG_WAKEUP_PKT_8023: attributes.binary(),
		NL80211_WOWLAN_TRIG_WAKEUP_PKT_8023_LEN: attributes.u32(),
		NL80211_WOWLAN_TRIG_TCP_CONNECTION: attributes.nested(ATTRIBUTES_WOWLAN_TCP),
		NL80211_WOWLAN_TRIG_WAKEUP_TCP_MATCH: attributes.flag(),
		NL80211_WOWLAN_TRIG_WAKEUP_TCP_CONNLOST: attributes.flag(),
		NL80211_WOWLAN_TRIG_WAKEUP_TCP_NOMORETOKENS: attributes.flag(),
		NL80211_WOWLAN_TRIG_NET_DETECT: attributes.nested(ATTRIBUTES),
		NL80211_WOWLAN_TRIG_NET_DETECT_RESULTS: attributes.array(attributes.nested(ATTRIBUTES))
	}
	
	ATTRIBUTES_WOWLAN_TRIG_SUPPORTED = ATTRIBUTES_WOWLAN_TRIG.copy()
	ATTRIBUTES_WOWLAN_TRIG_SUPPORTED.update({
		NL80211_WOWLAN_TRIG_NET_DETECT: attributes.u32()
	})
	
	ATTRIBUTES_IFACE_LIMIT = {
		NL80211_IFACE_LIMIT_MAX: attributes.u32(),
		NL80211_IFACE_LIMIT_TYPES: attributes.array(attributes.flag())
	}

	ATTRIBUTES_IFACE_COMB = {
		NL80211_IFACE_COMB_LIMITS: attributes.array(attributes.nested(ATTRIBUTES_IFACE_LIMIT), base=1),
		NL80211_IFACE_COMB_MAXNUM: attributes.u32(),
		NL80211_IFACE_COMB_STA_AP_BI_MATCH: attributes.flag(),
		NL80211_IFACE_COMB_NUM_CHANNELS: attributes.u32(),
		NL80211_IFACE_COMB_RADAR_DETECT_WIDTHS: attributes.u32(),
		NL80211_IFACE_COMB_RADAR_DETECT_REGIONS: attributes.u32(),
		NL80211_IFACE_COMB_BI_MIN_GCD: attributes.u32()
	}
	
	ATTRIBUTES_RATE_INFO = {
		NL80211_RATE_INFO_BITRATE: attributes.u16(),
		NL80211_RATE_INFO_MCS: attributes.u8(),
		NL80211_RATE_INFO_40_MHZ_WIDTH: attributes.flag(),
		NL80211_RATE_INFO_SHORT_GI: attributes.flag(),
		NL80211_RATE_INFO_BITRATE32: attributes.u32(),
		NL80211_RATE_INFO_VHT_MCS: attributes.u8(),
		NL80211_RATE_INFO_VHT_NSS: attributes.u8(),
		NL80211_RATE_INFO_80_MHZ_WIDTH: attributes.flag(),
		NL80211_RATE_INFO_80P80_MHZ_WIDTH: attributes.flag(),
		NL80211_RATE_INFO_160_MHZ_WIDTH: attributes.flag(),
		NL80211_RATE_INFO_10_MHZ_WIDTH: attributes.flag(),
		NL80211_RATE_INFO_5_MHZ_WIDTH: attributes.flag(),
		NL80211_RATE_INFO_HE_MCS: attributes.u8(),
		NL80211_RATE_INFO_HE_NSS: attributes.u8(),
		NL80211_RATE_INFO_HE_GI: attributes.u8(),
		NL80211_RATE_INFO_HE_DCM: attributes.u8(),
		NL80211_RATE_INFO_HE_RU_ALLOC: attributes.u8()
	}
	
	ATTRIBUTES_TXQ_STATS = {
		NL80211_TXQ_STATS_BACKLOG_BYTES: attributes.u32(),
		NL80211_TXQ_STATS_BACKLOG_PACKETS: attributes.u32(),
		NL80211_TXQ_STATS_FLOWS: attributes.u32(),
		NL80211_TXQ_STATS_DROPS: attributes.u32(),
		NL80211_TXQ_STATS_ECN_MARKS: attributes.u32(),
		NL80211_TXQ_STATS_OVERLIMIT: attributes.u32(),
		NL80211_TXQ_STATS_OVERMEMORY: attributes.u32(),
		NL80211_TXQ_STATS_COLLISIONS: attributes.u32(),
		NL80211_TXQ_STATS_TX_BYTES: attributes.u32(),
		NL80211_TXQ_STATS_TX_PACKETS: attributes.u32(),
		NL80211_TXQ_STATS_MAX_FLOWS: attributes.u32()
	}
	
	ATTRIBUTES_TID_STATS = {
		NL80211_TID_STATS_RX_MSDU: attributes.u64(),
		NL80211_TID_STATS_TX_MSDU: attributes.u64(),
		NL80211_TID_STATS_TX_MSDU_RETRIES: attributes.u64(),
		NL80211_TID_STATS_TX_MSDU_FAILED: attributes.u64(),
		NL80211_TID_STATS_PAD: attributes.padding(),
		NL80211_TID_STATS_TXQ_STATS: attributes.nested(ATTRIBUTES_TXQ_STATS)
	}
	
	ATTRIBUTES_STA_BSS_PARAM = {
		NL80211_STA_BSS_PARAM_CTS_PROT: attributes.flag(),
		NL80211_STA_BSS_PARAM_SHORT_PREAMBLE: attributes.flag(),
		NL80211_STA_BSS_PARAM_SHORT_SLOT_TIME: attributes.flag(),
		NL80211_STA_BSS_PARAM_DTIM_PERIOD: attributes.u8(),
		NL80211_STA_BSS_PARAM_BEACON_INTERVAL: attributes.u16()
	}
	
	ATTRIBUTES_STA_FLAG = {
		NL80211_STA_FLAG_AUTHORIZED: attributes.flag(),
		NL80211_STA_FLAG_SHORT_PREAMBLE: attributes.flag(),
		NL80211_STA_FLAG_WME: attributes.flag(),
		NL80211_STA_FLAG_MFP: attributes.flag(),
		NL80211_STA_FLAG_AUTHENTICATED: attributes.flag(),
		NL80211_STA_FLAG_TDLS_PEER: attributes.flag(),
		NL80211_STA_FLAG_ASSOCIATED: attributes.flag()
	}
	
	ATTRIBUTES_STA_INFO = {
		NL80211_STA_INFO_INACTIVE_TIME: attributes.u32(),
		NL80211_STA_INFO_RX_BYTES: attributes.u32(),
		NL80211_STA_INFO_TX_BYTES: attributes.u32(),
		NL80211_STA_INFO_LLID: attributes.u16(),
		NL80211_STA_INFO_PLID: attributes.u16(),
		NL80211_STA_INFO_PLINK_STATE: attributes.u8(),
		NL80211_STA_INFO_SIGNAL: attributes.u8(),
		NL80211_STA_INFO_TX_BITRATE: attributes.nested(ATTRIBUTES_RATE_INFO),
		NL80211_STA_INFO_RX_PACKETS: attributes.u32(),
		NL80211_STA_INFO_TX_PACKETS: attributes.u32(),
		NL80211_STA_INFO_TX_RETRIES: attributes.u32(),
		NL80211_STA_INFO_TX_FAILED: attributes.u32(),
		NL80211_STA_INFO_SIGNAL_AVG: attributes.u8(),
		NL80211_STA_INFO_RX_BITRATE: attributes.nested(ATTRIBUTES_RATE_INFO),
		NL80211_STA_INFO_BSS_PARAM: attributes.nested(ATTRIBUTES_STA_BSS_PARAM),
		NL80211_STA_INFO_CONNECTED_TIME: attributes.u32(),
		NL80211_STA_INFO_STA_FLAGS: attributes.binary(),
		NL80211_STA_INFO_BEACON_LOSS: attributes.u32(),
		NL80211_STA_INFO_T_OFFSET: attributes.u64(),
		NL80211_STA_INFO_LOCAL_PM: attributes.u32(),
		NL80211_STA_INFO_PEER_PM: attributes.u32(),
		NL80211_STA_INFO_NONPEER_PM: attributes.u32(),
		NL80211_STA_INFO_RX_BYTES64: attributes.u64(),
		NL80211_STA_INFO_TX_BYTES64: attributes.u64(),
		NL80211_STA_INFO_CHAIN_SIGNAL: attributes.array(attributes.u8()),
		NL80211_STA_INFO_CHAIN_SIGNAL_AVG: attributes.array(attributes.u8()),
		NL80211_STA_INFO_EXPECTED_THROUGHPUT: attributes.u32(),
		NL80211_STA_INFO_RX_DROP_MISC: attributes.u64(),
		NL80211_STA_INFO_BEACON_RX: attributes.u64(),
		NL80211_STA_INFO_BEACON_SIGNAL_AVG: attributes.u8(),
		NL80211_STA_INFO_TID_STATS: attributes.array(attributes.nested(ATTRIBUTES_TID_STATS), base=1),
		NL80211_STA_INFO_RX_DURATION: attributes.u64(),
		NL80211_STA_INFO_PAD: attributes.padding(),
		NL80211_STA_INFO_ACK_SIGNAL:attributes.u8(),
		NL80211_STA_INFO_ACK_SIGNAL_AVG: attributes.s8(),
		NL80211_STA_INFO_RX_MPDUS: attributes.u32(),
		NL80211_STA_INFO_FCS_ERROR_COUNT: attributes.u32(),
		NL80211_STA_INFO_CONNECTED_TO_GATE: attributes.u8(),
		NL80211_STA_INFO_TX_DURATION: attributes.u64(),
		NL80211_STA_INFO_AIRTIME_WEIGHT: attributes.u16(),
		NL80211_STA_INFO_AIRTIME_LINK_METRIC: attributes.u32(),
		NL80211_STA_INFO_ASSOC_AT_BOOTTIME: attributes.u64(),
		NL80211_STA_INFO_CONNECTED_TO_AS: attributes.u8()
	}
	
	ATTRIBUTES_STA_WME = {
		NL80211_STA_WME_UAPSD_QUEUES: attributes.u8(),
		NL80211_STA_WME_MAX_SP: attributes.u8()
	}
	
	ATTRIBUTES_MPATH_INFO = {
		NL80211_MPATH_INFO_FRAME_QLEN: attributes.u32(),
		NL80211_MPATH_INFO_SN: attributes.u32(),
		NL80211_MPATH_INFO_METRIC: attributes.u32(),
		NL80211_MPATH_INFO_EXPTIME: attributes.u32(),
		NL80211_MPATH_INFO_FLAGS: attributes.u8(),
		NL80211_MPATH_INFO_DISCOVERY_TIMEOUT: attributes.u32(),
		NL80211_MPATH_INFO_DISCOVERY_RETRIES: attributes.u8(),
		NL80211_MPATH_INFO_HOP_COUNT: attributes.u8(),
		NL80211_MPATH_INFO_PATH_CHANGE: attributes.u32()
	}
	
	ATTRIBUTES_REG_RULE = {
		NL80211_ATTR_REG_RULE_FLAGS: attributes.u32(),
		NL80211_ATTR_FREQ_RANGE_START: attributes.u32(),
		NL80211_ATTR_FREQ_RANGE_END: attributes.u32(),
		NL80211_ATTR_FREQ_RANGE_MAX_BW: attributes.u32(),
		NL80211_ATTR_POWER_RULE_MAX_ANT_GAIN: attributes.u32(),
		NL80211_ATTR_POWER_RULE_MAX_EIRP: attributes.u32(),
		NL80211_ATTR_DFS_CAC_TIME: attributes.u32()
	}
	
	ATTRIBUTES_BSS = {
		NL80211_BSS_BSSID: attributes.binary(),
		NL80211_BSS_FREQUENCY: attributes.u32(),
		NL80211_BSS_TSF: attributes.u64(),
		NL80211_BSS_BEACON_INTERVAL: attributes.u16(),
		NL80211_BSS_CAPABILITY: attributes.u16(),
		NL80211_BSS_INFORMATION_ELEMENTS: attributes.binary(),
		NL80211_BSS_SIGNAL_MBM: attributes.u32(),
		NL80211_BSS_SIGNAL_UNSPEC: attributes.u8(),
		NL80211_BSS_STATUS: attributes.u32(),
		NL80211_BSS_SEEN_MS_AGO: attributes.u32(),
		NL80211_BSS_BEACON_IES: attributes.binary(),
		NL80211_BSS_CHAN_WIDTH: attributes.u32(),
		NL80211_BSS_BEACON_TSF: attributes.u64(),
		NL80211_BSS_PRESP_DATA: attributes.flag(),
		NL80211_BSS_LAST_SEEN_BOOTTIME: attributes.u64(),
		NL80211_BSS_PAD: attributes.padding(),
		NL80211_BSS_PARENT_TSF: attributes.u64(),
		NL80211_BSS_PARENT_BSSID: attributes.binary(),
		NL80211_BSS_CHAIN_SIGNAL: attributes.array(attributes.u8()),
		NL80211_BSS_FREQUENCY_OFFSET: attributes.u32()
	}
	
	ATTRIBUTES_KEY_DEFAULT = {
		NL80211_KEY_DEFAULT_TYPE_UNICAST: attributes.flag(),
		NL80211_KEY_DEFAULT_TYPE_MULTICAST: attributes.flag()
	}
	
	ATTRIBUTES_KEY = {
		NL80211_KEY_DATA: attributes.binary(),
		NL80211_KEY_IDX: attributes.u8(),
		NL80211_KEY_CIPHER: attributes.u32(),
		NL80211_KEY_SEQ: attributes.binary(),
		NL80211_KEY_DEFAULT: attributes.flag(),
		NL80211_KEY_DEFAULT_MGMT: attributes.flag(),
		NL80211_KEY_TYPE: attributes.u32(),
		NL80211_KEY_DEFAULT_TYPES: attributes.nested(ATTRIBUTES_KEY_DEFAULT),
		NL80211_KEY_MODE: attributes.u8(),
		NL80211_KEY_DEFAULT_BEACON: attributes.flag()
	}

	ATTRIBUTES.update({
		#1 - 34
		NL80211_ATTR_WIPHY: attributes.u32(),
		NL80211_ATTR_WIPHY_NAME: attributes.string(),
		NL80211_ATTR_IFINDEX: attributes.u32(),
		NL80211_ATTR_IFNAME: attributes.string(),
		NL80211_ATTR_IFTYPE: attributes.u32(),
		NL80211_ATTR_MAC: attributes.binary(),
		NL80211_ATTR_KEY_DATA: attributes.binary(),
		NL80211_ATTR_KEY_IDX: attributes.u8(),
		NL80211_ATTR_KEY_CIPHER: attributes.u32(),
		NL80211_ATTR_KEY_SEQ: attributes.binary(),
		NL80211_ATTR_KEY_DEFAULT: attributes.flag(),
		NL80211_ATTR_BEACON_INTERVAL: attributes.u32(),
		NL80211_ATTR_DTIM_PERIOD: attributes.u32(),
		NL80211_ATTR_BEACON_HEAD: attributes.binary(),
		NL80211_ATTR_BEACON_TAIL: attributes.binary(),
		NL80211_ATTR_STA_AID: attributes.u16(),
		NL80211_ATTR_STA_FLAGS: attributes.nested(ATTRIBUTES_STA_FLAG),
		NL80211_ATTR_STA_LISTEN_INTERVAL: attributes.u16(),
		NL80211_ATTR_STA_SUPPORTED_RATES: attributes.binary(),
		NL80211_ATTR_STA_VLAN: attributes.u32(),
		NL80211_ATTR_STA_INFO: attributes.nested(ATTRIBUTES_STA_INFO),
		NL80211_ATTR_WIPHY_BANDS: attributes.dict(attributes.nested(ATTRIBUTES_BAND)),
		NL80211_ATTR_MNTR_FLAGS: attributes.dict(attributes.flag()),
		NL80211_ATTR_MESH_ID: attributes.binary(),
		NL80211_ATTR_STA_PLINK_ACTION: attributes.u8(),
		NL80211_ATTR_MPATH_NEXT_HOP: attributes.binary(),
		NL80211_ATTR_MPATH_INFO: attributes.nested(ATTRIBUTES_MPATH_INFO),
		NL80211_ATTR_BSS_CTS_PROT: attributes.u8(),
		NL80211_ATTR_BSS_SHORT_PREAMBLE: attributes.u8(),
		NL80211_ATTR_BSS_SHORT_SLOT_TIME: attributes.u8(),
		NL80211_ATTR_HT_CAPABILITY: attributes.binary(),
		NL80211_ATTR_SUPPORTED_IFTYPES: attributes.array(attributes.flag()),
		NL80211_ATTR_REG_ALPHA2: attributes.string(),
		NL80211_ATTR_REG_RULES: attributes.array(attributes.nested(ATTRIBUTES_REG_RULE)),
		
		#38 - 39
		NL80211_ATTR_WIPHY_FREQ: attributes.u32(),
		NL80211_ATTR_WIPHY_CHANNEL_TYPE: attributes.u32(),
		
		#41 - 57
		NL80211_ATTR_MGMT_SUBTYPE: attributes.u8(),
		NL80211_ATTR_IE: attributes.binary(),
		NL80211_ATTR_MAX_NUM_SCAN_SSIDS: attributes.u8(),
		NL80211_ATTR_SCAN_FREQUENCIES: attributes.array(attributes.u32()),
		NL80211_ATTR_SCAN_SSIDS: attributes.array(attributes.binary()),
		NL80211_ATTR_GENERATION: attributes.u32(),
		NL80211_ATTR_BSS: attributes.nested(ATTRIBUTES_BSS),
		NL80211_ATTR_REG_INITIATOR: attributes.u8(),
		NL80211_ATTR_REG_TYPE: attributes.u8(),
		NL80211_ATTR_SUPPORTED_COMMANDS: attributes.array(attributes.u32(), base=1),
		NL80211_ATTR_FRAME: attributes.binary(),
		NL80211_ATTR_SSID: attributes.binary(),
		NL80211_ATTR_AUTH_TYPE: attributes.u32(),
		NL80211_ATTR_REASON_CODE: attributes.u16(),
		NL80211_ATTR_KEY_TYPE: attributes.u32(),
		NL80211_ATTR_MAX_SCAN_IE_LEN: attributes.u16(),
		NL80211_ATTR_CIPHER_SUITES: attributes.binary(),
		
		#61 - 66
		NL80211_ATTR_WIPHY_RETRY_SHORT: attributes.u8(),
		NL80211_ATTR_WIPHY_RETRY_LONG: attributes.u8(),
		NL80211_ATTR_WIPHY_FRAG_THRESHOLD: attributes.u32(),
		NL80211_ATTR_WIPHY_RTS_THRESHOLD: attributes.u32(),
		NL80211_ATTR_TIMED_OUT: attributes.flag(),
		NL80211_ATTR_USE_MFP: attributes.u32(),
		
		#68
		NL80211_ATTR_CONTROL_PORT: attributes.flag(),
		
		#70 - 83
		NL80211_ATTR_PRIVACY: attributes.flag(),
		NL80211_ATTR_DISCONNECTED_BY_AP: attributes.flag(),
		NL80211_ATTR_STATUS_CODE: attributes.u16(),
		NL80211_ATTR_CIPHER_SUITES_PAIRWISE: attributes.binary(),
		NL80211_ATTR_CIPHER_SUITE_GROUP: attributes.u32(),
		NL80211_ATTR_WPA_VERSIONS: attributes.u32(),
		NL80211_ATTR_AKM_SUITES: attributes.binary(),
		NL80211_ATTR_REQ_IE: attributes.binary(),
		NL80211_ATTR_RESP_IE: attributes.binary(),
		NL80211_ATTR_PREV_BSSID: attributes.binary(),
		NL80211_ATTR_KEY: attributes.nested(ATTRIBUTES_KEY),
		NL80211_ATTR_KEYS: attributes.array(attributes.nested(ATTRIBUTES_KEY)),
		NL80211_ATTR_PID: attributes.u32(),
		NL80211_ATTR_4ADDR: attributes.u8(),
		
		#86 - 89
		NL80211_ATTR_MAX_NUM_PMKIDS: attributes.u8(),
		NL80211_ATTR_DURATION: attributes.u32(),
		NL80211_ATTR_COOKIE: attributes.u64(),
		NL80211_ATTR_WIPHY_COVERAGE_CLASS: attributes.u8(),
		
		#91 - 92
		NL80211_ATTR_FRAME_MATCH: attributes.binary(),
		NL80211_ATTR_ACK: attributes.flag(),
		
		#94
		NL80211_ATTR_CQM: attributes.nested(ATTRIBUTES_CQM),
		
		#98 - 106
		NL80211_ATTR_WIPHY_TX_POWER_LEVEL: attributes.u32(),
		NL80211_ATTR_TX_FRAME_TYPES: attributes.dict(attributes.array(attributes.u16())),
		NL80211_ATTR_RX_FRAME_TYPES: attributes.dict(attributes.array(attributes.u16())),
		NL80211_ATTR_FRAME_TYPE: attributes.u16(),
		NL80211_ATTR_CONTROL_PORT_ETHERTYPE: attributes.binary(), # flag or u16
		NL80211_ATTR_CONTROL_PORT_NO_ENCRYPT: attributes.flag(),
		NL80211_ATTR_SUPPORT_IBSS_RSN: attributes.flag(),
		NL80211_ATTR_WIPHY_ANTENNA_TX: attributes.u32(),
		NL80211_ATTR_WIPHY_ANTENNA_RX: attributes.u32(),
		
		#108
		NL80211_ATTR_OFFCHANNEL_TX_OK: attributes.flag(),
		
		#111
		NL80211_ATTR_MAX_REMAIN_ON_CHANNEL_DURATION: attributes.u32(),
		
		#113 - 115
		NL80211_ATTR_WIPHY_ANTENNA_AVAIL_TX: attributes.u32(),
		NL80211_ATTR_WIPHY_ANTENNA_AVAIL_RX: attributes.u32(),
		NL80211_ATTR_SUPPORT_MESH_AUTH: attributes.flag(),
		
		#118
		NL80211_ATTR_WOWLAN_TRIGGERS_SUPPORTED: attributes.nested(ATTRIBUTES_WOWLAN_TRIG_SUPPORTED),
		
		#120 - 121
		NL80211_ATTR_INTERFACE_COMBINATIONS: attributes.array(attributes.nested(ATTRIBUTES_IFACE_COMB), base=1),
		NL80211_ATTR_SOFTWARE_IFTYPES: attributes.array(attributes.flag()),
		
		#123 - 126
		NL80211_ATTR_MAX_NUM_SCHED_SCAN_SSIDS: attributes.u8(),
		NL80211_ATTR_MAX_SCHED_SCAN_IE_LEN: attributes.u16(),
		NL80211_ATTR_SCAN_SUPP_RATES: attributes.dict(attributes.binary()),
		NL80211_ATTR_HIDDEN_SSID: attributes.u32(),
		
		#129 - 131
		NL80211_ATTR_STA_WME: attributes.nested(ATTRIBUTES_STA_WME),
		NL80211_ATTR_SUPPORT_AP_UAPSD: attributes.flag(),
		NL80211_ATTR_ROAM_SUPPORT: attributes.flag(),
		
		#133
		NL80211_ATTR_MAX_MATCH_SETS: attributes.u8(),
		
		#135 - 137
		NL80211_ATTR_TX_NO_CCK_RATE: attributes.flag(),
		NL80211_ATTR_TDLS_ACTION: attributes.u8(),
		NL80211_ATTR_TDLS_DIALOG_TOKEN: attributes.u8(),
		
		#139 - 140
		NL80211_ATTR_TDLS_SUPPORT: attributes.flag(),
		NL80211_ATTR_TDLS_EXTERNAL_SETUP: attributes.flag(),
		
		#142 - 144
		NL80211_ATTR_DONT_WAIT_FOR_ACK: attributes.flag(),
		NL80211_ATTR_FEATURE_FLAGS: attributes.u32(),
		NL80211_ATTR_PROBE_RESP_OFFLOAD: attributes.u32(),
		
		#148
		NL80211_ATTR_HT_CAPABILITY_MASK: attributes.binary(),
		
		#151 - 153
		NL80211_ATTR_RX_SIGNAL_DBM: attributes.u32(),
		NL80211_ATTR_BG_SCAN_PERIOD: attributes.u16(),
		NL80211_ATTR_WDEV: attributes.u64(),
		
		#158 - 161
		NL80211_ATTR_SCAN_FLAGS: attributes.u32(),
		NL80211_ATTR_CHANNEL_WIDTH: attributes.u32(),
		NL80211_ATTR_CENTER_FREQ1: attributes.u32(),
		NL80211_ATTR_CENTER_FREQ2: attributes.u32(),
		
		#166
		NL80211_ATTR_MAC_ADDRS: attributes.array(attributes.binary(), base=1),
		
		#169 - 171
		NL80211_ATTR_EXT_CAPA: attributes.binary(),
		NL80211_ATTR_EXT_CAPA_MASK: attributes.binary(),
		NL80211_ATTR_STA_CAPABILITY: attributes.u16(),
		
		#174
		NL80211_ATTR_SPLIT_WIPHY_DUMP: attributes.flag(),
		
		#176
		NL80211_ATTR_VHT_CAPABILITY_MASK: attributes.binary(),
		
		#189
		NL80211_ATTR_STA_SUPPORTED_CHANNELS: attributes.binary(),
		
		#192 - 193
		NL80211_ATTR_SUPPORT_5_MHZ: attributes.flag(),
		NL80211_ATTR_SUPPORT_10_MHZ: attributes.flag(),
		
		#197 - 198
		NL80211_ATTR_VENDOR_DATA: attributes.binary(), # Or nested (depends on command)
		NL80211_ATTR_VENDOR_EVENTS: attributes.array(attributes.binary(), base=1),
		
		#200 - 202
		NL80211_ATTR_MAC_HINT: attributes.binary(),
		NL80211_ATTR_WIPHY_FREQ_HINT: attributes.u32(),
		NL80211_ATTR_MAX_AP_ASSOC_STA: attributes.u32(),
		
		#204 - 206
		NL80211_ATTR_SOCKET_OWNER: attributes.flag(),
		NL80211_ATTR_CSA_C_OFFSETS_TX: attributes.binary(),
		NL80211_ATTR_MAX_CSA_COUNTERS: attributes.u8(),
		
		#215 - 217
		NL80211_ATTR_MAC_MASK: attributes.binary(),
		NL80211_ATTR_WIPHY_SELF_MANAGED_REG: attributes.flag(),
		NL80211_ATTR_EXT_FEATURES: attributes.binary(),
		
		#222 - 224
		NL80211_ATTR_MAX_NUM_SCHED_SCAN_PLANS: attributes.u32(),
		NL80211_ATTR_MAX_SCAN_PLAN_INTERVAL: attributes.u32(),
		NL80211_ATTR_MAX_SCAN_PLAN_ITERATIONS: attributes.u32(),
		
		#229
		NL80211_ATTR_PAD: attributes.padding(),
		
		#233 - 236
		NL80211_ATTR_SCAN_START_TIME_TSF: attributes.u64(),
		NL80211_ATTR_SCAN_START_TIME_TSF_BSSID: attributes.binary(),
		NL80211_ATTR_MEASUREMENT_DURATION: attributes.u16(),
		NL80211_ATTR_MEASUREMENT_DURATION_MANDATORY: attributes.flag(),
		
		#239
		NL80211_ATTR_BANDS: attributes.u32(),
		
		#245
		NL80211_ATTR_BSSID: attributes.binary(),
		
		#248
		NL80211_ATTR_TIMEOUT_REASON: attributes.u32(),
		
		#254
		NL80211_ATTR_PMK: attributes.binary(),
		
		#256 - 257
		NL80211_ATTR_SCHED_SCAN_MAX_REQS: attributes.u32(),
		NL80211_ATTR_WANT_1X_4WAY_HS: attributes.flag(),
		
		#264 - 268
		NL80211_ATTR_CONTROL_PORT_OVER_NL80211: attributes.flag(),
		NL80211_ATTR_TXQ_STATS: attributes.nested(ATTRIBUTES_TXQ_STATS),
		NL80211_ATTR_TXQ_LIMIT: attributes.u32(),
		NL80211_ATTR_TXQ_MEMORY_LIMIT: attributes.u32(),
		NL80211_ATTR_TXQ_QUANTUM: attributes.u32(),
		
		#274
		NL80211_ATTR_AIRTIME_WEIGHT: attributes.u16(),
		
		#277
		NL80211_ATTR_SAE_PASSWORD: attributes.binary(),
		
		#280 - 281
		NL80211_ATTR_WIPHY_EDMG_CHANNELS: attributes.u8(),
		NL80211_ATTR_WIPHY_EDMG_BW_CONFIG: attributes.u8(),
		
		#286
		NL80211_ATTR_CONTROL_PORT_NO_PREAUTH: attributes.flag(),
		
		#290
		NL80211_ATTR_WIPHY_FREQ_OFFSET: attributes.u32(),
		
		#292
		NL80211_ATTR_SCAN_FREQ_KHZ: attributes.array(attributes.u32()),
		
		#298
		NL80211_ATTR_SAE_PWE: attributes.u8(),
	})


@contextlib.asynccontextmanager
async def connect():
	async with generic.connect() as ctrl:
		yield await ctrl.get("nl80211", NL80211)
