"""Base test case class."""

from typing import TypeVar

import pytest

from neva.arch import Application

T = TypeVar("T")


class TestCase:
    """Base test case with auto-injected app and helper methods."""

    app: Application

    @pytest.fixture(autouse=True)
    def _inject_app(self, application: Application) -> None:
        """Auto-inject app fixture into self.app."""
        self.app = application
