"""Hashing module config."""

from typing import Literal, NotRequired, TypedDict


class BcryptConfig(TypedDict):
    """Bcrypt hasher config."""

    rounds: int
    prefix: str


class Argon2Config(TypedDict):
    """Argon2 hasher config."""

    time_cost: int
    memory_cost: int
    parallelism: int
    hash_len: int
    salt_len: int


class HashingConfig(TypedDict):
    """Hasher config."""

    driver: Literal["argon2", "bcrypt"]
    argon: NotRequired[Argon2Config]
    bcrypt: NotRequired[BcryptConfig]
