"""Configuration management for NLQL."""

from dataclasses import dataclass, field
from typing import Any


@dataclass
class NLQLConfig:
    """Configuration for NLQL engine.

    Attributes:
        default_limit: Default LIMIT value if not specified in query.
                      Applied when query does not have explicit LIMIT clause.
        enable_caching: Whether to enable query result caching.
                       Reserved for future implementation.
        debug_mode: Enable debug logging and verbose error messages.
                   When True, logs execution steps and detailed error information.
        custom_settings: Additional user-defined settings.
                        Reserved for future extensibility.
    """

    default_limit: int | None = None
    enable_caching: bool = False  # TODO: Not implemented yet
    debug_mode: bool = False
    custom_settings: dict[str, Any] = field(default_factory=dict)  # TODO: Not implemented yet

    @classmethod
    def default(cls) -> "NLQLConfig":
        """Create a default configuration."""
        return cls()

