"""Text processing utility functions."""

import re


def contains_pattern(text: str, pattern: str, case_sensitive: bool = True) -> bool:
    """Check if text contains a pattern.

    Args:
        text: Text to search in
        pattern: Pattern to search for (can be regex)
        case_sensitive: Whether to perform case-sensitive matching

    Returns:
        True if pattern is found, False otherwise
    """
    flags = 0 if case_sensitive else re.IGNORECASE
    return bool(re.search(pattern, text, flags=flags))


def count_occurrences(text: str, substring: str, case_sensitive: bool = True) -> int:
    """Count occurrences of a substring in text.

    Args:
        text: Text to search in
        substring: Substring to count
        case_sensitive: Whether to perform case-sensitive matching

    Returns:
        Number of occurrences
    """
    if not case_sensitive:
        text = text.lower()
        substring = substring.lower()

    return text.count(substring)

