# GitHub Pages Setup Guide

This guide explains how to enable and configure GitHub Pages for the NLQL documentation.

## Overview

The NLQL project uses:
- **MkDocs** with Material theme for documentation
- **GitHub Actions** for automated builds
- **GitHub Pages** for hosting

Documentation URL: https://natural-language-query-language.github.io/python-nlql

## Initial Setup

### 1. Enable GitHub Pages

1. Go to the repository settings:
   ```
   https://github.com/natural-language-query-language/python-nlql/settings/pages
   ```

2. Under "Build and deployment":
   - **Source**: Select "GitHub Actions"
   - This allows the workflow to deploy directly without using `gh-pages` branch

3. Click "Save"

### 2. Verify Workflow Permissions

1. Go to repository settings → Actions → General:
   ```
   https://github.com/natural-language-query-language/python-nlql/settings/actions
   ```

2. Under "Workflow permissions":
   - Select "Read and write permissions"
   - Check "Allow GitHub Actions to create and approve pull requests"
   - Click "Save"

### 3. Trigger First Deployment

**Option A: Push to main branch**

```bash
# Make a change to docs
echo "# Test" >> docs/index.md
git add docs/index.md
git commit -m "Trigger docs deployment"
git push origin main
```

**Option B: Manual trigger**

1. Go to Actions tab:
   ```
   https://github.com/natural-language-query-language/python-nlql/actions
   ```

2. Select "Deploy Documentation" workflow
3. Click "Run workflow" → "Run workflow"

### 4. Monitor Deployment

1. Go to Actions tab to see workflow progress
2. The workflow has two jobs:
   - **Build Documentation**: Builds MkDocs site
   - **Deploy to GitHub Pages**: Deploys to Pages

3. Once completed, visit:
   ```
   https://natural-language-query-language.github.io/python-nlql
   ```

## Workflow Details

### Trigger Conditions

The workflow runs when:
- Changes are pushed to `main` branch affecting:
  - `docs/**` (any documentation files)
  - `mkdocs.yml` (MkDocs configuration)
  - `README.md` or `README_EN.md` (included in docs)
  - `.github/workflows/docs.yml` (workflow itself)
- Manually triggered via GitHub UI

### Build Process

1. **Checkout**: Fetches repository code
2. **Setup Python**: Installs Python 3.11
3. **Install Dependencies**: Installs MkDocs and plugins via `pip install -e ".[docs]"`
4. **Build**: Runs `mkdocs build --strict --verbose`
   - `--strict`: Fail on warnings
   - `--verbose`: Show detailed output
5. **Upload**: Uploads built site as artifact
6. **Deploy**: Deploys to GitHub Pages

### Dependencies

The workflow installs documentation dependencies from `pyproject.toml`:

```toml
[project.optional-dependencies]
docs = [
    "mkdocs>=1.5.0",
    "mkdocs-material>=9.0.0",
    "mkdocstrings[python]>=0.24.0",
]
```

## Troubleshooting

### Error: "Failed to build documentation"

**Cause**: MkDocs build errors (broken links, invalid syntax, etc.)

**Solution**:
1. Build locally to see detailed errors:
   ```bash
   mkdocs build --strict --verbose
   ```
2. Fix errors in documentation
3. Push changes

### Error: "Permission denied"

**Cause**: Workflow doesn't have permission to deploy

**Solution**:
1. Check repository settings → Actions → General
2. Ensure "Read and write permissions" is selected
3. Re-run workflow

### Error: "404 Not Found" after deployment

**Cause**: GitHub Pages not properly configured

**Solution**:
1. Go to repository settings → Pages
2. Ensure "Source" is set to "GitHub Actions"
3. Wait 1-2 minutes for DNS propagation
4. Clear browser cache

### Documentation not updating

**Cause**: Changes not triggering workflow

**Solution**:
1. Check if changes are in monitored paths (`docs/**`, `mkdocs.yml`, etc.)
2. Manually trigger workflow from Actions tab
3. Check workflow logs for errors

## Local Development

### Preview Documentation Locally

```bash
# Install dependencies
pip install -e ".[docs]"

# Serve documentation with live reload
mkdocs serve

# Open browser to http://127.0.0.1:8000
```

### Build Documentation Locally

```bash
# Build static site
mkdocs build

# Output is in site/ directory
# Open site/index.html in browser
```

### Test Strict Mode

```bash
# Build with strict mode (same as CI)
mkdocs build --strict --verbose
```

This will fail on:
- Broken internal links
- Missing files
- Invalid Markdown syntax
- Plugin errors

## Custom Domain (Optional)

If you want to use a custom domain (e.g., `docs.nlql.org`):

### 1. Add CNAME File

Create `docs/CNAME`:
```
docs.nlql.org
```

### 2. Configure DNS

Add DNS records at your domain provider:
```
Type: CNAME
Name: docs
Value: natural-language-query-language.github.io
```

### 3. Update GitHub Settings

1. Go to repository settings → Pages
2. Under "Custom domain", enter: `docs.nlql.org`
3. Check "Enforce HTTPS"
4. Click "Save"

### 4. Update URLs

Update `site_url` in `mkdocs.yml`:
```yaml
site_url: https://docs.nlql.org
```

## Maintenance

### Updating MkDocs or Plugins

1. Update versions in `pyproject.toml`:
   ```toml
   docs = [
       "mkdocs>=1.6.0",  # Updated version
       "mkdocs-material>=9.5.0",
   ]
   ```

2. Test locally:
   ```bash
   pip install -e ".[docs]"
   mkdocs build --strict
   ```

3. Push changes - workflow will use new versions

### Monitoring Deployments

- View deployment history: Settings → Pages → "View deployments"
- View workflow runs: Actions tab
- Check deployment status badge (optional):
  ```markdown
  ![Docs](https://github.com/natural-language-query-language/python-nlql/actions/workflows/docs.yml/badge.svg)
  ```

## Additional Resources

- [GitHub Pages Documentation](https://docs.github.com/en/pages)
- [GitHub Actions Documentation](https://docs.github.com/en/actions)
- [MkDocs Documentation](https://www.mkdocs.org/)
- [Material for MkDocs](https://squidfunk.github.io/mkdocs-material/)

