"""Pytest configuration and fixtures."""

import pytest

from nlql.adapters import MemoryAdapter


@pytest.fixture
def sample_data() -> list[tuple[str, dict]]:
    """Sample data for testing (text, metadata pairs)."""
    return [
        (
            "AI agents are autonomous systems that can perceive and act.",
            {"topic": "AI", "date": "2024-01-01", "length": 60},
        ),
        (
            "Machine learning is a subset of artificial intelligence.",
            {"topic": "ML", "date": "2024-01-02", "length": 56},
        ),
        (
            "Natural language processing enables computers to understand text.",
            {"topic": "NLP", "date": "2024-01-03", "length": 66},
        ),
        (
            "Deep learning uses neural networks with multiple layers.",
            {"topic": "DL", "date": "2024-01-04", "length": 56},
        ),
    ]


@pytest.fixture
def memory_adapter(sample_data: list[tuple[str, dict]]) -> MemoryAdapter:
    """Memory adapter with sample data."""
    adapter = MemoryAdapter()
    for text, metadata in sample_data:
        adapter.add_text(text, metadata)
    return adapter

