# Python script to convert a GitLab-CI OIDC TOken into a PYPI Token
#   PYPI_OIDC_URL - token generated by GitLab with an 'aud' of 'pypi' or 'testpypi'
#   PYPI_ID_TOKEN - PyPI mint-token URL: https://(test.)pypi.org/_/oidc/mint-token
import os

import httpx

resp = httpx.post(
    os.getenv("PYPI_OIDC_URL"),
    json={
        "token": os.getenv("PYPI_ID_TOKEN"),
    },
)
resp.raise_for_status()
print(resp.json()["token"])
