<p align="center">
    <a target="_blank" href='https://github.com/CoderWanFeng/python-office'>
    <img src="https://www.python-office.com/api/img-cdn/github-nav.jpg" alt="github license"/>
    </a>   
</p>
<p align="center">
	👉 <a target="_blank" href="https://www.python-office.com/">项目官网：https://www.python-office.com/</a> 👈
</p>
<p align="center">
	👉 <a target="_blank" href="https://www.python-office.com/api/img-cdn/group/python-office.jpg">本开源项目的交流群</a> 👈
</p>


<p align="center" name="'github">
    <a target="_blank" href='https://github.com/CoderWanFeng/python-office'>
    <img src="https://img.shields.io/github/stars/CoderWanFeng/python-office.svg?style=social" alt="github star"/>
    </a>
    <a target="_blank" href='https://github.com/CoderWanFeng/python-office'>
    <img src="https://img.shields.io/github/contributors/CoderWanFeng/python-office" alt="github contributors"/>
    </a>
    <a target="_blank" href='https://github.com/CoderWanFeng/python-office'>
    <img src="https://img.shields.io/github/forks/CoderWanFeng/python-office" alt="github forks"/>
    </a>
    <a target="_blank" href='https://github.com/CoderWanFeng/python-office'>
    <img src="https://img.shields.io/github/issues/CoderWanFeng/python-office" alt="github issues"/>
    </a>	
    <a target="_blank" href='https://github.com/CoderWanFeng/python-office'>
    <img src="https://img.shields.io/github/issues-pr/CoderWanFeng/python-office" alt="github license"/>
    </a>
    <a target="_blank" href='https://github.com/CoderWanFeng/python-office'>
    <img src="https://img.shields.io/github/license/CoderWanFeng/python-office" alt="github license"/>
    </a>   
</p>

<p align="center" name="gitee">
	<a target="_blank" href='https://gitee.com/CoderWanFeng/python-office/'>
		<img src='https://gitee.com/CoderWanFeng/python-office/badge/star.svg?theme=dark' alt='gitee star'/>
	</a>
	<a target="_blank" href='https://github.com/CoderWanFeng/python-office'>
		<img src="https://gitee.com/CoderWanFeng/python-office/badge/fork.svg?theme=dark" alt="gitee fork"/>
	</a>
	<a target="_blank" href="http://www.python4office.cn/images/qq.jpg">
	<img src="https://img.shields.io/badge/QQ-1090738447-orange"/></a>
</p>





-------------------------------------------------------------------------------

[**🌎English Documentation**](README-EN.md)

-------------------------------------------------------------------------------

## 📚简介

Python-office 是一个 Python 自动化办公第三方库，能解决大部分自动化办公的问题。而且每个功能只需一行代码，不需要小白用户学习 Python 知识，做到了真正的开箱即用。
> 功能持续更新中，提交你的功能需求/参与项目开发，联系👉[开发者微信](https://mp.weixin.qq.com/s/dAm2B09i2ZaqCwhwP-AEdQ)


![](https://www.python-office.com/api/img-cdn/python-office/find_excel_data/group.jpg)
### 🍺特点
- 一键搭建所有 Python + 自动化办公的编程环境。
- 使用一行代码解决大部分自动化办公的问题，不需要小白学习 Python 知识
- 贴合职场办公需求
- 极简编程，学习成本极低，工作效率提升显著


-------------------------------------------------------------------------------

## 📦安装

### 🍊pip 自动下载&更新

```
pip install -i https://pypi.tuna.tsinghua.edu.cn/simple python-office -U
```


-------------------------------------------------------------------------------

## 📝文档

[📘官网：https://www.python-office.com/](https://www.python-office.com/)

全部功能的说明
- 文字教程👉[传送门](https://www.python-office.com/guide/allFunc.html)
- 视频教程👉[传送门](https://www.python-office.com/video/video.html)


## 🛠️包含组件

以下所有功能，都在逐步搭建中。

| 模块                   |     介绍                                                                          |GitHub地址| star|
| ----------------------|---------------------------------------------------------------------------------- |-----|-----|
| PyOfficeRobot                   |     聊天机器人                                                        | https://github.com/CoderWanFeng/PyOfficeRobot |<img src="https://img.shields.io/github/stars/CoderWanFeng/PyOfficeRobot.svg" alt="github star"/>|
| search4file                   |     文档搜索                                                        | https://github.com/CoderWanFeng/search4file |<img src="https://img.shields.io/github/stars/CoderWanFeng/search4file.svg" alt="github star"/>|
| poexcel                 |     excel处理                                              |https://github.com/CoderWanFeng/poexcel |<img src="https://img.shields.io/github/stars/CoderWanFeng/poexcel.svg" alt="github star"/>|
| poword                  |     word处理                                              |https://github.com/CoderWanFeng/poword |<img src="https://img.shields.io/github/stars/CoderWanFeng/poword.svg" alt="github star"/>|
| poppt                   |     ppt处理                                                                     |https://github.com/CoderWanFeng/poppt |<img src="https://img.shields.io/github/stars/CoderWanFeng/poppt.svg" alt="github star"/>|
| popdf                   |     pdf处理                                              |https://github.com/CoderWanFeng/popdf |<img src="https://img.shields.io/github/stars/CoderWanFeng/popdf.svg" alt="github star"/>|
| pofile                  |     文件和文件夹的操作                                          |https://github.com/CoderWanFeng/pofile |<img src="https://img.shields.io/github/stars/CoderWanFeng/pofile.svg" alt="github star"/>|
| wftools                 |     便捷小工具                                        |https://github.com/CoderWanFeng/wftools |<img src="https://img.shields.io/github/stars/CoderWanFeng/wftools.svg" alt="github star"/>|
| poimage                 |     图片处理            |https://github.com/CoderWanFeng/poimage |<img src="https://img.shields.io/github/stars/CoderWanFeng/poimage.svg" alt="github star"/>|
| povideo                 |     视频处理                                          |https://github.com/CoderWanFeng/povideo |<img src="https://img.shields.io/github/stars/CoderWanFeng/povideo.svg" alt="github star"/>|
| web（名称待定）                   |     网站快捷搭建                                         | | |
| email（名称待定）                  |     邮件功能                                                        | | |
| ocr（名称待定）     |     识别功能：文字识别、语音识别                                                         | | |

可以根据需求对每个模块单独引入，也可以通过`import office`方式引入所有模块。


-------------------------------------------------------------------------------

## 🏗️添砖加瓦


### 📐PR的建议

python-office欢迎任何人来添砖加瓦，贡献代码，建议提交的pr（pull request）放在一个单独的文件夹下：

- 在[contributors](https://github.com/CoderWanFeng/python-office/tree/master/contributors)文件夹中，用自己的GitHub名字建一个文件夹；
- 把自己的所有代码，都提交到这个自己的文件夹里；
- 不要改其它任何文件夹里的代码！不要改别人的代码！
- 对别人的代码有疑问，可以直接提issue。



### 🐞提供bug反馈或建议

提交问题反馈时，请务必填写和python-office代码本身有关的问题，不进行有关python学习，甚至是个人练习的知识答疑和讨论。

- [Gitee issue](https://gitee.com/CoderWanFeng/python-office/issues)
- [Github issue](https://github.com/CoderWanFeng/python-office/issues)

-------------------------------------------------------------------------------

## 🪙支持python-office

### 💳捐赠

如果你觉得python-office不错，可以捐赠请维护者喝杯咖啡~，在此表示感谢^_^。

[捐赠给项目](https://gitee.com/CoderWanFeng/python-office) 👈该项捐赠仅用于支持本项目发展使用


-------------------------------------------------------------------------------

## ⭐Star python-office

[![Stargazers over time](https://starchart.cc/CoderWanFeng/python-office.svg)](https://starchart.cc/CoderWanFeng/python-office)

## 📌联系作者


![CoderWanFeng](https://www.python-office.com/api/img-cdn/group/qr-code.jpg)
