__author__ = 'mark'

TESTS_DEBUG = True

"""
Add frequently used test variables in this file.

check https://code.google.com/p/omhe for documentation

###########################
Current Tests Implemented:
###########################

_bg_
*Blood Glucose Level*
bloodglucose
BETA
Only # tags are allowed.	Used to express a blood glucose level.
Range:0-400
bg120, bg135, bg=124, bg120#off the charts today


_bp_
*Blood Pressure*
bloodpressure
BETA
Use either a 'd' or a front slash '/' to delineate between systolic and diastolic readings.
Either 'd' or '/' is required for a valid message.
Use 'p' to denote pulse. # tags are allowed.
The first number always represents systolic pressure.
The second number is always the diastolic pressure.
The third number is always pulse (if given).
Range:
Systolic acceptable range: 50-400.
Diastolic acceptable range:20-200.
Pulse acceptable Range: 30-200.
bp90d123p70, bp=102d80p70, bp140d80p60, bp=140/80p60, bp=120080060

_ci_
*Check In*
ci, checkin, check-in
BETA
# tags are allowed.	Check in to an OMHE service.
ci=Howdy Partner, checkin=Just ate a tofo.#lunch Gross!t

_fm_
*Fat Mass*
fatmass
BETA
'k' suffix indicates kilograms. 'l' suffix indicates lbs. lbs is assumed if no weight provided. # tags are allowed	Used to express a body fat mass.
fm12 fm=20, fm=20k, fatmass=20l#foo

_ffm_
*Free Fat Mass*
freefatmass
BETA
'k' suffix indicates kilograms. 'l' suffix indicates lbs. lbs is assumed if no weight provided.
# tags are allowed	Used to express a body's free fat mass.
ffm12 ffm=20, ffm=20k, freefatmass=20l#foo

_frv_
*freggies*
frv, freggie
BETA
No # tags allowed.
Record a fruit or vegetable eaten. One fruit or vegetable per message.
frv=strawberry, freggie=passionfruit

_md_
*Mood*
mood
BETA
No # tags allowed.
Level of happiness, mood,
or general feeling of well being on a scale of 0-10.
Range:0=none, 10=max
mood9, mood=1

_pbf_
*Percent Body Fat*
percentbodyfat
BETA
# tags are allowed
Used to record the percent of weight that is made up of body fat.
Valid range is 1-95.
pbf12.6 pbf=20, percentbodyfat=41#foo

_pn_
*Pain*
pain
BETA
# tags are allowed
Pain (general) on a scale of 0-10.
Range:0=none, 10=max
pain=0, pain9#back, pain=5#neck

_pts_
*Points*
points, gems
# tags are allowed
Points or rewards
Range: negative or positive integer
pts=-50, points=100 points

_st_
*steps*
steps, spd, fitbit
PROPOSAL
# tags are allowed
Records the number of steps taken in a day.
Optionally indicate time in minutes.
(This is normally a reading from a pedometer).
st=7540, st=1200, st=5050m480#hike

_wt_
*Weight*
weight
BETA
Use the 'k' suffix to denote kilograms.
Use the 'l' suffix to denote pounds(lbs).
Use '.' or 'p' to indicate 1/10ths of the weight unit.
# tags are allowed.
If the 'l' or 'k' is not supplied then the weight unit is inferred based on geography.
For example, pounds as a weight unit is implied in the United states.
wt125, wt=125l, wt85k, wt=155.5l, weight=134p7 wt170l#feel heavy


#########################
Tests to be Implemented:
#########################
_bmi_
*Body Mass Index*
bodymassindex
BETA
Only # tags are allowed	Used to express a body mass index value.
Range:0-100
bmi20, bmi20p5, bmi19.7, bmi=15.2 bmi=12.3#foo


lip
Lipid Profile (including total cholesterol, HDL, LDL and triglycerides)
chol, chl
BETA
Only # tags are allowed	Used to express total cholesterol, HDL, LDL, and triglycerides. All values are required. The first number is total cholesterol, followed by HDL, LDL, and triglycerides, respectively.
lip190h44l126t99, chol190h44l126t99

mc
Menstrual Cycle
mooncycle, mcycle, cyclebeads
BETA
Only # tags are allowed	First day of period.
mcycle, mcycle#start

hr
Personal Health Record
healthrecord
BETA
Only # tags are allowed	Report/add a PHR by URL reference. 'hr' may be followed by a valid URL.
hr#someinfo, hr=http://foobar.com/myphr.xml#ccr, hr=https://myphr.foo/mypage.pdf

hc
Health Card
healthcard
BETA
Only # tags are allowed	Report/add a Health benefits card by URL reference. 'hc' may be followed by a valid URL.
hc#someinfo, hc=http://myplan.com/mycard.xml, hchttp://mysite.com/myplan.pdf#bcbs

zeo
Zeo Sleep Score
sleepscore
BETA
Range:0-100
A number between 1-100 is required. # tags are allowed	A sleep score generated by the Zeo sleep machine (http://myzeo.com).
zeo=77, sleepscore99

hp
Help
help
BETA
# tags are allowed.	Ask an OMHE service for help.
help, helpbg, help=hc, helpweight

ok
OK - an affirmative response
okay, y
BETA
# tags are allowed.	Answer yes or confirm
ok, y, y#good

sta
Start
start, begin
BETA
# tags are allowed.	Start using an an OMHE service or begin an enrollment.
start, starthc, startwt, start#great

sto
Stop
stop, end
BETA
# tags are allowed.	Stop using an OMHE service.
stop, stophc, stopwt, stop#i am done

id
Identification Number or User Name
user, identificationumber, username
BETA
none	A username or account number with no spaces. Provided as a convenience function, this often not required because it this can inferred by the phone number twitter name or other transport-level identifier.
id3478342, idBeGoodJ

hid
Hardware Identification Number or String
hardwareid
BETA
# tags are allowed.	A unique identifier to identify the hardware device. Provided as a convenience function, this often not required because it can inferred.
hid3478342, hid 00:03:0d:47:dd:72#mac


"""




