from openagent.core.llm import gen_ai_resp_format
from openagent.models.sentinel import ExecutionEvalulationRequest
from openagent.models.sentinel import ExecutionEvalulationResponse
from openagent.prompts.execution_sentinel import ExecutionSentinelAgentPrompt


class ExecutionSentinelAgent:
    def __init__(self) -> None:
        pass

    def evaluate_step(
        self, step_goal: str, step_response: str
    ) -> ExecutionEvalulationResponse:
        """Evaluate a step response against its goal.

        Args:
            step_goal (str): The goal of the step to be evaluated.
            step_response (str): The response generated by the agent.

        Returns:
            ExecutionEvalulationResponse: The evaluation result.
        """
        eval_request = ExecutionEvalulationRequest(
            step_goal=step_goal, step_response=step_response
        )
        prompt = ExecutionSentinelAgentPrompt(query=eval_request)
        response = gen_ai_resp_format(
            messages=prompt.to_message_chain(),
            resp_cast=ExecutionEvalulationResponse,
        )
        return response
