from pydantic import BaseModel
from pydantic import Field


class ExecutionEvalulationRequest(BaseModel):
    """Request model for execution evaluation."""

    step_goal: str = Field(..., description="The goal of the step to be evaluated.")
    step_response: str = Field(..., description="The response generated by the agent.")

    def to_markdown(self) -> str:
        return f"""
        ### Step Goal
        {self.step_goal}
        ### Step Response
        {self.step_response}
        """.strip()


class ExecutionEvalulationResponse(BaseModel):
    """Response model for execution evaluation."""

    step_goal_fulfilled: bool = Field(
        ..., description="Indicates if the step goal was fulfilled."
    )
    step_missing_info: str | None = Field(
        default=None, description="Any missing information in the step response."
    )
    augmented_goal_for_next_step: str | None = Field(
        default=None,
        description="Augmented goal for the next step if applicable. If step goals were only partially fulfilled, provide a more specific goal for the next step.",
    )
