# do not import all endpoints into this module because that uses a lot of memory and stack frames
# if you need the ability to import all endpoints from this module, import them with
# from python_opendota.apis.path_to_api import path_to_api

import enum


class PathValues(str, enum.Enum):
    MATCHES_MATCH_ID = "/matches/{match_id}"
    PLAYERS_BY_RANK = "/playersByRank"
    PLAYERS_ACCOUNT_ID = "/players/{account_id}"
    PLAYERS_ACCOUNT_ID_WL = "/players/{account_id}/wl"
    PLAYERS_ACCOUNT_ID_RECENT_MATCHES = "/players/{account_id}/recentMatches"
    PLAYERS_ACCOUNT_ID_MATCHES = "/players/{account_id}/matches"
    PLAYERS_ACCOUNT_ID_HEROES = "/players/{account_id}/heroes"
    PLAYERS_ACCOUNT_ID_PEERS = "/players/{account_id}/peers"
    PLAYERS_ACCOUNT_ID_PROS = "/players/{account_id}/pros"
    PLAYERS_ACCOUNT_ID_TOTALS = "/players/{account_id}/totals"
    PLAYERS_ACCOUNT_ID_COUNTS = "/players/{account_id}/counts"
    PLAYERS_ACCOUNT_ID_HISTOGRAMS_FIELD = "/players/{account_id}/histograms/{field}"
    PLAYERS_ACCOUNT_ID_WARDMAP = "/players/{account_id}/wardmap"
    PLAYERS_ACCOUNT_ID_WORDCLOUD = "/players/{account_id}/wordcloud"
    PLAYERS_ACCOUNT_ID_RATINGS = "/players/{account_id}/ratings"
    PLAYERS_ACCOUNT_ID_RANKINGS = "/players/{account_id}/rankings"
    PLAYERS_ACCOUNT_ID_REFRESH = "/players/{account_id}/refresh"
    PRO_PLAYERS = "/proPlayers"
    PRO_MATCHES = "/proMatches"
    PUBLIC_MATCHES = "/publicMatches"
    PARSED_MATCHES = "/parsedMatches"
    EXPLORER = "/explorer"
    METADATA = "/metadata"
    DISTRIBUTIONS = "/distributions"
    SEARCH = "/search"
    RANKINGS = "/rankings"
    BENCHMARKS = "/benchmarks"
    STATUS = "/status"
    HEALTH = "/health"
    REQUEST_JOB_ID = "/request/{jobId}"
    REQUEST_MATCH_ID = "/request/{match_id}"
    FIND_MATCHES = "/findMatches"
    HEROES = "/heroes"
    HERO_STATS = "/heroStats"
    HEROES_HERO_ID_MATCHES = "/heroes/{hero_id}/matches"
    HEROES_HERO_ID_MATCHUPS = "/heroes/{hero_id}/matchups"
    HEROES_HERO_ID_DURATIONS = "/heroes/{hero_id}/durations"
    HEROES_HERO_ID_PLAYERS = "/heroes/{hero_id}/players"
    HEROES_HERO_ID_ITEM_POPULARITY = "/heroes/{hero_id}/itemPopularity"
    LEAGUES = "/leagues"
    LEAGUES_LEAGUE_ID = "/leagues/{league_id}"
    LEAGUES_LEAGUE_ID_MATCHES = "/leagues/{league_id}/matches"
    LEAGUES_LEAGUE_ID_TEAMS = "/leagues/{league_id}/teams"
    TEAMS = "/teams"
    TEAMS_TEAM_ID = "/teams/{team_id}"
    TEAMS_TEAM_ID_MATCHES = "/teams/{team_id}/matches"
    TEAMS_TEAM_ID_PLAYERS = "/teams/{team_id}/players"
    TEAMS_TEAM_ID_HEROES = "/teams/{team_id}/heroes"
    REPLAYS = "/replays"
    RECORDS_FIELD = "/records/{field}"
    LIVE = "/live"
    SCENARIOS_ITEM_TIMINGS = "/scenarios/itemTimings"
    SCENARIOS_LANE_ROLES = "/scenarios/laneRoles"
    SCENARIOS_MISC = "/scenarios/misc"
    SCHEMA = "/schema"
    CONSTANTS_RESOURCE = "/constants/{resource}"
    CONSTANTS = "/constants"
