# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['python_opendota',
 'python_opendota.apis',
 'python_opendota.apis.paths',
 'python_opendota.apis.tags',
 'python_opendota.model',
 'python_opendota.models',
 'python_opendota.paths',
 'python_opendota.paths.benchmarks',
 'python_opendota.paths.constants',
 'python_opendota.paths.constants_resource',
 'python_opendota.paths.distributions',
 'python_opendota.paths.explorer',
 'python_opendota.paths.find_matches',
 'python_opendota.paths.health',
 'python_opendota.paths.hero_stats',
 'python_opendota.paths.heroes',
 'python_opendota.paths.heroes_hero_id_durations',
 'python_opendota.paths.heroes_hero_id_item_popularity',
 'python_opendota.paths.heroes_hero_id_matches',
 'python_opendota.paths.heroes_hero_id_matchups',
 'python_opendota.paths.heroes_hero_id_players',
 'python_opendota.paths.leagues',
 'python_opendota.paths.leagues_league_id',
 'python_opendota.paths.leagues_league_id_matches',
 'python_opendota.paths.leagues_league_id_teams',
 'python_opendota.paths.live',
 'python_opendota.paths.matches_match_id',
 'python_opendota.paths.metadata',
 'python_opendota.paths.parsed_matches',
 'python_opendota.paths.players_account_id',
 'python_opendota.paths.players_account_id_counts',
 'python_opendota.paths.players_account_id_heroes',
 'python_opendota.paths.players_account_id_histograms_field',
 'python_opendota.paths.players_account_id_matches',
 'python_opendota.paths.players_account_id_peers',
 'python_opendota.paths.players_account_id_pros',
 'python_opendota.paths.players_account_id_rankings',
 'python_opendota.paths.players_account_id_ratings',
 'python_opendota.paths.players_account_id_recent_matches',
 'python_opendota.paths.players_account_id_refresh',
 'python_opendota.paths.players_account_id_totals',
 'python_opendota.paths.players_account_id_wardmap',
 'python_opendota.paths.players_account_id_wl',
 'python_opendota.paths.players_account_id_wordcloud',
 'python_opendota.paths.players_by_rank',
 'python_opendota.paths.pro_matches',
 'python_opendota.paths.pro_players',
 'python_opendota.paths.public_matches',
 'python_opendota.paths.rankings',
 'python_opendota.paths.records_field',
 'python_opendota.paths.replays',
 'python_opendota.paths.request_job_id',
 'python_opendota.paths.request_match_id',
 'python_opendota.paths.scenarios_item_timings',
 'python_opendota.paths.scenarios_lane_roles',
 'python_opendota.paths.scenarios_misc',
 'python_opendota.paths.schema',
 'python_opendota.paths.search',
 'python_opendota.paths.status',
 'python_opendota.paths.teams',
 'python_opendota.paths.teams_team_id',
 'python_opendota.paths.teams_team_id_heroes',
 'python_opendota.paths.teams_team_id_matches',
 'python_opendota.paths.teams_team_id_players']

package_data = \
{'': ['*']}

install_requires = \
['python-dateutil>=2.8.2,<3.0.0', 'urllib3>=1.26.9,<2.0.0']

setup_kwargs = {
    'name': 'python-opendota',
    'version': '3.0.0',
    'description': 'Generated Python SDK for working with OpenDota API',
    'long_description': '# python-opendota\n# Introduction\nThe OpenDota API provides Dota 2 related data including advanced match data extracted from match replays.\n\nYou can find data that can be used to convert hero and ability IDs and other information provided by the API from the [dotaconstants](https://github.com/odota/dotaconstants) repository.\n\n**Beginning 2018-04-22, the OpenDota API is limited to 50,000 free calls per month and 60 requests/minute** We offer a Premium Tier with unlimited API calls and higher rate limits. Check out the [API page](https://www.opendota.com/api-keys) to learn more.\n\n\nThis Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:\n\n- API version: 19.0.0\n- Package version: 3.0.0\n- Build package: org.openapitools.codegen.languages.PythonClientCodegen\n\n## Requirements.\n\nPython &gt;&#x3D;3.7\n\n## Migration from other generators like python and python-legacy\n\n### Changes\n1. This generator uses spec case for all (object) property names and parameter names.\n    - So if the spec has a property name like camelCase, it will use camelCase rather than camel_case\n    - So you will need to update how you input and read properties to use spec case\n2. Endpoint parameters are stored in dictionaries to prevent collisions (explanation below)\n    - So you will need to update how you pass data in to endpoints\n3. Endpoint responses now include the original response, the deserialized response body, and (todo)the deserialized headers\n    - So you will need to update your code to use response.body to access deserialized data\n4. All validated data is instantiated in an instance that subclasses all validated Schema classes and Decimal/str/list/tuple/frozendict/NoneClass/BoolClass/bytes/io.FileIO\n    - This means that you can use isinstance to check if a payload validated against a schema class\n    - This means that no data will be of type None/True/False\n        - ingested None will subclass NoneClass\n        - ingested True will subclass BoolClass\n        - ingested False will subclass BoolClass\n        - So if you need to check is True/False/None, instead use instance.is_true_oapg()/.is_false_oapg()/.is_none_oapg()\n5. All validated class instances are immutable except for ones based on io.File\n    - This is because if properties were changed after validation, that validation would no longer apply\n    - So no changing values or property values after a class has been instantiated\n6. String + Number types with formats\n    - String type data is stored as a string and if you need to access types based on its format like date,\n    date-time, uuid, number etc then you will need to use accessor functions on the instance\n    - type string + format: See .as_date_oapg, .as_datetime_oapg, .as_decimal_oapg, .as_uuid_oapg\n    - type number + format: See .as_float_oapg, .as_int_oapg\n    - this was done because openapi/json-schema defines constraints. string data may be type string with no format\n    keyword in one schema, and include a format constraint in another schema\n    - So if you need to access a string format based type, use as_date_oapg/as_datetime_oapg/as_decimal_oapg/as_uuid_oapg\n    - So if you need to access a number format based type, use as_int_oapg/as_float_oapg\n7. Property access on AnyType(type unset) or object(dict) schemas\n    - Only required keys with valid python names are properties like .someProp and have type hints\n    - All optional keys may not exist, so properties are not defined for them\n    - One can access optional values with dict_instance[\'optionalProp\'] and KeyError will be raised if it does not exist\n    - Use get_item_oapg if you need a way to always get a value whether or not the key exists\n        - If the key does not exist, schemas.unset is returned from calling dict_instance.get_item_oapg(\'optionalProp\')\n        - All required and optional keys have type hints for this method, and @typing.overload is used\n        - A type hint is also generated for additionalProperties accessed using this method\n    - So you will need to update you code to use some_instance[\'optionalProp\'] to access optional property\n    and additionalProperty values\n8. The location of the api classes has changed\n    - Api classes are located in your_package.apis.tags.some_api\n    - This change was made to eliminate redundant code generation\n    - Legacy generators generated the same endpoint twice if it had > 1 tag on it\n    - This generator defines an endpoint in one class, then inherits that class to generate\n      apis by tags and by paths\n    - This change reduces code and allows quicker run time if you use the path apis\n        - path apis are at your_package.apis.paths.some_path\n    - Those apis will only load their needed models, which is less to load than all of the resources needed in a tag api\n    - So you will need to update your import paths to the api classes\n\n### Why are Oapg and _oapg used in class and method names?\nClasses can have arbitrarily named properties set on them\nEndpoints can have arbitrary operationId method names set\nFor those reasons, I use the prefix Oapg and _oapg to greatly reduce the likelihood of collisions\non protected + public classes/methods.\noapg stands for OpenApi Python Generator.\n\n### Object property spec case\nThis was done because when payloads are ingested, they can be validated against N number of schemas.\nIf the input signature used a different property name then that has mutated the payload.\nSo SchemaA and SchemaB must both see the camelCase spec named variable.\nAlso it is possible to send in two properties, named camelCase and camel_case in the same payload.\nThat use case should be support so spec case is used.\n\n### Parameter spec case\nParameters can be included in different locations including:\n- query\n- path\n- header\n- cookie\n\nAny of those parameters could use the same parameter names, so if every parameter\nwas included as an endpoint parameter in a function signature, they would collide.\nFor that reason, each of those inputs have been separated out into separate typed dictionaries:\n- query_params\n- path_params\n- header_params\n- cookie_params\n\nSo when updating your code, you will need to pass endpoint parameters in using those\ndictionaries.\n\n### Endpoint responses\nEndpoint responses have been enriched to now include more information.\nAny response reom an endpoint will now include the following properties:\nresponse: urllib3.HTTPResponse\nbody: typing.Union[Unset, Schema]\nheaders: typing.Union[Unset, TODO]\nNote: response header deserialization has not yet been added\n\n\n## Installation & Usage\n### pip install\n\nIf the python package is hosted on a repository, you can install directly using:\n\n```sh\npip install git+https://github.com/swimmwatch/python-opendota.git\n```\n(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/swimmwatch/python-opendota.git`)\n\nThen import the package:\n```python\nimport python_opendota\n```\n\n### Setuptools\n\nInstall via [Setuptools](http://pypi.python.org/pypi/setuptools).\n\n```sh\npython setup.py install --user\n```\n(or `sudo python setup.py install` to install the package for all users)\n\nThen import the package:\n```python\nimport python_opendota\n```\n\n## Getting Started\n\nPlease follow the [installation procedure](#installation--usage) and then run the following:\n\n```python\n\nimport time\nimport python_opendota\nfrom pprint import pprint\nfrom python_opendota.apis.tags import benchmarks_api\n# Defining the host is optional and defaults to http://api.opendota.com/api\n# See configuration.py for a list of all supported configuration parameters.\nconfiguration = python_opendota.Configuration(\n    host = "http://api.opendota.com/api"\n)\n\n\n# Enter a context with an instance of the API client\nwith python_opendota.ApiClient(configuration) as api_client:\n    # Create an instance of the API class\n    api_instance = benchmarks_api.BenchmarksApi(api_client)\n    hero_id = "hero_id_example" # str | Hero ID\n\n    try:\n        # GET /benchmarks\n        api_response = api_instance.benchmarks_get(hero_id)\n        pprint(api_response)\n    except python_opendota.ApiException as e:\n        print("Exception when calling BenchmarksApi->benchmarks_get: %s\\n" % e)\n```\n\n## Documentation for API Endpoints\n\nAll URIs are relative to *http://api.opendota.com/api*\n\nClass | Method | HTTP request | Description\n------------ | ------------- | ------------- | -------------\n*BenchmarksApi* | [**benchmarks_get**](docs/apis/tags/BenchmarksApi.md#benchmarks_get) | **get** /benchmarks | GET /benchmarks\n*ConstantsApi* | [**constants_get**](docs/apis/tags/ConstantsApi.md#constants_get) | **get** /constants | GET /constants\n*ConstantsApi* | [**constants_resource_get**](docs/apis/tags/ConstantsApi.md#constants_resource_get) | **get** /constants/{resource} | GET /constants\n*DistributionsApi* | [**distributions_get**](docs/apis/tags/DistributionsApi.md#distributions_get) | **get** /distributions | GET /distributions\n*ExplorerApi* | [**explorer_get**](docs/apis/tags/ExplorerApi.md#explorer_get) | **get** /explorer | GET /explorer\n*FindMatchesApi* | [**find_matches_get**](docs/apis/tags/FindMatchesApi.md#find_matches_get) | **get** /findMatches | GET /\n*HealthApi* | [**health_get**](docs/apis/tags/HealthApi.md#health_get) | **get** /health | GET /health\n*HeroStatsApi* | [**hero_stats_get**](docs/apis/tags/HeroStatsApi.md#hero_stats_get) | **get** /heroStats | GET /heroStats\n*HeroesApi* | [**heroes_get**](docs/apis/tags/HeroesApi.md#heroes_get) | **get** /heroes | GET /heroes\n*HeroesApi* | [**heroes_hero_id_durations_get**](docs/apis/tags/HeroesApi.md#heroes_hero_id_durations_get) | **get** /heroes/{hero_id}/durations | GET /heroes/{hero_id}/durations\n*HeroesApi* | [**heroes_hero_id_item_popularity_get**](docs/apis/tags/HeroesApi.md#heroes_hero_id_item_popularity_get) | **get** /heroes/{hero_id}/itemPopularity | GET /heroes/{hero_id}/itemPopularity\n*HeroesApi* | [**heroes_hero_id_matches_get**](docs/apis/tags/HeroesApi.md#heroes_hero_id_matches_get) | **get** /heroes/{hero_id}/matches | GET /heroes/{hero_id}/matches\n*HeroesApi* | [**heroes_hero_id_matchups_get**](docs/apis/tags/HeroesApi.md#heroes_hero_id_matchups_get) | **get** /heroes/{hero_id}/matchups | GET /heroes/{hero_id}/matchups\n*HeroesApi* | [**heroes_hero_id_players_get**](docs/apis/tags/HeroesApi.md#heroes_hero_id_players_get) | **get** /heroes/{hero_id}/players | GET /heroes/{hero_id}/players\n*LeaguesApi* | [**leagues_get**](docs/apis/tags/LeaguesApi.md#leagues_get) | **get** /leagues | GET /leagues\n*LeaguesApi* | [**leagues_league_id_get**](docs/apis/tags/LeaguesApi.md#leagues_league_id_get) | **get** /leagues/{league_id} | GET /leagues/{league_id}\n*LeaguesApi* | [**leagues_league_id_matches_get**](docs/apis/tags/LeaguesApi.md#leagues_league_id_matches_get) | **get** /leagues/{league_id}/matches | GET /leagues/{league_id}/matches\n*LeaguesApi* | [**leagues_league_id_teams_get**](docs/apis/tags/LeaguesApi.md#leagues_league_id_teams_get) | **get** /leagues/{league_id}/teams | GET /leagues/{league_id}/teams\n*LiveApi* | [**live_get**](docs/apis/tags/LiveApi.md#live_get) | **get** /live | GET /live\n*MatchesApi* | [**matches_match_id_get**](docs/apis/tags/MatchesApi.md#matches_match_id_get) | **get** /matches/{match_id} | GET /matches/{match_id}\n*MetadataApi* | [**metadata_get**](docs/apis/tags/MetadataApi.md#metadata_get) | **get** /metadata | GET /metadata\n*ParsedMatchesApi* | [**parsed_matches_get**](docs/apis/tags/ParsedMatchesApi.md#parsed_matches_get) | **get** /parsedMatches | GET /parsedMatches\n*PlayersApi* | [**players_account_id_counts_get**](docs/apis/tags/PlayersApi.md#players_account_id_counts_get) | **get** /players/{account_id}/counts | GET /players/{account_id}/counts\n*PlayersApi* | [**players_account_id_get**](docs/apis/tags/PlayersApi.md#players_account_id_get) | **get** /players/{account_id} | GET /players/{account_id}\n*PlayersApi* | [**players_account_id_heroes_get**](docs/apis/tags/PlayersApi.md#players_account_id_heroes_get) | **get** /players/{account_id}/heroes | GET /players/{account_id}/heroes\n*PlayersApi* | [**players_account_id_histograms_field_get**](docs/apis/tags/PlayersApi.md#players_account_id_histograms_field_get) | **get** /players/{account_id}/histograms/{field} | GET /players/{account_id}/histograms\n*PlayersApi* | [**players_account_id_matches_get**](docs/apis/tags/PlayersApi.md#players_account_id_matches_get) | **get** /players/{account_id}/matches | GET /players/{account_id}/matches\n*PlayersApi* | [**players_account_id_peers_get**](docs/apis/tags/PlayersApi.md#players_account_id_peers_get) | **get** /players/{account_id}/peers | GET /players/{account_id}/peers\n*PlayersApi* | [**players_account_id_pros_get**](docs/apis/tags/PlayersApi.md#players_account_id_pros_get) | **get** /players/{account_id}/pros | GET /players/{account_id}/pros\n*PlayersApi* | [**players_account_id_rankings_get**](docs/apis/tags/PlayersApi.md#players_account_id_rankings_get) | **get** /players/{account_id}/rankings | GET /players/{account_id}/rankings\n*PlayersApi* | [**players_account_id_ratings_get**](docs/apis/tags/PlayersApi.md#players_account_id_ratings_get) | **get** /players/{account_id}/ratings | GET /players/{account_id}/ratings\n*PlayersApi* | [**players_account_id_recent_matches_get**](docs/apis/tags/PlayersApi.md#players_account_id_recent_matches_get) | **get** /players/{account_id}/recentMatches | GET /players/{account_id}/recentMatches\n*PlayersApi* | [**players_account_id_refresh_post**](docs/apis/tags/PlayersApi.md#players_account_id_refresh_post) | **post** /players/{account_id}/refresh | POST /players/{account_id}/refresh\n*PlayersApi* | [**players_account_id_totals_get**](docs/apis/tags/PlayersApi.md#players_account_id_totals_get) | **get** /players/{account_id}/totals | GET /players/{account_id}/totals\n*PlayersApi* | [**players_account_id_wardmap_get**](docs/apis/tags/PlayersApi.md#players_account_id_wardmap_get) | **get** /players/{account_id}/wardmap | GET /players/{account_id}/wardmap\n*PlayersApi* | [**players_account_id_wl_get**](docs/apis/tags/PlayersApi.md#players_account_id_wl_get) | **get** /players/{account_id}/wl | GET /players/{account_id}/wl\n*PlayersApi* | [**players_account_id_wordcloud_get**](docs/apis/tags/PlayersApi.md#players_account_id_wordcloud_get) | **get** /players/{account_id}/wordcloud | GET /players/{account_id}/wordcloud\n*PlayersByRankApi* | [**players_by_rank_get**](docs/apis/tags/PlayersByRankApi.md#players_by_rank_get) | **get** /playersByRank | GET /playersByRank\n*ProMatchesApi* | [**pro_matches_get**](docs/apis/tags/ProMatchesApi.md#pro_matches_get) | **get** /proMatches | GET /proMatches\n*ProPlayersApi* | [**pro_players_get**](docs/apis/tags/ProPlayersApi.md#pro_players_get) | **get** /proPlayers | GET /proPlayers\n*PublicMatchesApi* | [**public_matches_get**](docs/apis/tags/PublicMatchesApi.md#public_matches_get) | **get** /publicMatches | GET /publicMatches\n*RankingsApi* | [**rankings_get**](docs/apis/tags/RankingsApi.md#rankings_get) | **get** /rankings | GET /rankings\n*RecordsApi* | [**records_field_get**](docs/apis/tags/RecordsApi.md#records_field_get) | **get** /records/{field} | GET /records/{field}\n*ReplaysApi* | [**replays_get**](docs/apis/tags/ReplaysApi.md#replays_get) | **get** /replays | GET /replays\n*RequestApi* | [**request_job_id_get**](docs/apis/tags/RequestApi.md#request_job_id_get) | **get** /request/{jobId} | GET /request/{jobId}\n*RequestApi* | [**request_match_id_post**](docs/apis/tags/RequestApi.md#request_match_id_post) | **post** /request/{match_id} | POST /request/{match_id}\n*ScenariosApi* | [**scenarios_item_timings_get**](docs/apis/tags/ScenariosApi.md#scenarios_item_timings_get) | **get** /scenarios/itemTimings | GET /scenarios/itemTimings\n*ScenariosApi* | [**scenarios_lane_roles_get**](docs/apis/tags/ScenariosApi.md#scenarios_lane_roles_get) | **get** /scenarios/laneRoles | GET /scenarios/laneRoles\n*ScenariosApi* | [**scenarios_misc_get**](docs/apis/tags/ScenariosApi.md#scenarios_misc_get) | **get** /scenarios/misc | GET /scenarios/misc\n*SchemaApi* | [**schema_get**](docs/apis/tags/SchemaApi.md#schema_get) | **get** /schema | GET /schema\n*SearchApi* | [**search_get**](docs/apis/tags/SearchApi.md#search_get) | **get** /search | GET /search\n*StatusApi* | [**status_get**](docs/apis/tags/StatusApi.md#status_get) | **get** /status | GET /status\n*TeamsApi* | [**teams_get**](docs/apis/tags/TeamsApi.md#teams_get) | **get** /teams | GET /teams\n*TeamsApi* | [**teams_team_id_get**](docs/apis/tags/TeamsApi.md#teams_team_id_get) | **get** /teams/{team_id} | GET /teams/{team_id}\n*TeamsApi* | [**teams_team_id_heroes_get**](docs/apis/tags/TeamsApi.md#teams_team_id_heroes_get) | **get** /teams/{team_id}/heroes | GET /teams/{team_id}/heroes\n*TeamsApi* | [**teams_team_id_matches_get**](docs/apis/tags/TeamsApi.md#teams_team_id_matches_get) | **get** /teams/{team_id}/matches | GET /teams/{team_id}/matches\n*TeamsApi* | [**teams_team_id_players_get**](docs/apis/tags/TeamsApi.md#teams_team_id_players_get) | **get** /teams/{team_id}/players | GET /teams/{team_id}/players\n\n## Documentation For Models\n\n\n## Documentation For Authorization\n\n Authentication schemes defined for the API:\n## api_key\n\n- **Type**: API key\n- **API key parameter name**: api_key\n- **Location**: URL query string\n\n\n## Author\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n## Notes for Large OpenAPI documents\nIf the OpenAPI document is large, imports in python_opendota.apis and python_opendota.models may fail with a\nRecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:\n\nSolution 1:\nUse specific imports for apis and models like:\n- `from python_opendota.apis.default_api import DefaultApi`\n- `from python_opendota.model.pet import Pet`\n\nSolution 1:\nBefore importing the package, adjust the maximum recursion limit as shown below:\n```\nimport sys\nsys.setrecursionlimit(1500)\nimport python_opendota\nfrom python_opendota.apis import *\nfrom python_opendota.models import *\n```\n',
    'author': 'OpenAPI Generator community',
    'author_email': 'team@openapitools.org',
    'maintainer': 'Dmitry Vasiliev',
    'maintainer_email': 'contact.vasiliev.dmitry@gmail.com',
    'url': 'https://docs.opendota.com/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7.2,<4',
}


setup(**setup_kwargs)
