import sys
import os
import random

# Add the project root path (one level up) to the Python search path
sys.path.insert(0, os.path.abspath(os.path.join(os.path.dirname(__file__), "..")))

from openhab import OpenHABClient
from openhab.tests import RulesTest

if __name__ == "__main__":
    # Initialize OpenHAB client
    client = OpenHABClient(url="http://127.0.0.1:8080", username="openhab", password="habopen")
    rulesTest = RulesTest(client)

    random_number = random.randint(0, 100)

    # Example rule data
    ruleID = "test_color-4"
    newRuleData = {
        "uid": "newRule" + random_number,
        "name": "New Rule",
        "description": "This is a new rule",
        "triggers": [],
        "conditions": [],
        "actions": []
    }
    updateData = {"name": "Updated Rule"}

    # Execute functions
    rulesTest.testGetRules()                       # Test #1
    rulesTest.testGetRule(ruleID)            # Test #2
    rulesTest.testCreateRule(newRuleData)           # Test #3
    rulesTest.testUpdateRule("newRule", updateData) # Test #4
    rulesTest.testSetRuleState("newRule", True)     # Test #5
    rulesTest.testSetRuleState("newRule", False)    # Test #5
    rulesTest.testRunNow(ruleID)            # Test #6
    rulesTest.testDeleteRule("newRule")             # Test #7
