## Description

Brief description of the changes in this PR.

## Type of Change

Please check the relevant option(s):

- [ ] 🐛 **Bug fix** (non-breaking change which fixes an issue)
- [ ] ✨ **New feature** (non-breaking change which adds functionality)
- [ ] 💥 **Breaking change** (fix or feature that would cause existing functionality to not work as expected)
- [ ] 📚 **Documentation** (changes to documentation only)
- [ ] 🧹 **Refactor** (code change that neither fixes a bug nor adds a feature)
- [ ] ⚡ **Performance** (code change that improves performance)
- [ ] 🧪 **Tests** (adding missing tests or correcting existing tests)
- [ ] 🔧 **Build/CI** (changes to build system or CI configuration)

## Changes Made

Please describe the changes made in detail:

- 
- 
- 

## Testing

Please describe the tests that you ran to verify your changes:

- [ ] Unit tests pass (`make ci-test`)
- [ ] Integration tests pass
- [ ] Performance tests pass (if applicable)
- [ ] Manual testing performed

## Performance Impact

For performance-related changes, please provide:

- **Benchmark results**: 
- **Memory usage impact**: 
- **Specialization rate improvement**: 

## Breaking Changes

If this is a breaking change, please describe:

- **What breaks**: 
- **Migration guide**: 
- **Deprecation timeline**: 

## Checklist

Please check all items that apply:

- [ ] My code follows the project's style guidelines
- [ ] I have performed a self-review of my own code
- [ ] I have commented my code, particularly in hard-to-understand areas
- [ ] I have made corresponding changes to the documentation
- [ ] My changes generate no new warnings
- [ ] I have added tests that prove my fix is effective or that my feature works
- [ ] New and existing unit tests pass locally with my changes
- [ ] Any dependent changes have been merged and published

## Related Issues

Please link any related issues:

- Closes #(issue_number)
- Related to #(issue_number)
- Part of #(issue_number)

## Screenshots/Recordings

If applicable, add screenshots or recordings to help explain your changes.

## Additional Notes

Any additional information, context, or notes for reviewers.