"""Asynchronous Python client for Overseerr."""

from python_overseerr.exceptions import (
    OverseerrAuthenticationError,
    OverseerrConnectionError,
    OverseerrError,
)
from python_overseerr.models import (
    TV,
    Genre,
    Keyword,
    MediaInfo,
    MediaInfoWithRequests,
    MediaStatus,
    MediaType,
    Movie,
    MovieDetails,
    NotificationConfig,
    NotificationType,
    Person,
    Request,
    RequestCount,
    RequestFilterStatus,
    RequestResponse,
    RequestSortStatus,
    RequestStatus,
    Result,
    SearchResult,
    Status,
    TVDetails,
    User,
    WatchlistEntry,
    WatchlistResponse,
    WebhookNotificationConfig,
    WebhookNotificationOptions,
)
from python_overseerr.overseerr import OverseerrClient

__all__ = [
    "TV",
    "Genre",
    "Keyword",
    "MediaInfo",
    "MediaInfoWithRequests",
    "MediaStatus",
    "MediaType",
    "Movie",
    "MovieDetails",
    "NotificationConfig",
    "NotificationType",
    "OverseerrAuthenticationError",
    "OverseerrClient",
    "OverseerrConnectionError",
    "OverseerrError",
    "Person",
    "Request",
    "RequestCount",
    "RequestFilterStatus",
    "RequestResponse",
    "RequestSortStatus",
    "RequestStatus",
    "Result",
    "SearchResult",
    "Status",
    "TVDetails",
    "User",
    "WatchlistEntry",
    "WatchlistResponse",
    "WebhookNotificationConfig",
    "WebhookNotificationOptions",
]
