# Python Pachyderm

[![PyPI Package latest releasee](https://img.shields.io/pypi/v/python-pachyderm.svg)](https://pypi.python.org/pypi/python-pachyderm)
[![Supported versions](https://img.shields.io/pypi/pyversions/python-pachyderm.svg)](https://pypi.python.org/pypi/python-pachyderm)
[![Slack Status](http://slack.pachyderm.io/badge.svg)](http://slack.pachyderm.io)

Official Python Pachyderm client. Created by [kalugny](https://github.com/kalugny) (formerly kalugny/pypachy), and now maintained by Pachyderm Inc.

## Installation

```bash
pip install python-pachyderm
```

## Usage

### PFS

For PFS-related functionality, you can use [PfsClient](https://pachyderm.github.io/python-pachyderm/python_pachyderm/pfs_client.html#python_pachyderm.pfs_client.PfsClient), which wraps around protobuf/gRPC autogenerated code to make for a more idiomatic Python experience.

Here's an example that creates a repo and adds a file:

```python
import python_pachyderm
client = python_pachyderm.PfsClient()
client.create_repo('test')
with client.commit('test', 'master') as c:
    client.put_file_bytes(c, '/dir_a/data.txt', b'DATA')

```

### PPS

Similarly, we offer a higher-level [PpsClient](https://pachyderm.github.io/python-pachyderm/python_pachyderm/pps_client.html#python_pachyderm.pps_client.PpsClient) for PPS-related functionality. An example:

```python
import python_pachyderm
client = python_pachyderm.PpsClient()
client.list_pipeline()
```

### Everything else

For all other gRPC APIs, we expose the protobuf/gRPC autogenerated code. See the [API docs](https://pachyderm.github.io/python-pachyderm/python_pachyderm/).

## Contributing

This driver is co-maintained by Pachyderm and the community. If you're looking to contribute to the project, this is a fantastic place to get involved.

### Getting started

To run tests, clone the repo, then run:

```
make init
tox
```
