# Python Pachyderm

[![PyPI Package latest releasee](https://img.shields.io/pypi/v/python-pachyderm.svg)](https://pypi.python.org/pypi/python-pachyderm)
[![Supported versions](https://img.shields.io/pypi/pyversions/python-pachyderm.svg)](https://pypi.python.org/pypi/python-pachyderm)
[![Slack Status](http://slack.pachyderm.io/badge.svg)](http://slack.pachyderm.io)

Official Python Pachyderm client. Created by [kalugny](https://github.com/kalugny) (formerly kalugny/pypachy), and now maintained by Pachyderm Inc.

## Installation

```bash
pip install python-pachyderm
```

## Usage

### PFS

For PFS-related functionality, you can use [PfsClient](https://pachyderm.github.io/python-pachyderm/python_pachyderm/pfs_client.m.html#python_pachyderm.pfs_client.PfsClient), which wraps around protobuf/gRPC autogenerated code to make for a more idiomatic Python experience.

Here's an example that creates a repo and adds a file:

```python
import python_pachyderm
client = python_pachyderm.PfsClient()
client.create_repo('test')
with client.commit('test', 'master') as c:
    client.put_file_bytes(c, '/dir_a/data.txt', b'DATA')

```

### PPS

Similarly, we offer a higher-level [PpsClient](https://pachyderm.github.io/python-pachyderm/python_pachyderm/pps_client.m.html#python_pachyderm.pps_client.PpsClient) for PPS-related functionality. An example:

```python
import python_pachyderm
client = python_pachyderm.PpsClient()
client.list_pipeline()
```

### Everything else

For all other gRPC APIs, we expose the protobuf/gRPC autogenerated code. See the [API docs](https://pachyderm.github.io/python-pachyderm/python_pachyderm/).

## Versioning

Prior to python-pachyderm 2.0, this library's versioning synced with pachyderm's core versioning; e.g. version 1.8.5 of this library synced with 1.8.5 of pachyderm core. python-pachyderm 2.0 onwards uses semver instead, so versions are not tied to pachyderm core. This was done for two reasons:

1. Sometimes this library makes breaking or backwards-incompatible changes, which aren't properly conveyed by revision changes.
2. Pachyderm core has stabilized enough that, even if you're using an older version of this library, it will usually work with newer versions of a pachyderm cluster.

However, do note that each version of python-pachyderm is only tested against one version of pachyderm core, and there are ways in which this library may be incompatible with certain versions of pachyderm core. If you are seeing an issue and want to rule out that possibility, consult `CHANGELOG.md` to see what version of pachyderm core was used to build any given version of python-pachyderm. Alternatively, you can consult `version.json` to see what version of pachyderm core is currently being tested against.

As a broad rule of thumb, we recommend working with the latest version of both pachyderm core and python-pachyderm where possible.

## Contributing

This driver is co-maintained by Pachyderm and the community. If you're looking to contribute to the project, this is a fantastic place to get involved.

### Getting started

To run tests, clone the repo, [install jq](https://stedolan.github.io/jq/), then run:

```
make init
tox
```
