# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['python_pachyderm',
 'python_pachyderm.experimental',
 'python_pachyderm.experimental.mixin',
 'python_pachyderm.experimental.proto',
 'python_pachyderm.experimental.proto.v2',
 'python_pachyderm.experimental.proto.v2.admin_v2',
 'python_pachyderm.experimental.proto.v2.auth_v2',
 'python_pachyderm.experimental.proto.v2.debug_v2',
 'python_pachyderm.experimental.proto.v2.enterprise_v2',
 'python_pachyderm.experimental.proto.v2.identity_v2',
 'python_pachyderm.experimental.proto.v2.license_v2',
 'python_pachyderm.experimental.proto.v2.pfs_v2',
 'python_pachyderm.experimental.proto.v2.pps_v2',
 'python_pachyderm.experimental.proto.v2.proxy',
 'python_pachyderm.experimental.proto.v2.transaction_v2',
 'python_pachyderm.experimental.proto.v2.versionpb_v2',
 'python_pachyderm.mixin',
 'python_pachyderm.proto.v2',
 'python_pachyderm.proto.v2.admin',
 'python_pachyderm.proto.v2.auth',
 'python_pachyderm.proto.v2.debug',
 'python_pachyderm.proto.v2.enterprise',
 'python_pachyderm.proto.v2.identity',
 'python_pachyderm.proto.v2.license',
 'python_pachyderm.proto.v2.pfs',
 'python_pachyderm.proto.v2.pps',
 'python_pachyderm.proto.v2.proxy',
 'python_pachyderm.proto.v2.transaction',
 'python_pachyderm.proto.v2.version',
 'python_pachyderm.proto.v2.version.versionpb']

package_data = \
{'': ['*']}

install_requires = \
['betterproto==2.0.0b3',
 'grpc-interceptor>=0.13.0,<0.14.0',
 'grpcio-health-checking>=1.38.0',
 'grpcio>=1.38.0',
 'protobuf>=3.17.1']

extras_require = \
{':python_version < "3.8"': ['importlib-metadata>1.5.1']}

setup_kwargs = {
    'name': 'python-pachyderm',
    'version': '7.2.0',
    'description': 'Python Pachyderm Client',
    'long_description': '# Python Pachyderm\n\n[![PyPI Package latest release](https://img.shields.io/pypi/v/python-pachyderm.svg)](https://pypi.python.org/pypi/python-pachyderm)\n[![Supported versions](https://img.shields.io/pypi/pyversions/python-pachyderm.svg)](https://pypi.python.org/pypi/python-pachyderm)\n[![Slack Status](https://badge.slack.pachyderm.io/badge.svg)](http://slack.pachyderm.io)\n\nOfficial Python Pachyderm client.\n\nThis library provides the autogenerated gRPC/protobuf code for Pachyderm, along with a higher-level and more pythonic `Client` class.\nSee the [API docs](https://python-pachyderm.readthedocs.io/en/stable/).\n\n## Installation\n\n```bash\npip install python-pachyderm\n```\n\n## A Small Taste\n\nHere\'s an example that creates a repo and adds a file:\n\n```python\nimport python_pachyderm\n\n# Connects to a pachyderm cluster on localhost:30650.\n# For other options, see the API docs.\nclient = python_pachyderm.Client()\n\n# Create a pachyderm repo called `test`\nclient.create_repo("test")\n\n# Create a file in `(repo="test", branch="master")` at `/dir_a/data.txt`\n# Similar to `pachctl put file test@master:/dir_a/data.txt`\nwith client.commit("test", "master") as commit:\n    client.put_file_bytes(commit, "/dir_a/data.txt", b"DATA")\n\n# Get back the file\nf = client.get_file(("test", "master"), "/dir_a/data.txt")\nprint(f.read())  # >>> b"DATA"\n```\n\nHow to load a CSV file into a Pandas dataframe\n\n```python\nimport pandas as pd\n\nf = client.get_file(("my_repo", "my_branch"), "/path_to/my_data.csv")\ndf = pd.read_csv(f)\n```\n\nFor more sophisticated examples, [see the examples directory](https://github.com/pachyderm/python-pachyderm/tree/master/examples).\n\n## Versioning\n\nPrior to python-pachyderm 2.0, this library\'s versioning synced with pachyderm\'s core versioning; e.g. version 1.8.5 of this library synced with 1.8.5 of pachyderm core. python-pachyderm 2.0 onwards uses semver instead, so versions are not tied to pachyderm core. This was done for two reasons:\n\n1. Sometimes this library makes breaking or backwards-incompatible changes, which aren\'t properly conveyed by revision changes.\n2. Pachyderm core is stable enough that most features of this library will work for disparate versions of pachyderm clusters. To help ensure this, this library\'s CI tests against several versions of pachyderm core.\n\nHowever, if for whatever reason you need to know which version of pachyderm core a version of python-pachyderm was built with, consult `CHANGELOG.md`. As a broad rule of thumb, we recommend working with the latest version of both pachyderm core and python-pachyderm where possible.\n\n## Contributing\n\nThis driver is co-maintained by Pachyderm and the community. If you\'re looking to contribute to the project, this is a fantastic place to get involved. Take a look at [the contributing guide](./contributing.md) for more info (including testing instructions).\n',
    'author': 'Pachyderm Integrations',
    'author_email': 'integrations@pachyderm.io',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/pachyderm/python-pachyderm',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
