# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: python_pachyderm/proto/v2/pfs/pfs.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import datetime, timedelta
from typing import AsyncIterable, AsyncIterator, Dict, Iterable, List, Optional, Union

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase
import grpclib


class OriginKind(betterproto.Enum):
    """These are the different places where a commit may be originated from"""

    ORIGIN_KIND_UNKNOWN = 0
    USER = 1
    AUTO = 2
    FSCK = 3
    ALIAS = 4


class FileType(betterproto.Enum):
    RESERVED = 0
    FILE = 1
    DIR = 2


class CommitState(betterproto.Enum):
    """
    CommitState describes the states a commit can be in. The states are
    increasingly specific, i.e. a commit that is FINISHED also counts as
    STARTED.
    """

    COMMIT_STATE_UNKNOWN = 0
    STARTED = 1
    READY = 2
    FINISHING = 3
    FINISHED = 4


class Delimiter(betterproto.Enum):
    NONE = 0
    JSON = 1
    LINE = 2
    SQL = 3
    CSV = 4


class SqlDatabaseEgressFileFormatType(betterproto.Enum):
    UNKNOWN = 0
    CSV = 1
    JSON = 2
    PARQUET = 3


@dataclass(eq=False, repr=False)
class Repo(betterproto.Message):
    name: str = betterproto.string_field(1)
    type: str = betterproto.string_field(2)
    project: "Project" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class Branch(betterproto.Message):
    repo: "Repo" = betterproto.message_field(1)
    name: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class File(betterproto.Message):
    commit: "Commit" = betterproto.message_field(1)
    path: str = betterproto.string_field(2)
    datum: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class RepoInfo(betterproto.Message):
    """RepoInfo is the main data structure representing a Repo in etcd"""

    repo: "Repo" = betterproto.message_field(1)
    created: datetime = betterproto.message_field(2)
    size_bytes_upper_bound: int = betterproto.int64_field(3)
    description: str = betterproto.string_field(4)
    branches: List["Branch"] = betterproto.message_field(5)
    # Set by ListRepo and InspectRepo if Pachyderm's auth system is active, but
    # not stored in etcd. To set a user's auth scope for a repo, use the
    # Pachyderm Auth API (in src/client/auth/auth.proto)
    auth_info: "RepoAuthInfo" = betterproto.message_field(6)
    details: "RepoInfoDetails" = betterproto.message_field(7)


@dataclass(eq=False, repr=False)
class RepoInfoDetails(betterproto.Message):
    """Details are only provided when explicitly requested"""

    size_bytes: int = betterproto.int64_field(1)


@dataclass(eq=False, repr=False)
class RepoAuthInfo(betterproto.Message):
    """
    RepoAuthInfo includes the caller's access scope for a repo, and is returned
    by ListRepo and InspectRepo but not persisted in etcd. It's used by the
    Pachyderm dashboard to render repo access appropriately. To set a user's
    auth scope for a repo, use the Pachyderm Auth API (in
    src/client/auth/auth.proto)
    """

    # The callers access level to the relevant repo. These are very granular
    # permissions - for the end user it makes sense to show them the roles they
    # have instead.
    permissions: List["_auth_v2__.Permission"] = betterproto.enum_field(1)
    # The caller's roles on the relevant repo. This includes inherited roles from
    # the cluster, group membership, etc.
    roles: List[str] = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class BranchInfo(betterproto.Message):
    branch: "Branch" = betterproto.message_field(1)
    head: "Commit" = betterproto.message_field(2)
    provenance: List["Branch"] = betterproto.message_field(3)
    subvenance: List["Branch"] = betterproto.message_field(4)
    direct_provenance: List["Branch"] = betterproto.message_field(5)
    trigger: "Trigger" = betterproto.message_field(6)


@dataclass(eq=False, repr=False)
class Trigger(betterproto.Message):
    """
    Trigger defines the conditions under which a head is moved, and to which
    branch it is moved.
    """

    # Which branch this trigger refers to
    branch: str = betterproto.string_field(1)
    # All indicates that all conditions must be satisfied before the trigger
    # happens, otherwise any conditions being satisfied will trigger it.
    all: bool = betterproto.bool_field(2)
    # Triggers if the cron spec has been satisfied since the last trigger and
    # there's been a new commit.
    cron_spec: str = betterproto.string_field(3)
    # Triggers if there's been `size` new data added since the last trigger.
    size: str = betterproto.string_field(4)
    # Triggers if there's been `commits` new commits added since the last
    # trigger.
    commits: int = betterproto.int64_field(5)


@dataclass(eq=False, repr=False)
class CommitOrigin(betterproto.Message):
    kind: "OriginKind" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class Commit(betterproto.Message):
    """
    Commit is a reference to a commit (e.g. the collection of branches and the
    collection of currently-open commits in etcd are collections of Commit
    protos)
    """

    branch: "Branch" = betterproto.message_field(1)
    id: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class CommitInfo(betterproto.Message):
    """CommitInfo is the main data structure representing a commit in etcd"""

    commit: "Commit" = betterproto.message_field(1)
    origin: "CommitOrigin" = betterproto.message_field(2)
    # description is a user-provided script describing this commit
    description: str = betterproto.string_field(3)
    parent_commit: "Commit" = betterproto.message_field(4)
    child_commits: List["Commit"] = betterproto.message_field(5)
    started: datetime = betterproto.message_field(6)
    finishing: datetime = betterproto.message_field(7)
    finished: datetime = betterproto.message_field(8)
    direct_provenance: List["Branch"] = betterproto.message_field(9)
    error: str = betterproto.string_field(10)
    size_bytes_upper_bound: int = betterproto.int64_field(11)
    details: "CommitInfoDetails" = betterproto.message_field(12)


@dataclass(eq=False, repr=False)
class CommitInfoDetails(betterproto.Message):
    """Details are only provided when explicitly requested"""

    size_bytes: int = betterproto.int64_field(1)
    compacting_time: timedelta = betterproto.message_field(2)
    validating_time: timedelta = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class CommitSet(betterproto.Message):
    id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class CommitSetInfo(betterproto.Message):
    commit_set: "CommitSet" = betterproto.message_field(1)
    commits: List["CommitInfo"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class FileInfo(betterproto.Message):
    file: "File" = betterproto.message_field(1)
    file_type: "FileType" = betterproto.enum_field(2)
    committed: datetime = betterproto.message_field(3)
    size_bytes: int = betterproto.int64_field(4)
    hash: bytes = betterproto.bytes_field(5)


@dataclass(eq=False, repr=False)
class Project(betterproto.Message):
    name: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class ProjectInfo(betterproto.Message):
    project: "Project" = betterproto.message_field(1)
    description: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class CreateRepoRequest(betterproto.Message):
    repo: "Repo" = betterproto.message_field(1)
    description: str = betterproto.string_field(2)
    update: bool = betterproto.bool_field(3)


@dataclass(eq=False, repr=False)
class InspectRepoRequest(betterproto.Message):
    repo: "Repo" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class ListRepoRequest(betterproto.Message):
    # type is the type of (system) repos that should be returned an empty string
    # requests all repos
    type: str = betterproto.string_field(1)
    # projects filters out repos that do not belong in the list, while no
    # projects means list all repos.
    projects: List["Project"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class DeleteRepoRequest(betterproto.Message):
    repo: "Repo" = betterproto.message_field(1)
    force: bool = betterproto.bool_field(2)


@dataclass(eq=False, repr=False)
class DeleteReposRequest(betterproto.Message):
    """DeleteReposRequest is used to delete more than one repo at once."""

    # All repos in each project will be deleted if the caller has permission.
    projects: List["Project"] = betterproto.message_field(1)
    force: bool = betterproto.bool_field(2)
    # If all is set, then all repos in all projects will be deleted if the caller
    # has permission.
    all: bool = betterproto.bool_field(3)


@dataclass(eq=False, repr=False)
class DeleteReposResponse(betterproto.Message):
    repos: List["Repo"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class StartCommitRequest(betterproto.Message):
    # parent may be empty in which case the commit that Branch points to will be
    # used as the parent. If the branch does not exist, the commit will have no
    # parent.
    parent: "Commit" = betterproto.message_field(1)
    # description is a user-provided string describing this commit
    description: str = betterproto.string_field(2)
    branch: "Branch" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class FinishCommitRequest(betterproto.Message):
    commit: "Commit" = betterproto.message_field(1)
    # description is a user-provided string describing this commit. Setting this
    # will overwrite the description set in StartCommit
    description: str = betterproto.string_field(2)
    error: str = betterproto.string_field(3)
    force: bool = betterproto.bool_field(4)


@dataclass(eq=False, repr=False)
class InspectCommitRequest(betterproto.Message):
    commit: "Commit" = betterproto.message_field(1)
    # Wait causes inspect commit to wait until the commit is in the desired
    # state.
    wait: "CommitState" = betterproto.enum_field(2)


@dataclass(eq=False, repr=False)
class ListCommitRequest(betterproto.Message):
    repo: "Repo" = betterproto.message_field(1)
    from_: "Commit" = betterproto.message_field(2)
    to: "Commit" = betterproto.message_field(3)
    number: int = betterproto.int64_field(4)
    reverse: bool = betterproto.bool_field(5)
    all: bool = betterproto.bool_field(6)
    origin_kind: "OriginKind" = betterproto.enum_field(7)
    started_time: datetime = betterproto.message_field(8)


@dataclass(eq=False, repr=False)
class InspectCommitSetRequest(betterproto.Message):
    commit_set: "CommitSet" = betterproto.message_field(1)
    wait: bool = betterproto.bool_field(2)


@dataclass(eq=False, repr=False)
class ListCommitSetRequest(betterproto.Message):
    project: "Project" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class SquashCommitSetRequest(betterproto.Message):
    commit_set: "CommitSet" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class DropCommitSetRequest(betterproto.Message):
    commit_set: "CommitSet" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class SubscribeCommitRequest(betterproto.Message):
    repo: "Repo" = betterproto.message_field(1)
    branch: str = betterproto.string_field(2)
    # only commits created since this commit are returned
    from_: "Commit" = betterproto.message_field(3)
    # Don't return commits until they're in (at least) the desired state.
    state: "CommitState" = betterproto.enum_field(4)
    all: bool = betterproto.bool_field(5)
    origin_kind: "OriginKind" = betterproto.enum_field(6)


@dataclass(eq=False, repr=False)
class ClearCommitRequest(betterproto.Message):
    commit: "Commit" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class CreateBranchRequest(betterproto.Message):
    head: "Commit" = betterproto.message_field(1)
    branch: "Branch" = betterproto.message_field(2)
    provenance: List["Branch"] = betterproto.message_field(3)
    trigger: "Trigger" = betterproto.message_field(4)
    new_commit_set: bool = betterproto.bool_field(5)


@dataclass(eq=False, repr=False)
class InspectBranchRequest(betterproto.Message):
    branch: "Branch" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class ListBranchRequest(betterproto.Message):
    repo: "Repo" = betterproto.message_field(1)
    reverse: bool = betterproto.bool_field(2)


@dataclass(eq=False, repr=False)
class DeleteBranchRequest(betterproto.Message):
    branch: "Branch" = betterproto.message_field(1)
    force: bool = betterproto.bool_field(2)


@dataclass(eq=False, repr=False)
class CreateProjectRequest(betterproto.Message):
    project: "Project" = betterproto.message_field(1)
    description: str = betterproto.string_field(2)
    update: bool = betterproto.bool_field(3)


@dataclass(eq=False, repr=False)
class InspectProjectRequest(betterproto.Message):
    project: "Project" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class ListProjectRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class DeleteProjectRequest(betterproto.Message):
    project: "Project" = betterproto.message_field(1)
    force: bool = betterproto.bool_field(2)


@dataclass(eq=False, repr=False)
class AddFile(betterproto.Message):
    path: str = betterproto.string_field(1)
    datum: str = betterproto.string_field(2)
    raw: Optional[bytes] = betterproto.message_field(
        3, wraps=betterproto.TYPE_BYTES, group="source"
    )
    url: "AddFileUrlSource" = betterproto.message_field(4, group="source")


@dataclass(eq=False, repr=False)
class AddFileUrlSource(betterproto.Message):
    url: str = betterproto.string_field(1)
    recursive: bool = betterproto.bool_field(2)
    concurrency: int = betterproto.uint32_field(3)


@dataclass(eq=False, repr=False)
class DeleteFile(betterproto.Message):
    path: str = betterproto.string_field(1)
    datum: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class CopyFile(betterproto.Message):
    dst: str = betterproto.string_field(1)
    datum: str = betterproto.string_field(2)
    src: "File" = betterproto.message_field(3)
    append: bool = betterproto.bool_field(4)


@dataclass(eq=False, repr=False)
class ModifyFileRequest(betterproto.Message):
    set_commit: "Commit" = betterproto.message_field(1, group="body")
    add_file: "AddFile" = betterproto.message_field(2, group="body")
    delete_file: "DeleteFile" = betterproto.message_field(3, group="body")
    copy_file: "CopyFile" = betterproto.message_field(4, group="body")


@dataclass(eq=False, repr=False)
class GetFileRequest(betterproto.Message):
    file: "File" = betterproto.message_field(1)
    url: str = betterproto.string_field(2)
    offset: int = betterproto.int64_field(3)
    path_range: "PathRange" = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class InspectFileRequest(betterproto.Message):
    file: "File" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class ListFileRequest(betterproto.Message):
    # File is the parent directory of the files we want to list. This sets the
    # repo, the commit/branch, and path prefix of files we're interested in If
    # the "path" field is omitted, a list of files at the top level of the repo
    # is returned
    file: "File" = betterproto.message_field(1)
    # Marker for pagination. If set, the files that come after the marker in
    # lexicographical order will be returned. If reverse is also set, the files
    # that come before the marker in lexicographical order will be returned.
    pagination_marker: "File" = betterproto.message_field(3)
    # Number of files to return
    number: int = betterproto.int64_field(4)
    # If true, return files in reverse order
    reverse: bool = betterproto.bool_field(5)


@dataclass(eq=False, repr=False)
class WalkFileRequest(betterproto.Message):
    file: "File" = betterproto.message_field(1)
    # Marker for pagination. If set, the files that come after the marker in
    # lexicographical order will be returned. If reverse is also set, the files
    # that come before the marker in lexicographical order will be returned.
    pagination_marker: "File" = betterproto.message_field(2)
    # Number of files to return
    number: int = betterproto.int64_field(3)
    # If true, return files in reverse order
    reverse: bool = betterproto.bool_field(4)


@dataclass(eq=False, repr=False)
class GlobFileRequest(betterproto.Message):
    commit: "Commit" = betterproto.message_field(1)
    pattern: str = betterproto.string_field(2)
    path_range: "PathRange" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class DiffFileRequest(betterproto.Message):
    new_file: "File" = betterproto.message_field(1)
    # OldFile may be left nil in which case the same path in the parent of
    # NewFile's commit will be used.
    old_file: "File" = betterproto.message_field(2)
    shallow: bool = betterproto.bool_field(3)


@dataclass(eq=False, repr=False)
class DiffFileResponse(betterproto.Message):
    new_file: "FileInfo" = betterproto.message_field(1)
    old_file: "FileInfo" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class FsckRequest(betterproto.Message):
    fix: bool = betterproto.bool_field(1)
    zombie_target: "Commit" = betterproto.message_field(2, group="zombie_check")
    # run zombie data detection against all pipelines
    zombie_all: bool = betterproto.bool_field(3, group="zombie_check")


@dataclass(eq=False, repr=False)
class FsckResponse(betterproto.Message):
    fix: str = betterproto.string_field(1)
    error: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class CreateFileSetResponse(betterproto.Message):
    file_set_id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class GetFileSetRequest(betterproto.Message):
    commit: "Commit" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class AddFileSetRequest(betterproto.Message):
    commit: "Commit" = betterproto.message_field(1)
    file_set_id: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class RenewFileSetRequest(betterproto.Message):
    file_set_id: str = betterproto.string_field(1)
    ttl_seconds: int = betterproto.int64_field(2)


@dataclass(eq=False, repr=False)
class ComposeFileSetRequest(betterproto.Message):
    file_set_ids: List[str] = betterproto.string_field(1)
    ttl_seconds: int = betterproto.int64_field(2)
    compact: bool = betterproto.bool_field(3)


@dataclass(eq=False, repr=False)
class ShardFileSetRequest(betterproto.Message):
    file_set_id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class PathRange(betterproto.Message):
    lower: str = betterproto.string_field(1)
    upper: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class ShardFileSetResponse(betterproto.Message):
    shards: List["PathRange"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class CheckStorageRequest(betterproto.Message):
    read_chunk_data: bool = betterproto.bool_field(1)
    chunk_begin: bytes = betterproto.bytes_field(2)
    chunk_end: bytes = betterproto.bytes_field(3)


@dataclass(eq=False, repr=False)
class CheckStorageResponse(betterproto.Message):
    chunk_object_count: int = betterproto.int64_field(1)


@dataclass(eq=False, repr=False)
class PutCacheRequest(betterproto.Message):
    key: str = betterproto.string_field(1)
    value: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(2)
    file_set_ids: List[str] = betterproto.string_field(3)
    tag: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class GetCacheRequest(betterproto.Message):
    key: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class GetCacheResponse(betterproto.Message):
    value: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class ClearCacheRequest(betterproto.Message):
    tag_prefix: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class ActivateAuthRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class ActivateAuthResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class RunLoadTestRequest(betterproto.Message):
    spec: str = betterproto.string_field(1)
    branch: "Branch" = betterproto.message_field(2)
    seed: int = betterproto.int64_field(3)
    state_id: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class RunLoadTestResponse(betterproto.Message):
    spec: str = betterproto.string_field(1)
    branch: "Branch" = betterproto.message_field(2)
    seed: int = betterproto.int64_field(3)
    error: str = betterproto.string_field(4)
    duration: timedelta = betterproto.message_field(5)
    state_id: str = betterproto.string_field(6)


@dataclass(eq=False, repr=False)
class ObjectStorageEgress(betterproto.Message):
    url: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class SqlDatabaseEgress(betterproto.Message):
    url: str = betterproto.string_field(1)
    file_format: "SqlDatabaseEgressFileFormat" = betterproto.message_field(2)
    secret: "SqlDatabaseEgressSecret" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class SqlDatabaseEgressFileFormat(betterproto.Message):
    type: "SqlDatabaseEgressFileFormatType" = betterproto.enum_field(1)
    columns: List[str] = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class SqlDatabaseEgressSecret(betterproto.Message):
    name: str = betterproto.string_field(1)
    key: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class EgressRequest(betterproto.Message):
    commit: "Commit" = betterproto.message_field(1)
    object_storage: "ObjectStorageEgress" = betterproto.message_field(2, group="target")
    sql_database: "SqlDatabaseEgress" = betterproto.message_field(3, group="target")


@dataclass(eq=False, repr=False)
class EgressResponse(betterproto.Message):
    object_storage: "EgressResponseObjectStorageResult" = betterproto.message_field(
        1, group="result"
    )
    sql_database: "EgressResponseSqlDatabaseResult" = betterproto.message_field(
        2, group="result"
    )


@dataclass(eq=False, repr=False)
class EgressResponseObjectStorageResult(betterproto.Message):
    bytes_written: int = betterproto.int64_field(1)


@dataclass(eq=False, repr=False)
class EgressResponseSqlDatabaseResult(betterproto.Message):
    rows_written: Dict[str, int] = betterproto.map_field(
        1, betterproto.TYPE_STRING, betterproto.TYPE_INT64
    )


class ApiStub(betterproto.ServiceStub):
    async def create_repo(
        self, *, repo: "Repo" = None, description: str = "", update: bool = False
    ) -> "betterproto_lib_google_protobuf.Empty":

        request = CreateRepoRequest()
        if repo is not None:
            request.repo = repo
        request.description = description
        request.update = update

        return await self._unary_unary(
            "/pfs_v2.API/CreateRepo", request, betterproto_lib_google_protobuf.Empty
        )

    async def inspect_repo(self, *, repo: "Repo" = None) -> "RepoInfo":

        request = InspectRepoRequest()
        if repo is not None:
            request.repo = repo

        return await self._unary_unary("/pfs_v2.API/InspectRepo", request, RepoInfo)

    async def list_repo(
        self, *, type: str = "", projects: Optional[List["Project"]] = None
    ) -> AsyncIterator["RepoInfo"]:
        projects = projects or []

        request = ListRepoRequest()
        request.type = type
        if projects is not None:
            request.projects = projects

        async for response in self._unary_stream(
            "/pfs_v2.API/ListRepo",
            request,
            RepoInfo,
        ):
            yield response

    async def delete_repo(
        self, *, repo: "Repo" = None, force: bool = False
    ) -> "betterproto_lib_google_protobuf.Empty":

        request = DeleteRepoRequest()
        if repo is not None:
            request.repo = repo
        request.force = force

        return await self._unary_unary(
            "/pfs_v2.API/DeleteRepo", request, betterproto_lib_google_protobuf.Empty
        )

    async def delete_repos(
        self,
        *,
        projects: Optional[List["Project"]] = None,
        force: bool = False,
        all: bool = False,
    ) -> "DeleteReposResponse":
        projects = projects or []

        request = DeleteReposRequest()
        if projects is not None:
            request.projects = projects
        request.force = force
        request.all = all

        return await self._unary_unary(
            "/pfs_v2.API/DeleteRepos", request, DeleteReposResponse
        )

    async def start_commit(
        self, *, parent: "Commit" = None, description: str = "", branch: "Branch" = None
    ) -> "Commit":

        request = StartCommitRequest()
        if parent is not None:
            request.parent = parent
        request.description = description
        if branch is not None:
            request.branch = branch

        return await self._unary_unary("/pfs_v2.API/StartCommit", request, Commit)

    async def finish_commit(
        self,
        *,
        commit: "Commit" = None,
        description: str = "",
        error: str = "",
        force: bool = False,
    ) -> "betterproto_lib_google_protobuf.Empty":

        request = FinishCommitRequest()
        if commit is not None:
            request.commit = commit
        request.description = description
        request.error = error
        request.force = force

        return await self._unary_unary(
            "/pfs_v2.API/FinishCommit", request, betterproto_lib_google_protobuf.Empty
        )

    async def clear_commit(
        self, *, commit: "Commit" = None
    ) -> "betterproto_lib_google_protobuf.Empty":

        request = ClearCommitRequest()
        if commit is not None:
            request.commit = commit

        return await self._unary_unary(
            "/pfs_v2.API/ClearCommit", request, betterproto_lib_google_protobuf.Empty
        )

    async def inspect_commit(
        self, *, commit: "Commit" = None, wait: "CommitState" = None
    ) -> "CommitInfo":

        request = InspectCommitRequest()
        if commit is not None:
            request.commit = commit
        request.wait = wait

        return await self._unary_unary("/pfs_v2.API/InspectCommit", request, CommitInfo)

    async def list_commit(
        self,
        *,
        repo: "Repo" = None,
        from_: "Commit" = None,
        to: "Commit" = None,
        number: int = 0,
        reverse: bool = False,
        all: bool = False,
        origin_kind: "OriginKind" = None,
        started_time: datetime = None,
    ) -> AsyncIterator["CommitInfo"]:

        request = ListCommitRequest()
        if repo is not None:
            request.repo = repo
        if from_ is not None:
            request.from_ = from_
        if to is not None:
            request.to = to
        request.number = number
        request.reverse = reverse
        request.all = all
        request.origin_kind = origin_kind
        if started_time is not None:
            request.started_time = started_time

        async for response in self._unary_stream(
            "/pfs_v2.API/ListCommit",
            request,
            CommitInfo,
        ):
            yield response

    async def subscribe_commit(
        self,
        *,
        repo: "Repo" = None,
        branch: str = "",
        from_: "Commit" = None,
        state: "CommitState" = None,
        all: bool = False,
        origin_kind: "OriginKind" = None,
    ) -> AsyncIterator["CommitInfo"]:

        request = SubscribeCommitRequest()
        if repo is not None:
            request.repo = repo
        request.branch = branch
        if from_ is not None:
            request.from_ = from_
        request.state = state
        request.all = all
        request.origin_kind = origin_kind

        async for response in self._unary_stream(
            "/pfs_v2.API/SubscribeCommit",
            request,
            CommitInfo,
        ):
            yield response

    async def inspect_commit_set(
        self, *, commit_set: "CommitSet" = None, wait: bool = False
    ) -> AsyncIterator["CommitInfo"]:

        request = InspectCommitSetRequest()
        if commit_set is not None:
            request.commit_set = commit_set
        request.wait = wait

        async for response in self._unary_stream(
            "/pfs_v2.API/InspectCommitSet",
            request,
            CommitInfo,
        ):
            yield response

    async def list_commit_set(
        self, *, project: "Project" = None
    ) -> AsyncIterator["CommitSetInfo"]:

        request = ListCommitSetRequest()
        if project is not None:
            request.project = project

        async for response in self._unary_stream(
            "/pfs_v2.API/ListCommitSet",
            request,
            CommitSetInfo,
        ):
            yield response

    async def squash_commit_set(
        self, *, commit_set: "CommitSet" = None
    ) -> "betterproto_lib_google_protobuf.Empty":

        request = SquashCommitSetRequest()
        if commit_set is not None:
            request.commit_set = commit_set

        return await self._unary_unary(
            "/pfs_v2.API/SquashCommitSet",
            request,
            betterproto_lib_google_protobuf.Empty,
        )

    async def drop_commit_set(
        self, *, commit_set: "CommitSet" = None
    ) -> "betterproto_lib_google_protobuf.Empty":

        request = DropCommitSetRequest()
        if commit_set is not None:
            request.commit_set = commit_set

        return await self._unary_unary(
            "/pfs_v2.API/DropCommitSet", request, betterproto_lib_google_protobuf.Empty
        )

    async def create_branch(
        self,
        *,
        head: "Commit" = None,
        branch: "Branch" = None,
        provenance: Optional[List["Branch"]] = None,
        trigger: "Trigger" = None,
        new_commit_set: bool = False,
    ) -> "betterproto_lib_google_protobuf.Empty":
        provenance = provenance or []

        request = CreateBranchRequest()
        if head is not None:
            request.head = head
        if branch is not None:
            request.branch = branch
        if provenance is not None:
            request.provenance = provenance
        if trigger is not None:
            request.trigger = trigger
        request.new_commit_set = new_commit_set

        return await self._unary_unary(
            "/pfs_v2.API/CreateBranch", request, betterproto_lib_google_protobuf.Empty
        )

    async def inspect_branch(self, *, branch: "Branch" = None) -> "BranchInfo":

        request = InspectBranchRequest()
        if branch is not None:
            request.branch = branch

        return await self._unary_unary("/pfs_v2.API/InspectBranch", request, BranchInfo)

    async def list_branch(
        self, *, repo: "Repo" = None, reverse: bool = False
    ) -> AsyncIterator["BranchInfo"]:

        request = ListBranchRequest()
        if repo is not None:
            request.repo = repo
        request.reverse = reverse

        async for response in self._unary_stream(
            "/pfs_v2.API/ListBranch",
            request,
            BranchInfo,
        ):
            yield response

    async def delete_branch(
        self, *, branch: "Branch" = None, force: bool = False
    ) -> "betterproto_lib_google_protobuf.Empty":

        request = DeleteBranchRequest()
        if branch is not None:
            request.branch = branch
        request.force = force

        return await self._unary_unary(
            "/pfs_v2.API/DeleteBranch", request, betterproto_lib_google_protobuf.Empty
        )

    async def modify_file(
        self,
        request_iterator: Union[
            AsyncIterable["ModifyFileRequest"], Iterable["ModifyFileRequest"]
        ],
    ) -> "betterproto_lib_google_protobuf.Empty":

        return await self._stream_unary(
            "/pfs_v2.API/ModifyFile",
            request_iterator,
            ModifyFileRequest,
            betterproto_lib_google_protobuf.Empty,
        )

    async def get_file(
        self,
        *,
        file: "File" = None,
        url: str = "",
        offset: int = 0,
        path_range: "PathRange" = None,
    ) -> AsyncIterator["betterproto_lib_google_protobuf.BytesValue"]:

        request = GetFileRequest()
        if file is not None:
            request.file = file
        request.url = url
        request.offset = offset
        if path_range is not None:
            request.path_range = path_range

        async for response in self._unary_stream(
            "/pfs_v2.API/GetFile",
            request,
            betterproto_lib_google_protobuf.BytesValue,
        ):
            yield response

    async def get_file_tar(
        self,
        *,
        file: "File" = None,
        url: str = "",
        offset: int = 0,
        path_range: "PathRange" = None,
    ) -> AsyncIterator["betterproto_lib_google_protobuf.BytesValue"]:

        request = GetFileRequest()
        if file is not None:
            request.file = file
        request.url = url
        request.offset = offset
        if path_range is not None:
            request.path_range = path_range

        async for response in self._unary_stream(
            "/pfs_v2.API/GetFileTAR",
            request,
            betterproto_lib_google_protobuf.BytesValue,
        ):
            yield response

    async def inspect_file(self, *, file: "File" = None) -> "FileInfo":

        request = InspectFileRequest()
        if file is not None:
            request.file = file

        return await self._unary_unary("/pfs_v2.API/InspectFile", request, FileInfo)

    async def list_file(
        self,
        *,
        file: "File" = None,
        pagination_marker: "File" = None,
        number: int = 0,
        reverse: bool = False,
    ) -> AsyncIterator["FileInfo"]:

        request = ListFileRequest()
        if file is not None:
            request.file = file
        if pagination_marker is not None:
            request.pagination_marker = pagination_marker
        request.number = number
        request.reverse = reverse

        async for response in self._unary_stream(
            "/pfs_v2.API/ListFile",
            request,
            FileInfo,
        ):
            yield response

    async def walk_file(
        self,
        *,
        file: "File" = None,
        pagination_marker: "File" = None,
        number: int = 0,
        reverse: bool = False,
    ) -> AsyncIterator["FileInfo"]:

        request = WalkFileRequest()
        if file is not None:
            request.file = file
        if pagination_marker is not None:
            request.pagination_marker = pagination_marker
        request.number = number
        request.reverse = reverse

        async for response in self._unary_stream(
            "/pfs_v2.API/WalkFile",
            request,
            FileInfo,
        ):
            yield response

    async def glob_file(
        self,
        *,
        commit: "Commit" = None,
        pattern: str = "",
        path_range: "PathRange" = None,
    ) -> AsyncIterator["FileInfo"]:

        request = GlobFileRequest()
        if commit is not None:
            request.commit = commit
        request.pattern = pattern
        if path_range is not None:
            request.path_range = path_range

        async for response in self._unary_stream(
            "/pfs_v2.API/GlobFile",
            request,
            FileInfo,
        ):
            yield response

    async def diff_file(
        self, *, new_file: "File" = None, old_file: "File" = None, shallow: bool = False
    ) -> AsyncIterator["DiffFileResponse"]:

        request = DiffFileRequest()
        if new_file is not None:
            request.new_file = new_file
        if old_file is not None:
            request.old_file = old_file
        request.shallow = shallow

        async for response in self._unary_stream(
            "/pfs_v2.API/DiffFile",
            request,
            DiffFileResponse,
        ):
            yield response

    async def activate_auth(self) -> "ActivateAuthResponse":

        request = ActivateAuthRequest()

        return await self._unary_unary(
            "/pfs_v2.API/ActivateAuth", request, ActivateAuthResponse
        )

    async def delete_all(self) -> "betterproto_lib_google_protobuf.Empty":

        request = betterproto_lib_google_protobuf.Empty()

        return await self._unary_unary(
            "/pfs_v2.API/DeleteAll", request, betterproto_lib_google_protobuf.Empty
        )

    async def fsck(
        self,
        *,
        fix: bool = False,
        zombie_target: "Commit" = None,
        zombie_all: bool = False,
    ) -> AsyncIterator["FsckResponse"]:

        request = FsckRequest()
        request.fix = fix
        if zombie_target is not None:
            request.zombie_target = zombie_target
        request.zombie_all = zombie_all

        async for response in self._unary_stream(
            "/pfs_v2.API/Fsck",
            request,
            FsckResponse,
        ):
            yield response

    async def create_file_set(
        self,
        request_iterator: Union[
            AsyncIterable["ModifyFileRequest"], Iterable["ModifyFileRequest"]
        ],
    ) -> "CreateFileSetResponse":

        return await self._stream_unary(
            "/pfs_v2.API/CreateFileSet",
            request_iterator,
            ModifyFileRequest,
            CreateFileSetResponse,
        )

    async def get_file_set(self, *, commit: "Commit" = None) -> "CreateFileSetResponse":

        request = GetFileSetRequest()
        if commit is not None:
            request.commit = commit

        return await self._unary_unary(
            "/pfs_v2.API/GetFileSet", request, CreateFileSetResponse
        )

    async def add_file_set(
        self, *, commit: "Commit" = None, file_set_id: str = ""
    ) -> "betterproto_lib_google_protobuf.Empty":

        request = AddFileSetRequest()
        if commit is not None:
            request.commit = commit
        request.file_set_id = file_set_id

        return await self._unary_unary(
            "/pfs_v2.API/AddFileSet", request, betterproto_lib_google_protobuf.Empty
        )

    async def renew_file_set(
        self, *, file_set_id: str = "", ttl_seconds: int = 0
    ) -> "betterproto_lib_google_protobuf.Empty":

        request = RenewFileSetRequest()
        request.file_set_id = file_set_id
        request.ttl_seconds = ttl_seconds

        return await self._unary_unary(
            "/pfs_v2.API/RenewFileSet", request, betterproto_lib_google_protobuf.Empty
        )

    async def compose_file_set(
        self,
        *,
        file_set_ids: Optional[List[str]] = None,
        ttl_seconds: int = 0,
        compact: bool = False,
    ) -> "CreateFileSetResponse":
        file_set_ids = file_set_ids or []

        request = ComposeFileSetRequest()
        request.file_set_ids = file_set_ids
        request.ttl_seconds = ttl_seconds
        request.compact = compact

        return await self._unary_unary(
            "/pfs_v2.API/ComposeFileSet", request, CreateFileSetResponse
        )

    async def shard_file_set(self, *, file_set_id: str = "") -> "ShardFileSetResponse":

        request = ShardFileSetRequest()
        request.file_set_id = file_set_id

        return await self._unary_unary(
            "/pfs_v2.API/ShardFileSet", request, ShardFileSetResponse
        )

    async def check_storage(
        self,
        *,
        read_chunk_data: bool = False,
        chunk_begin: bytes = b"",
        chunk_end: bytes = b"",
    ) -> "CheckStorageResponse":

        request = CheckStorageRequest()
        request.read_chunk_data = read_chunk_data
        request.chunk_begin = chunk_begin
        request.chunk_end = chunk_end

        return await self._unary_unary(
            "/pfs_v2.API/CheckStorage", request, CheckStorageResponse
        )

    async def put_cache(
        self,
        *,
        key: str = "",
        value: "betterproto_lib_google_protobuf.Any" = None,
        file_set_ids: Optional[List[str]] = None,
        tag: str = "",
    ) -> "betterproto_lib_google_protobuf.Empty":
        file_set_ids = file_set_ids or []

        request = PutCacheRequest()
        request.key = key
        if value is not None:
            request.value = value
        request.file_set_ids = file_set_ids
        request.tag = tag

        return await self._unary_unary(
            "/pfs_v2.API/PutCache", request, betterproto_lib_google_protobuf.Empty
        )

    async def get_cache(self, *, key: str = "") -> "GetCacheResponse":

        request = GetCacheRequest()
        request.key = key

        return await self._unary_unary(
            "/pfs_v2.API/GetCache", request, GetCacheResponse
        )

    async def clear_cache(
        self, *, tag_prefix: str = ""
    ) -> "betterproto_lib_google_protobuf.Empty":

        request = ClearCacheRequest()
        request.tag_prefix = tag_prefix

        return await self._unary_unary(
            "/pfs_v2.API/ClearCache", request, betterproto_lib_google_protobuf.Empty
        )

    async def run_load_test(
        self,
        *,
        spec: str = "",
        branch: "Branch" = None,
        seed: int = 0,
        state_id: str = "",
    ) -> "RunLoadTestResponse":

        request = RunLoadTestRequest()
        request.spec = spec
        if branch is not None:
            request.branch = branch
        request.seed = seed
        request.state_id = state_id

        return await self._unary_unary(
            "/pfs_v2.API/RunLoadTest", request, RunLoadTestResponse
        )

    async def run_load_test_default(self) -> "RunLoadTestResponse":

        request = betterproto_lib_google_protobuf.Empty()

        return await self._unary_unary(
            "/pfs_v2.API/RunLoadTestDefault", request, RunLoadTestResponse
        )

    async def list_task(
        self, *, group: "Group" = None
    ) -> AsyncIterator["_taskapi__.TaskInfo"]:

        request = _taskapi__.ListTaskRequest()
        if group is not None:
            request.group = group

        async for response in self._unary_stream(
            "/pfs_v2.API/ListTask",
            request,
            _taskapi__.TaskInfo,
        ):
            yield response

    async def egress(
        self,
        *,
        commit: "Commit" = None,
        object_storage: "ObjectStorageEgress" = None,
        sql_database: "SqlDatabaseEgress" = None,
    ) -> "EgressResponse":

        request = EgressRequest()
        if commit is not None:
            request.commit = commit
        if object_storage is not None:
            request.object_storage = object_storage
        if sql_database is not None:
            request.sql_database = sql_database

        return await self._unary_unary("/pfs_v2.API/Egress", request, EgressResponse)

    async def create_project(
        self, *, project: "Project" = None, description: str = "", update: bool = False
    ) -> "betterproto_lib_google_protobuf.Empty":

        request = CreateProjectRequest()
        if project is not None:
            request.project = project
        request.description = description
        request.update = update

        return await self._unary_unary(
            "/pfs_v2.API/CreateProject", request, betterproto_lib_google_protobuf.Empty
        )

    async def inspect_project(self, *, project: "Project" = None) -> "ProjectInfo":

        request = InspectProjectRequest()
        if project is not None:
            request.project = project

        return await self._unary_unary(
            "/pfs_v2.API/InspectProject", request, ProjectInfo
        )

    async def list_project(self) -> AsyncIterator["ProjectInfo"]:

        request = ListProjectRequest()

        async for response in self._unary_stream(
            "/pfs_v2.API/ListProject",
            request,
            ProjectInfo,
        ):
            yield response

    async def delete_project(
        self, *, project: "Project" = None, force: bool = False
    ) -> "betterproto_lib_google_protobuf.Empty":

        request = DeleteProjectRequest()
        if project is not None:
            request.project = project
        request.force = force

        return await self._unary_unary(
            "/pfs_v2.API/DeleteProject", request, betterproto_lib_google_protobuf.Empty
        )


class ApiBase(ServiceBase):
    async def create_repo(
        self, repo: "Repo", description: str, update: bool
    ) -> "betterproto_lib_google_protobuf.Empty":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def inspect_repo(self, repo: "Repo") -> "RepoInfo":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def list_repo(
        self, type: str, projects: Optional[List["Project"]]
    ) -> AsyncIterator["RepoInfo"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delete_repo(
        self, repo: "Repo", force: bool
    ) -> "betterproto_lib_google_protobuf.Empty":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delete_repos(
        self, projects: Optional[List["Project"]], force: bool, all: bool
    ) -> "DeleteReposResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def start_commit(
        self, parent: "Commit", description: str, branch: "Branch"
    ) -> "Commit":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def finish_commit(
        self, commit: "Commit", description: str, error: str, force: bool
    ) -> "betterproto_lib_google_protobuf.Empty":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def clear_commit(
        self, commit: "Commit"
    ) -> "betterproto_lib_google_protobuf.Empty":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def inspect_commit(
        self, commit: "Commit", wait: "CommitState"
    ) -> "CommitInfo":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def list_commit(
        self,
        repo: "Repo",
        from_: "Commit",
        to: "Commit",
        number: int,
        reverse: bool,
        all: bool,
        origin_kind: "OriginKind",
        started_time: datetime,
    ) -> AsyncIterator["CommitInfo"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def subscribe_commit(
        self,
        repo: "Repo",
        branch: str,
        from_: "Commit",
        state: "CommitState",
        all: bool,
        origin_kind: "OriginKind",
    ) -> AsyncIterator["CommitInfo"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def inspect_commit_set(
        self, commit_set: "CommitSet", wait: bool
    ) -> AsyncIterator["CommitInfo"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def list_commit_set(
        self, project: "Project"
    ) -> AsyncIterator["CommitSetInfo"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def squash_commit_set(
        self, commit_set: "CommitSet"
    ) -> "betterproto_lib_google_protobuf.Empty":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def drop_commit_set(
        self, commit_set: "CommitSet"
    ) -> "betterproto_lib_google_protobuf.Empty":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def create_branch(
        self,
        head: "Commit",
        branch: "Branch",
        provenance: Optional[List["Branch"]],
        trigger: "Trigger",
        new_commit_set: bool,
    ) -> "betterproto_lib_google_protobuf.Empty":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def inspect_branch(self, branch: "Branch") -> "BranchInfo":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def list_branch(
        self, repo: "Repo", reverse: bool
    ) -> AsyncIterator["BranchInfo"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delete_branch(
        self, branch: "Branch", force: bool
    ) -> "betterproto_lib_google_protobuf.Empty":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def modify_file(
        self, request_iterator: AsyncIterator["ModifyFileRequest"]
    ) -> "betterproto_lib_google_protobuf.Empty":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_file(
        self, file: "File", url: str, offset: int, path_range: "PathRange"
    ) -> AsyncIterator["betterproto_lib_google_protobuf.BytesValue"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_file_tar(
        self, file: "File", url: str, offset: int, path_range: "PathRange"
    ) -> AsyncIterator["betterproto_lib_google_protobuf.BytesValue"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def inspect_file(self, file: "File") -> "FileInfo":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def list_file(
        self, file: "File", pagination_marker: "File", number: int, reverse: bool
    ) -> AsyncIterator["FileInfo"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def walk_file(
        self, file: "File", pagination_marker: "File", number: int, reverse: bool
    ) -> AsyncIterator["FileInfo"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def glob_file(
        self, commit: "Commit", pattern: str, path_range: "PathRange"
    ) -> AsyncIterator["FileInfo"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def diff_file(
        self, new_file: "File", old_file: "File", shallow: bool
    ) -> AsyncIterator["DiffFileResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def activate_auth(self) -> "ActivateAuthResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delete_all(self) -> "betterproto_lib_google_protobuf.Empty":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def fsck(
        self, fix: bool, zombie_target: "Commit", zombie_all: bool
    ) -> AsyncIterator["FsckResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def create_file_set(
        self, request_iterator: AsyncIterator["ModifyFileRequest"]
    ) -> "CreateFileSetResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_file_set(self, commit: "Commit") -> "CreateFileSetResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def add_file_set(
        self, commit: "Commit", file_set_id: str
    ) -> "betterproto_lib_google_protobuf.Empty":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def renew_file_set(
        self, file_set_id: str, ttl_seconds: int
    ) -> "betterproto_lib_google_protobuf.Empty":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def compose_file_set(
        self, file_set_ids: Optional[List[str]], ttl_seconds: int, compact: bool
    ) -> "CreateFileSetResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def shard_file_set(self, file_set_id: str) -> "ShardFileSetResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def check_storage(
        self, read_chunk_data: bool, chunk_begin: bytes, chunk_end: bytes
    ) -> "CheckStorageResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def put_cache(
        self,
        key: str,
        value: "betterproto_lib_google_protobuf.Any",
        file_set_ids: Optional[List[str]],
        tag: str,
    ) -> "betterproto_lib_google_protobuf.Empty":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_cache(self, key: str) -> "GetCacheResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def clear_cache(
        self, tag_prefix: str
    ) -> "betterproto_lib_google_protobuf.Empty":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def run_load_test(
        self, spec: str, branch: "Branch", seed: int, state_id: str
    ) -> "RunLoadTestResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def run_load_test_default(self) -> "RunLoadTestResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def list_task(self, group: "Group") -> AsyncIterator["_taskapi__.TaskInfo"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def egress(
        self,
        commit: "Commit",
        object_storage: "ObjectStorageEgress",
        sql_database: "SqlDatabaseEgress",
    ) -> "EgressResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def create_project(
        self, project: "Project", description: str, update: bool
    ) -> "betterproto_lib_google_protobuf.Empty":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def inspect_project(self, project: "Project") -> "ProjectInfo":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def list_project(self) -> AsyncIterator["ProjectInfo"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delete_project(
        self, project: "Project", force: bool
    ) -> "betterproto_lib_google_protobuf.Empty":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_create_repo(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "repo": request.repo,
            "description": request.description,
            "update": request.update,
        }

        response = await self.create_repo(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_inspect_repo(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "repo": request.repo,
        }

        response = await self.inspect_repo(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_list_repo(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "type": request.type,
            "projects": request.projects,
        }

        await self._call_rpc_handler_server_stream(
            self.list_repo,
            stream,
            request_kwargs,
        )

    async def __rpc_delete_repo(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "repo": request.repo,
            "force": request.force,
        }

        response = await self.delete_repo(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_delete_repos(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "projects": request.projects,
            "force": request.force,
            "all": request.all,
        }

        response = await self.delete_repos(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_start_commit(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "parent": request.parent,
            "description": request.description,
            "branch": request.branch,
        }

        response = await self.start_commit(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_finish_commit(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "commit": request.commit,
            "description": request.description,
            "error": request.error,
            "force": request.force,
        }

        response = await self.finish_commit(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_clear_commit(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "commit": request.commit,
        }

        response = await self.clear_commit(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_inspect_commit(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "commit": request.commit,
            "wait": request.wait,
        }

        response = await self.inspect_commit(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_list_commit(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "repo": request.repo,
            "from_": request.from_,
            "to": request.to,
            "number": request.number,
            "reverse": request.reverse,
            "all": request.all,
            "origin_kind": request.origin_kind,
            "started_time": request.started_time,
        }

        await self._call_rpc_handler_server_stream(
            self.list_commit,
            stream,
            request_kwargs,
        )

    async def __rpc_subscribe_commit(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "repo": request.repo,
            "branch": request.branch,
            "from_": request.from_,
            "state": request.state,
            "all": request.all,
            "origin_kind": request.origin_kind,
        }

        await self._call_rpc_handler_server_stream(
            self.subscribe_commit,
            stream,
            request_kwargs,
        )

    async def __rpc_inspect_commit_set(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "commit_set": request.commit_set,
            "wait": request.wait,
        }

        await self._call_rpc_handler_server_stream(
            self.inspect_commit_set,
            stream,
            request_kwargs,
        )

    async def __rpc_list_commit_set(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "project": request.project,
        }

        await self._call_rpc_handler_server_stream(
            self.list_commit_set,
            stream,
            request_kwargs,
        )

    async def __rpc_squash_commit_set(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "commit_set": request.commit_set,
        }

        response = await self.squash_commit_set(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_drop_commit_set(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "commit_set": request.commit_set,
        }

        response = await self.drop_commit_set(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_create_branch(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "head": request.head,
            "branch": request.branch,
            "provenance": request.provenance,
            "trigger": request.trigger,
            "new_commit_set": request.new_commit_set,
        }

        response = await self.create_branch(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_inspect_branch(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "branch": request.branch,
        }

        response = await self.inspect_branch(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_list_branch(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "repo": request.repo,
            "reverse": request.reverse,
        }

        await self._call_rpc_handler_server_stream(
            self.list_branch,
            stream,
            request_kwargs,
        )

    async def __rpc_delete_branch(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "branch": request.branch,
            "force": request.force,
        }

        response = await self.delete_branch(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_modify_file(self, stream: grpclib.server.Stream) -> None:
        request_kwargs = {"request_iterator": stream.__aiter__()}

        response = await self.modify_file(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_get_file(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "file": request.file,
            "url": request.url,
            "offset": request.offset,
            "path_range": request.path_range,
        }

        await self._call_rpc_handler_server_stream(
            self.get_file,
            stream,
            request_kwargs,
        )

    async def __rpc_get_file_tar(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "file": request.file,
            "url": request.url,
            "offset": request.offset,
            "path_range": request.path_range,
        }

        await self._call_rpc_handler_server_stream(
            self.get_file_tar,
            stream,
            request_kwargs,
        )

    async def __rpc_inspect_file(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "file": request.file,
        }

        response = await self.inspect_file(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_list_file(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "file": request.file,
            "pagination_marker": request.pagination_marker,
            "number": request.number,
            "reverse": request.reverse,
        }

        await self._call_rpc_handler_server_stream(
            self.list_file,
            stream,
            request_kwargs,
        )

    async def __rpc_walk_file(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "file": request.file,
            "pagination_marker": request.pagination_marker,
            "number": request.number,
            "reverse": request.reverse,
        }

        await self._call_rpc_handler_server_stream(
            self.walk_file,
            stream,
            request_kwargs,
        )

    async def __rpc_glob_file(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "commit": request.commit,
            "pattern": request.pattern,
            "path_range": request.path_range,
        }

        await self._call_rpc_handler_server_stream(
            self.glob_file,
            stream,
            request_kwargs,
        )

    async def __rpc_diff_file(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "new_file": request.new_file,
            "old_file": request.old_file,
            "shallow": request.shallow,
        }

        await self._call_rpc_handler_server_stream(
            self.diff_file,
            stream,
            request_kwargs,
        )

    async def __rpc_activate_auth(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.activate_auth(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_delete_all(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.delete_all(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_fsck(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "fix": request.fix,
            "zombie_target": request.zombie_target,
            "zombie_all": request.zombie_all,
        }

        await self._call_rpc_handler_server_stream(
            self.fsck,
            stream,
            request_kwargs,
        )

    async def __rpc_create_file_set(self, stream: grpclib.server.Stream) -> None:
        request_kwargs = {"request_iterator": stream.__aiter__()}

        response = await self.create_file_set(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_get_file_set(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "commit": request.commit,
        }

        response = await self.get_file_set(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_add_file_set(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "commit": request.commit,
            "file_set_id": request.file_set_id,
        }

        response = await self.add_file_set(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_renew_file_set(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "file_set_id": request.file_set_id,
            "ttl_seconds": request.ttl_seconds,
        }

        response = await self.renew_file_set(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_compose_file_set(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "file_set_ids": request.file_set_ids,
            "ttl_seconds": request.ttl_seconds,
            "compact": request.compact,
        }

        response = await self.compose_file_set(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_shard_file_set(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "file_set_id": request.file_set_id,
        }

        response = await self.shard_file_set(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_check_storage(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "read_chunk_data": request.read_chunk_data,
            "chunk_begin": request.chunk_begin,
            "chunk_end": request.chunk_end,
        }

        response = await self.check_storage(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_put_cache(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "key": request.key,
            "value": request.value,
            "file_set_ids": request.file_set_ids,
            "tag": request.tag,
        }

        response = await self.put_cache(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_get_cache(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "key": request.key,
        }

        response = await self.get_cache(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_clear_cache(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "tag_prefix": request.tag_prefix,
        }

        response = await self.clear_cache(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_run_load_test(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "spec": request.spec,
            "branch": request.branch,
            "seed": request.seed,
            "state_id": request.state_id,
        }

        response = await self.run_load_test(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_run_load_test_default(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.run_load_test_default(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_list_task(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "group": request.group,
        }

        await self._call_rpc_handler_server_stream(
            self.list_task,
            stream,
            request_kwargs,
        )

    async def __rpc_egress(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "commit": request.commit,
            "object_storage": request.object_storage,
            "sql_database": request.sql_database,
        }

        response = await self.egress(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_create_project(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "project": request.project,
            "description": request.description,
            "update": request.update,
        }

        response = await self.create_project(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_inspect_project(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "project": request.project,
        }

        response = await self.inspect_project(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_list_project(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        await self._call_rpc_handler_server_stream(
            self.list_project,
            stream,
            request_kwargs,
        )

    async def __rpc_delete_project(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "project": request.project,
            "force": request.force,
        }

        response = await self.delete_project(**request_kwargs)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/pfs_v2.API/CreateRepo": grpclib.const.Handler(
                self.__rpc_create_repo,
                grpclib.const.Cardinality.UNARY_UNARY,
                CreateRepoRequest,
                betterproto_lib_google_protobuf.Empty,
            ),
            "/pfs_v2.API/InspectRepo": grpclib.const.Handler(
                self.__rpc_inspect_repo,
                grpclib.const.Cardinality.UNARY_UNARY,
                InspectRepoRequest,
                RepoInfo,
            ),
            "/pfs_v2.API/ListRepo": grpclib.const.Handler(
                self.__rpc_list_repo,
                grpclib.const.Cardinality.UNARY_STREAM,
                ListRepoRequest,
                RepoInfo,
            ),
            "/pfs_v2.API/DeleteRepo": grpclib.const.Handler(
                self.__rpc_delete_repo,
                grpclib.const.Cardinality.UNARY_UNARY,
                DeleteRepoRequest,
                betterproto_lib_google_protobuf.Empty,
            ),
            "/pfs_v2.API/DeleteRepos": grpclib.const.Handler(
                self.__rpc_delete_repos,
                grpclib.const.Cardinality.UNARY_UNARY,
                DeleteReposRequest,
                DeleteReposResponse,
            ),
            "/pfs_v2.API/StartCommit": grpclib.const.Handler(
                self.__rpc_start_commit,
                grpclib.const.Cardinality.UNARY_UNARY,
                StartCommitRequest,
                Commit,
            ),
            "/pfs_v2.API/FinishCommit": grpclib.const.Handler(
                self.__rpc_finish_commit,
                grpclib.const.Cardinality.UNARY_UNARY,
                FinishCommitRequest,
                betterproto_lib_google_protobuf.Empty,
            ),
            "/pfs_v2.API/ClearCommit": grpclib.const.Handler(
                self.__rpc_clear_commit,
                grpclib.const.Cardinality.UNARY_UNARY,
                ClearCommitRequest,
                betterproto_lib_google_protobuf.Empty,
            ),
            "/pfs_v2.API/InspectCommit": grpclib.const.Handler(
                self.__rpc_inspect_commit,
                grpclib.const.Cardinality.UNARY_UNARY,
                InspectCommitRequest,
                CommitInfo,
            ),
            "/pfs_v2.API/ListCommit": grpclib.const.Handler(
                self.__rpc_list_commit,
                grpclib.const.Cardinality.UNARY_STREAM,
                ListCommitRequest,
                CommitInfo,
            ),
            "/pfs_v2.API/SubscribeCommit": grpclib.const.Handler(
                self.__rpc_subscribe_commit,
                grpclib.const.Cardinality.UNARY_STREAM,
                SubscribeCommitRequest,
                CommitInfo,
            ),
            "/pfs_v2.API/InspectCommitSet": grpclib.const.Handler(
                self.__rpc_inspect_commit_set,
                grpclib.const.Cardinality.UNARY_STREAM,
                InspectCommitSetRequest,
                CommitInfo,
            ),
            "/pfs_v2.API/ListCommitSet": grpclib.const.Handler(
                self.__rpc_list_commit_set,
                grpclib.const.Cardinality.UNARY_STREAM,
                ListCommitSetRequest,
                CommitSetInfo,
            ),
            "/pfs_v2.API/SquashCommitSet": grpclib.const.Handler(
                self.__rpc_squash_commit_set,
                grpclib.const.Cardinality.UNARY_UNARY,
                SquashCommitSetRequest,
                betterproto_lib_google_protobuf.Empty,
            ),
            "/pfs_v2.API/DropCommitSet": grpclib.const.Handler(
                self.__rpc_drop_commit_set,
                grpclib.const.Cardinality.UNARY_UNARY,
                DropCommitSetRequest,
                betterproto_lib_google_protobuf.Empty,
            ),
            "/pfs_v2.API/CreateBranch": grpclib.const.Handler(
                self.__rpc_create_branch,
                grpclib.const.Cardinality.UNARY_UNARY,
                CreateBranchRequest,
                betterproto_lib_google_protobuf.Empty,
            ),
            "/pfs_v2.API/InspectBranch": grpclib.const.Handler(
                self.__rpc_inspect_branch,
                grpclib.const.Cardinality.UNARY_UNARY,
                InspectBranchRequest,
                BranchInfo,
            ),
            "/pfs_v2.API/ListBranch": grpclib.const.Handler(
                self.__rpc_list_branch,
                grpclib.const.Cardinality.UNARY_STREAM,
                ListBranchRequest,
                BranchInfo,
            ),
            "/pfs_v2.API/DeleteBranch": grpclib.const.Handler(
                self.__rpc_delete_branch,
                grpclib.const.Cardinality.UNARY_UNARY,
                DeleteBranchRequest,
                betterproto_lib_google_protobuf.Empty,
            ),
            "/pfs_v2.API/ModifyFile": grpclib.const.Handler(
                self.__rpc_modify_file,
                grpclib.const.Cardinality.STREAM_UNARY,
                ModifyFileRequest,
                betterproto_lib_google_protobuf.Empty,
            ),
            "/pfs_v2.API/GetFile": grpclib.const.Handler(
                self.__rpc_get_file,
                grpclib.const.Cardinality.UNARY_STREAM,
                GetFileRequest,
                betterproto_lib_google_protobuf.BytesValue,
            ),
            "/pfs_v2.API/GetFileTAR": grpclib.const.Handler(
                self.__rpc_get_file_tar,
                grpclib.const.Cardinality.UNARY_STREAM,
                GetFileRequest,
                betterproto_lib_google_protobuf.BytesValue,
            ),
            "/pfs_v2.API/InspectFile": grpclib.const.Handler(
                self.__rpc_inspect_file,
                grpclib.const.Cardinality.UNARY_UNARY,
                InspectFileRequest,
                FileInfo,
            ),
            "/pfs_v2.API/ListFile": grpclib.const.Handler(
                self.__rpc_list_file,
                grpclib.const.Cardinality.UNARY_STREAM,
                ListFileRequest,
                FileInfo,
            ),
            "/pfs_v2.API/WalkFile": grpclib.const.Handler(
                self.__rpc_walk_file,
                grpclib.const.Cardinality.UNARY_STREAM,
                WalkFileRequest,
                FileInfo,
            ),
            "/pfs_v2.API/GlobFile": grpclib.const.Handler(
                self.__rpc_glob_file,
                grpclib.const.Cardinality.UNARY_STREAM,
                GlobFileRequest,
                FileInfo,
            ),
            "/pfs_v2.API/DiffFile": grpclib.const.Handler(
                self.__rpc_diff_file,
                grpclib.const.Cardinality.UNARY_STREAM,
                DiffFileRequest,
                DiffFileResponse,
            ),
            "/pfs_v2.API/ActivateAuth": grpclib.const.Handler(
                self.__rpc_activate_auth,
                grpclib.const.Cardinality.UNARY_UNARY,
                ActivateAuthRequest,
                ActivateAuthResponse,
            ),
            "/pfs_v2.API/DeleteAll": grpclib.const.Handler(
                self.__rpc_delete_all,
                grpclib.const.Cardinality.UNARY_UNARY,
                betterproto_lib_google_protobuf.Empty,
                betterproto_lib_google_protobuf.Empty,
            ),
            "/pfs_v2.API/Fsck": grpclib.const.Handler(
                self.__rpc_fsck,
                grpclib.const.Cardinality.UNARY_STREAM,
                FsckRequest,
                FsckResponse,
            ),
            "/pfs_v2.API/CreateFileSet": grpclib.const.Handler(
                self.__rpc_create_file_set,
                grpclib.const.Cardinality.STREAM_UNARY,
                ModifyFileRequest,
                CreateFileSetResponse,
            ),
            "/pfs_v2.API/GetFileSet": grpclib.const.Handler(
                self.__rpc_get_file_set,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetFileSetRequest,
                CreateFileSetResponse,
            ),
            "/pfs_v2.API/AddFileSet": grpclib.const.Handler(
                self.__rpc_add_file_set,
                grpclib.const.Cardinality.UNARY_UNARY,
                AddFileSetRequest,
                betterproto_lib_google_protobuf.Empty,
            ),
            "/pfs_v2.API/RenewFileSet": grpclib.const.Handler(
                self.__rpc_renew_file_set,
                grpclib.const.Cardinality.UNARY_UNARY,
                RenewFileSetRequest,
                betterproto_lib_google_protobuf.Empty,
            ),
            "/pfs_v2.API/ComposeFileSet": grpclib.const.Handler(
                self.__rpc_compose_file_set,
                grpclib.const.Cardinality.UNARY_UNARY,
                ComposeFileSetRequest,
                CreateFileSetResponse,
            ),
            "/pfs_v2.API/ShardFileSet": grpclib.const.Handler(
                self.__rpc_shard_file_set,
                grpclib.const.Cardinality.UNARY_UNARY,
                ShardFileSetRequest,
                ShardFileSetResponse,
            ),
            "/pfs_v2.API/CheckStorage": grpclib.const.Handler(
                self.__rpc_check_storage,
                grpclib.const.Cardinality.UNARY_UNARY,
                CheckStorageRequest,
                CheckStorageResponse,
            ),
            "/pfs_v2.API/PutCache": grpclib.const.Handler(
                self.__rpc_put_cache,
                grpclib.const.Cardinality.UNARY_UNARY,
                PutCacheRequest,
                betterproto_lib_google_protobuf.Empty,
            ),
            "/pfs_v2.API/GetCache": grpclib.const.Handler(
                self.__rpc_get_cache,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetCacheRequest,
                GetCacheResponse,
            ),
            "/pfs_v2.API/ClearCache": grpclib.const.Handler(
                self.__rpc_clear_cache,
                grpclib.const.Cardinality.UNARY_UNARY,
                ClearCacheRequest,
                betterproto_lib_google_protobuf.Empty,
            ),
            "/pfs_v2.API/RunLoadTest": grpclib.const.Handler(
                self.__rpc_run_load_test,
                grpclib.const.Cardinality.UNARY_UNARY,
                RunLoadTestRequest,
                RunLoadTestResponse,
            ),
            "/pfs_v2.API/RunLoadTestDefault": grpclib.const.Handler(
                self.__rpc_run_load_test_default,
                grpclib.const.Cardinality.UNARY_UNARY,
                betterproto_lib_google_protobuf.Empty,
                RunLoadTestResponse,
            ),
            "/pfs_v2.API/ListTask": grpclib.const.Handler(
                self.__rpc_list_task,
                grpclib.const.Cardinality.UNARY_STREAM,
                _taskapi__.ListTaskRequest,
                _taskapi__.TaskInfo,
            ),
            "/pfs_v2.API/Egress": grpclib.const.Handler(
                self.__rpc_egress,
                grpclib.const.Cardinality.UNARY_UNARY,
                EgressRequest,
                EgressResponse,
            ),
            "/pfs_v2.API/CreateProject": grpclib.const.Handler(
                self.__rpc_create_project,
                grpclib.const.Cardinality.UNARY_UNARY,
                CreateProjectRequest,
                betterproto_lib_google_protobuf.Empty,
            ),
            "/pfs_v2.API/InspectProject": grpclib.const.Handler(
                self.__rpc_inspect_project,
                grpclib.const.Cardinality.UNARY_UNARY,
                InspectProjectRequest,
                ProjectInfo,
            ),
            "/pfs_v2.API/ListProject": grpclib.const.Handler(
                self.__rpc_list_project,
                grpclib.const.Cardinality.UNARY_STREAM,
                ListProjectRequest,
                ProjectInfo,
            ),
            "/pfs_v2.API/DeleteProject": grpclib.const.Handler(
                self.__rpc_delete_project,
                grpclib.const.Cardinality.UNARY_UNARY,
                DeleteProjectRequest,
                betterproto_lib_google_protobuf.Empty,
            ),
        }


from .. import auth_v2 as _auth_v2__
from .. import taskapi as _taskapi__
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
