#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.
*/
#ifndef _CFFI_USE_EMBEDDING
#  include <pyconfig.h>
#  if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG)
#    define Py_LIMITED_API
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47

#define _CFFI__NUM_PRIM         48
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _CFFI_NUM_EXPORTS 26

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/

#include "papi.h"

/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // int()(float *, float *, long long *, float *)
/*  1 */ _CFFI_OP(_CFFI_OP_POINTER, 53), // float *
/*  2 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/*  3 */ _CFFI_OP(_CFFI_OP_POINTER, 54), // long long *
/*  4 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/*  5 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  6 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // int()(int *)
/*  7 */ _CFFI_OP(_CFFI_OP_POINTER, 11), // int *
/*  8 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  9 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // int()(int *, int)
/* 10 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 11 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/* 12 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 13 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // int()(int)
/* 14 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 15 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 16 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // int()(int, float *, float *, long long *, long long *, long long *, float *)
/* 17 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 18 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 19 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 20 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 21 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 22 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 23 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 24 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 25 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // int()(int, int *)
/* 26 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 27 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 28 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 29 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // int()(int, int *, int *)
/* 30 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 31 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 32 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 33 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 34 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // int()(int, int *, int)
/* 35 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 36 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 37 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 38 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 39 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // int()(int, int)
/* 40 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 41 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 42 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 43 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // int()(int, long long *)
/* 44 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 45 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 46 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 47 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // int()(long long *, int)
/* 48 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 49 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 50 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 51 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // int()(void)
/* 52 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 53 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13), // float
/* 54 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 11), // long long
};

static int _cffi_d_PAPI_accum(int x0, long long * x1)
{
  return PAPI_accum(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PAPI_accum(PyObject *self, PyObject *args)
{
  int x0;
  long long * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "PAPI_accum", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (long long *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(3), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PAPI_accum(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_PAPI_accum _cffi_d_PAPI_accum
#endif

static int _cffi_d_PAPI_accum_counters(long long * x0, int x1)
{
  return PAPI_accum_counters(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PAPI_accum_counters(PyObject *self, PyObject *args)
{
  long long * x0;
  int x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "PAPI_accum_counters", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (long long *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(3), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PAPI_accum_counters(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_PAPI_accum_counters _cffi_d_PAPI_accum_counters
#endif

static int _cffi_d_PAPI_add_event(int x0, int x1)
{
  return PAPI_add_event(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PAPI_add_event(PyObject *self, PyObject *args)
{
  int x0;
  int x1;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "PAPI_add_event", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PAPI_add_event(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_PAPI_add_event _cffi_d_PAPI_add_event
#endif

static int _cffi_d_PAPI_add_events(int x0, int * x1, int x2)
{
  return PAPI_add_events(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PAPI_add_events(PyObject *self, PyObject *args)
{
  int x0;
  int * x1;
  int x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "PAPI_add_events", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (int *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(7), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PAPI_add_events(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_PAPI_add_events _cffi_d_PAPI_add_events
#endif

static int _cffi_d_PAPI_cleanup_eventset(int x0)
{
  return PAPI_cleanup_eventset(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PAPI_cleanup_eventset(PyObject *self, PyObject *arg0)
{
  int x0;
  int result;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PAPI_cleanup_eventset(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_PAPI_cleanup_eventset _cffi_d_PAPI_cleanup_eventset
#endif

static int _cffi_d_PAPI_create_eventset(int * x0)
{
  return PAPI_create_eventset(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PAPI_create_eventset(PyObject *self, PyObject *arg0)
{
  int * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (int *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(7), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PAPI_create_eventset(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_PAPI_create_eventset _cffi_d_PAPI_create_eventset
#endif

static int _cffi_d_PAPI_destroy_eventset(int * x0)
{
  return PAPI_destroy_eventset(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PAPI_destroy_eventset(PyObject *self, PyObject *arg0)
{
  int * x0;
  Py_ssize_t datasize;
  int result;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (int *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(7), arg0) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PAPI_destroy_eventset(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_PAPI_destroy_eventset _cffi_d_PAPI_destroy_eventset
#endif

static int _cffi_d_PAPI_epc(int x0, float * x1, float * x2, long long * x3, long long * x4, long long * x5, float * x6)
{
  return PAPI_epc(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PAPI_epc(PyObject *self, PyObject *args)
{
  int x0;
  float * x1;
  float * x2;
  long long * x3;
  long long * x4;
  long long * x5;
  float * x6;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "PAPI_epc", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (float *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(1), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = (float *)alloca((size_t)datasize);
    memset((void *)x2, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(1), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = (long long *)alloca((size_t)datasize);
    memset((void *)x3, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(3), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = (long long *)alloca((size_t)datasize);
    memset((void *)x4, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(3), arg4) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg5, (char **)&x5);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x5 = (long long *)alloca((size_t)datasize);
    memset((void *)x5, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x5, _cffi_type(3), arg5) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg6, (char **)&x6);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x6 = (float *)alloca((size_t)datasize);
    memset((void *)x6, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x6, _cffi_type(1), arg6) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PAPI_epc(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_PAPI_epc _cffi_d_PAPI_epc
#endif

static int _cffi_d_PAPI_flips(float * x0, float * x1, long long * x2, float * x3)
{
  return PAPI_flips(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PAPI_flips(PyObject *self, PyObject *args)
{
  float * x0;
  float * x1;
  long long * x2;
  float * x3;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "PAPI_flips", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (float *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(1), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (float *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(1), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = (long long *)alloca((size_t)datasize);
    memset((void *)x2, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(3), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = (float *)alloca((size_t)datasize);
    memset((void *)x3, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(1), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PAPI_flips(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_PAPI_flips _cffi_d_PAPI_flips
#endif

static int _cffi_d_PAPI_flops(float * x0, float * x1, long long * x2, float * x3)
{
  return PAPI_flops(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PAPI_flops(PyObject *self, PyObject *args)
{
  float * x0;
  float * x1;
  long long * x2;
  float * x3;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "PAPI_flops", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (float *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(1), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (float *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(1), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = (long long *)alloca((size_t)datasize);
    memset((void *)x2, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(3), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = (float *)alloca((size_t)datasize);
    memset((void *)x3, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(1), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PAPI_flops(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_PAPI_flops _cffi_d_PAPI_flops
#endif

static int _cffi_d_PAPI_ipc(float * x0, float * x1, long long * x2, float * x3)
{
  return PAPI_ipc(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PAPI_ipc(PyObject *self, PyObject *args)
{
  float * x0;
  float * x1;
  long long * x2;
  float * x3;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "PAPI_ipc", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (float *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(1), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (float *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(1), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = (long long *)alloca((size_t)datasize);
    memset((void *)x2, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(3), arg2) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = (float *)alloca((size_t)datasize);
    memset((void *)x3, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(1), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PAPI_ipc(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_PAPI_ipc _cffi_d_PAPI_ipc
#endif

static int _cffi_d_PAPI_is_initialized(void)
{
  return PAPI_is_initialized();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PAPI_is_initialized(PyObject *self, PyObject *noarg)
{
  int result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PAPI_is_initialized(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_PAPI_is_initialized _cffi_d_PAPI_is_initialized
#endif

static int _cffi_d_PAPI_library_init(int x0)
{
  return PAPI_library_init(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PAPI_library_init(PyObject *self, PyObject *arg0)
{
  int x0;
  int result;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PAPI_library_init(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_PAPI_library_init _cffi_d_PAPI_library_init
#endif

static int _cffi_d_PAPI_list_events(int x0, int * x1, int * x2)
{
  return PAPI_list_events(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PAPI_list_events(PyObject *self, PyObject *args)
{
  int x0;
  int * x1;
  int * x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "PAPI_list_events", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (int *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(7), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = (int *)alloca((size_t)datasize);
    memset((void *)x2, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(7), arg2) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PAPI_list_events(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_PAPI_list_events _cffi_d_PAPI_list_events
#endif

static int _cffi_d_PAPI_num_components(void)
{
  return PAPI_num_components();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PAPI_num_components(PyObject *self, PyObject *noarg)
{
  int result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PAPI_num_components(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_PAPI_num_components _cffi_d_PAPI_num_components
#endif

static int _cffi_d_PAPI_num_counters(void)
{
  return PAPI_num_counters();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PAPI_num_counters(PyObject *self, PyObject *noarg)
{
  int result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PAPI_num_counters(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_PAPI_num_counters _cffi_d_PAPI_num_counters
#endif

static int _cffi_d_PAPI_read(int x0, long long * x1)
{
  return PAPI_read(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PAPI_read(PyObject *self, PyObject *args)
{
  int x0;
  long long * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "PAPI_read", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (long long *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(3), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PAPI_read(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_PAPI_read _cffi_d_PAPI_read
#endif

static int _cffi_d_PAPI_read_counters(long long * x0, int x1)
{
  return PAPI_read_counters(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PAPI_read_counters(PyObject *self, PyObject *args)
{
  long long * x0;
  int x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "PAPI_read_counters", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (long long *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(3), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PAPI_read_counters(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_PAPI_read_counters _cffi_d_PAPI_read_counters
#endif

static int _cffi_d_PAPI_remove_event(int x0, int x1)
{
  return PAPI_remove_event(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PAPI_remove_event(PyObject *self, PyObject *args)
{
  int x0;
  int x1;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "PAPI_remove_event", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PAPI_remove_event(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_PAPI_remove_event _cffi_d_PAPI_remove_event
#endif

static int _cffi_d_PAPI_remove_events(int x0, int * x1, int x2)
{
  return PAPI_remove_events(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PAPI_remove_events(PyObject *self, PyObject *args)
{
  int x0;
  int * x1;
  int x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "PAPI_remove_events", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (int *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(7), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PAPI_remove_events(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_PAPI_remove_events _cffi_d_PAPI_remove_events
#endif

static int _cffi_d_PAPI_start(int x0)
{
  return PAPI_start(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PAPI_start(PyObject *self, PyObject *arg0)
{
  int x0;
  int result;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PAPI_start(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_PAPI_start _cffi_d_PAPI_start
#endif

static int _cffi_d_PAPI_start_counters(int * x0, int x1)
{
  return PAPI_start_counters(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PAPI_start_counters(PyObject *self, PyObject *args)
{
  int * x0;
  int x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "PAPI_start_counters", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (int *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(7), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PAPI_start_counters(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_PAPI_start_counters _cffi_d_PAPI_start_counters
#endif

static int _cffi_d_PAPI_state(int x0, int * x1)
{
  return PAPI_state(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PAPI_state(PyObject *self, PyObject *args)
{
  int x0;
  int * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "PAPI_state", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (int *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(7), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PAPI_state(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_PAPI_state _cffi_d_PAPI_state
#endif

static int _cffi_d_PAPI_stop(int x0, long long * x1)
{
  return PAPI_stop(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PAPI_stop(PyObject *self, PyObject *args)
{
  int x0;
  long long * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "PAPI_stop", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (long long *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(3), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PAPI_stop(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_PAPI_stop _cffi_d_PAPI_stop
#endif

static int _cffi_d_PAPI_stop_counters(long long * x0, int x1)
{
  return PAPI_stop_counters(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PAPI_stop_counters(PyObject *self, PyObject *args)
{
  long long * x0;
  int x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "PAPI_stop_counters", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (long long *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(3), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PAPI_stop_counters(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_PAPI_stop_counters _cffi_d_PAPI_stop_counters
#endif

static int _cffi_const_PAPI_ATTACHED(unsigned long long *o)
{
  int n = (PAPI_ATTACHED) <= 0;
  *o = (unsigned long long)((PAPI_ATTACHED) | 0);  /* check that PAPI_ATTACHED is an integer */
  if (!_cffi_check_int(*o, n, 128U))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_CPU_ATTACHED(unsigned long long *o)
{
  int n = (PAPI_CPU_ATTACHED) <= 0;
  *o = (unsigned long long)((PAPI_CPU_ATTACHED) | 0);  /* check that PAPI_CPU_ATTACHED is an integer */
  if (!_cffi_check_int(*o, n, 256U))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_EATTR(unsigned long long *o)
{
  int n = (PAPI_EATTR) <= 0;
  *o = (unsigned long long)((PAPI_EATTR) | 0);  /* check that PAPI_EATTR is an integer */
  if (!_cffi_check_int(*o, n, -22))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_EBUF(unsigned long long *o)
{
  int n = (PAPI_EBUF) <= 0;
  *o = (unsigned long long)((PAPI_EBUF) | 0);  /* check that PAPI_EBUF is an integer */
  if (!_cffi_check_int(*o, n, -20))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_EBUG(unsigned long long *o)
{
  int n = (PAPI_EBUG) <= 0;
  *o = (unsigned long long)((PAPI_EBUG) | 0);  /* check that PAPI_EBUG is an integer */
  if (!_cffi_check_int(*o, n, -6))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_ECLOST(unsigned long long *o)
{
  int n = (PAPI_ECLOST) <= 0;
  *o = (unsigned long long)((PAPI_ECLOST) | 0);  /* check that PAPI_ECLOST is an integer */
  if (!_cffi_check_int(*o, n, -5))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_ECMP(unsigned long long *o)
{
  int n = (PAPI_ECMP) <= 0;
  *o = (unsigned long long)((PAPI_ECMP) | 0);  /* check that PAPI_ECMP is an integer */
  if (!_cffi_check_int(*o, n, -4))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_ECNFLCT(unsigned long long *o)
{
  int n = (PAPI_ECNFLCT) <= 0;
  *o = (unsigned long long)((PAPI_ECNFLCT) | 0);  /* check that PAPI_ECNFLCT is an integer */
  if (!_cffi_check_int(*o, n, -8))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_ECOMBO(unsigned long long *o)
{
  int n = (PAPI_ECOMBO) <= 0;
  *o = (unsigned long long)((PAPI_ECOMBO) | 0);  /* check that PAPI_ECOMBO is an integer */
  if (!_cffi_check_int(*o, n, -24))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_ECOUNT(unsigned long long *o)
{
  int n = (PAPI_ECOUNT) <= 0;
  *o = (unsigned long long)((PAPI_ECOUNT) | 0);  /* check that PAPI_ECOUNT is an integer */
  if (!_cffi_check_int(*o, n, -23))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_EINVAL(unsigned long long *o)
{
  int n = (PAPI_EINVAL) <= 0;
  *o = (unsigned long long)((PAPI_EINVAL) | 0);  /* check that PAPI_EINVAL is an integer */
  if (!_cffi_check_int(*o, n, -1))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_EINVAL_DOM(unsigned long long *o)
{
  int n = (PAPI_EINVAL_DOM) <= 0;
  *o = (unsigned long long)((PAPI_EINVAL_DOM) | 0);  /* check that PAPI_EINVAL_DOM is an integer */
  if (!_cffi_check_int(*o, n, -21))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_EISRUN(unsigned long long *o)
{
  int n = (PAPI_EISRUN) <= 0;
  *o = (unsigned long long)((PAPI_EISRUN) | 0);  /* check that PAPI_EISRUN is an integer */
  if (!_cffi_check_int(*o, n, -10))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_EMISC(unsigned long long *o)
{
  int n = (PAPI_EMISC) <= 0;
  *o = (unsigned long long)((PAPI_EMISC) | 0);  /* check that PAPI_EMISC is an integer */
  if (!_cffi_check_int(*o, n, -14))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_ENOCMP(unsigned long long *o)
{
  int n = (PAPI_ENOCMP) <= 0;
  *o = (unsigned long long)((PAPI_ENOCMP) | 0);  /* check that PAPI_ENOCMP is an integer */
  if (!_cffi_check_int(*o, n, -17))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_ENOCNTR(unsigned long long *o)
{
  int n = (PAPI_ENOCNTR) <= 0;
  *o = (unsigned long long)((PAPI_ENOCNTR) | 0);  /* check that PAPI_ENOCNTR is an integer */
  if (!_cffi_check_int(*o, n, -13))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_ENOEVNT(unsigned long long *o)
{
  int n = (PAPI_ENOEVNT) <= 0;
  *o = (unsigned long long)((PAPI_ENOEVNT) | 0);  /* check that PAPI_ENOEVNT is an integer */
  if (!_cffi_check_int(*o, n, -7))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_ENOEVST(unsigned long long *o)
{
  int n = (PAPI_ENOEVST) <= 0;
  *o = (unsigned long long)((PAPI_ENOEVST) | 0);  /* check that PAPI_ENOEVST is an integer */
  if (!_cffi_check_int(*o, n, -11))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_ENOIMPL(unsigned long long *o)
{
  int n = (PAPI_ENOIMPL) <= 0;
  *o = (unsigned long long)((PAPI_ENOIMPL) | 0);  /* check that PAPI_ENOIMPL is an integer */
  if (!_cffi_check_int(*o, n, -19))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_ENOINIT(unsigned long long *o)
{
  int n = (PAPI_ENOINIT) <= 0;
  *o = (unsigned long long)((PAPI_ENOINIT) | 0);  /* check that PAPI_ENOINIT is an integer */
  if (!_cffi_check_int(*o, n, -16))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_ENOMEM(unsigned long long *o)
{
  int n = (PAPI_ENOMEM) <= 0;
  *o = (unsigned long long)((PAPI_ENOMEM) | 0);  /* check that PAPI_ENOMEM is an integer */
  if (!_cffi_check_int(*o, n, -2))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_ENOSUPP(unsigned long long *o)
{
  int n = (PAPI_ENOSUPP) <= 0;
  *o = (unsigned long long)((PAPI_ENOSUPP) | 0);  /* check that PAPI_ENOSUPP is an integer */
  if (!_cffi_check_int(*o, n, -18))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_ENOTPRESET(unsigned long long *o)
{
  int n = (PAPI_ENOTPRESET) <= 0;
  *o = (unsigned long long)((PAPI_ENOTPRESET) | 0);  /* check that PAPI_ENOTPRESET is an integer */
  if (!_cffi_check_int(*o, n, -12))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_ENOTRUN(unsigned long long *o)
{
  int n = (PAPI_ENOTRUN) <= 0;
  *o = (unsigned long long)((PAPI_ENOTRUN) | 0);  /* check that PAPI_ENOTRUN is an integer */
  if (!_cffi_check_int(*o, n, -9))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_EPERM(unsigned long long *o)
{
  int n = (PAPI_EPERM) <= 0;
  *o = (unsigned long long)((PAPI_EPERM) | 0);  /* check that PAPI_EPERM is an integer */
  if (!_cffi_check_int(*o, n, -15))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_ESBSTR(unsigned long long *o)
{
  int n = (PAPI_ESBSTR) <= 0;
  *o = (unsigned long long)((PAPI_ESBSTR) | 0);  /* check that PAPI_ESBSTR is an integer */
  if (!_cffi_check_int(*o, n, -4))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_ESYS(unsigned long long *o)
{
  int n = (PAPI_ESYS) <= 0;
  *o = (unsigned long long)((PAPI_ESYS) | 0);  /* check that PAPI_ESYS is an integer */
  if (!_cffi_check_int(*o, n, -3))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_HIGH_LEVEL_INITED(unsigned long long *o)
{
  int n = (PAPI_HIGH_LEVEL_INITED) <= 0;
  *o = (unsigned long long)((PAPI_HIGH_LEVEL_INITED) | 0);  /* check that PAPI_HIGH_LEVEL_INITED is an integer */
  if (!_cffi_check_int(*o, n, 2U))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_LOW_LEVEL_INITED(unsigned long long *o)
{
  int n = (PAPI_LOW_LEVEL_INITED) <= 0;
  *o = (unsigned long long)((PAPI_LOW_LEVEL_INITED) | 0);  /* check that PAPI_LOW_LEVEL_INITED is an integer */
  if (!_cffi_check_int(*o, n, 1U))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_MULTIPLEXING(unsigned long long *o)
{
  int n = (PAPI_MULTIPLEXING) <= 0;
  *o = (unsigned long long)((PAPI_MULTIPLEXING) | 0);  /* check that PAPI_MULTIPLEXING is an integer */
  if (!_cffi_check_int(*o, n, 64U))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_NOT_INIT(unsigned long long *o)
{
  int n = (PAPI_NOT_INIT) <= 0;
  *o = (unsigned long long)((PAPI_NOT_INIT) | 0);  /* check that PAPI_NOT_INIT is an integer */
  if (!_cffi_check_int(*o, n, 8U))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_NOT_INITED(unsigned long long *o)
{
  int n = (PAPI_NOT_INITED) <= 0;
  *o = (unsigned long long)((PAPI_NOT_INITED) | 0);  /* check that PAPI_NOT_INITED is an integer */
  if (!_cffi_check_int(*o, n, 0))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_NULL(unsigned long long *o)
{
  int n = (PAPI_NULL) <= 0;
  *o = (unsigned long long)((PAPI_NULL) | 0);  /* check that PAPI_NULL is an integer */
  if (!_cffi_check_int(*o, n, -1))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_NUM_ERRORS(unsigned long long *o)
{
  int n = (PAPI_NUM_ERRORS) <= 0;
  *o = (unsigned long long)((PAPI_NUM_ERRORS) | 0);  /* check that PAPI_NUM_ERRORS is an integer */
  if (!_cffi_check_int(*o, n, 25U))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_OK(unsigned long long *o)
{
  int n = (PAPI_OK) <= 0;
  *o = (unsigned long long)((PAPI_OK) | 0);  /* check that PAPI_OK is an integer */
  if (!_cffi_check_int(*o, n, 0))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_OVERFLOWING(unsigned long long *o)
{
  int n = (PAPI_OVERFLOWING) <= 0;
  *o = (unsigned long long)((PAPI_OVERFLOWING) | 0);  /* check that PAPI_OVERFLOWING is an integer */
  if (!_cffi_check_int(*o, n, 16U))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_PAUSED(unsigned long long *o)
{
  int n = (PAPI_PAUSED) <= 0;
  *o = (unsigned long long)((PAPI_PAUSED) | 0);  /* check that PAPI_PAUSED is an integer */
  if (!_cffi_check_int(*o, n, 4U))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_PROFILING(unsigned long long *o)
{
  int n = (PAPI_PROFILING) <= 0;
  *o = (unsigned long long)((PAPI_PROFILING) | 0);  /* check that PAPI_PROFILING is an integer */
  if (!_cffi_check_int(*o, n, 32U))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_RUNNING(unsigned long long *o)
{
  int n = (PAPI_RUNNING) <= 0;
  *o = (unsigned long long)((PAPI_RUNNING) | 0);  /* check that PAPI_RUNNING is an integer */
  if (!_cffi_check_int(*o, n, 2U))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_STOPPED(unsigned long long *o)
{
  int n = (PAPI_STOPPED) <= 0;
  *o = (unsigned long long)((PAPI_STOPPED) | 0);  /* check that PAPI_STOPPED is an integer */
  if (!_cffi_check_int(*o, n, 1U))
    n |= 2;
  return n;
}

static int _cffi_const_PAPI_THREAD_LEVEL_INITED(unsigned long long *o)
{
  int n = (PAPI_THREAD_LEVEL_INITED) <= 0;
  *o = (unsigned long long)((PAPI_THREAD_LEVEL_INITED) | 0);  /* check that PAPI_THREAD_LEVEL_INITED is an integer */
  if (!_cffi_check_int(*o, n, 4U))
    n |= 2;
  return n;
}

static const struct _cffi_global_s _cffi_globals[] = {
  { "PAPI_ATTACHED", (void *)_cffi_const_PAPI_ATTACHED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_CPU_ATTACHED", (void *)_cffi_const_PAPI_CPU_ATTACHED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_EATTR", (void *)_cffi_const_PAPI_EATTR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_EBUF", (void *)_cffi_const_PAPI_EBUF, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_EBUG", (void *)_cffi_const_PAPI_EBUG, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_ECLOST", (void *)_cffi_const_PAPI_ECLOST, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_ECMP", (void *)_cffi_const_PAPI_ECMP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_ECNFLCT", (void *)_cffi_const_PAPI_ECNFLCT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_ECOMBO", (void *)_cffi_const_PAPI_ECOMBO, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_ECOUNT", (void *)_cffi_const_PAPI_ECOUNT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_EINVAL", (void *)_cffi_const_PAPI_EINVAL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_EINVAL_DOM", (void *)_cffi_const_PAPI_EINVAL_DOM, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_EISRUN", (void *)_cffi_const_PAPI_EISRUN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_EMISC", (void *)_cffi_const_PAPI_EMISC, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_ENOCMP", (void *)_cffi_const_PAPI_ENOCMP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_ENOCNTR", (void *)_cffi_const_PAPI_ENOCNTR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_ENOEVNT", (void *)_cffi_const_PAPI_ENOEVNT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_ENOEVST", (void *)_cffi_const_PAPI_ENOEVST, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_ENOIMPL", (void *)_cffi_const_PAPI_ENOIMPL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_ENOINIT", (void *)_cffi_const_PAPI_ENOINIT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_ENOMEM", (void *)_cffi_const_PAPI_ENOMEM, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_ENOSUPP", (void *)_cffi_const_PAPI_ENOSUPP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_ENOTPRESET", (void *)_cffi_const_PAPI_ENOTPRESET, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_ENOTRUN", (void *)_cffi_const_PAPI_ENOTRUN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_EPERM", (void *)_cffi_const_PAPI_EPERM, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_ESBSTR", (void *)_cffi_const_PAPI_ESBSTR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_ESYS", (void *)_cffi_const_PAPI_ESYS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_HIGH_LEVEL_INITED", (void *)_cffi_const_PAPI_HIGH_LEVEL_INITED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_LOW_LEVEL_INITED", (void *)_cffi_const_PAPI_LOW_LEVEL_INITED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_MULTIPLEXING", (void *)_cffi_const_PAPI_MULTIPLEXING, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_NOT_INIT", (void *)_cffi_const_PAPI_NOT_INIT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_NOT_INITED", (void *)_cffi_const_PAPI_NOT_INITED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_NULL", (void *)_cffi_const_PAPI_NULL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_NUM_ERRORS", (void *)_cffi_const_PAPI_NUM_ERRORS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_OK", (void *)_cffi_const_PAPI_OK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_OVERFLOWING", (void *)_cffi_const_PAPI_OVERFLOWING, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_PAUSED", (void *)_cffi_const_PAPI_PAUSED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_PROFILING", (void *)_cffi_const_PAPI_PROFILING, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_RUNNING", (void *)_cffi_const_PAPI_RUNNING, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_STOPPED", (void *)_cffi_const_PAPI_STOPPED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_THREAD_LEVEL_INITED", (void *)_cffi_const_PAPI_THREAD_LEVEL_INITED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PAPI_accum", (void *)_cffi_f_PAPI_accum, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 43), (void *)_cffi_d_PAPI_accum },
  { "PAPI_accum_counters", (void *)_cffi_f_PAPI_accum_counters, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 47), (void *)_cffi_d_PAPI_accum_counters },
  { "PAPI_add_event", (void *)_cffi_f_PAPI_add_event, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 39), (void *)_cffi_d_PAPI_add_event },
  { "PAPI_add_events", (void *)_cffi_f_PAPI_add_events, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 34), (void *)_cffi_d_PAPI_add_events },
  { "PAPI_cleanup_eventset", (void *)_cffi_f_PAPI_cleanup_eventset, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 13), (void *)_cffi_d_PAPI_cleanup_eventset },
  { "PAPI_create_eventset", (void *)_cffi_f_PAPI_create_eventset, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 6), (void *)_cffi_d_PAPI_create_eventset },
  { "PAPI_destroy_eventset", (void *)_cffi_f_PAPI_destroy_eventset, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 6), (void *)_cffi_d_PAPI_destroy_eventset },
  { "PAPI_epc", (void *)_cffi_f_PAPI_epc, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 16), (void *)_cffi_d_PAPI_epc },
  { "PAPI_flips", (void *)_cffi_f_PAPI_flips, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_PAPI_flips },
  { "PAPI_flops", (void *)_cffi_f_PAPI_flops, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_PAPI_flops },
  { "PAPI_ipc", (void *)_cffi_f_PAPI_ipc, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_PAPI_ipc },
  { "PAPI_is_initialized", (void *)_cffi_f_PAPI_is_initialized, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 51), (void *)_cffi_d_PAPI_is_initialized },
  { "PAPI_library_init", (void *)_cffi_f_PAPI_library_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 13), (void *)_cffi_d_PAPI_library_init },
  { "PAPI_list_events", (void *)_cffi_f_PAPI_list_events, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 29), (void *)_cffi_d_PAPI_list_events },
  { "PAPI_num_components", (void *)_cffi_f_PAPI_num_components, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 51), (void *)_cffi_d_PAPI_num_components },
  { "PAPI_num_counters", (void *)_cffi_f_PAPI_num_counters, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 51), (void *)_cffi_d_PAPI_num_counters },
  { "PAPI_read", (void *)_cffi_f_PAPI_read, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 43), (void *)_cffi_d_PAPI_read },
  { "PAPI_read_counters", (void *)_cffi_f_PAPI_read_counters, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 47), (void *)_cffi_d_PAPI_read_counters },
  { "PAPI_remove_event", (void *)_cffi_f_PAPI_remove_event, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 39), (void *)_cffi_d_PAPI_remove_event },
  { "PAPI_remove_events", (void *)_cffi_f_PAPI_remove_events, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 34), (void *)_cffi_d_PAPI_remove_events },
  { "PAPI_start", (void *)_cffi_f_PAPI_start, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 13), (void *)_cffi_d_PAPI_start },
  { "PAPI_start_counters", (void *)_cffi_f_PAPI_start_counters, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 9), (void *)_cffi_d_PAPI_start_counters },
  { "PAPI_state", (void *)_cffi_f_PAPI_state, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 25), (void *)_cffi_d_PAPI_state },
  { "PAPI_stop", (void *)_cffi_f_PAPI_stop, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 43), (void *)_cffi_d_PAPI_stop },
  { "PAPI_stop_counters", (void *)_cffi_f_PAPI_stop_counters, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 47), (void *)_cffi_d_PAPI_stop_counters },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  NULL,  /* no fields */
  NULL,  /* no struct_unions */
  NULL,  /* no enums */
  NULL,  /* no typenames */
  66,  /* num_globals */
  0,  /* num_struct_unions */
  0,  /* num_enums */
  0,  /* num_typenames */
  NULL,  /* no includes */
  55,  /* num_types */
  0,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit__papi(const void *p[])
{
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit__papi(void) { return NULL; }
#  else
     init_papi(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit__papi(void)
{
  return _cffi_init("pypapi._papi", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
init_papi(void)
{
  _cffi_init("pypapi._papi", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
