from enum import Enum

class EndPoint(Enum):
    PRODUCTION = "api.paypal.com"
    SANDBOX = "api.sandbox.paypal.com"

class ProductType(str, Enum):
    PHYSICAL = 'PHYSICAL'
    DIGITAL = 'DIGITAL'
    SERVICE = 'SERVICE'

class CategoryType(str, Enum):
    AC_REFRIGERATION_REPAIR = 'AC_REFRIGERATION_REPAIR'
    ACADEMIC_SOFTWARE = 'ACADEMIC_SOFTWARE'
    ACCESSORIES = 'ACCESSORIES'
    # Check how to find the whole categories in code mode

class ShipmentStatus(str, Enum):
    CANCELLED = 'CANCELLED'
    DELIVERED = 'DELIVERED'
    LOCAL_PICKUP = 'LOCAL_PICKUP'
    ON_HOLD = 'ON_HOLD'
    SHIPPED = 'SHIPPED'
    SHIPMENT_CREATED = 'SHIPMENT_CREATED'
    DROPPED_OFF = 'DROPPED_OFF'
    IN_TRANSIT = 'IN_TRANSIT'
    RETURNED = 'RETURNED'
    LABEL_PRINTED = 'LABEL_PRINTED'
    ERROR = 'ERROR'
    UNCONFIRMED = 'UNCONFIRMED'
    PICKUP_FAILED = 'PICKUP_FAILED'
    DELIVERY_DELAYED = 'DELIVERY_DELAYED'
    DELIVERY_SCHEDULED = 'DELIVERY_SCHEDULED'
    DELIVERY_FAILED = 'DELIVERY_FAILED'
    INRETURN = 'INRETURN'
    IN_PROCESS = 'IN_PROCESS'
    NEW = 'NEW'
    VOID = 'VOID'
    PROCESSED = 'PROCESSED'
    NOT_SHIPPED = 'NOT_SHIPPED'

class Carrier(str, Enum):
    ACOMMERCE = 'ACOMMERCE'
    PHL_2GO = 'PHL_2GO'
    AU_DHL_EXPRESS = 'AU_DHL_EXPRESS'
    BEL_DHL = 'BEL_DHL'
    DE_DHL_DEUTSHCE_POST_INTL_SHIPMENTS = 'DE_DHL_DEUTSHCE_POST_INTL_SHIPMENTS'
    IE_AN_POST_REGISTERED = 'IE_AN_POST_REGISTERED'
    AU_AU_POST = 'AU_AU_POST'
    SPEEDEXCOURIER = 'SPEEDEXCOURIER'
    UK_ROYALMAIL_SPECIAL = 'UK_ROYALMAIL_SPECIAL'
    FR_COLIS = 'FR_COLIS'
    VNPOST_EMS = 'VNPOST_EMS'
    NL_FEDEX = 'NL_FEDEX'
    CN_EMS = 'CN_EMS'
    IT_POSTE_ITALIANE = 'IT_POSTE_ITALIANE'
    HK_DHL_ECOMMERCE = 'HK_DHL_ECOMMERCE'
    ARAMEX = 'ARAMEX'
    AU_OTHER = 'AU_OTHER'
    TW_CHUNGHWA_POST = 'TW_CHUNGHWA_POST'
    DPEX = 'DPEX'
    POST_SERBIA = 'POST_SERBIA'
    PL_POCZTEX = 'PL_POCZTEX'
    CNEXPS = 'CNEXPS'
    DIRECTLOG = 'DIRECTLOG'
    ES_CORREOS_DE_ESPANA = 'ES_CORREOS_DE_ESPANA'
    BE_KIALA = 'BE_KIALA'
    ALPHAFAST = 'ALPHAFAST'
    UKR_POSHTA = 'UKR_POSHTA'
    CN_FEDEX = 'CN_FEDEX'
    BUYLOGIC = 'BUYLOGIC'
    IT_DHL_ECOMMERCE = 'IT_DHL_ECOMMERCE'
    NINJAVAN_MY = 'NINJAVAN_MY'
    JPN_YAMATO = 'JPN_YAMATO'
    POSTNORD_LOGISTICS = 'POSTNORD_LOGISTICS'
    US_DHL_GLOBALFORWARDING = 'US_DHL_GLOBALFORWARDING'
    IT_SGT = 'IT_SGT'
    NINJAVAN_PHILIPPINES = 'NINJAVAN_PHILIPPINES'
    EKART = 'EKART'
    IDN_WAHANA = 'IDN_WAHANA'
    FR_GLS = 'FR_GLS'
    IDN_POS_INT = 'IDN_POS_INT'
    DE_HERMES = 'DE_HERMES'
    PRT_CHRONOPOST = 'PRT_CHRONOPOST'
    MYS_MYS_POST = 'MYS_MYS_POST'
    WEBINTERPRET = 'WEBINTERPRET'
    BG_BULGARIAN_POST = 'BG_BULGARIAN_POST'
    NL_TPG = 'NL_TPG'
    CA_CANPAR = 'CA_CANPAR'
    MYS_AIRPAK = 'MYS_AIRPAK'
    MEX_SENDA = 'MEX_SENDA'
    LANDMARK_GLOBAL = 'LANDMARK_GLOBAL'
    UK_NIGHTLINE = 'UK_NIGHTLINE'
    JP_UPS = 'JP_UPS'
    UK_DHL = 'UK_DHL'
    SG_SG_POST = 'SG_SG_POST'
    PHL_AIRSPEED = 'PHL_AIRSPEED'
    DHL = 'DHL'
    KR_KOREA_POST = 'KR_KOREA_POST'
    JP_KURO_NEKO_YAMATO_UNYUU = 'JP_KURO_NEKO_YAMATO_UNYUU'
    IE_AN_POST_SWIFTPOST = 'IE_AN_POST_SWIFTPOST'
    CUCKOOEXPRESS = 'CUCKOOEXPRESS'
    FR_OTHER = 'FR_OTHER'
    FASTRAK_TH = 'FASTRAK_TH'
    AU_DHL_ECOMMERCE = 'AU_DHL_ECOMMERCE'
    DE_UPS = 'DE_UPS'
    ESHOPWORLD = 'ESHOPWORLD'
    INTERNATIONAL_BRIDGE = 'INTERNATIONAL_BRIDGE'
    FR_COLIPOSTE = 'FR_COLIPOSTE'
    AU_AUSTRIAN_POST = 'AU_AUSTRIAN_POST'
    IND_DELHIVERY = 'IND_DELHIVERY'
    DE_TNT = 'DE_TNT'
    GLOBAL_DHL = 'GLOBAL_DHL'
    US_DHL_PARCEL = 'US_DHL_PARCEL'
    NL_UPS = 'NL_UPS'
    GB_APC = 'GB_APC'
    IDN_TIKI = 'IDN_TIKI'
    HERMES = 'HERMES'
    ESP_NACEX = 'ESP_NACEX'
    NL_TNT = 'NL_TNT'
    DE_FEDEX = 'DE_FEDEX'
    OTHER = 'OTHER'
    BONDSCOURIERS = 'BONDSCOURIERS'
    IT_DHL_GLOBALFORWARDING = 'IT_DHL_GLOBALFORWARDING'
    IDN_LION_PARCEL = 'IDN_LION_PARCEL'
    UK_YODEL = 'UK_YODEL'
    IT_DHL_EXPRESS = 'IT_DHL_EXPRESS'
    PL_DHL_GLOBALFORWARDING = 'PL_DHL_GLOBALFORWARDING'
    DPD_POLAND = 'DPD_POLAND'
    AU_AUSTRALIA_POST_EXPRESS_POST_PLATINUM = 'AU_AUSTRALIA_POST_EXPRESS_POST_PLATINUM'
    ES_TNT = 'ES_TNT'
    CN_DHL_EXPRESS = 'CN_DHL_EXPRESS'
    DE_DPD = 'DE_DPD'
    DE_DPD_DELISTRACK = 'DE_DPD_DELISTRACK'
    CN_DHL_ECOMMERCE = 'CN_DHL_ECOMMERCE'
    JP_TNT = 'JP_TNT'
    PRT_CTT = 'PRT_CTT'
    UK_INTERLINK_EXPRESS = 'UK_INTERLINK_EXPRESS'
    NLD_POSTNL = 'NLD_POSTNL'
    CA_DHL_ECOMMERCE = 'CA_DHL_ECOMMERCE'
    SWIFTAIR = 'SWIFTAIR'
    NOR_POSTEN = 'NOR_POSTEN'
    MEX_REDPACK = 'MEX_REDPACK'
    PL_MASTERLINK = 'PL_MASTERLINK'
    PL_TNT = 'PL_TNT'
    NIM_EXPRESS = 'NIM_EXPRESS'
    PL_UPS = 'PL_UPS'
    UKR_NOVA = 'UKR_NOVA'
    QUANTIUM = 'QUANTIUM'
    SENDLE = 'SENDLE'
    SG_PARCELPOST = 'SG_PARCELPOST'
    SG_NINJAVAN = 'SG_NINJAVAN'
    BQC_EXPRESS = 'BQC_EXPRESS'
    RPD2MAN = 'RPD2MAN'
    THA_KERRY = 'THA_KERRY'
    MEX_AEROFLASH = 'MEX_AEROFLASH'
    SPREADEL = 'SPREADEL'
    ESP_REDUR = 'ESP_REDUR'
    JP_JAPANPOST = 'JP_JAPANPOST'
    ARE_EMIRATES_POST = 'ARE_EMIRATES_POST'
    CN_CHINA_POST_EMS = 'CN_CHINA_POST_EMS'
    UK_DHL_GLOBALFORWARDING = 'UK_DHL_GLOBALFORWARDING'
    CN_SF_EXPRESS = 'CN_SF_EXPRESS'
    UK_FEDEX = 'UK_FEDEX'
    POL_POCZTA = 'POL_POCZTA'
    YANWEN = 'YANWEN'
    KOR_CJ = 'KOR_CJ'
    DE_DEUTSCHE_POST_DHL_WITHIN_EUROPE_TRACKNET = 'DE_DEUTSCHE_POST_DHL_WITHIN_EUROPE_TRACKNET'
    IND_XPRESSBEES = 'IND_XPRESSBEES'
    UK_TNT = 'UK_TNT'
    CJ_KOREA_THAI = 'CJ_KOREA_THAI'
    CN_OTHER = 'CN_OTHER'
    IDN_POS = 'IDN_POS'
    ABC_MAIL = 'ABC_MAIL'
    UK_UPS = 'UK_UPS'
    CHINA_POST = 'CHINA_POST'
    PL_DHL_EXPRESS = 'PL_DHL_EXPRESS'
    ESP_SPANISH_SEUR = 'ESP_SPANISH_SEUR'
    SG_ZALORA = 'SG_ZALORA'
    MATKAHUOLTO = 'MATKAHUOLTO'
    FR_LAPOSTE = 'FR_LAPOSTE'
    KANGAROO_MY = 'KANGAROO_MY'
    ESP_CORREOS = 'ESP_CORREOS'
    NL_KIALA = 'NL_KIALA'
    IND_BLUEDART = 'IND_BLUEDART'
    TUR_PTT = 'TUR_PTT'
    CA_CANNOT_PROVIDE_TRACKING = 'CA_CANNOT_PROVIDE_TRACKING'
    JPN_SAGAWA = 'JPN_SAGAWA'
    MYS_SKYNET = 'MYS_SKYNET'
    IT_FERCAM = 'IT_FERCAM'
    UK_AIRBORNE_EXPRESS = 'UK_AIRBORNE_EXPRESS'
    CA_OTHER = 'CA_OTHER'
    DE_DEUTSHCE_POST_DHL_TRACK_TRACE_EXPRESS = 'DE_DEUTSHCE_POST_DHL_TRACK_TRACE_EXPRESS'
    CORREOS_DE_MEXICO = 'CORREOS_DE_MEXICO'
    FR_DHL_GLOBALFORWARDING = 'FR_DHL_GLOBALFORWARDING'
    GLOBAL_SKYNET = 'GLOBAL_SKYNET'
    AU_DHL_GLOBALFORWARDING = 'AU_DHL_GLOBALFORWARDING'
    DE_DHL_GLOBALFORWARDING = 'DE_DHL_GLOBALFORWARDING'
    SFC_LOGISTICS = 'SFC_LOGISTICS'
    US_GLOBEGISTICS = 'US_GLOBEGISTICS'
    CA_DHL_GLOBALFORWARDING = 'CA_DHL_GLOBALFORWARDING'
    OMNIPARCEL = 'OMNIPARCEL'
    PHL_AIR21 = 'PHL_AIR21'
    CBL_LOGISTICA = 'CBL_LOGISTICA'
    FR_MONDIAL = 'FR_MONDIAL'
    DE_DHL_ECOMMERCE = 'DE_DHL_ECOMMERCE'
    ADICIONAL = 'ADICIONAL'
    CH_SWISS_POST_PRIORITY = 'CH_SWISS_POST_PRIORITY'
    NL_INTANGIBLE_DIGITAL_SERVICES = 'NL_INTANGIBLE_DIGITAL_SERVICES'
    DE_ASENDIA = 'DE_ASENDIA'
    NL_ABC_MAIL = 'NL_ABC_MAIL'
    UK_DELTEC = 'UK_DELTEC'
    ONE_WORLD = 'ONE_WORLD'
    AIRBORNE_EXPRESS = 'AIRBORNE_EXPRESS'
    ES_OTHER = 'ES_OTHER'
    US_DHL_ECOMMERCE = 'US_DHL_ECOMMERCE'
    US_ENSENDA = 'US_ENSENDA'
    CPACKET = 'CPACKET'
    AXL = 'AXL'
    IND_REDEXPRESS = 'IND_REDEXPRESS'
    NL_LOCAL_PICKUP = 'NL_LOCAL_PICKUP'
    UK_ROYALMAIL_AIRSURE = 'UK_ROYALMAIL_AIRSURE'
    FR_TNT = 'FR_TNT'
    USPS = 'USPS'
    RINCOS = 'RINCOS'
    B2CEUROPE = 'B2CEUROPE'
    PHL_LBC = 'PHL_LBC'
    SG_TAQBIN = 'SG_TAQBIN'
    GR_ELTA = 'GR_ELTA'
    WINIT = 'WINIT'
    NLD_DHL = 'NLD_DHL'
    FR_GEODIS = 'FR_GEODIS'
    DE_DHL_PACKET = 'DE_DHL_PACKET'
    ARG_OCA = 'ARG_OCA'
    JP_DHL = 'JP_DHL'
    RUSSIAN_POST = 'RUSSIAN_POST'
    TW_TAIWAN_POST = 'TW_TAIWAN_POST'
    UPS = 'UPS'
    BE_BPOST = 'BE_BPOST'
    JP_SAGAWA_KYUU_BIN = 'JP_SAGAWA_KYUU_BIN'
    NATIONWIDE_MY = 'NATIONWIDE_MY'
    TNT = 'TNT'
    COURIERS_PLEASE = 'COURIERS_PLEASE'
    DMM_NETWORK = 'DMM_NETWORK'
    TOLL = 'TOLL'
    NONE = 'NONE'
    IDN_FIRST_LOGISTICS = 'IDN_FIRST_LOGISTICS'
    BH_POSTA = 'BH_POSTA'
    SENDIT = 'SENDIT'
    US_DHL_EXPRESS = 'US_DHL_EXPRESS'
    FEDEX = 'FEDEX'
    SWE_POSTNORD = 'SWE_POSTNORD'
    PHL_XEND_EXPRESS = 'PHL_XEND_EXPRESS'
    POSTI = 'POSTI'
    CA_CANADA_POST = 'CA_CANADA_POST'
    PL_FEXEX = 'PL_FEXEX'
    CN_EC = 'CN_EC'
    HK_TAQBIN = 'HK_TAQBIN'
    UK_AN_POST = 'UK_AN_POST'
    WISELOADS = 'WISELOADS'
    PRT_SEUR = 'PRT_SEUR'
    US_ONTRAC = 'US_ONTRAC'
    THA_THAILAND_POST = 'THA_THAILAND_POST'
    DPE_EXPRESS = 'DPE_EXPRESS'
    UK_DHL_EXPRESS = 'UK_DHL_EXPRESS'
    NL_DHL = 'NL_DHL'
    HK_FLYT_EXPRESS = 'HK_FLYT_EXPRESS'
    UK_HERMESWORLD = 'UK_HERMESWORLD'
    IT_REGISTER_MAIL = 'IT_REGISTER_MAIL'
    ARG_CORREO = 'ARG_CORREO'
    CA_LOOMIS = 'CA_LOOMIS'
    DTDC_AU = 'DTDC_AU'
    DPD = 'DPD'
    ASENDIA_HK = 'ASENDIA_HK'
    UK_ROYALMAIL_RECORDED = 'UK_ROYALMAIL_RECORDED'
    PL_POCZTA_POLSKA = 'PL_POCZTA_POLSKA'
    EU_IMX = 'EU_IMX'
    IDN_PANDU = 'IDN_PANDU'
    MEX_ESTAFETA = 'MEX_ESTAFETA'
    SREKOREA = 'SREKOREA'
    CYP_CYPRUS_POST = 'CYP_CYPRUS_POST'
    NZ_COURIER_POST = 'NZ_COURIER_POST'
    CN_EMPS = 'CN_EMPS'
    AU_TNT = 'AU_TNT'
    UK_CANNOT_PROVIDE_TRACKING = 'UK_CANNOT_PROVIDE_TRACKING'
    ES_DHL = 'ES_DHL'
    CONTINENTAL = 'CONTINENTAL'
    IND_DTDC = 'IND_DTDC'
    DE_GLS = 'DE_GLS'
    NLD_GLS = 'NLD_GLS'
    UK_DPD = 'UK_DPD'
    IT_TNT = 'IT_TNT'
    PL_DHL = 'PL_DHL'
    JP_NITTSU_PELICAN_BIN = 'JP_NITTSU_PELICAN_BIN'
    THA_DYNAMIC_LOGISTICS = 'THA_DYNAMIC_LOGISTICS'
    IT_POSTE_ITALIA = 'IT_POSTE_ITALIA'
    UK_ROYALMAIL_INTER_SIGNED = 'UK_ROYALMAIL_INTER_SIGNED'
    HERMES_IT = 'HERMES_IT'
    FR_BERT = 'FR_BERT'
    IND_PROFESSIONAL_COURIERS = 'IND_PROFESSIONAL_COURIERS'
    POL_SIODEMKA = 'POL_SIODEMKA'
    IE_AN_POST_SDS_PRIORITY = 'IE_AN_POST_SDS_PRIORITY'
    ADSONE = 'ADSONE'
    BRA_CORREIOS = 'BRA_CORREIOS'
    UBI_LOGISTICS = 'UBI_LOGISTICS'
    ES_CORREOS = 'ES_CORREOS'
    NGA_NIPOST = 'NGA_NIPOST'
    AUT_AUSTRIAN_POST = 'AUT_AUSTRIAN_POST'
    AU_FASTWAY = 'AU_FASTWAY'
    AUS_TOLL = 'AUS_TOLL'
    CA_CANPAR_COURIER = 'CA_CANPAR_COURIER'
    SWE_DIRECTLINK = 'SWE_DIRECTLINK'
    CZE_CESKA = 'CZE_CESKA'
    ROYAL_MAIL = 'ROYAL_MAIL'
    SG_SINGPOST = 'SG_SINGPOST'
    IT_OTHER = 'IT_OTHER'
    ZA_FASTWAY = 'ZA_FASTWAY'
    SEKOLOGISTICS = 'SEKOLOGISTICS'
    CN_UPS = 'CN_UPS'
    HUNTER_EXPRESS = 'HUNTER_EXPRESS'
    DE_DHL_PARCEL = 'DE_DHL_PARCEL'
    NLD_TRANSMISSION = 'NLD_TRANSMISSION'
    CN_TNT = 'CN_TNT'
    DE_DEUTSCHE = 'DE_DEUTSCHE'
    AIRSURE = 'AIRSURE'
    UK_PARCELFORCE = 'UK_PARCELFORCE'
    SWE_DB = 'SWE_DB'
    CN_CHINA_POST = 'CN_CHINA_POST'
    PL_GLS = 'PL_GLS'
    EU_BPOST = 'EU_BPOST'
    RELAIS_COLIS = 'RELAIS_COLIS'
    UK_DHL_PARCEL = 'UK_DHL_PARCEL'
    AUS_STARTRACK = 'AUS_STARTRACK'
    AU_TOLL_IPEC = 'AU_TOLL_IPEC'
    CORREOS_CHILE = 'CORREOS_CHILE'
    CH_SWISS_POST_EXPRES = 'CH_SWISS_POST_EXPRES'
    MYS_TAQBIN = 'MYS_TAQBIN'
    JET_SHIP = 'JET_SHIP'
    HK_DHL_EXPRESS = 'HK_DHL_EXPRESS'
    IT_SDA = 'IT_SDA'
    DE_DHL_DEUTSCHEPOST = 'DE_DHL_DEUTSCHEPOST'
    HK_DHL_GLOBALFORWARDING = 'HK_DHL_GLOBALFORWARDING'
    PHL_RAF = 'PHL_RAF'
    IT_GLS = 'IT_GLS'
    PANTOS = 'PANTOS'
    KOR_ECARGO = 'KOR_ECARGO'
    AT_AUSTRIAN_POST_EMS = 'AT_AUSTRIAN_POST_EMS'
    IT_BRT = 'IT_BRT'
    CHE_SWISS_POST = 'CHE_SWISS_POST'
    FASTWAY_NZ = 'FASTWAY_NZ'
    IT_EBOOST_SDA = 'IT_EBOOST_SDA'
    ASENDIA_UK = 'ASENDIA_UK'
    RRDONNELLEY = 'RRDONNELLEY'
    US_RL = 'US_RL'
    GR_GENIKI = 'GR_GENIKI'
    DE_DHL_EXPRESS = 'DE_DHL_EXPRESS'
    CA_GREYHOUND = 'CA_GREYHOUND'
    UK_COLLECTPLUS = 'UK_COLLECTPLUS'
    NINJAVAN_THAI = 'NINJAVAN_THAI'
    RABEN_GROUP = 'RABEN_GROUP'
    CA_DHL_EXPRESS = 'CA_DHL_EXPRESS'
    GLOBAL_TNT = 'GLOBAL_TNT'
    IN_INDIAPOST = 'IN_INDIAPOST'
    ITIS = 'ITIS'
    PHL_JAMEXPRESS = 'PHL_JAMEXPRESS'
    PRT_INT_SEUR = 'PRT_INT_SEUR'
    ESP_ASM = 'ESP_ASM'
    NINJAVAN_ID = 'NINJAVAN_ID'
    JP_FEDEX = 'JP_FEDEX'
    FR_CHRONOPOST = 'FR_CHRONOPOST'
    FR_SUIVI = 'FR_SUIVI'
    FR_TELIWAY = 'FR_TELIWAY'
    JPN_JAPAN_POST = 'JPN_JAPAN_POST'
    HRV_HRVATSKA = 'HRV_HRVATSKA'
    AT_AUSTRIAN_POST_PAKET_PRIME = 'AT_AUSTRIAN_POST_PAKET_PRIME'
    DE_OTHER = 'DE_OTHER'
    HK_HONGKONG_POST = 'HK_HONGKONG_POST'
    GRC_ACS = 'GRC_ACS'
    HUN_MAGYAR = 'HUN_MAGYAR'
    FR_DHL_PARCEL = 'FR_DHL_PARCEL'
    UK_OTHER = 'UK_OTHER'
    LWE_HK = 'LWE_HK'
    EFS = 'EFS'
    PL_DHL_PARCEL = 'PL_DHL_PARCEL'
    PARCELFORCE = 'PARCELFORCE'
    AU_AUSTRALIA_POST_EMS = 'AU_AUSTRALIA_POST_EMS'
    US_ASCENDIA = 'US_ASCENDIA'
    ROU_POSTA = 'ROU_POSTA'
    NZ_NZ_POST = 'NZ_NZ_POST'
    RPX = 'RPX'
    POSTUR_IS = 'POSTUR_IS'
    IE_AN_POST_SDS_EMS = 'IE_AN_POST_SDS_EMS'
    UK_UK_MAIL = 'UK_UK_MAIL'
    UK_FASTWAY = 'UK_FASTWAY'
    CORREOS_DE_COSTA_RICA = 'CORREOS_DE_COSTA_RICA'
    MYS_CITYLINK = 'MYS_CITYLINK'
    PUROLATOR = 'PUROLATOR'
    IND_DOTZOT = 'IND_DOTZOT'
    NG_COURIERPLUS = 'NG_COURIERPLUS'
    HK_FOUR_PX_EXPRESS = 'HK_FOUR_PX_EXPRESS'
    ROCKETPARCEL = 'ROCKETPARCEL'
    CN_DHL_GLOBALFORWARDING = 'CN_DHL_GLOBALFORWARDING'
    EPARCEL_KR = 'EPARCEL_KR'
    INPOST_PACZKOMATY = 'INPOST_PACZKOMATY'
    KOR_KOREA_POST = 'KOR_KOREA_POST'
    CA_PUROLATOR = 'CA_PUROLATOR'
    APR_72 = 'APR_72'
    FR_DHL_EXPRESS = 'FR_DHL_EXPRESS'
    IDN_JNE = 'IDN_JNE'
    AU_AUSTRALIA_POST_EPARCEL = 'AU_AUSTRALIA_POST_EPARCEL'
    GLOBAL_ESTES = 'GLOBAL_ESTES'
    LTU_LIETUVOS = 'LTU_LIETUVOS'
    THECOURIERGUY = 'THECOURIERGUY'
    BE_CHRONOPOST = 'BE_CHRONOPOST'
    VNM_VIETNAM_POST = 'VNM_VIETNAM_POST'
    AU_STAR_TRACK_EXPRESS = 'AU_STAR_TRACK_EXPRESS'
    RAM = 'RAM'

class TrackingNumberType(str, Enum):
    CARRIER_PROVIDED = 'CARRIER_PROVIDED'
    E2E_PARTNER_PROVIDED = 'E2E_PARTNER_PROVIDED'