# PythonPDB

Tools for working with Protein Data Bank Files. This package was created to provide a bridge between python based OOP
(like [BioPython](https://biopython.org/)) and dataframe/pandas style interfaces (like
[BioPandas](https://biopandas.github.io/biopandas/)).

## Key Links

* Source code: [https://github.com/benjiemc/PythonPDB](https://github.com/benjiemc/PythonPDB)
* Documentation: [https://benjiemc.github.io/PythonPDB/](https://benjiemc.github.io/PythonPDB/)
* PyPi: [https://pypi.org/project/python-pdb/](https://pypi.org/project/python-pdb/)

## Installation

The package is available on PyPi and can be downloaded as follows.

```
pip install python-pdb
```

### Installing for Development

To work on this package, download the git repository...

```
git clone https://github.com/benjiemc/PythonPDB.git

# or using SSH
git clone git@github.com:benjiemc/PythonPDB.git

cd PythonPDB/
```

... and then install the package with development dependencies (best practice is to use a virtual environment).

```
python3 -m venv venv
pip install -e '.[develop]'
```

## Documentation

Documentation can be found at [https://benjiemc.github.io/PythonPDB/](https://benjiemc.github.io/PythonPDB/).
