/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2.decoder.huffman;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.pdfbox.jbig2.decoder.huffman.HuffmanTable;
import org.apache.pdfbox.jbig2.io.SubInputStream;
import org.apache.pdfbox.jbig2.segments.Table;

public class EncodedTable
extends HuffmanTable {
    private Table table;

    public EncodedTable(Table table) throws IOException {
        this.table = table;
        this.parseTable();
    }

    public void parseTable() throws IOException {
        int n;
        int n2;
        int n3;
        SubInputStream subInputStream = this.table.getSubInputStream();
        ArrayList<HuffmanTable.Code> arrayList = new ArrayList<HuffmanTable.Code>();
        for (int i = this.table.getHtLow(); i < this.table.getHtHigh(); i += 1 << n3) {
            n2 = (int)subInputStream.readBits(this.table.getHtPS());
            n3 = (int)subInputStream.readBits(this.table.getHtRS());
            n = i;
            arrayList.add(new HuffmanTable.Code(n2, n3, n, false));
        }
        n2 = (int)subInputStream.readBits(this.table.getHtPS());
        n3 = 32;
        n = this.table.getHtLow() - 1;
        arrayList.add(new HuffmanTable.Code(n2, n3, n, true));
        n2 = (int)subInputStream.readBits(this.table.getHtPS());
        n3 = 32;
        n = this.table.getHtHigh();
        arrayList.add(new HuffmanTable.Code(n2, n3, n, false));
        if (this.table.getHtOOB() == 1) {
            n2 = (int)subInputStream.readBits(this.table.getHtPS());
            arrayList.add(new HuffmanTable.Code(n2, -1, -1, false));
        }
        this.initTree(arrayList);
    }
}

