/*
 * Decompiled with CFR 0.152.
 */
import pdfextract.Common;
import pdfextract.PDFExtract;

public class Main {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        PDFExtract oExtractor = null;
        try {
            Common common = new Common();
            if (args == null || args.length == 0 || args[0].equals("--help")) {
                common.printHelp();
                System.exit(0);
            }
            String input = "";
            String output = "";
            String batchfile = "";
            String logpath = "";
            String threadcount = "";
            String verbose = "";
            String keepbrtags = "";
            String getperms = "";
            String configfile = "";
            String timeout = "";
            String key = "";
            for (String parm : args) {
                if (parm.startsWith("--")) {
                    key = parm.substring(2);
                    if (key.equals("keepbrtags")) {
                        keepbrtags = "1";
                        key = "";
                        continue;
                    }
                    if (!key.equals("getperms")) continue;
                    getperms = "1";
                    key = "";
                    continue;
                }
                if (parm.startsWith("-")) {
                    key = parm.substring(1);
                    if (!key.equals("v")) continue;
                    verbose = "1";
                    key = "";
                    continue;
                }
                if (key.equals("I")) {
                    input = parm;
                } else if (key.equals("O")) {
                    output = parm;
                } else if (key.equals("B")) {
                    batchfile = parm;
                } else if (key.equals("L")) {
                    logpath = parm;
                } else if (key.equals("T")) {
                    threadcount = parm;
                } else if (key.equals("C")) {
                    configfile = parm;
                } else if (key.equals("t")) {
                    timeout = parm;
                }
                key = "";
            }
            common.setVerbose(common.getInt(verbose));
            if (!common.IsEmpty(input) && !common.IsEmpty(output)) {
                try {
                    oExtractor = new PDFExtract(logpath, common.getInt(verbose), configfile, common.getLong(timeout));
                    oExtractor.Extract(input, output, common.getInt(keepbrtags), common.getInt(getperms));
                }
                catch (Exception e) {
                    common.print("File: " + input + ", " + e.getMessage());
                }
            } else if (!common.IsEmpty(batchfile)) {
                try {
                    oExtractor = new PDFExtract(logpath, common.getInt(verbose), configfile, common.getLong(timeout));
                    oExtractor.Extract(batchfile, common.getInt(threadcount), common.getInt(keepbrtags), common.getInt(getperms));
                }
                catch (Exception e) {
                    common.print("File: " + batchfile + ", " + e.getMessage());
                }
            } else {
                common.print("Cannot start extract: Invalid parameters.");
                System.exit(0);
            }
        }
        catch (Exception ex) {
            System.out.println("Cannot start extract. Error=" + ex.getMessage());
            System.exit(0);
        }
        finally {
            if (oExtractor != null) {
                try {
                    oExtractor.shutdownProcess();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                oExtractor = null;
                System.gc();
            }
        }
    }
}

