/*
 * Decompiled with CFR 0.152.
 */
package pdfextract;

import com.itextpdf.text.pdf.PdfEncryptor;
import com.itextpdf.text.pdf.PdfReader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import pdfextract.Common;

public class PDFToHtml {
    Common common = new Common();
    private long timeout = 600L;

    public PDFToHtml(long timeout_) {
        if (timeout_ > 0L) {
            this.timeout = timeout_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer extract(ByteArrayInputStream bIn) throws Exception {
        String rand = this.common.getStr(Math.random());
        File fTempIn = null;
        try {
            fTempIn = File.createTempFile("pdf-", rand);
            fTempIn.deleteOnExit();
            IOUtils.copy((InputStream)bIn, (OutputStream)new FileOutputStream(fTempIn));
            StringBuffer stringBuffer = this.extract(fTempIn.getPath());
            return stringBuffer;
        }
        catch (Exception e) {
            StringBuffer stringBuffer = new StringBuffer();
            return stringBuffer;
        }
        finally {
            if (fTempIn != null) {
                this.common.deleteFile(fTempIn);
            }
        }
    }

    public StringBuffer extract(String inputPath) throws Exception {
        return this.extract(inputPath, null);
    }

    public StringBuffer extract(String inputPath, String outputPath) throws Exception {
        File fTempOut = null;
        try {
            if (this.common.IsEmpty(outputPath)) {
                String name = this.common.getName(inputPath);
                fTempOut = File.createTempFile(name, ".xml");
                fTempOut.deleteOnExit();
                outputPath = fTempOut.getPath();
            }
            StringBuffer sb = new StringBuffer();
            String[] sCommand = new String[]{"pdftohtml", "-s", "-i", "-noframes", "-xml", "-fontfullname", inputPath, outputPath};
            try {
                this.executeCommand(sCommand);
            }
            catch (Exception e) {
                String errorMsg = e.getMessage();
                if (errorMsg.contains("Permission Error:")) {
                    this.decrypt(inputPath);
                    this.executeCommand(sCommand);
                }
                throw e;
            }
            sb.append(FileUtils.readFileToString(fTempOut, "UTF-8"));
            StringBuffer stringBuffer = sb;
            if (fTempOut != null) {
                this.common.deleteFile(fTempOut);
            }
            this.common.deleteFile(outputPath);
            return stringBuffer;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                if (fTempOut != null) {
                    this.common.deleteFile(fTempOut);
                }
                this.common.deleteFile(outputPath);
                throw throwable;
            }
        }
    }

    public void decrypt(String file) throws IOException {
        this.decrypt(null, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrypt(PdfReader reader, String file) throws IOException {
        File fTemp = null;
        try {
            if (reader == null) {
                reader = new PdfReader(file);
                PdfReader.unethicalreading = true;
            }
            fTemp = File.createTempFile(new File(file).getName(), ".unlocked");
            fTemp.deleteOnExit();
            String inputPathUnlocked = fTemp.getPath();
            PdfEncryptor.encrypt(reader, (OutputStream)new FileOutputStream(inputPathUnlocked), null, null, 3900, false);
            this.common.moveFile(fTemp.getPath(), file);
        }
        catch (Exception exception) {
        }
        finally {
            if (reader != null) {
                reader.close();
                reader = null;
            }
            if (fTemp != null) {
                this.common.deleteFile(fTemp);
            }
        }
    }

    private String executeCommand(String ... command) throws Exception {
        Process proc = null;
        boolean bTimeout = false;
        try {
            StringBuilder sb = new StringBuilder("");
            proc = Runtime.getRuntime().exec(command);
            if (!proc.waitFor(this.timeout, TimeUnit.SECONDS)) {
                bTimeout = true;
                proc.destroyForcibly();
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String line = "";
            while ((line = reader.readLine()) != null) {
                sb.append(line + '\n');
            }
            BufferedReader stdError = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            StringBuilder sbError = new StringBuilder();
            String sProcessError = null;
            while ((sProcessError = stdError.readLine()) != null) {
                sbError.append(sProcessError + '\n');
            }
            if (sbError.length() == 0) {
                String string = sb.toString();
                return string;
            }
            try {
                throw new Exception(sbError.toString());
            }
            catch (IOException e) {
                if (bTimeout) {
                    throw new TimeoutException("Timed out waiting for poppler extract pdf reach. (" + this.timeout + " seconds)");
                }
                throw e;
            }
            catch (InterruptedException e) {
                throw e;
            }
        }
        finally {
            proc.destroy();
        }
    }
}

