/*
 * Decompiled with CFR 0.152.
 */
package pdfextract;

import com.google.common.collect.Lists;
import com.itextpdf.text.pdf.PdfEncryptor;
import com.itextpdf.text.pdf.PdfReader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import pdfextract.Common;
import pdfextract.Config;
import pdfextract.DetectLanguage;
import pdfextract.HTMLObject;
import pdfextract.PDFToHtml;
import pdfextract.SentenceJoin;

public class PDFExtract {
    private final boolean runnable = true;
    private String logPath = "";
    private boolean writeLogFile = true;
    private Pattern patternPageOpen = Pattern.compile("<page ");
    private Pattern patternStyleOpen = Pattern.compile("<fontspec ");
    private Pattern patternText = Pattern.compile("<text ");
    private Pattern patternPageNo = Pattern.compile(".*number=\"([0-9\\.]+)\".*");
    private Pattern patternWidth = Pattern.compile(".*width=\"([0-9\\.]+)\".*");
    private Pattern patternHeight = Pattern.compile(".*height=\"([0-9\\.]+)\".*");
    private Pattern patternLeft = Pattern.compile(".*left=\"([0-9\\.]+)\".*");
    private Pattern patternTop = Pattern.compile(".*top=\"([0-9\\.]+)\".*");
    private Pattern patternFont = Pattern.compile(".*font=\"([0-9\\.]+)\".*");
    private Pattern patternId = Pattern.compile(".*id=\"([0-9]+)\".*");
    private Pattern patternSize = Pattern.compile(".*size=\"([0-9]+)\".*");
    private Pattern patternFamily = Pattern.compile(".*family=\"([^\"]+)\".*");
    private Pattern patternColor = Pattern.compile(".*color=\"(#[a-z0-9]+)\".*");
    private Pattern patternLink = Pattern.compile(".*<a ?[^>]*>(.+?)<\\/a>.*");
    private Pattern patternWord = Pattern.compile("<text [^>]*>(.*?)<\\/text>");
    private Common common = new Common();
    private ExecutorService executor;
    private PDFToHtml pdf = null;
    private String paraMarker = "LSMARKERLS:PARA";
    private int maxWordsJoin = 5;
    private Object _objectWorker = new Object();
    private HashMap<String, SentenceJoin> _hashSentenceJoin = new HashMap();
    private Config config = null;

    private void initial(String logFilePath, int verbose, String configFile, long timeout) throws Exception {
        this.initial(logFilePath, verbose, configFile, timeout, null, null);
    }

    private void initial(String logFilePath, int verbose, String configFile, long timeout, String kenlmPath, String sentenceJoinPath) throws Exception {
        this.common.setVerbose(verbose);
        if (this.common.IsEmpty(logFilePath)) {
            this.writeLogFile = false;
        } else {
            boolean logFileValid;
            if (this.common.IsEmpty(this.common.getExtension(logFilePath))) {
                logFilePath = logFilePath + ".log";
            }
            if (!(logFileValid = this.common.validateFile(logFilePath))) {
                throw new Exception("Invalid log file path or permission denied.");
            }
            this.writeLogFile = true;
            this.logPath = logFilePath;
            this.common.print("Log File: " + this.logPath);
        }
        try {
            if (this.common.IsEmpty(configFile) || !this.common.IsExist(configFile)) {
                configFile = this.common.getConfigPath();
            }
            this.config = new Config(configFile, kenlmPath, sentenceJoinPath);
        }
        catch (Exception e) {
            throw new Exception("initial failed. " + e.getMessage());
        }
        this.pdf = new PDFToHtml(timeout);
    }

    public PDFExtract() throws Exception {
        this.initial("", 0, "", 0L);
    }

    public PDFExtract(String configFile) throws Exception {
        this.initial("", 0, configFile, 0L);
    }

    public PDFExtract(long timeout) throws Exception {
        this.initial("", 0, "", timeout);
    }

    public PDFExtract(String configFile, long timeout) throws Exception {
        this.initial("", 0, configFile, timeout);
    }

    public PDFExtract(String logFilePath, String configFile, long timeout) throws Exception {
        this.initial(logFilePath, 0, configFile, timeout);
    }

    public PDFExtract(String logFilePath, int verbose, String configFile, long timeout) throws Exception {
        this.initial(logFilePath, verbose, configFile, timeout);
    }

    public PDFExtract(String logFilePath, int verbose, String configFile, long timeout, String kenlmPath, String sentenceJoinPath) throws Exception {
        this.initial(logFilePath, verbose, configFile, timeout, kenlmPath, sentenceJoinPath);
    }

    public void Extract(String inputFile, String outputFile, int keepBrTags, int getPermission) throws Exception {
        String outputPath = "";
        try {
            if (this.writeLogFile) {
                this.common.print(inputFile, "Start extract");
                this.common.writeLog(this.logPath, inputFile, "Start extract", false);
            } else {
                this.common.print(inputFile, "Start extract");
            }
            if (!this.common.IsExist(inputFile)) {
                throw new Exception("Input file does not exist.");
            }
            if (this.common.IsEmpty(outputFile)) {
                throw new Exception("Output file cannot be empty.");
            }
            outputPath = this.common.getParentPath(outputFile);
            if (!this.common.IsEmpty(outputPath) && !this.common.IsExist(outputPath)) {
                this.common.createDir(outputPath);
            }
            this.common.checkPermissions(inputFile);
            if (!this.common.getExtension(inputFile).toLowerCase().equals("pdf")) {
                throw new Exception("Input file extension is not pdf.");
            }
            StringBuffer htmlBuffer = new StringBuffer("");
            AtomicReference<HTMLObject.DocumentObject> refDoc = new AtomicReference<HTMLObject.DocumentObject>(new HTMLObject.DocumentObject());
            if (getPermission == 1) {
                this.getAccessPermissions(inputFile, refDoc);
            }
            htmlBuffer = this.convertPdfToHtml(inputFile);
            this.getHtmlObject(htmlBuffer, refDoc);
            this.repairAndAdjustment(refDoc);
            this.languageId(refDoc);
            this.sentenceJoin(refDoc);
            this.finalRepair(refDoc);
            htmlBuffer = this.generateOutput(refDoc, keepBrTags, getPermission);
            this.common.WriteFile(outputFile, htmlBuffer.toString());
            if (this.writeLogFile) {
                this.common.print(inputFile, "Extract success. -> " + outputFile + "");
                this.common.writeLog(this.logPath, inputFile, "Extract success. -> " + outputFile + "", false);
            } else {
                this.common.print(inputFile, "Extract success. -> " + outputFile + "");
            }
        }
        catch (Exception e) {
            if (!this.common.IsEmpty(outputFile)) {
                this.common.WriteFile(outputFile, this.common.getOutputError(e));
            }
            String message = e.getMessage();
            if (this.writeLogFile) {
                this.common.writeLog(this.logPath, inputFile, "Error: " + message, true);
            }
            throw e;
        }
        finally {
            this.shutdownProcess();
        }
    }

    public ByteArrayOutputStream Extract(ByteArrayInputStream inputStream, int keepBrTags, int getPermission) throws Exception {
        try {
            if (this.writeLogFile) {
                this.common.print("Input Stream", "Start extract");
                this.common.writeLog(this.logPath, "Input Stream", "Start extract", false);
            } else {
                this.common.print("Input Stream", "Start extract");
            }
            if (inputStream.available() <= 0) {
                throw new Exception("Input Stream does not exist.");
            }
            AtomicReference<HTMLObject.DocumentObject> refDoc = new AtomicReference<HTMLObject.DocumentObject>(new HTMLObject.DocumentObject());
            if (getPermission == 1) {
                this.getAccessPermissions(inputStream, refDoc);
            }
            StringBuffer htmlBuffer = this.convertPdfToHtml(inputStream);
            this.getHtmlObject(htmlBuffer, refDoc);
            this.repairAndAdjustment(refDoc);
            this.languageId(refDoc);
            this.sentenceJoin(refDoc);
            htmlBuffer = this.generateOutput(refDoc, keepBrTags, getPermission);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            IOUtils.write(htmlBuffer.toString(), (OutputStream)outputStream, "UTF-8");
            if (this.writeLogFile) {
                this.common.print("Input Stream", "Extract success.");
                this.common.writeLog(this.logPath, "Input Stream", "Extract success.", false);
            } else {
                this.common.print("Input Stream", "Extract success.");
            }
            ByteArrayOutputStream byteArrayOutputStream = outputStream;
            return byteArrayOutputStream;
        }
        catch (Exception e) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            IOUtils.write(this.common.getOutputError(e), (OutputStream)outputStream, "UTF-8");
            String message = e.getMessage();
            if (this.writeLogFile) {
                this.common.writeLog(this.logPath, "Input Stream", "Error: " + message, true);
            } else {
                this.common.print("Input Stream", "Error: " + message);
            }
            throw e;
        }
        finally {
            this.shutdownProcess();
        }
    }

    public void Extract(String batchFile, int threadCount, int keepBrTags, int getPermission) throws Exception {
        try {
            if (this.writeLogFile) {
                this.common.print("Start extract batch file: " + batchFile);
                this.common.writeLog(this.logPath, "Start extract batch file: " + batchFile);
            } else {
                this.common.print("Start extract batch file: " + batchFile);
            }
            if (!this.common.IsExist(batchFile)) {
                throw new Exception("Input batch file does not exist.");
            }
            if (threadCount == 0) {
                threadCount = 1;
            }
            int maxThreadCount = threadCount;
            List<String> lines = this.common.readLines(batchFile);
            this.executor = Executors.newFixedThreadPool(maxThreadCount);
            int ind = 0;
            int len = lines.size();
            while (ind < len) {
                String line = lines.get(ind);
                if (this.common.IsEmpty(line)) {
                    ++ind;
                    continue;
                }
                this.AddThreadExtract(ind, line, keepBrTags, getPermission);
                ++ind;
            }
            this.executor.shutdown();
            this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (this.writeLogFile) {
                this.common.writeLog(this.logPath, message, true);
            } else {
                this.common.print("Error: " + e.getMessage());
            }
            throw e;
        }
        finally {
            if (this.writeLogFile) {
                this.common.print("Finish extract batch file: " + batchFile);
                this.common.writeLog(this.logPath, "Finish extract batch file: " + batchFile);
            } else {
                this.common.print("Finish extract batch file: " + batchFile);
            }
            this.shutdownProcess();
        }
    }

    private void AddThreadExtract(int index, final String line, final int keepBrTags, final int getPermission) {
        try {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    block3: {
                        String inputFile = "";
                        String outputFile = "";
                        try {
                            String[] cols = line.split("\t");
                            if (cols == null || cols.length < 2) {
                                throw new Exception("Invalid batch line: " + line);
                            }
                            inputFile = cols[0];
                            outputFile = cols[1];
                            PDFExtract.this.Extract(inputFile, outputFile, keepBrTags, getPermission);
                        }
                        catch (Exception e) {
                            String message = e.getMessage();
                            if (!PDFExtract.this.writeLogFile) break block3;
                            PDFExtract.this.common.print(inputFile, "Error: " + message);
                            PDFExtract.this.common.writeLog(PDFExtract.this.logPath, inputFile, "Error: " + message, true);
                        }
                    }
                }
            });
        }
        catch (Exception ex) {
            String message = ex.toString();
            if (this.writeLogFile) {
                this.common.print("Batch line: " + line + ", Error: " + message);
                this.common.writeLog(this.logPath, "Batch line: " + line + ", Error: " + message, true);
            }
            this.common.print("Batch line: " + line + ", Error: " + message);
        }
    }

    private void getAccessPermissions(String inputFile, AtomicReference<HTMLObject.DocumentObject> refDoc) throws Exception {
        HTMLObject.DocumentObject doc = refDoc.get();
        PdfReader reader = null;
        try {
            reader = new PdfReader(inputFile);
            this.setAccessPermissions(reader, refDoc);
            if (!doc.permission.canCopy) {
                this.pdf.decrypt(reader, inputFile);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (reader != null) {
                reader.close();
                reader = null;
            }
        }
    }

    private void getAccessPermissions(InputStream inputStream, AtomicReference<HTMLObject.DocumentObject> refDoc) throws Exception {
        PdfReader reader = null;
        try {
            reader = new PdfReader(inputStream);
            this.setAccessPermissions(reader, refDoc);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (reader != null) {
                reader.close();
                reader = null;
            }
        }
    }

    private void setAccessPermissions(PdfReader reader, AtomicReference<HTMLObject.DocumentObject> refDoc) {
        HTMLObject.DocumentObject doc = refDoc.get();
        PdfReader.unethicalreading = true;
        int permissions = (int)reader.getPermissions();
        doc.permission.isEncrytped = reader.isEncrypted();
        doc.permission.canAssembly = PdfEncryptor.isAssemblyAllowed(permissions);
        doc.permission.canCopy = PdfEncryptor.isCopyAllowed(permissions);
        doc.permission.canPrint = PdfEncryptor.isPrintingAllowed(permissions);
        doc.permission.canPrintDegraded = PdfEncryptor.isDegradedPrintingAllowed(permissions);
        doc.permission.canModified = PdfEncryptor.isModifyContentsAllowed(permissions);
        doc.permission.canModifyAnnotations = PdfEncryptor.isModifyAnnotationsAllowed(permissions);
        doc.permission.canFillInForm = PdfEncryptor.isFillInAllowed(permissions);
        doc.permission.canScreenReader = PdfEncryptor.isScreenReadersAllowed(permissions);
        doc.permission.verbose = PdfEncryptor.getPermissionsVerbose(permissions);
    }

    private StringBuffer convertPdfToHtml(String inputFile) throws Exception {
        return this.pdf.extract(inputFile);
    }

    private StringBuffer convertPdfToHtml(ByteArrayInputStream inputStream) throws Exception {
        return this.pdf.extract(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getHtmlObject(StringBuffer htmlBuffer, AtomicReference<HTMLObject.DocumentObject> refDoc) throws Exception {
        BufferedReader b_in = null;
        HTMLObject.DocumentObject doc = refDoc.get();
        try {
            InputStreamReader i_in = new InputStreamReader((InputStream)new ByteArrayInputStream(htmlBuffer.toString().getBytes()), StandardCharsets.UTF_8);
            b_in = new BufferedReader(i_in);
            String line = "";
            int currentPage = 0;
            HTMLObject.PageObject page = new HTMLObject.PageObject();
            HashMap<Float, Integer> mapPageWidth = new HashMap<Float, Integer>();
            HashMap<Float, Integer> mapPageHeight = new HashMap<Float, Integer>();
            HashMap<String, HTMLObject.StyleObject> mapStyle = new HashMap<String, HTMLObject.StyleObject>();
            while ((line = b_in.readLine()) != null) {
                Matcher mStyleOpen = this.patternStyleOpen.matcher(line);
                Matcher patternText = this.patternText.matcher(line);
                Matcher mPageOpen = this.patternPageOpen.matcher(line);
                if (patternText.find()) {
                    HTMLObject.TextObject text = this.getTextObject(line, mapStyle);
                    if (!this.checkLineAdd(page.width, page.height, text)) continue;
                    page.texts.add(text);
                    continue;
                }
                if (mPageOpen.find()) {
                    if (currentPage > 0) {
                        doc.pages.add(page);
                        Thread.sleep(50L);
                    }
                    ++currentPage;
                    page = new HTMLObject.PageObject();
                    page.pageno = this.common.getInt(this.patternPageNo.matcher(line).replaceAll("$1"));
                    page.height = this.common.getFloat(this.patternHeight.matcher(line).replaceAll("$1"));
                    page.width = this.common.getFloat(this.patternWidth.matcher(line).replaceAll("$1"));
                    mapPageWidth.put(Float.valueOf(page.width), this.common.getInt(mapPageWidth.get(Float.valueOf(page.width))) + 1);
                    mapPageHeight.put(Float.valueOf(page.height), this.common.getInt(mapPageHeight.get(Float.valueOf(page.height))) + 1);
                    continue;
                }
                if (!mStyleOpen.find()) continue;
                HTMLObject.StyleObject style = new HTMLObject.StyleObject();
                style.id = this.common.getStr(this.patternId.matcher(line).replaceAll("$1"));
                style.size = this.common.getInt(this.patternSize.matcher(line).replaceAll("$1"));
                style.family = this.common.getStr(this.patternFamily.matcher(line).replaceAll("$1"));
                style.color = this.common.getStr(this.patternColor.matcher(line).replaceAll("$1"));
                mapStyle.put(style.id, style);
            }
            doc.pages.add(page);
            doc.style = mapStyle;
            doc.width = this.getMaxCount(mapPageWidth).floatValue();
            doc.height = this.getMaxCount(mapPageHeight).floatValue();
        }
        finally {
            if (b_in != null) {
                b_in.close();
                b_in = null;
            }
            refDoc.set(doc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repairAndAdjustment(AtomicReference<HTMLObject.DocumentObject> refDoc) throws Exception {
        HTMLObject.DocumentObject doc = refDoc.get();
        try {
            HTMLObject.TextObject nextText;
            int j;
            Config.LangInfo commonInfo = null;
            if (this.config != null) {
                commonInfo = this.config.get("common");
            }
            HashMap<String, Integer> mapStyleCount = new HashMap<String, Integer>();
            for (HTMLObject.PageObject page : doc.pages) {
                Iterator<HTMLObject.PageObject> mapHeight = new HashMap();
                int len = page.texts.size();
                for (int i = 0; i < len; ++i) {
                    int count;
                    HTMLObject.TextObject text = page.texts.get(i);
                    if (this.common.IsEmpty(text.text)) {
                        text.deleted = true;
                        continue;
                    }
                    if (!this.common.IsEmpty(text.class_)) {
                        count = 0;
                        if (mapStyleCount.containsKey(text.class_)) {
                            count = mapStyleCount.get(text.class_);
                        }
                        mapStyleCount.put(text.class_, count + 1);
                    }
                    if (text.height > 0.0f) {
                        count = 0;
                        if (((HashMap)((Object)mapHeight)).containsKey(Float.valueOf(text.height))) {
                            count = (Integer)((HashMap)((Object)mapHeight)).get(Float.valueOf(text.height));
                        }
                        ((HashMap)((Object)mapHeight)).put(Float.valueOf(text.height), count + 1);
                    }
                    if (commonInfo == null) continue;
                    text.text = this.common.replaceText(commonInfo.normalize, text.text).trim();
                }
            }
            String keyMostStyle = this.getMaxLangCount(mapStyleCount);
            HTMLObject.StyleObject mostStyle = doc.style.get(keyMostStyle);
            for (HTMLObject.PageObject page : doc.pages) {
                int len = page.texts.size();
                for (int i = 0; i < len; ++i) {
                    HTMLObject.TextObject text = page.texts.get(i);
                    if (text.deleted) continue;
                    if (this.common.IsEmpty(text.text)) {
                        text.deleted = true;
                        continue;
                    }
                    StringBuffer sb = new StringBuffer(text.text.trim());
                    boolean hasUpdated = false;
                    if (i + 1 >= len) continue;
                    for (j = i + 1; j < len; ++j) {
                        nextText = page.texts.get(j);
                        if (text.deleted) continue;
                        if (this.common.IsEmpty(nextText.text)) {
                            nextText.deleted = true;
                            continue;
                        }
                        if (!this.isMergeTop(text, nextText)) {
                            i = j - 1;
                            break;
                        }
                        sb.append(" " + nextText.text.trim());
                        if (nextText.islink) {
                            text.color = mostStyle.color;
                            text.fontfamily = mostStyle.family;
                            text.class_ = mostStyle.id;
                        }
                        if (nextText.top < text.top) {
                            text.top = nextText.top;
                        }
                        if (nextText.bottom > text.bottom) {
                            text.bottom = nextText.bottom;
                        }
                        if (nextText.text.length() > text.text.length()) {
                            text.fontfamily = nextText.fontfamily;
                            text.color = nextText.color;
                            text.class_ = nextText.class_;
                        }
                        text.right = nextText.right;
                        text.width = text.right - text.left;
                        text.height = text.bottom - text.top;
                        nextText.deleted = true;
                        hasUpdated = true;
                    }
                    if (!hasUpdated) continue;
                    text.text = sb.toString();
                }
            }
            for (HTMLObject.PageObject page : doc.pages) {
                ArrayList<HTMLObject.TextObject> newTexts = new ArrayList<HTMLObject.TextObject>();
                float fLineSpace = new Float("-99.0").floatValue();
                int len = page.texts.size();
                block9: for (int i = 0; i < len; ++i) {
                    HTMLObject.TextObject text = page.texts.get(i);
                    if (text.deleted || this.common.IsEmpty(text.text)) continue;
                    newTexts.add(text);
                    if (i + 1 < len) {
                        for (j = i + 1; j < len; ++j) {
                            nextText = page.texts.get(j);
                            if (nextText.deleted || this.common.IsEmpty(nextText.text)) continue;
                            if (text.text.trim().endsWith(",") && this.isClassChanged(text, nextText)) {
                                newTexts.add(this.getNewText(this.paraMarker));
                                fLineSpace = -1.0f;
                                continue block9;
                            }
                            if (this.isTooFar(text, nextText, fLineSpace) || this.isFontChanged(text, nextText)) {
                                newTexts.add(this.getNewText(this.paraMarker));
                                fLineSpace = -1.0f;
                                continue block9;
                            }
                            if (!text.fontfamily.equals(nextText.fontfamily) && text.text.length() > 6 && nextText.text.length() > 6) {
                                newTexts.add(this.getNewText(this.paraMarker));
                                fLineSpace = -1.0f;
                                continue block9;
                            }
                            if (!(fLineSpace < 0.0f)) continue block9;
                            fLineSpace = nextText.top - text.top;
                            continue block9;
                        }
                        continue;
                    }
                    newTexts.add(this.getNewText(this.paraMarker));
                }
                page.texts.clear();
                page.texts.addAll(newTexts);
            }
            List<Object> joinList = new ArrayList();
            List<Object> eofList = new ArrayList();
            if (this.config != null && this.config.get("common") != null) {
                joinList = this.config.get((String)"common").joinWords;
                eofList = this.config.get((String)"common").absoluteEOF;
            }
            for (HTMLObject.PageObject page : doc.pages) {
                int len = page.texts.size();
                block12: for (int i = 0; i < len; ++i) {
                    HTMLObject.TextObject text = page.texts.get(i);
                    if (text.deleted || text.text.equals(this.paraMarker)) continue;
                    boolean isJoin = false;
                    if (i + 1 >= len) continue;
                    for (int j2 = i + 1; j2 < len; ++j2) {
                        HTMLObject.TextObject nextText2 = page.texts.get(j2);
                        if (nextText2.deleted) continue;
                        if (nextText2.text.equals(this.paraMarker) || !text.lang.equals(nextText2.lang)) continue block12;
                        boolean isEOF = false;
                        for (Object rule : eofList) {
                            if (!this.common.IsEmpty(((Config.EOFInfo)rule).front) && !this.common.IsEmpty(((Config.EOFInfo)rule).back)) {
                                if (text.text.matches(((Config.EOFInfo)rule).front) && nextText2.text.matches(((Config.EOFInfo)rule).back)) {
                                    isEOF = true;
                                }
                            } else if (!this.common.IsEmpty(((Config.EOFInfo)rule).front)) {
                                if (text.text.matches(((Config.EOFInfo)rule).front)) {
                                    isEOF = true;
                                }
                            } else if (!this.common.IsEmpty(((Config.EOFInfo)rule).back) && nextText2.text.matches(((Config.EOFInfo)rule).back)) {
                                isEOF = true;
                            }
                            if (!isEOF) continue;
                            isJoin = false;
                            break;
                        }
                        if (!isEOF) {
                            for (Object rule : joinList) {
                                if (!this.common.IsEmpty(((Config.JoinWordInfo)rule).front) && !this.common.IsEmpty(((Config.JoinWordInfo)rule).back)) {
                                    if (text.text.matches(((Config.JoinWordInfo)rule).front) && nextText2.text.matches(((Config.JoinWordInfo)rule).back)) {
                                        isJoin = true;
                                    }
                                } else if (!this.common.IsEmpty(((Config.JoinWordInfo)rule).front)) {
                                    if (text.text.matches(((Config.JoinWordInfo)rule).front)) {
                                        isJoin = true;
                                    }
                                } else if (!this.common.IsEmpty(((Config.JoinWordInfo)rule).back) && nextText2.text.matches(((Config.JoinWordInfo)rule).back)) {
                                    isJoin = true;
                                }
                                if (!isJoin) continue;
                                text.text = text.text + ((Config.JoinWordInfo)rule).joinText + nextText2.text;
                                nextText2.deleted = true;
                                break;
                            }
                        }
                        if (isJoin) continue;
                        i = j2 - 1;
                        continue block12;
                    }
                }
            }
        }
        finally {
            refDoc.set(doc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void languageId(AtomicReference<HTMLObject.DocumentObject> refDoc) {
        HTMLObject.DocumentObject doc = refDoc.get();
        try {
            DetectLanguage detectLang = null;
            try {
                detectLang = new DetectLanguage();
            }
            catch (UnsatisfiedLinkError e) {
                doc.warningList.add(new HTMLObject.WarnObject("languageId", this.common.getStackTrace(e)));
            }
            catch (Exception e) {
                doc.warningList.add(new HTMLObject.WarnObject("languageId", this.common.getStackTrace(e)));
            }
            if (detectLang == null) {
                return;
            }
            ArrayList<Config.NormalizeInfo> normalizeList = new ArrayList();
            Config.LangInfo langInfo = new Config.LangInfo();
            HashMap<String, Integer> mapLang = new HashMap<String, Integer>();
            List<DetectLanguage.LanguageResult> results = null;
            for (HTMLObject.PageObject page : doc.pages) {
                int len = page.texts.size();
                for (int i = 0; i < len; ++i) {
                    HTMLObject.TextObject text = page.texts.get(i);
                    if (text.deleted || text.text.equals(this.paraMarker) || !this.canDetectLang(text) || (results = detectLang.find(text.text)) == null || results.size() <= 0) continue;
                    DetectLanguage.LanguageResult lang = results.get(0);
                    if (!lang.reliable) continue;
                    text.lang = lang.language;
                    if (this.config != null && (langInfo = this.config.get(text.lang)) != null) {
                        normalizeList = langInfo.normalize;
                        text.text = this.common.replaceText(normalizeList, text.text);
                    }
                    int count = 0;
                    if (mapLang.containsKey(lang.language)) {
                        count = mapLang.get(lang.language);
                    }
                    mapLang.put(lang.language, count + 1);
                }
            }
            doc.language = this.getMaxLangCount(mapLang);
            doc.langList = this.getLangList(mapLang);
        }
        catch (Exception exception) {
        }
        finally {
            refDoc.set(doc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sentenceJoin(AtomicReference<HTMLObject.DocumentObject> refDoc) {
        HTMLObject.DocumentObject doc = refDoc.get();
        if (this.common.IsEmpty(doc.language)) {
            return;
        }
        try {
            for (HTMLObject.PageObject page : doc.pages) {
                String currentLang = "";
                ArrayList<HTMLObject.TextObject> texts = new ArrayList<HTMLObject.TextObject>();
                ArrayList<HTMLObject.TextObject> newTexts = new ArrayList<HTMLObject.TextObject>();
                int len = page.texts.size();
                for (int i = 0; i < len; ++i) {
                    HTMLObject.TextObject text = page.texts.get(i);
                    if (text.deleted) continue;
                    if (this.common.IsEmpty(text.lang)) {
                        text.lang = doc.language;
                    }
                    if (i == 0 || this.common.IsEmpty(currentLang)) {
                        currentLang = !this.common.IsEmpty(text.lang) ? text.lang : doc.language;
                        texts.add(text);
                        continue;
                    }
                    if (text.text.equals(this.paraMarker) || !this.common.IsEmpty(currentLang) && !this.common.IsEmpty(text.lang) && !text.lang.equals(currentLang)) {
                        if (text.text.equals(this.paraMarker)) {
                            newTexts.add(text);
                        }
                        if (!text.lang.equals(currentLang)) {
                            newTexts.add(this.getNewText(this.paraMarker));
                        }
                        newTexts.addAll(this.sentenceJoin(texts, currentLang));
                        texts.clear();
                        if (!text.text.equals(this.paraMarker)) {
                            texts.add(text);
                            if (!this.common.IsEmpty(text.lang)) {
                                currentLang = text.lang;
                                continue;
                            }
                            currentLang = doc.language;
                            continue;
                        }
                        currentLang = "";
                        continue;
                    }
                    texts.add(text);
                }
                if (texts.size() > 0) {
                    newTexts.add(this.getNewText(this.paraMarker));
                    newTexts.addAll(this.sentenceJoin(texts, currentLang));
                    texts.clear();
                }
                List<HTMLObject.TextObject> tempTextJoin = new ArrayList<HTMLObject.TextObject>();
                int processingIndex = 0;
                block7: for (int i = 0; i < newTexts.size() - 2; ++i) {
                    for (int j = i + 1; j < newTexts.size(); ++j) {
                        if (!this.paraMarker.equals(((HTMLObject.TextObject)newTexts.get((int)j)).text) && !((HTMLObject.TextObject)newTexts.get((int)j)).deleted || ((HTMLObject.TextObject)newTexts.get((int)(j - 1))).deleted) continue;
                        processingIndex = j - 1;
                        if (!this.paraMarker.equals(((HTMLObject.TextObject)newTexts.get((int)j)).text)) continue;
                        for (int k = j + 1; k < newTexts.size(); ++k) {
                            if (((HTMLObject.TextObject)newTexts.get((int)k)).deleted) continue;
                            HTMLObject.TextObject textleft = (HTMLObject.TextObject)newTexts.get(processingIndex);
                            HTMLObject.TextObject textright = (HTMLObject.TextObject)newTexts.get(k);
                            if (!textleft.lang.equals(textright.lang)) {
                                processingIndex = k;
                                break;
                            }
                            tempTextJoin.add(textleft);
                            tempTextJoin.add(textright);
                            tempTextJoin = this.sentenceJoin(tempTextJoin, textleft.lang);
                            if (tempTextJoin.size() > 1) {
                                processingIndex = k;
                            } else {
                                ((HTMLObject.TextObject)newTexts.get((int)processingIndex)).text = tempTextJoin.get((int)0).text;
                                ((HTMLObject.TextObject)newTexts.get((int)k)).deleted = true;
                                ((HTMLObject.TextObject)newTexts.get((int)j)).deleted = true;
                            }
                            tempTextJoin = new ArrayList();
                            break;
                        }
                        if (processingIndex <= j) continue;
                        i = processingIndex - 1;
                        continue block7;
                    }
                }
                page.texts.clear();
                page.texts.addAll(newTexts);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            refDoc.set(doc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalRepair(AtomicReference<HTMLObject.DocumentObject> refDoc) {
        HTMLObject.DocumentObject doc = refDoc.get();
        try {
            ArrayList<Config.NormalizeInfo> repairList = new ArrayList();
            if (this.config.get("common") != null) {
                repairList = this.config.get((String)"common").repair;
            }
            Config.LangInfo langInfo = new Config.LangInfo();
            for (HTMLObject.PageObject page : doc.pages) {
                int len = page.texts.size();
                for (int i = 0; i < len; ++i) {
                    HTMLObject.TextObject text = page.texts.get(i);
                    if (text.deleted || text.text.equals(this.paraMarker)) continue;
                    text.text = this.common.replaceText(repairList, text.text);
                    if (this.common.IsEmpty(text.lang) || (langInfo = this.config.get(text.lang)) == null) continue;
                    List<Config.NormalizeInfo> langRepairList = langInfo.repair;
                    text.text = this.common.replaceText(langRepairList, text.text);
                }
            }
        }
        finally {
            refDoc.set(doc);
        }
    }

    private StringBuffer generateOutput(AtomicReference<HTMLObject.DocumentObject> refDoc, int keepBrTags, int getPermission) {
        HTMLObject.DocumentObject doc = refDoc.get();
        StringBuffer sbOut = new StringBuffer();
        boolean isKenlmError = false;
        sbOut.append("<html>\n");
        sbOut.append("<head>\n");
        sbOut.append("<defaultLang abbr=\"" + doc.language + "\" />\n");
        sbOut.append("<languages>\n");
        ArrayList<String> noModel = new ArrayList<String>();
        ArrayList<String> errorModel = new ArrayList<String>();
        for (HTMLObject.LangObject lang : doc.langList) {
            sbOut.append("<language abbr=\"" + lang.name + "\" percent=\"" + lang.percent + "\" rows=\"" + lang.count + "\" />\n");
            SentenceJoin sj = this._hashSentenceJoin.get(lang.name);
            if (this._hashSentenceJoin.containsKey(lang.name) && sj == null) {
                noModel.add(lang.name);
                continue;
            }
            if (null == sj || sj.status() != SentenceJoin.WorkerStatus.ERROR) continue;
            isKenlmError = sj.isKenlmError;
            errorModel.add(lang.name);
        }
        String scriptPath = this.config.getSentenceJoinScript();
        if (StringUtils.isEmpty(scriptPath) || !this.common.IsExist(scriptPath)) {
            doc.warningList.add(new HTMLObject.WarnObject("sentenceJoin", "Fail loading Python script sentence-join.py", "Please specify/verify the \"sentence_join\" value in the configuration files."));
        } else {
            if (errorModel.size() > 0) {
                if (isKenlmError) {
                    doc.warningList.add(new HTMLObject.WarnObject("sentenceJoin", "Fail loading model for language: " + String.join((CharSequence)", ", errorModel) + "", "Please verify the KenLM path on the argument of command-line."));
                } else {
                    doc.warningList.add(new HTMLObject.WarnObject("sentenceJoin", "Fail loading model for language: " + String.join((CharSequence)", ", errorModel) + "", "Please verify the \"sentencejoin_model\" value of language {" + String.join((CharSequence)", ", errorModel) + "} in configuration file."));
                }
            }
            if (noModel.size() > 0) {
                doc.warningList.add(new HTMLObject.WarnObject("sentenceJoin", "No model for language: " + String.join((CharSequence)", ", noModel) + "", "Please specify the \"sentencejoin_model\" value of language {" + String.join((CharSequence)", ", noModel) + "} in configuration file."));
            }
        }
        sbOut.append("</languages>\n");
        if (doc.warningList.size() > 0) {
            sbOut.append("<warnings>\n");
            for (HTMLObject.WarnObject warnObj : doc.warningList) {
                sbOut.append("<warning>\n");
                sbOut.append("<method>" + warnObj.method + "</method>\n");
                sbOut.append("<details>\n");
                sbOut.append("\t<message>");
                sbOut.append("<![CDATA[");
                sbOut.append(warnObj.detail);
                sbOut.append("]]>");
                sbOut.append("</message>\n");
                sbOut.append("\t<suggestion>");
                sbOut.append("<![CDATA[");
                sbOut.append(warnObj.solution);
                sbOut.append("]]>");
                sbOut.append("</suggestion>\n");
                sbOut.append("</details>\n");
                sbOut.append("</warning>\n");
            }
            sbOut.append("</warnings>\n");
        }
        if (getPermission == 1) {
            sbOut.append("<permission isencrypted=\"" + doc.permission.isEncrytped + "\">\n");
            sbOut.append("<canassemply>" + doc.permission.canAssembly + "</canassemply>\n");
            sbOut.append("<cancopy>" + doc.permission.canCopy + "</cancopy>\n");
            sbOut.append("<canmodified>" + doc.permission.canModified + "</canmodified>\n");
            sbOut.append("<canmodifyannotations>" + doc.permission.canModifyAnnotations + "</canmodifyannotations>\n");
            sbOut.append("<canprint>" + doc.permission.canPrint + "</canprint>\n");
            sbOut.append("<canprintdegraded>" + doc.permission.canPrintDegraded + "</canprintdegraded>\n");
            sbOut.append("<canfillinform>" + doc.permission.canFillInForm + "</canfillinform>\n");
            sbOut.append("<canscreenreader>" + doc.permission.canScreenReader + "</canscreenreader>\n");
            sbOut.append("</permission>\n");
        }
        sbOut.append("</head>\n");
        sbOut.append("<body>\n");
        for (HTMLObject.PageObject page : doc.pages) {
            sbOut.append("<div id=\"page" + page.pageno + "\" class=\"page\">\n");
            int ipara = 1;
            boolean bpara = false;
            if (page.texts.size() > 0) {
                int len = page.texts.size();
                for (int i = 0; i < len; ++i) {
                    HTMLObject.TextObject text = page.texts.get(i);
                    if (text.deleted || this.common.IsEmpty(text.text)) continue;
                    if (text.text.equals(this.paraMarker) && !text.deleted) {
                        if (bpara) {
                            sbOut.append("</p>\n");
                            bpara = false;
                        }
                        if (i + 1 >= len || page.texts.get((int)(i + 1)).text.equals(this.paraMarker) && !page.texts.get((int)(i + 1)).deleted || this.common.IsEmpty(page.texts.get((int)(i + 1)).text)) continue;
                        String lang = page.texts.get((int)(i + 1)).lang;
                        String font = page.texts.get((int)(i + 1)).fontfamily;
                        sbOut.append("<p id=\"page" + page.pageno + "p" + ipara++ + "\" lang=\"" + lang + "\" fontname=\"" + font + "\">\n");
                        bpara = true;
                        continue;
                    }
                    if (!bpara) {
                        sbOut.append("<p id=\"page" + page.pageno + "p" + ipara++ + "\" lang=\"" + text.lang + "\" fontname=\"" + text.fontfamily + "\">\n");
                        bpara = true;
                    }
                    sbOut.append(text.text.trim());
                    sbOut.append((keepBrTags == 1 ? "<br />" : "") + "\n");
                }
                if (ipara > 1) {
                    sbOut.append("</p>\n");
                }
            }
            sbOut.append("</div>\n");
        }
        sbOut.append("</body>\n");
        sbOut.append("</html>\n");
        return sbOut;
    }

    private HTMLObject.TextObject getTextObject(String line, HashMap<String, HTMLObject.StyleObject> mapStyle) {
        String text;
        HTMLObject.TextObject obj = new HTMLObject.TextObject();
        obj.top = this.common.getFloat(this.patternTop.matcher(line).replaceAll("$1"));
        obj.left = this.common.getFloat(this.patternLeft.matcher(line).replaceAll("$1"));
        obj.width = this.common.getFloat(this.patternWidth.matcher(line).replaceAll("$1"));
        obj.height = this.common.getFloat(this.patternHeight.matcher(line).replaceAll("$1"));
        obj.bottom = obj.top + obj.height;
        obj.right = obj.left + obj.width;
        obj.text = this.common.getStr(this.patternWord.matcher(line).replaceAll("$1"));
        obj.class_ = this.common.getStr(this.patternFont.matcher(line).replaceAll("$1"));
        if (mapStyle != null && mapStyle.containsKey(obj.class_)) {
            HTMLObject.StyleObject css = mapStyle.get(obj.class_);
            obj.fontsize = css.size;
            obj.fontfamily = css.family;
            obj.color = css.color;
        }
        if (this.patternLink.matcher(text = obj.text).matches()) {
            obj.islink = true;
        }
        text = text.replaceAll("<br\\/>", "_LSBRLS_");
        text = text.replaceAll("<[^>]*>", "");
        text = text.replaceAll("&#160;", " ").replaceAll("\\s{2,100}", " ");
        obj.text = text = text.replaceAll("_LSBRLS_", "<br/>");
        return obj;
    }

    private boolean checkLineAdd(float pageWidth, float pageHeight, HTMLObject.TextObject text) {
        return !(text.left < 0.0f || text.top < 0.0f || text.left > pageWidth) && !(text.top > pageHeight);
    }

    private boolean isFontChanged(HTMLObject.TextObject text, HTMLObject.TextObject nextText) {
        return text.fontsize != nextText.fontsize && !this.isEquals(Float.valueOf(text.height), Float.valueOf(nextText.height)) || !text.color.equals(nextText.color) && !this.isEquals(Float.valueOf(text.top), Float.valueOf(nextText.top));
    }

    private boolean isClassChanged(HTMLObject.TextObject text, HTMLObject.TextObject nextText) {
        return !text.class_.equals(nextText.class_);
    }

    private Float getMaxCount(HashMap<Float, Integer> map) {
        if (map == null || map.size() == 0) {
            return Float.valueOf(0.0f);
        }
        Map.Entry<Float, Integer> maxEntry = null;
        for (Map.Entry<Float, Integer> entry : map.entrySet()) {
            if (maxEntry != null && entry.getValue().compareTo(maxEntry.getValue()) <= 0) continue;
            maxEntry = entry;
        }
        return (Float)maxEntry.getKey();
    }

    private String getMaxLangCount(HashMap<String, Integer> map) {
        if (map == null || map.size() == 0) {
            return "";
        }
        Map.Entry<String, Integer> maxEntry = null;
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            if (maxEntry != null && entry.getValue().compareTo(maxEntry.getValue()) <= 0) continue;
            maxEntry = entry;
        }
        return (String)maxEntry.getKey();
    }

    private HTMLObject.TextObject getNewText(String val) {
        HTMLObject.TextObject t = new HTMLObject.TextObject();
        t.text = val;
        return t;
    }

    private boolean isEquals(Float f1, Float f2) {
        return Math.abs(f1.floatValue() - f2.floatValue()) <= 8.0f;
    }

    private boolean isTooFar(HTMLObject.TextObject text, HTMLObject.TextObject nextText, float fLinespace) {
        float ftempLineSpace = 0.0f;
        boolean bResult = fLinespace > 0.0f ? ((double)(ftempLineSpace = Math.abs(text.top - nextText.top)) >= 0.7 * (double)fLinespace && (double)ftempLineSpace <= 1.3 * (double)fLinespace && (text.left - nextText.left < 0.0f || text.left - nextText.left > 0.0f) ? true : (double)ftempLineSpace < 0.7 * (double)fLinespace || (double)ftempLineSpace > 1.3 * (double)fLinespace) : (double)Math.abs(text.top - nextText.top) > (double)(text.height + nextText.height) * 1.5 || !(Math.abs(text.left - nextText.left) <= 100.0f) || !(Math.abs(text.left - nextText.left) >= 0.0f) || text.text.length() <= 10;
        return bResult;
    }

    private boolean isMergeTop(HTMLObject.TextObject text, HTMLObject.TextObject nextText) {
        return this.isEquals(Float.valueOf(text.top), Float.valueOf(nextText.top)) && !this.isFontChanged(text, nextText) && nextText.left - text.right < 200.0f;
    }

    private boolean canDetectLang(HTMLObject.TextObject text) {
        String str = text.text;
        str = str.replaceAll("[\\?\\!\\,0-9\\-\\_\\#\\*\\&\\(\\)\\+\\=\\@\\%\\<\\>\\{\\}\\[\\]\\^\\\\\\/\\;\\.{2,100}]*", "");
        str = str.replaceAll("\\s\\.{2,100}", "");
        str = str.replaceAll("\\:", " ");
        str = str.replaceAll("[\u03c3\u03a6\u03d5\u2208\u2020\u03c4\u03c8\u03b7\u2207\u03c0\u2211\u2202\u03b1\u03b2\u2192\u220f\u03b5]*", "");
        str = str.replaceAll("\\s{2,100}", " ");
        str = str.trim();
        int wordlength = str.split(" ", -1).length;
        int charlength = str.replaceAll(" ", "").length();
        return wordlength > 10 || charlength > 30;
    }

    private List<HTMLObject.LangObject> getLangList(HashMap<String, Integer> map) {
        ArrayList<HTMLObject.LangObject> langList = new ArrayList<HTMLObject.LangObject>();
        float total = 0.0f;
        for (Map.Entry<String, Integer> hash : map.entrySet()) {
            total = (float)((double)total + this.common.getDouble(hash.getValue()));
        }
        for (Map.Entry<String, Integer> hash : map.entrySet()) {
            float percent = this.common.getFloat(hash.getValue()) * 100.0f / total;
            HTMLObject.LangObject lang = new HTMLObject.LangObject();
            lang.name = hash.getKey();
            lang.percent = percent;
            lang.count = hash.getValue();
            langList.add(lang);
        }
        Collections.sort(langList, new Comparator<HTMLObject.LangObject>(){

            @Override
            public int compare(HTMLObject.LangObject l1, HTMLObject.LangObject l2) {
                return Float.compare(l2.percent, l1.percent);
            }
        });
        return langList;
    }

    private String getFirstWords(String str) {
        String[] words = str.split(" ");
        int wordlength = words.length;
        String newStr = "";
        for (int i = 0; i <= this.maxWordsJoin && i < wordlength; ++i) {
            newStr = newStr + " " + words[i];
        }
        return newStr.trim();
    }

    private String getLastWords(String str) {
        String[] words = str.trim().split(" ");
        int wordlength = words.length;
        int count = 0;
        String newStr = "";
        for (int i = wordlength - 1; i >= 0 && count <= this.maxWordsJoin; --i, ++count) {
            newStr = words[i] + " " + newStr;
        }
        return newStr.trim();
    }

    private String getSentenceJoinModel(String lang) {
        if (this.config != null && this.config.get(lang) != null) {
            return this.config.get((String)lang).sentenceJoinModel;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HTMLObject.TextObject> sentenceJoin(List<HTMLObject.TextObject> texts, String lang) {
        ArrayList<HTMLObject.TextObject> newTexts = new ArrayList<HTMLObject.TextObject>();
        try {
            SentenceJoin sj;
            if (texts.size() < 2) {
                return texts;
            }
            Object object = this._objectWorker;
            synchronized (object) {
                if (this._hashSentenceJoin.containsKey(lang)) {
                    sj = this._hashSentenceJoin.get(lang);
                } else {
                    String scriptPath = this.config.getSentenceJoinScript();
                    String sKenlmPath = this.config.getKenlmPath();
                    String modelPath = this.getSentenceJoinModel(lang);
                    if (this.common.IsExist(scriptPath) && !this.common.IsEmpty(modelPath)) {
                        sj = new SentenceJoin(lang, scriptPath, modelPath, sKenlmPath);
                        this._hashSentenceJoin.put(lang, sj);
                    } else {
                        sj = null;
                        this._hashSentenceJoin.put(lang, sj);
                    }
                }
                if (sj != null && sj.status() != SentenceJoin.WorkerStatus.RUNNING && sj.status() != SentenceJoin.WorkerStatus.LOADING && sj.status() != SentenceJoin.WorkerStatus.ERROR) {
                    sj.start();
                }
            }
            if (sj != null && sj.status() == SentenceJoin.WorkerStatus.RUNNING) {
                int start = 0;
                for (int i = texts.size() - 1; i >= start; --i) {
                    HTMLObject.TextObject text = texts.get(i);
                    if (i - 1 >= 0) {
                        HTMLObject.TextObject prevText = texts.get(i - 1);
                        String text1 = this.getLastWords(prevText.text).trim();
                        String text2 = this.getFirstWords(text.text).trim();
                        boolean isJoin = false;
                        if (!(this.common.IsEmpty(text1) || this.common.IsEmpty(text2) || text1.trim().endsWith(".") || text2.trim().startsWith("\u2022") || text1.trim().equals("\u00a0") || text2.trim().equals("\u00a0"))) {
                            isJoin = sj.execute(text1, text2);
                        }
                        if (isJoin) {
                            prevText.text = prevText.text.trim() + " " + text.text.trim();
                            text.deleted = true;
                            continue;
                        }
                        newTexts.add(text);
                        continue;
                    }
                    newTexts.add(text);
                }
                return Lists.reverse(newTexts);
            }
        }
        catch (Exception e) {
            this.common.print(e.getMessage());
        }
        return texts;
    }

    public void shutdownProcess() throws Exception {
        if (this._hashSentenceJoin != null && this._hashSentenceJoin.size() > 0) {
            for (Map.Entry<String, SentenceJoin> hash : this._hashSentenceJoin.entrySet()) {
                if (hash.getValue() == null) continue;
                hash.getValue().stop();
            }
        }
    }
}

