/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.knot;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class NNetLanguageIdentifierWrapper {
    private long identifierCppPtr;

    public NNetLanguageIdentifierWrapper() {
        this.identifierCppPtr = NNetLanguageIdentifierWrapper.newNNetLanguageIdentifier();
    }

    public NNetLanguageIdentifierWrapper(int n, int n2) {
        this.identifierCppPtr = NNetLanguageIdentifierWrapper.newNNetLanguageIdentifier(n, n2);
    }

    public void dispose() {
        if (this.identifierCppPtr != 0L) {
            NNetLanguageIdentifierWrapper.deleteNNetLanguageIdentifier(this.identifierCppPtr);
            this.identifierCppPtr = 0L;
        }
    }

    public native Result findLanguage(String var1);

    public native Result[] findTopNMostFreqLangs(String var1, int var2);

    public static native String getUnknown();

    public static native int getMinNumBytesToConsider();

    public static native int getMaxNumBytesToConsider();

    public static native int getMaxNumInputBytesToConsider();

    public static native float getReliabilityThreshold();

    public static native float getReliabilityHrBsThreshold();

    private static native long newNNetLanguageIdentifier();

    private static native long newNNetLanguageIdentifier(int var0, int var1);

    private static native void deleteNNetLanguageIdentifier(long var0);

    static {
        String string = System.mapLibraryName("forcld3");
        try {
            System.loadLibrary("forcld3");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            try {
                File file = new File(System.getProperty("java.io.tmpdir"), "native-forcld3-" + System.nanoTime());
                if (!file.mkdir()) {
                    throw new IOException("Failed to create temporary directory.");
                }
                file.deleteOnExit();
                File file2 = new File(file, string);
                InputStream inputStream = NNetLanguageIdentifierWrapper.class.getResourceAsStream("/" + string);
                Files.copy(inputStream, file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
                file2.deleteOnExit();
                System.load(file2.getAbsolutePath());
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            catch (NullPointerException nullPointerException) {
                throw new RuntimeException("File '" + string + "' was not found inside JAR.");
            }
        }
    }

    public static class Result {
        public String language = NNetLanguageIdentifierWrapper.getUnknown();
        public float probability = 0.0f;
        public boolean isReliable = false;
        public float proportion = 0.0f;

        public Result(String string, float f, boolean bl, float f2) {
            this.language = string;
            this.probability = f;
            this.isReliable = bl;
            this.proportion = f2;
        }
    }
}

