/*
 * Decompiled with CFR 0.152.
 */
package pdfextract;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import pdfextract.Config;

public class Common {
    Object _oLockerFile = new Object();
    private int verbose = 1;

    public static boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("win") >= 0;
    }

    public static boolean isMac() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("mac") >= 0;
    }

    public static boolean isUnix() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0;
    }

    public String getJarPath() {
        String applicationDir = this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
        if (applicationDir.endsWith(".jar")) {
            String regex = "[/]([^\\/]+\\.jar)";
            Pattern p = Pattern.compile(regex, 2);
            Matcher m3 = p.matcher(applicationDir);
            String jar = "";
            while (m3.find()) {
                jar = m3.group(1);
            }
            applicationDir = applicationDir.replace(jar, "");
        }
        return applicationDir;
    }

    public String combine(String path1, String path2) {
        File file1 = new File(path1);
        File file2 = new File(file1, path2);
        String path = file2.getPath();
        path = Common.isWindows() ? path.replace("/", "\\") : path.replace("\\", "/");
        return path;
    }

    public String readFile(String filePath) throws Exception {
        String data = "";
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                return "";
            }
            FileInputStream fin = new FileInputStream(file);
            byte[] fileContent = new byte[(int)file.length()];
            fin.read(fileContent);
            data = new String(fileContent);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        data = data.replace("\ufeff", "");
        data = data.replace("\ufeff\r\n", "\n");
        data = data.replace("\ufeff\r", "\n");
        return data.replace("\u00ef\u00bb\u00bf", "");
    }

    public List<String> readLines(String filePath) throws Exception {
        return FileUtils.readLines(this.getFile(filePath));
    }

    public void copyFileToFolder(File file, File folder) throws IOException {
        String newPath = this.combine(folder.getPath(), file.getName());
        File fileNew = new File(newPath);
        if (fileNew.exists()) {
            fileNew.delete();
        }
        FileUtils.copyFileToDirectory(file, folder);
    }

    public String getStr(Object obj) {
        try {
            if (obj == null) {
                return "";
            }
            return obj.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public Boolean getBool(Object obj) {
        try {
            if (obj == null) {
                return false;
            }
            if (obj.toString().equals("1") || obj.toString().toLowerCase().trim().equals("true")) {
                return true;
            }
            return Boolean.valueOf(obj.toString());
        }
        catch (Exception e) {
            return false;
        }
    }

    public int getInt(Object obj) {
        try {
            if (obj == null) {
                return 0;
            }
            if (obj.equals("")) {
                return 0;
            }
            return Integer.parseInt(obj.toString());
        }
        catch (Exception e) {
            return 0;
        }
    }

    public long getLong(Object obj) {
        if (obj.equals("")) {
            return 0L;
        }
        return Long.parseLong(obj.toString());
    }

    public float getFloat(Object obj) {
        try {
            if (obj == null) {
                return 0.0f;
            }
            if (obj == "") {
                return 0.0f;
            }
            return Float.parseFloat(obj.toString().trim());
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public double getDouble(Object obj) {
        try {
            if (obj == null) {
                return 0.0;
            }
            if (obj == "") {
                return 0.0;
            }
            return Double.parseDouble(obj.toString().trim());
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public boolean IsEmpty(Object object) {
        if (object == null) {
            return true;
        }
        return object.toString().trim().length() == 0;
    }

    public boolean IsNull(Object object) {
        return object == null;
    }

    public boolean IsExist(File file) {
        return file != null && file.exists();
    }

    public boolean IsExist(String filepath) {
        File file = this.getFile(filepath);
        return file != null && file.exists();
    }

    public boolean validateFile(String filepath) {
        File file = this.getFile(filepath);
        if (file != null && file.exists()) {
            if (!file.canWrite()) {
                return false;
            }
            try {
                new FileOutputStream(file, true).close();
            }
            catch (IOException e) {
                return false;
            }
            return true;
        }
        try {
            file.createNewFile();
            file.delete();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void createDir(String filepath) {
        this.getFile(filepath).mkdirs();
    }

    public File getFile(String filepath) {
        return new File(filepath);
    }

    public String getExtension(String filepath) {
        return FilenameUtils.getExtension(filepath);
    }

    public String getName(String filepath) {
        return FilenameUtils.getName(filepath);
    }

    public String getBaseName(String filepath) {
        return FilenameUtils.getBaseName(filepath);
    }

    public String getParentPath(String filepath) {
        File file = this.getFile(filepath);
        if (file != null && file.getParentFile() != null) {
            return file.getParentFile().getPath();
        }
        return "";
    }

    public void printHelp() {
        System.out.println("------------------------");
        System.out.println("Arguments");
        System.out.println("------------------------");
        System.out.print("-I <input_file>\t\t");
        System.out.println("specifies the path to the source PDF file process for extraction.");
        System.out.print("-O <output_file>\t");
        System.out.println("specifies the path to the output HTML file after extraction.");
        System.out.print("-B <batch_file>\t\t");
        System.out.println("specifies the path to the batch file for processing list of files.\n\t\t\tThe input file and output file are specified on the same line delimited by a tab.\n\t\t\tEach line is delimited by a new line character.");
        System.out.print("-L <log_path>\t\t");
        System.out.println("specifies the path to write the log file to.\n\t\t\tAs it is common for PDF files to have issues when processing\n\t\t\tsuch as being password protected or other forms of restricted permissions,\n\t\t\tthe log file can be written to a specifed location for additional processing.\n\t\t\tIf not specified, then the log file will write to stdout.");
        System.out.print("-T <number_threads>\t");
        System.out.println("specifies the number of threads to run concurrently when processing PDF files.\n\t\t\tOne file can be processed per thread. If not specified, then the default valur of 1 thread is used.");
        System.out.print("-v\t\t\t");
        System.out.println("enables Verbose mode.");
        System.out.print("--keepbrtags\t\t");
        System.out.println("by default <br /> is not included in the output. \n\t\t\tWhen this argument is specified, then the output will include the <br /> tag after each line.");
        System.out.print("-S <sentence_join>\t");
        System.out.println("specifies the Sentence Join python script path.");
        System.out.print("-K <Kenlm_Path>\t\t");
        System.out.println("specifies the Kenlm path.");
        System.out.println("------------------------");
    }

    public void WriteFile(String filePath, String content) throws Exception {
        if (this.IsEmpty(filePath) || this.IsEmpty(content)) {
            return;
        }
        File file = new File(filePath);
        if (!(file.getParentFile() == null || this.IsExist(file.getParentFile()) && file.getParentFile().isDirectory())) {
            file.getParentFile().mkdirs();
        }
        FileUtils.writeStringToFile(file, content, "UTF-8", false);
    }

    public String getLogPath() {
        String jarPath = this.getJarPath();
        String logPath = this.combine(jarPath, "Log");
        return logPath;
    }

    public void writeLog(String path, String message) {
        this.writeLog(path, message, false);
    }

    public void writeLog(String path, String message, boolean isError) {
        this.writeLog(path, "", message, isError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLog(String path, String inputfile, String message, boolean isError) {
        if (this.verbose == 1) {
            Object object = this._oLockerFile;
            synchronized (object) {
                BufferedWriter oBuffer = null;
                try {
                    File dir;
                    Calendar oCal = Calendar.getInstance();
                    SimpleDateFormat oDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
                    String logfilepath = path;
                    logfilepath = Common.isWindows() ? logfilepath.replace("/", "\\") : logfilepath.replace("\\", "/");
                    File file = new File(logfilepath);
                    if (file.getParent() != null && !(dir = new File(file.getParent())).exists()) {
                        dir.mkdirs();
                    }
                    if (!this.IsEmpty(inputfile)) {
                        message = "File: " + inputfile + ", " + message;
                    }
                    FileWriter oFileWriter = new FileWriter(logfilepath, true);
                    oBuffer = new BufferedWriter(oFileWriter);
                    String text = oDateTimeFormat.format(oCal.getTime()) + "\t" + (isError ? "ERROR" : "INFO") + "\t" + message;
                    oBuffer.write(text);
                    oBuffer.newLine();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    if (oBuffer != null) {
                        try {
                            oBuffer.close();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    public void copyFile(String sorucePath, String targetPath) throws Exception {
        this.copyFile(this.getFile(sorucePath), this.getFile(targetPath));
    }

    public void copyFile(File sourceFile, File targetFile) throws Exception {
        if (!sourceFile.exists()) {
            throw new Exception("File does not exist");
        }
        if (targetFile.isDirectory()) {
            String filename = sourceFile.getName();
            String targetFilePath = this.combine(targetFile.getPath(), filename);
            targetFile = new File(targetFilePath);
        }
        if (targetFile.exists()) {
            targetFile.delete();
        }
        FileUtils.copyFile(sourceFile, targetFile);
    }

    public void moveFile(String sourcePath, String targetPath) throws Exception {
        this.moveFile(this.getFile(sourcePath), this.getFile(targetPath));
    }

    public void moveFile(File sourceFile, File targetFile) throws Exception {
        if (!sourceFile.exists()) {
            throw new Exception("File does not exist");
        }
        if (targetFile.isDirectory()) {
            String filename = sourceFile.getName();
            String targetFilePath = this.combine(targetFile.getPath(), filename);
            targetFile = new File(targetFilePath);
        }
        if (targetFile.exists()) {
            targetFile.delete();
        }
        FileUtils.moveFile(sourceFile, targetFile);
    }

    public void deleteFile(String filePath) {
        this.deleteFile(this.getFile(filePath));
    }

    public void deleteFile(File file) {
        file.delete();
    }

    public void checkPermissions(String path) {
        try {
            File file = this.getFile(path);
            file.setExecutable(true);
            file.setReadable(true);
            file.setWritable(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void print(String message) {
        this.print("", message);
    }

    public void print(String file, String message) {
        if (this.verbose == 1) {
            if (!this.IsEmpty(file)) {
                message = "File: " + file + ", " + message;
            }
            System.out.println(message);
        }
    }

    public void setVerbose(int val) {
        this.verbose = val;
    }

    public HashMap<String, String> getSearchReplaceList() {
        HashMap<String, String> list = new HashMap<String, String>();
        String searchReplacePath = this.combine(this.getJarPath(), "search-replace.tab");
        if (this.IsExist(searchReplacePath)) {
            try {
                List<String> lines = this.readLines(searchReplacePath);
                int len = lines.size();
                for (int i = 0; i < len; ++i) {
                    String[] cols = lines.get(i).split("\t");
                    if (cols.length < 2) continue;
                    list.put(cols[0], cols[1]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return list;
    }

    public String getConfigPath() {
        return this.combine(this.getJarPath(), "PDFExtract.json");
    }

    public String replaceText(HashMap<String, String> hash, String text) {
        String rtext = text;
        if (hash != null && hash.size() > 0) {
            for (Map.Entry<String, String> me : hash.entrySet()) {
                String search = me.getKey().toString();
                String replace = me.getValue().toString();
                rtext = rtext.replaceAll(search, replace);
            }
        }
        return rtext;
    }

    public String replaceText(List<Config.NormalizeInfo> normalizeList, String text) {
        String rtext = text;
        if (normalizeList != null && normalizeList.size() > 0) {
            for (Config.NormalizeInfo normalize : normalizeList) {
                String search = normalize.search;
                String replace = normalize.replace;
                rtext = rtext.replaceAll(search, replace);
            }
        }
        return rtext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStackTrace(UnsatisfiedLinkError e2) {
        String text = "";
        StringWriter writer = null;
        try {
            writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            e2.printStackTrace(printWriter);
            text = ((Object)writer).toString();
        }
        catch (Exception exception) {
        }
        finally {
            if (writer != null) {
                try {
                    ((Writer)writer).close();
                }
                catch (IOException iOException) {}
            }
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStackTrace(Exception exception) {
        String text = "";
        StringWriter writer = null;
        try {
            writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            exception.printStackTrace(printWriter);
            text = ((Object)writer).toString();
        }
        catch (Exception exception2) {
        }
        finally {
            if (writer != null) {
                try {
                    ((Writer)writer).close();
                }
                catch (IOException iOException) {}
            }
        }
        return text;
    }

    public String getOutputError(Exception e) {
        StringBuffer html = new StringBuffer("");
        html.append("<html>\n");
        html.append("<error>\n");
        html.append("<message>\n");
        html.append("<![CDATA[\n");
        html.append(e.getMessage() + "\n");
        html.append("]]>\n");
        html.append("</message>\n");
        html.append("<stacktrace>\n");
        html.append("<![CDATA[\n");
        html.append(this.getStackTrace(e) + "\n");
        html.append("]]>\n");
        html.append("</stacktrace>\n");
        html.append("</error>\n");
        html.append("</html>\n");
        return html.toString();
    }

    public JSONObject getJSONFormat(String sData) {
        if (sData == null || sData.trim().length() == 0) {
            return null;
        }
        return JSONObject.fromObject(sData);
    }

    public String getJSONValue(JSONObject json, String name) {
        if (json != null && json.has(name)) {
            return json.getString(name);
        }
        return null;
    }

    public String getJSONValue(JSONObject json, String parentname, String name) {
        if (json != null && json.has(parentname)) {
            JSONObject jobj = json.getJSONObject(parentname);
            if (jobj != null && jobj.has(name)) {
                return jobj.getString(name);
            }
            return null;
        }
        return null;
    }

    public JSONObject getJSONObject(JSONObject json, String name) {
        if (json != null && json.has(name)) {
            return json.getJSONObject(name);
        }
        return null;
    }

    public JSONObject getJSONObject(JSONObject json, String parentname, String name) {
        if (json != null && json.has(parentname)) {
            JSONObject jobj = json.getJSONObject(parentname);
            if (jobj != null && jobj.has(name)) {
                return jobj.getJSONObject(name);
            }
            return null;
        }
        return null;
    }

    public JSONArray getJSONArray(JSONObject json, String name) {
        if (json != null && json.has(name)) {
            return json.getJSONArray(name);
        }
        return null;
    }

    public JSONArray getJSONArray(JSONObject json, String parentname, String name) {
        if (json != null && json.has(parentname)) {
            JSONObject jobj = json.getJSONObject(parentname);
            if (jobj != null && jobj.has(name)) {
                return jobj.getJSONArray(name);
            }
            return null;
        }
        return null;
    }
}

