/*
 * Decompiled with CFR 0.152.
 */
package pdfextract;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import pdfextract.Common;

public class Config {
    private Common common = new Common();
    private String _path = "";
    private ConfigInfo _config = new ConfigInfo();

    public Config(String path) throws Exception {
        this._path = path;
        this.load();
    }

    public Config(String path, String kenlmPath, String sentenceJoinPath) throws Exception {
        this._path = path;
        this.load(kenlmPath, sentenceJoinPath);
    }

    private List<NormalizeInfo> getNormalizeList(JSONArray jArray) {
        ArrayList<NormalizeInfo> list = new ArrayList<NormalizeInfo>();
        if (jArray != null) {
            int jlen = jArray.size();
            for (int j = 0; j < jlen; ++j) {
                JSONArray jNormalize = (JSONArray)jArray.get(j);
                String left = jNormalize.getString(0);
                String right = jNormalize.getString(1);
                if (this.common.IsEmpty(left) || right.length() <= 0) continue;
                NormalizeInfo norm = new NormalizeInfo();
                norm.search = left;
                norm.replace = right;
                list.add(norm);
            }
        }
        return list;
    }

    private List<JoinWordInfo> getJoinWordsList(JSONArray jArray) {
        ArrayList<JoinWordInfo> list = new ArrayList<JoinWordInfo>();
        if (jArray != null) {
            int jlen = jArray.size();
            for (int j = 0; j < jlen; ++j) {
                JSONArray jNormalize = (JSONArray)jArray.get(j);
                String front = jNormalize.getString(0);
                String back = jNormalize.getString(1);
                String replace = jNormalize.getString(2);
                JoinWordInfo joinw = new JoinWordInfo();
                joinw.front = front;
                joinw.back = back;
                joinw.joinText = replace;
                list.add(joinw);
            }
        }
        return list;
    }

    private List<EOFInfo> getEOFList(JSONArray jArray) {
        ArrayList<EOFInfo> list = new ArrayList<EOFInfo>();
        if (jArray != null) {
            int jlen = jArray.size();
            for (int j = 0; j < jlen; ++j) {
                JSONArray jEOF = (JSONArray)jArray.get(j);
                String front = jEOF.getString(0);
                String back = jEOF.getString(1);
                EOFInfo eofi = new EOFInfo();
                eofi.front = front;
                eofi.back = back;
                list.add(eofi);
            }
        }
        return list;
    }

    private void load() throws Exception {
        this.load(null, null);
    }

    private void load(String kenlmPath, String sentenceJoinPath) throws Exception {
        String sKenlmPath;
        String sentenceJoinScript;
        if (!this.common.IsExist(this._path)) {
            return;
        }
        String sConfig = this.common.readFile(this._path);
        if (this.common.IsEmpty(sConfig)) {
            return;
        }
        JSONObject json = this.common.getJSONFormat(sConfig);
        JSONArray languages = this.common.getJSONArray(json, "language");
        this._config = new ConfigInfo();
        this._config.sentenceJoinScript = !StringUtils.isEmpty(sentenceJoinPath) && this.common.IsExist(sentenceJoinPath) ? sentenceJoinPath : (sentenceJoinScript = this.common.getJSONValue(json, "script", "sentence_join"));
        this._config.kenlmPath = !StringUtils.isEmpty(kenlmPath) && this.common.IsExist(kenlmPath) ? kenlmPath : (sKenlmPath = this.common.getJSONValue(json, "script", "kenlm_path"));
        int len = languages.size();
        for (int i = 0; i < len; ++i) {
            JSONObject config = languages.getJSONObject(i);
            String lang = this.common.getJSONValue(config, "name");
            JSONObject langConfigs = this.common.getJSONObject(config, "config");
            JSONArray joinWords = this.common.getJSONArray(langConfigs, "join_words");
            JSONArray absoluteEOF = this.common.getJSONArray(langConfigs, "absolute_eof");
            JSONArray normalize = this.common.getJSONArray(langConfigs, "normalize");
            JSONArray repair = this.common.getJSONArray(langConfigs, "repair");
            String sentenceJoinModel = this.common.getJSONValue(langConfigs, "sentencejoin_model");
            LangInfo langInfo = new LangInfo();
            langInfo.language = lang;
            langInfo.joinWords.addAll(this.getJoinWordsList(joinWords));
            langInfo.absoluteEOF.addAll(this.getEOFList(absoluteEOF));
            langInfo.normalize.addAll(this.getNormalizeList(normalize));
            langInfo.repair.addAll(this.getNormalizeList(repair));
            langInfo.sentenceJoinModel = sentenceJoinModel;
            this._config.langConfig.put(lang, langInfo);
        }
    }

    public LangInfo get(String lang) {
        if (this._config != null && this._config.langConfig != null) {
            LangInfo langInfo = this._config.langConfig.get(lang);
            return langInfo;
        }
        return null;
    }

    public String getSentenceJoinScript() {
        if (this._config != null && this._config.sentenceJoinScript != null) {
            return this._config.sentenceJoinScript;
        }
        return null;
    }

    public String getKenlmPath() {
        if (this._config != null && this._config.kenlmPath != null) {
            return this._config.kenlmPath;
        }
        return null;
    }

    public static class EOFInfo {
        public String front = "";
        public String back = "";
    }

    public static class JoinWordInfo {
        public String front = "";
        public String back = "";
        public String joinText = "";
    }

    public static class NormalizeInfo {
        public String search = "";
        public String replace = "";
    }

    public static class LangInfo {
        public String language = "";
        public List<JoinWordInfo> joinWords = new ArrayList<JoinWordInfo>();
        public List<EOFInfo> absoluteEOF = new ArrayList<EOFInfo>();
        public List<NormalizeInfo> normalize = new ArrayList<NormalizeInfo>();
        public List<NormalizeInfo> repair = new ArrayList<NormalizeInfo>();
        public String sentenceJoinModel = "";
    }

    public static class ConfigInfo {
        public HashMap<String, LangInfo> langConfig = new HashMap();
        public String sentenceJoinScript = null;
        public String kenlmPath = null;
    }
}

