# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['python_playvox']

package_data = \
{'': ['*']}

install_requires = \
['requests>=2.23.0,<3.0.0']

setup_kwargs = {
    'name': 'python-playvox',
    'version': '0.2.1',
    'description': 'A Python wrapper for the Playvox REST API.',
    'long_description': "# python-playvox\n\npython-playvox is a simple API wrapper for the Playvox REST API.\n\nDocumentation for the Playvox API can be found [here.](https://developers.playvox.com/restapis/#/introduction/api-reference)\n\nPlease note, this wrapper is in beta and has not been fully tested.\n\n## Usage\nTo instantiate the API wrapper you will need the subdomain for your your API uid and your API key.\n\n```python\nfrom python_playvox import Playvox\n\nsubdomain = 'mysubdomain'\nuid = 'my-playvox-uid'\nkey = 'my-playvox-key'\n\npv = Playvox(subdomain, uid, key)\n```\n\nThis will create an instance of the wrapper that makes calls to 'https://mysubdomain.playvox.com/api/v1/' and authenticates with your playvox uid and key.\n\n## Methods\n\n  - [pv.coaching.get(**kwargs):](#pvcoachinggetkwargs)\n  - [pv.learning.get(**kwargs):](#pvlearninggetkwargs)\n  - [pv.campaign.get(**kwargs):](#pvcampaigngetkwargs)\n  - [pv.campaign.vars(campaign_id)](#pvcampaignvarscampaign_id)\n  - [pv.campaign.users(campaign_id)](#pvcampaignuserscampaign_id)\n  - [pv.campaign.send_data(campaign_id, data)](#pvcampaignsend_datacampaign_id-data)\n  - [pv.calibration.get(**kwargs)](#pvcalibrationgetkwargs)\n  - [pv.evaluation.get(**kwargs)](#pvevaluationgetkwargs)\n  - [pv.scorecard.get(**kwargs)](#pvscorecardgetkwargs)\n  - [pv.team.get(**kwargs)](#pvteamgetkwargs)\n  - [pv.team.new(name, description, team_leaders, users)](#pvteamnewname-description-team_leaders-users)\n  - [pv.team.update(team_id, **kwargs)](#pvteamupdateteam_id-kwargs)\n  - [pv.team.add_user(team_id, user_id)](#pvteamadd_userteam_id-user_id)\n  - [pv.team.remove_user(team_id, user_id)](#pvteamremove_userteam_id-user_id)\n  - [pv.team.delete(team_id)](#pvteamdeleteteam_id)\n  - [pv.user.get(**kwargs)](#pvusergetkwargs)\n  - [pv.user.new(first_name, last_name, username, email, password, **kwargs)](#pvusernewfirst_name-last_name-username-email-password-kwargs)\n  - [pv.user.update(user_id, **kwargs)](#pvuserupdateuser_id-kwargs)\n  - [pv.user.deactivate(user_id, deactivation_type, reason)](#pvuserdeactivateuser_id-deactivation_type-reason)\n  - [pv.user.activate(user_id)](#pvuseractivateuser_id)\n  - [pv.role.get(**kwargs)](#pvrolegetkwargs)\n  - [pv.integration.get()](#pvintegrationget)\n  - [pv.integration.new(name, description, data_storage_minutes)](#pvintegrationnewname-description-data_storage_minutes)\n  - [pv.integration.update(integration_id, **kwargs)](#pvintegrationupdateintegration_id-kwargs)\n  - [pv.integration.delete(integration_id)](#pvintegrationdeleteintegration_id)\n  - [pv.integration.add_metadata(integration_id, field_id, m_type, allowed, required, available_in):](#pvintegrationadd_metadataintegration_id-field_id-m_type-allowed-required-available_in)\n  - [pv.integration.update_metadata(integration_id, metadata_id, **kwargs):](#pvintegrationupdate_metadataintegration_id-metadata_id-kwargs)\n  - [pv.integration.delete_metadata(integration_id, metadata_id)](#pvintegrationdelete_metadataintegration_id-metadata_id)\n  - [pv.interaction.get(integration_id)](#pvinteractiongetintegration_id)\n  - [pv.interaction.add(integration_id, interaction_id, assignee_id, custom_metadata)](#pvinteractionaddintegration_id-interaction_id-assignee_id-custom_metadata)\n  - [pv.interaction.update(integration_id, interaction_id, data)](#pvinteractionupdateintegration_id-interaction_id-data)\n  - [pv.interaction.delete(integration_id, interaction_id)](#pvinteractiondeleteintegration_id-interaction_id)\n  - [pv.interaction.get_comments(interaction_id)](#pvinteractionget_commentsinteraction_id)\n  - [pv.interaction.add_comment(interaction_id, body, comment_type, author_id, comment_dt=None)](#pvinteractionadd_commentinteraction_id-body-comment_type-author_id-comment_dtnone)\n  - [pv.interaction.update_comment(interaction_id, comment_id, body, comment_dt=None)](#pvinteractionupdate_commentinteraction_id-comment_id-body-comment_dtnone)\n  - [pv.delete_comment(interaction_id, comment_id)](#pvdelete_commentinteraction_id-comment_id)\n  - [pv.interaction.bulk_add(integration_id, interactions)](#pvinteractionbulk_addintegration_id-interactions)\n  - [pv.interaction.bulk_status(job_id)](#pvinteractionbulk_statusjob_id)\n\n#### pv.coaching.get(**kwargs):\n\nParameters:\n\n- include(string): use include='all' to include all coaching related objects information\n- page(int): page number for data pagination\n- per_page(int): number of resources per page for data pagination\n- query(string): JSON specifying resource filters\n- fields(string): comma separated list of fields to be returned from the resource\n- sort(string): comma separated list of sort attributes. Use + as prefix for ascending and - as prefix for descending\n\n*Returns a dict of coaching data that match the specified parameters*\n\n#### pv.learning.get(**kwargs):\n\nParameters:\n\n- include(string): use include='all' to include all learning related objects information\n- page(int): page number for data pagination\n- per_page(int): number of resources per page for data pagination\n- query(string): JSON specifying resource filters\n- fields(string): comma separated list of fields to be returned from the resource\n- sort(string): comma separated list of sort attributes. Use + as prefix for ascending and - as prefix for descending\n\n*Returns a dict of learnings data that match the specified parameters*\n\n#### pv.campaign.get(**kwargs):\n\nParameters:\n\n- include(string): use include='all' to include all campaign related objects information\n- page(int): page number for data pagination\n- per_page(int): number of resources per page for data pagination\n- query(string): JSON specifying resource filters\n- fields(string): comma separated list of fields to be returned from the resource\n- sort(string): comma separated list of sort attributes. Use + as prefix for ascending and - as prefix for descending\n\n*Returns a dict of campaign data that match the specified parameters*\n\n#### pv.campaign.vars(campaign_id)\n\nParameters:\n\n- campaign_id(string) *required*: campaign ID to pull vars data for\n\n*Returns a dict containing vars data for the specified campaign*\n\n#### pv.campaign.users(campaign_id)\n\nParameters:\n\n- campaign_id(string) *required*: campaign ID to pull users data for\n\n*Returns a dict containing users data for the specified campaign*\n\n#### pv.campaign.send_data(campaign_id, data)\n\nParameters:\n\n- campaign_id(string) *required*: id of campaign to send campaign metric data to\n- data(dict or list[dict]) *required*: metric data to add to the campaign\n\n*Returns True if the data was successfully added, otherwise an error is raised*\n\n#### pv.calibration.get(**kwargs)\n\nParameters:\n\n- include(string): use include='all' to include all calibration related objects information\n- page(int): page number for data pagination\n- per_page(int): number of resources per page for data pagination\n- query(string): JSON specifying resource filters\n- fields(string): comma separated list of fields to be returned from the resource\n- sort(string): comma separated list of sort attributes. Use + as prefix for ascending and - as prefix for descending\n\n*Returns a dict of calibration data that match the specified parameters*\n\n#### pv.evaluation.get(**kwargs)\n\nParameters:\n\n- include(string): use include='all' to include all evaluation related objects information\n- page(int): page number for data pagination\n- per_page(int): number of resources per page for data pagination\n- query(string): JSON specifying resource filters\n- fields(string): comma separated list of fields to be returned from the resource\n- sort(string): comma separated list of sort attributes. Use + as prefix for ascending and - as prefix for descending\n\n*Returns a dict of evaluation data that match the specified parameters*\n\n#### pv.scorecard.get(**kwargs)\n\nParameters:\n\n- include(string): use include='all' to include all scorecard related objects information\n- page(int): page number for data pagination\n- per_page(int): number of resources per page for data pagination\n- query(string): JSON specifying resource filters\n- fields(string): comma separated list of fields to be returned from the resource\n- sort(string): comma separated list of sort attributes. Use + as prefix for ascending and - as prefix for descending\n\n*Returns a dict of scorecard data that match the specified parameters*\n\n#### pv.team.get(**kwargs)\n\nParameters:\n\n- include(string): use include='all' to include all team related objects information\n- page(int): page number for data pagination\n- per_page(int): number of resources per page for data pagination\n- query(string): JSON specifying resource filters\n- fields(string): comma separated list of fields to be returned from the resource\n- sort(string): comma separated list of sort attributes. Use + as prefix for ascending and - as prefix for descending\n\n*Returns a dict of team data that match the specified parameters*\n\n#### pv.team.new(name, description, team_leaders, users)\n\nParameters:\n\n- name(string) *required*: name of the new team\n- description(string): description of the new team\n- team_leaders(list) *required*: a list of the user ids of team leaders\n- users(list): a list of the user ids of team members\n\n*Returns the id of the newly created team*\n\n#### pv.team.update(team_id, **kwargs)\n\nParameters:\n\n- team_id(string) *required*: the id of the team to be updated\n- name(string): the new name of the team\n- description(string): the new description for the team\n- team_leader_id(list): a list of user ids for team leaders to replace the current list\n- users(list): a list of user ids for users to replace the current list\n\n*Returns True if successful, otherwise an error will be raised*\n\n#### pv.team.add_user(team_id, user_id)\n\nParameters:\n\n- team_id(string) *required*: the id of the team the user will be added to\n- user_id(string) *required*: the id of the user that will be added to the team\n\n*Returns True if successful, otherwise an error will be raised*\n\n#### pv.team.remove_user(team_id, user_id)\n\nParameters:\n\n- team_id(string) *required*: the id of the team that the user will be removed from\n- user_id(string) *required*: the id of the user that will be removed from the team\n\n*Returns True if successful, otherwise an error will be raised*\n\n#### pv.team.delete(team_id)\n\nParameters:\n\n- team_id(string) *required*: the id of the team that will be deleted\n\n*Returns True if successful, otherwise an error will be raised*\n\n#### pv.user.get(**kwargs)\n\nParameters:\n\n- include(string): use include='all' to include all user related objects information\n- page(int): page number for data pagination\n- per_page(int): number of resources per page for data pagination\n- query(string): JSON specifying resource filters\n- fields(string): comma separated list of fields to be returned from the resource\n- sort(string): comma separated list of sort attributes. Use + as prefix for ascending and - as prefix for descending\n\n*Returns a dict containing user data for the specified parameters*\n\n#### pv.user.new(first_name, last_name, username, email, password, **kwargs)\n\nParameters:\n\n - first_name(string) *required*: the new user's first name\n - last_name(string) *required*: the new user's last name\n - username(string) *required*: the username that the new user will login with\n - email(string) *required*: the new user's email address\n - password(string) *required*: the new user's password\n   - at least 10 characters\n   - 1 numer required\n   - 1 uppercase letter required\n   - 1 lowercase letter required\n- integrations_{integration_name}(string): the user's integration ID for the specified integration, acceptable integration names include:\n  - five9\n  - zendesk\n  - salesforce\n  - livechat\n  - ringcentral\n  - intercom\n  - freshdesk\n  - talkdesk\n  - sopim\n  - kustomer\n  - helpscout\n  - helpshift\n\n*Returns the id of the new user*\n\n#### pv.user.update(user_id, **kwargs)\n\nParameters:\n\n- user_id(string) *required*: the id of the user to be updated\n- name(string): the new first name for the specified user\n- last_name(string): the new last name for the specified user\n- integrations_{integration_name}(string): the user's integration ID for the specified integration, acceptable integration names include:\n  - five9\n  - zendesk\n  - salesforce\n  - livechat\n  - ringcentral\n  - intercom\n  - freshdesk\n  - talkdesk\n  - sopim\n  - kustomer\n  - helpscout\n  - helpshift\n\n*Returns True if the user was updated successfully, otherwise an error will be raised*\n\n#### pv.user.deactivate(user_id, deactivation_type, reason)\n\nParameters:\n\n- user_id(string) *required*: the id of the user to be deactivated\n- deactivation_type(string) *required*: the type of deactivation\n- reason(string) *required*: the reason the user is being deactivated\n\n*Returns True if successful, otherwise an error will be raised*\n\n#### pv.user.activate(user_id)\n\nParameters:\n\n- user_id(string) *required*: the id of a previously deactivated user to be activated\n\n*Returns True if succesful, otherwise an error will be raised*\n\n#### pv.role.get(**kwargs)\n\nParameters:\n\n- include(string): use include='all' to include all role related objects information\n- page(int): page number for data pagination\n- per_page(int): number of resources per page for data pagination\n- query(string): JSON specifying resource filters\n- fields(string): comma separated list of fields to be returned from the resource\n- sort(string): comma separated list of sort attributes. Use + as prefix for ascending and - as prefix for descending\n\n*Returns a dict of role data that match the specified parameters*\n\n#### pv.integration.get()\n\n*Returns all available integrations*\n\n#### pv.integration.new(name, description, data_storage_minutes)\n\nParameters:\n\n- name(string) *required*: name for the new integration\n- description(string) *required*: description for the new integration\n- data_storage_minutes(int) *required*: the time in minutes to retain data from the integration\n  - Max: 129600(90 days)\n\n*Returns the id of the newly created integration*\n\n#### pv.integration.update(integration_id, **kwargs)\n\nParameters:\n\n- integration_id(string) *required*: the id of the integration to be updated\n- name(string): a new name for the integration\n- description(string): a new description for the integration\n- data_storage_minutes(int): the time in minutes to retain data from the integration\n  - Max: 129600(90 days)\n\n*Returns True if the specified integration is updated successfully, otherwise an error will be raised*\n\n#### pv.integration.delete(integration_id)\n\nParameters:\n\n- integration_id(string) *required*: the id of the integration to be deleted\n\n*Returns True if the specified integration is deleted successfully, otherwise an error will be raised*\n\n#### pv.integration.add_metadata(integration_id, field_id, m_type, allowed, required, available_in):\n\nParameters:\n\n- integration_id(string) *required*: the id of the integration that the metadata field will be added to\n- field_id(string) *required*: name to identify the metadata field\n  - Minimum 3 characters\n  - Maximum 30 characters\n  - Accepts only a-z and underscores\n- m_type(string) *required*: the type of the field, allowed values:\n  - string\n  - integer\n  - float\n  - list\n  - boolean\n  - datetime\n- allowed(list) *required*: the allowed values that the filed will accept\n- required(boolean) *required*: specifies whether or not the field is required\n- available_in(list[string]): specifies if the field can be filtered or shown in related data, accepts:\n  - 'filters'\n  - 'display'\n\n*Returns the id of the new metadata field if successful, otherwise an error will be raised*\n\n#### pv.integration.update_metadata(integration_id, metadata_id, **kwargs):\n\nParameters:\n\n- integration_id(string) *required*: the id of the integration that the target metadata field exists on\n- metadata_id(string) *required*: the id of the metadata field that will be updated\n- field_id(string): name to identify the metadata field\n  - Minimum 3 characters\n  - Maximum 30 characters\n  - Accepts only a-z and underscores\n- m_type(string): the type of the field, allowed values:\n  - string\n  - integer\n  - float\n  - list\n  - boolean\n  - datetime\n- allowed(list): the allowed values that the filed will accept\n- required(boolean): specifies whether or not the field is required\n- available_in(list[string]): specifies if the field can be filtered or shown in related data, accepts:\n  - 'filters'\n  - 'display'\n\n*Returns True if successful, otherwise an error will be raised*\n\n#### pv.integration.delete_metadata(integration_id, metadata_id)\n\nParameters:\n\n- integration_id(string) *required*: the id of the integration that the target metadata field exists on\n- metadata_id(string) *required*: the id of the metadata field to be deleted\n\n*Returns True if successful, otherwise an error will be raised*\n\n#### pv.interaction.get(integration_id)\n\nParameters:\n\n- integration_id(string) *required* The id of the integration to get integrations for.\n\n*Returns all interactions for the specified integration*\n\n#### pv.interaction.add(integration_id, interaction_id, assignee_id, custom_metadata)\n\nParameters:\n\n- integration_id(string) *required*: The id of the integration the interaction will be added to.\n- interaction_id(string): The id of your external system\n  - Max length: 68 characters\n- assignee_id(string): The id of the user on the external system (should match email or username in playvox)\n- custom_metadata(dict) *required*: The payload of all the metadata fields defined on the integration\n\n*Returns the id of the new interaction*\n\n#### pv.interaction.update(integration_id, interaction_id, data)\n\nParameters:\n\n- integration_id(string) *required*: the id of the integration the target interaction exists on\n- interaction_id(string) *required*: the id of the interaction to be updated\n- data(dict) *required*: The payload of the metadata fields to be updated\n\n*Returns True if successful, otherwise an error will be raised*\n\n#### pv.interaction.delete(integration_id, interaction_id)\n\nParameters:\n\n- integration_id(string) *required*: the id of the integration the target interaction exists on\n- interaction_id(string) *required*: the id of the interaction to be deleted\n\n*Returns True if successful, otherwise an error will be raised*\n\n#### pv.interaction.get_comments(interaction_id)\n\nParameters:\n\n- interaction_id(string) *required*: the id of the interaction to get comments for\n\n*Returns all comments associated with the interaction*\n\n#### pv.interaction.add_comment(interaction_id, body, comment_type, author_id, comment_dt=None)\n\nParameters:\n\n- interaction_id(string) *required*: the id of the interaction the comment will be added to\n- body(string) *required*: the body of the comment\n- comment_type(string) *required*: the type of comment, accepts:\n  - 'customer_comment'\n  - 'agent_comment'\n  - 'internal_note'\n- author_id(string) *required*: the username or email of the author on playvox\n- comment_dt(datetime): the time that the comment was added to the interaction, defaults to current time if not specified\n\n*Returns the id of the newly created comment*\n\n#### pv.interaction.update_comment(interaction_id, comment_id, body, comment_dt=None)\n\nParameters:\n\n- interaction_id(string) *required*: the id of the interaction that the comment is associated with\n- comment_id(string) *required*: the id of the comment to be updated\n- body(string) *required*: the new body of the comment\n- comment_dt(datetime): the time that the comment was updated, defaults to current time if not specified\n\n*Returns True if the comment is updated successfully, otherwise an error will be raised*\n\n#### pv.delete_comment(interaction_id, comment_id)\n\nParameters:\n\n- interaction_id(string) *required*: the id of the interaction that the target comment is associated with\n- comment_id(string) *required*: the id of the comment to be deleted\n\n*Returns True if the comment is deleted successfully, otherwise an error will be raised*\n\n#### pv.interaction.bulk_add(integration_id, interactions)\n\nParameters:\n\n- integration_id(string) *required*: the id of the integration that the interactions will be added to\n- interactions(dict) *required*: the interactions to be added to the integration, for more information see the [Playvox API Documentation](https://developers.playvox.com/restapis/#/reference/0/bulk-interactions/create)\n\n*Returns the job id of the bulk job*\n\n#### pv.interaction.bulk_status(job_id)\n\nParameters:\n\n- job_id(string) *required*: the id of the bulk job to check the status of\n\n*Returns status information on the specified bulk job*\n\n",
    'author': 'Moses Wynn',
    'author_email': 'mail@moseswynn.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://git.moseswynn.com/moseswynn/python-playvox',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
